/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ClickZoomWireListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener {
    private static Preferences prefs = Preferences.userNodeForPackage(ClickZoomWireListener.class);
    private static long cancelMoveDelayMillis;
    private static long zoomInDelayMillis;
    private static final boolean debug = false;
    public static ClickZoomWireListener theOne;
    private int clickX;
    private int clickY;
    private int dbMoveStartX;
    private int dbMoveStartY;
    private int lastdbMouseX;
    private int lastdbMouseY;
    private Mode modeLeft = Mode.none;
    private Mode modeRight = Mode.none;
    private boolean specialSelect = false;
    private boolean invertSelection = false;
    private long leftMousePressedTimeStamp;
    private long rightMousePressedTimeStamp;
    private ElectricObject wiringTarget;
    private InteractiveRouter router = new SimpleWirer();
    private ElectricObject startObj;
    private ElectricObject endObj;
    private int mouseX;
    private int mouseY;
    private Highlight moveDelta;
    private EventListener oldListener;
    private static final boolean isMac;
    private static final String cancelMoveDelayMillisPref = "cancelMoveDelayMillis";
    private static final String zoomInDelayMillisPref = "zoomInDelayMillis";

    private ClickZoomWireListener() {
        this.readPrefs();
    }

    public void setSpecialSelect() {
        this.specialSelect = true;
    }

    public void clearSpecialSelect() {
        this.specialSelect = false;
    }

    public boolean getStickyMove() {
        return false;
    }

    public void setRouter(InteractiveRouter router) {
        this.router = router;
    }

    public boolean getStickyWiring() {
        return true;
    }

    public Point2D getLastMouse() {
        return new Point2D.Double(this.mouseX, this.mouseY);
    }

    public void zoomBoxSingleShot(EventListener oldListener) {
        this.modeRight = Mode.zoomBoxSingleShot;
        this.oldListener = oldListener;
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return isMac ? !evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16 : (evt.getModifiers() & 0x10) == 16;
    }

    public static boolean isRightMouse(MouseEvent evt) {
        if (isMac) {
            if (evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16) {
                return true;
            }
            if ((evt.getModifiers() & 4) == 4) {
                return true;
            }
        } else if ((evt.getModifiers() & 4) == 4) {
            return true;
        }
        return false;
    }

    public void mousePressed(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            this.clickX = evt.getX();
            this.clickY = evt.getY();
            Point2D dbClick = wnd.screenToDatabase(this.clickX, this.clickY);
            this.lastdbMouseX = (int)dbClick.getX();
            this.lastdbMouseY = (int)dbClick.getY();
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.invertSelection = (evt.getModifiersEx() & 0x40) != 0;
            this.specialSelect = ToolBar.getSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.rightMousePressedTimeStamp = currentTime;
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (!this.invertSelection) {
                    Highlight h1;
                    Iterator hIt = Highlight.getHighlights();
                    if (Highlight.getNumHighlights() == 2) {
                        h1 = (Highlight)hIt.next();
                        Highlight h2 = (Highlight)hIt.next();
                        if (h1.getType() == Highlight.Type.EOBJ && h2.getType() == Highlight.Type.EOBJ) {
                            this.modeRight = Mode.wiringConnect;
                            this.wiringTarget = null;
                            this.startObj = h1.getElectricObject();
                            this.endObj = h2.getElectricObject();
                            EditWindow.gridAlign(dbClick);
                            this.router.highlightRoute(cell, h1.getElectricObject(), h2.getElectricObject(), dbClick);
                            return;
                        }
                    }
                    if (Highlight.getNumHighlights() == 1 && (h1 = (Highlight)hIt.next()).getType() == Highlight.Type.EOBJ) {
                        this.modeRight = Mode.wiringFind;
                        this.endObj = null;
                        this.wiringTarget = null;
                        this.startObj = h1.getElectricObject();
                        this.router.startInteractiveRoute();
                        int numFound = Highlight.findObject(dbClick, wnd, false, false, false, true, false, this.specialSelect, false);
                        if (numFound == 0) {
                            this.endObj = null;
                            this.wiringTarget = null;
                        } else {
                            Highlight h2 = (Highlight)Highlight.getHighlights().next();
                            this.endObj = h2.getElectricObject();
                        }
                        EditWindow.gridAlign(dbClick);
                        this.router.highlightRoute(cell, h1.getElectricObject(), this.endObj, dbClick);
                        return;
                    }
                    System.out.println("Must start new arc from one node or arc; or wire two node/arcs together");
                    return;
                }
                wnd.setStartDrag(this.clickX, this.clickY);
                wnd.setEndDrag(this.clickX, this.clickY);
                wnd.setDoingAreaDrag();
                if (this.invertSelection && !another) {
                    this.modeRight = Mode.zoomOut;
                }
                if (another && this.invertSelection) {
                    Highlight.clear();
                    this.modeRight = Mode.drawBox;
                }
                return;
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.stickyMove) {
                    if (another) {
                        dbClick = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbClick);
                    }
                    Point dbDelta = new Point((int)dbClick.getX() - this.dbMoveStartX, (int)dbClick.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                        Highlight.setHighlightOffset(0, 0);
                        CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                        wnd.repaintContents(null);
                    }
                    this.modeLeft = Mode.none;
                    return;
                }
                this.leftMousePressedTimeStamp = evt.getWhen();
                if (evt.getClickCount() == 2 && !another && !this.invertSelection && Highlight.getNumHighlights() >= 1) {
                    EditMenu.getInfoCommand();
                    return;
                }
                if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    Highlight.clear();
                    this.modeLeft = Mode.drawBox;
                    return;
                }
                if (!another && !this.invertSelection && Highlight.overHighlighted(wnd, this.clickX, this.clickY)) {
                    this.dbMoveStartX = (int)dbClick.getX();
                    this.dbMoveStartY = (int)dbClick.getY();
                    this.moveDelta = null;
                    this.modeLeft = Mode.move;
                } else {
                    int numFound = Highlight.findObject(dbClick, wnd, false, another, this.invertSelection, true, false, this.specialSelect, true);
                    if (numFound == 0) {
                        wnd.setStartDrag(this.clickX, this.clickY);
                        wnd.setEndDrag(this.clickX, this.clickY);
                        wnd.setDoingAreaDrag();
                        this.modeLeft = Mode.selectBox;
                    } else {
                        this.dbMoveStartX = (int)dbClick.getX();
                        this.dbMoveStartY = (int)dbClick.getY();
                        this.moveDelta = null;
                        this.modeLeft = Mode.move;
                    }
                }
                return;
            }
        }
    }

    public void mouseDragged(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            int mouseX = evt.getX();
            int mouseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(mouseX, mouseY);
            this.lastdbMouseX = (int)dbMouse.getX();
            this.lastdbMouseY = (int)dbMouse.getY();
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.getSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    if (!wnd.isDoingAreaDrag()) {
                        wnd.setStartDrag(mouseX, mouseY);
                        wnd.setEndDrag(mouseX, mouseY);
                        wnd.setDoingAreaDrag();
                    }
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.zoomOut && currentTime - this.rightMousePressedTimeStamp > zoomInDelayMillis) {
                    this.modeRight = Mode.zoomBox;
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox) {
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    int numFound = Highlight.findObject(dbMouse, wnd, false, false, false, true, false, this.specialSelect, false);
                    if (numFound == 0) {
                        EditWindow.gridAlign(dbMouse);
                        this.endObj = null;
                        this.wiringTarget = null;
                    } else {
                        this.endObj = null;
                        if (this.wiringTarget != null) {
                            EditWindow.gridAlign(dbMouse);
                            List underCursor = Highlight.findAllInArea(cell, false, true, true, false, this.specialSelect, false, new Rectangle2D.Double(dbMouse.getX(), dbMouse.getY(), 0.0, 0.0), wnd);
                            Iterator hs = underCursor.iterator();
                            while (hs.hasNext()) {
                                Highlight h = (Highlight)hs.next();
                                ElectricObject eobj = h.getElectricObject();
                                if (eobj != this.wiringTarget) continue;
                                this.endObj = this.wiringTarget;
                                break;
                            }
                            if (this.endObj == null) {
                                this.wiringTarget = null;
                            }
                        }
                        if (this.endObj == null) {
                            Iterator hIt = Highlight.getHighlights();
                            Highlight h2 = (Highlight)hIt.next();
                            this.endObj = h2.getElectricObject();
                        }
                        EditWindow.gridAlign(dbMouse);
                    }
                    this.router.highlightRoute(cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    this.router.highlightRoute(cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    this.router.highlightRoute(cell, this.startObj, null, dbMouse);
                }
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox) {
                    wnd.setEndDrag(mouseX, mouseY);
                    wnd.repaint();
                }
                if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                    if (another) {
                        dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse);
                    }
                    Point dbDelta = new Point((int)dbMouse.getX() - this.dbMoveStartX, (int)dbMouse.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    Point screenDelta = wnd.deltaDatabaseToScreen((int)((Point2D)dbDelta).getX(), (int)((Point2D)dbDelta).getY());
                    Highlight.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                    Point center = new Point((int)(-((Point2D)screenDelta).getX() + wnd.getOffset().getX()), (int)(-((Point2D)screenDelta).getY() + wnd.getOffset().getY()));
                    if (this.moveDelta != null) {
                        Highlight.remove(this.moveDelta);
                    }
                    Rectangle2D bounds = wnd.getDisplayedBounds();
                    this.moveDelta = Highlight.addMessage(cell, "(" + (int)((Point2D)dbDelta).getX() + "," + (int)((Point2D)dbDelta).getY() + ")", new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
                    wnd.repaint();
                }
            }
            wnd.repaint();
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            int releaseX = evt.getX();
            int releaseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(releaseX, releaseY);
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.getSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                double scale;
                if (this.modeRight == Mode.zoomIn) {
                    scale = wnd.getScale();
                    wnd.setScale(scale * 2.0);
                    wnd.clearDoingAreaDrag();
                    wnd.repaintContents(null);
                }
                if (this.modeRight == Mode.zoomOut) {
                    scale = wnd.getScale();
                    wnd.setScale(scale / 2.0);
                    wnd.setOffset(dbMouse);
                    wnd.clearDoingAreaDrag();
                    wnd.repaintContents(null);
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot) {
                    Rectangle2D.Double bounds;
                    Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                    Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                    double minSelX = Math.min(start.getX(), end.getX());
                    double maxSelX = Math.max(start.getX(), end.getX());
                    double minSelY = Math.min(start.getY(), end.getY());
                    double maxSelY = Math.max(start.getY(), end.getY());
                    if (this.modeRight == Mode.drawBox) {
                        Highlight.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                    }
                    if (this.modeRight == Mode.zoomBoxSingleShot) {
                        bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                        if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                            wnd.focusScreen(bounds);
                        }
                        WindowFrame.setListener(this.oldListener);
                    }
                    if (this.modeRight == Mode.zoomBox) {
                        bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                        if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                            wnd.focusScreen(bounds);
                        } else {
                            double scale2 = wnd.getScale();
                            wnd.setScale(scale2 / 2.0);
                            wnd.clearDoingAreaDrag();
                            wnd.repaintContents(null);
                        }
                    }
                    Highlight.finished();
                    wnd.clearDoingAreaDrag();
                    wnd.repaint();
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    EditWindow.gridAlign(dbMouse);
                    this.router.makeRoute(cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    this.router.makeRoute(cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    this.router.makeRoute(cell, this.startObj, null, dbMouse);
                    this.wiringTarget = null;
                }
                this.modeRight = Mode.none;
            }
            if (this.isLeftMouse(evt)) {
                long curTime = evt.getWhen();
                if ((this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) && curTime - this.leftMousePressedTimeStamp < cancelMoveDelayMillis) {
                    Highlight.setHighlightOffset(0, 0);
                    this.modeLeft = Mode.none;
                    if (this.moveDelta != null) {
                        Highlight.remove(this.moveDelta);
                    }
                    wnd.repaint();
                    return;
                }
                if (this.getStickyMove() && this.modeLeft == Mode.move) {
                    this.modeLeft = Mode.stickyMove;
                } else {
                    if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox) {
                        Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                        Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                        double minSelX = Math.min(start.getX(), end.getX());
                        double maxSelX = Math.max(start.getX(), end.getX());
                        double minSelY = Math.min(start.getY(), end.getY());
                        double maxSelY = Math.max(start.getY(), end.getY());
                        if (this.modeLeft == Mode.selectBox) {
                            if (!this.invertSelection) {
                                Highlight.clear();
                            }
                            Highlight.selectArea(wnd, minSelX, maxSelX, minSelY, maxSelY, this.invertSelection, this.specialSelect);
                        }
                        if (this.modeLeft == Mode.drawBox) {
                            Highlight.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                        }
                        Highlight.finished();
                        wnd.clearDoingAreaDrag();
                        wnd.repaint();
                    }
                    if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                        if (another) {
                            dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse);
                        }
                        Point dbDelta = new Point((int)dbMouse.getX() - this.dbMoveStartX, (int)dbMouse.getY() - this.dbMoveStartY);
                        EditWindow.gridAlign(dbDelta);
                        if (this.moveDelta != null) {
                            Highlight.remove(this.moveDelta);
                        }
                        if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                            Highlight.setHighlightOffset(0, 0);
                            CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                            wnd.repaintContents(null);
                        }
                    }
                    this.modeLeft = Mode.none;
                }
            }
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.getSelectSpecial();
            if (this.modeLeft == Mode.stickyMove) {
                Point2D dbMouse = wnd.screenToDatabase(this.mouseX, this.mouseY);
                if (another) {
                    dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse);
                }
                Point dbDelta = new Point((int)dbMouse.getX() - this.dbMoveStartX, (int)dbMouse.getY() - this.dbMoveStartY);
                EditWindow.gridAlign(dbDelta);
                Point screenDelta = wnd.deltaDatabaseToScreen((int)((Point2D)dbDelta).getX(), (int)((Point2D)dbDelta).getY());
                Highlight.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                wnd.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean sideways = (evt.getModifiersEx() & 0x40) != 0;
            boolean sideways2 = (evt.getModifiersEx() & 0x80) != 0;
            int rotation = evt.getWheelRotation();
            if (sideways || sideways2) {
                ZoomAndPanListener.panX(wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            } else {
                ZoomAndPanListener.panY(wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            }
        }
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (chr == 37) {
                ClickZoomWireListener.moveSelected(-1.0, 0.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 39) {
                ClickZoomWireListener.moveSelected(1.0, 0.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 38) {
                ClickZoomWireListener.moveSelected(0.0, 1.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 40) {
                ClickZoomWireListener.moveSelected(0.0, -1.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 27) {
                if (this.modeRight == Mode.wiringConnect || this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    this.router.cancelInteractiveRoute();
                }
                this.modeLeft = Mode.none;
                this.modeRight = Mode.none;
                Highlight.setHighlightOffset(0, 0);
                wnd.repaint();
            } else if (chr == 17) {
                // empty if block
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (chr == 17) {
                // empty if block
            }
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public static void moveSelected(double dX, double dY, boolean scaleMove, boolean scaleMove2) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        double arrowDistance = ToolBar.getArrowDistance();
        dX *= arrowDistance;
        dY *= arrowDistance;
        int scale = User.getDefGridXBoldFrequency();
        if (scaleMove) {
            dX *= (double)scale;
            dY *= (double)scale;
        }
        if (scaleMove2) {
            dX *= (double)scale;
            dY *= (double)scale;
        }
        Highlight.setHighlightOffset(0, 0);
        CircuitChanges.manyMove(dX, dY);
        wnd.repaintContents(null);
    }

    public static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint) {
        double xdist = Math.abs(mousePoint.getX() - startPoint.getX());
        double ydist = Math.abs(mousePoint.getY() - startPoint.getY());
        if (ydist > xdist) {
            return new Point2D.Double(startPoint.getX(), mousePoint.getY());
        }
        return new Point2D.Double(mousePoint.getX(), startPoint.getY());
    }

    public void switchWiringTarget() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (this.modeRight == Mode.wiringToSpace) {
            this.modeRight = Mode.wiringFind;
        }
        if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
            Point2D.Double dbMouse = new Point2D.Double(this.lastdbMouseX, this.lastdbMouseY);
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.lastdbMouseX, this.lastdbMouseY, 0.0, 0.0);
            List targets = Highlight.findAllInArea(wnd.getCell(), false, false, true, false, this.specialSelect, false, bounds, wnd);
            Iterator it = targets.iterator();
            boolean found = false;
            if (this.wiringTarget == null) {
                this.wiringTarget = this.endObj;
            }
            while (it.hasNext()) {
                if (((Highlight)it.next()).getElectricObject() != this.wiringTarget) continue;
                found = true;
                if (!it.hasNext()) {
                    this.modeRight = Mode.wiringToSpace;
                    this.wiringTarget = null;
                    break;
                }
                this.wiringTarget = ((Highlight)it.next()).getElectricObject();
                break;
            }
            if (!found) {
                it = targets.iterator();
                this.wiringTarget = it.hasNext() ? ((Highlight)it.next()).getElectricObject() : null;
            }
            if (this.modeRight == Mode.wiringToSpace) {
                this.endObj = null;
                System.out.println("Switching to 'ignore all wiring targets'");
                this.router.highlightRoute(cell, this.startObj, null, dbMouse);
                return;
            }
            if (this.endObj == this.wiringTarget) {
                return;
            }
            this.endObj = this.wiringTarget;
            if (this.wiringTarget == null) {
                System.out.println("Switching to wiring target 'none'");
            } else {
                System.out.println("Switching to wiring target '" + this.wiringTarget + "'");
            }
            this.router.highlightRoute(cell, this.startObj, this.wiringTarget, dbMouse);
        }
    }

    public void wireTo(int layerNumber) {
        ElectricObject obj;
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        ArcProto ap = null;
        Technology tech = Technology.getCurrent();
        boolean found = false;
        Iterator it = tech.getArcs();
        while (it.hasNext()) {
            ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            switch (layerNumber) {
                case 0: {
                    if (ap.getFunction() != ArcProto.Function.POLY1) break;
                    found = true;
                    break;
                }
                case 1: {
                    if (ap.getFunction() != ArcProto.Function.METAL1) break;
                    found = true;
                    break;
                }
                case 2: {
                    if (ap.getFunction() != ArcProto.Function.METAL2) break;
                    found = true;
                    break;
                }
                case 3: {
                    if (ap.getFunction() != ArcProto.Function.METAL3) break;
                    found = true;
                    break;
                }
                case 4: {
                    if (ap.getFunction() != ArcProto.Function.METAL4) break;
                    found = true;
                    break;
                }
                case 5: {
                    if (ap.getFunction() != ArcProto.Function.METAL5) break;
                    found = true;
                    break;
                }
                case 6: {
                    if (ap.getFunction() != ArcProto.Function.METAL6) break;
                    found = true;
                }
            }
            if (!found) continue;
        }
        if (!found) {
            return;
        }
        if (ap == User.tool.getCurrentArcProto()) {
            return;
        }
        if (Highlight.getNumHighlights() == 1 && cell != null && (obj = Highlight.getOneHighlight().getElectricObject()) instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            this.router.makeVerticalRoute(pi, ap);
        }
        User.tool.setCurrentArcProto(ap);
    }

    public JPopupMenu selectPopupMenu(List objects) {
        JPopupMenu popup = new JPopupMenu("Choose One");
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Highlight obj = (Highlight)it.next();
            JMenuItem m = new JMenuItem(obj.toString());
            m.addActionListener(this);
            popup.add(m);
        }
        return popup;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
    }

    private void readPrefs() {
        cancelMoveDelayMillis = prefs.getLong(cancelMoveDelayMillisPref, 200L);
        zoomInDelayMillis = prefs.getLong(zoomInDelayMillisPref, 120L);
    }

    public long getCancelMoveDelayMillis() {
        return cancelMoveDelayMillis;
    }

    public void setCancelMoveDelayMillis(long delay) {
        cancelMoveDelayMillis = delay;
        prefs.putLong(cancelMoveDelayMillisPref, delay);
    }

    public long getZoomInDelayMillis() {
        return zoomInDelayMillis;
    }

    public void setZoomInDelayMillis(long delay) {
        zoomInDelayMillis = delay;
        prefs.putLong(zoomInDelayMillisPref, delay);
    }

    static {
        theOne = new ClickZoomWireListener();
        isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    private static class Mode {
        private final String name;
        public static final Mode none = new Mode("none");
        public static final Mode move = new Mode("move");
        public static final Mode stickyMove = new Mode("stickyMove");
        public static final Mode drawBox = new Mode("drawBox");
        public static final Mode zoomBox = new Mode("zoomBox");
        public static final Mode zoomBoxSingleShot = new Mode("zoomBoxSingleShot");
        public static final Mode zoomIn = new Mode("zoomIn");
        public static final Mode zoomOut = new Mode("zoomOut");
        public static final Mode selectBox = new Mode("selectBox");
        public static final Mode wiringConnect = new Mode("wiring");
        public static final Mode wiringFind = new Mode("wiringFind");
        public static final Mode wiringToSpace = new Mode("wiringToSpace");
        public static final Mode stickyWiring = new Mode("stickyWiring");

        public Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

