;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-

(in-package :xit)

(defun show-pixmap (pixmap)
  (let ((pm
	 (cond ((or (eq (contact-depth *toplevel*) (drawable-depth pixmap))
		    (eq (drawable-depth pixmap) 1))
		pixmap)
	       (t nil))))
    (if pm
	(let ((window (make-window 'bitmap-dispel :bitmap pixmap
				   :foreground "black" :background "white")))
	  (update-state *display*)
	  (process-all-events *display*)
	  (format t "~&Press <Return> to get rid of this window.~&")
	  (read-char)
	  (destroy window))
      (warn "Sorry. Can't display depth ~d." (drawable-depth pixmap)))))
