dnl  -*- buffer-read-only: t -*- vi: set ro:
dnl 
dnl DO NOT EDIT THIS FILE   (ag_macros.m4)
dnl 
dnl It has been AutoGen-ed  Monday February 23, 2004 at 06:58:44 PM PST
dnl From the definitions    misc.def
dnl and the template file   conftest.tpl
dnl
dnl @synopsis  INVOKE_AG_MACROS
dnl
dnl  This macro will invoke the AutoConf macros specified in misc.def
dnl  that have not been disabled with "omit-invocation".
dnl
AC_DEFUN([AG_DISABLE_SHELL],[
  AC_ARG_ENABLE([shell],
    AC_HELP_STRING([--disable-shell], [using shell scripts]),
    [ag_cv_enable_shell=${enable_shell}],
    AC_CACHE_CHECK([whether using shell scripts], ag_cv_enable_shell,
      ag_cv_enable_shell=yes)
  ) # end of AC_ARG_ENABLE

  if test "X${ag_cv_enable_shell}" != Xno
  then
    AC_DEFINE([SHELL_ENABLED],[1],
        [Define this if using shell scripts])
    AC_SUBST(OPTS_TESTDIR)
    AC_SUBST(TOP_DIRLIST)
    AC_SUBST(AGEN5_TESTS)
    TOP_DIRLIST='@S|@(SHELL_DIRS) @S|@(XML2AG_DIR)'
    OPTS_TESTDIR=test
    AGEN5_TESTS='@S|@(SHELL_TESTS) @S|@(NOSHELL_TESTS)'
  else
    TOP_DIRLIST='@S|@(NOSHELL_DIRS) @S|@(XML2AG_DIR)'
    OPTS_TESTDIR=
    AGEN5_TESTS='@S|@(NOSHELL_TESTS)'
  fi
  
]) # end of AC_DEFUN of AG_DISABLE_SHELL


AC_DEFUN([AG_WITH_REGEX_HEADER],[
  AC_ARG_WITH([regex-header],
    AC_HELP_STRING([--with-regex-header], [a reg expr header is specified]),
    [ag_cv_with_regex_header=${with_regex_header}],
    AC_CACHE_CHECK([whether a reg expr header is specified], ag_cv_with_regex_header,
      ag_cv_with_regex_header=no)
  ) # end of AC_ARG_WITH

  if test "X${ag_cv_with_regex_header}" != Xno
  then
    AC_DEFINE_UNQUOTED([REGEX_HEADER],[<${ag_cv_with_regex_header}>])
  else
    AC_DEFINE([REGEX_HEADER],[<regex.h>],[name of regex header file])
  fi
  
]) # end of AC_DEFUN of AG_WITH_REGEX_HEADER


AC_DEFUN([AG_WITHLIB_REGEX],[
  AC_ARG_WITH([libregex],
    AC_HELP_STRING([--with-libregex], [libregex installation prefix]),
    [ag_cv_with_libregex_root=${with_libregex}],
    AC_CACHE_CHECK([whether with-libregex was specified], ag_cv_with_libregex_root,
      ag_cv_with_libregex_root=no)
  ) # end of AC_ARG_WITH libregex

  if test "${with_libguile+set}" = set && \
     test "${withval}" = no
  then ## disabled by request
    ag_cv_with_libregex_root=no
    ag_cv_with_libregex_cflags=no
    ag_cv_with_libregex_libs=no
  else

  AC_ARG_WITH([libregex-cflags],
    AC_HELP_STRING([--with-libregex-cflags], [libregex compile flags]),
    [ag_cv_with_libregex_cflags=${with_regex_cflags}],
    AC_CACHE_CHECK([whether with-libregex-cflags was specified], ag_cv_with_libregex_cflags,
      ag_cv_with_libregex_cflags=no)
  ) # end of AC_ARG_WITH libregex-cflags

  AC_ARG_WITH([libregex-libs],
    AC_HELP_STRING([--with-libregex-libs], [libregex link command arguments]),
    [ag_cv_with_libregex_libs=${with_regex_libs}],
    AC_CACHE_CHECK([whether with-libregex-libs was specified], ag_cv_with_libregex_libs,
      ag_cv_with_libregex_libs=no)
  ) # end of AC_ARG_WITH libregex-libs

  case "X${ag_cv_with_libregex_cflags}" in
  Xyes|Xno|X )
    case "X${ag_cv_with_libregex_root}" in
    Xyes|Xno|X ) ag_cv_with_libregex_cflags=no ;;
    * )        ag_cv_with_libregex_cflags=-I${ag_cv_with_libregex_root}/include ;;
    esac
  esac
  case "X${ag_cv_with_libregex_libs}" in
  Xyes|Xno|X )
    case "X${ag_cv_with_libregex_root}" in
    Xyes|Xno|X ) ag_cv_with_libregex_libs=no ;;
    * )        ag_cv_with_libregex_libs="-L${ag_cv_with_libregex_root}/lib -lregex";;
    esac
  esac
  ag_save_CPPFLAGS="${CPPFLAGS}"
  ag_save_LIBS="${LIBS}"
  fi ## disabled by request

  case "X${ag_cv_with_libregex_cflags}" in
  Xyes|Xno|X )
    ag_cv_with_libregex_cflags="" ;;
  * ) CPPFLAGS="${CPPFLAGS} ${ag_cv_with_libregex_cflags}" ;;
  esac
  case "X${ag_cv_with_libregex_libs}" in
  Xyes|Xno|X )
    ag_cv_with_libregex_libs="" ;;
  * )
    LIBS="${LIBS} ${ag_cv_with_libregex_libs}" ;;
  esac
  LIBREGEX_CFLAGS=""
  LIBREGEX_LIBS=""
  AC_MSG_CHECKING([whether libregex functions properly])
  AC_CACHE_VAL([ag_cv_with_libregex],[
  AC_TRY_RUN([@%:@include <stdio.h>
@%:@include <sys/types.h>
@%:@include REGEX_HEADER
static regex_t re;
void comp_re( const char* pzPat ) {
  int res = regcomp( &re, pzPat, REG_EXTENDED|REG_ICASE|REG_NEWLINE );
  if (res == 0) return;
  exit( res ); }
int main() {
  int  res;
  regmatch_t m@<:@2@:>@;
  comp_re( "^.*\@S|@"   );
  comp_re( "()|no.*" );
  comp_re( "."       );
  if (regexec( &re, "X", 2, m, 0 ) != 0)  return 1;
  if ((m@<:@0@:>@.rm_so != 0) || (m@<:@0@:>@.rm_eo != 1)) {
    fputs( "error: regex -->.<-- did not match\n", stderr );
    return 1;
  }
  return 0; }],
    [ag_cv_with_libregex=yes], [ag_cv_with_libregex=no],
    [ag_cv_with_libregex=no]) # end of AC_TRY_RUN 
  ]) # end of AC_CACHE_VAL for ag_cv_with_libregex
  AC_MSG_RESULT([${ag_cv_with_libregex}])

  if test "X${ag_cv_with_libregex}" = Xno
  then
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LIBS="${ag_save_LIBS}"
        	cat >&2 <<'_EOF_'
I cannot detect POSIX compliant regcomp/regexec routines.
These are required for AutoGen to work correctly.  If you have
such a library present on your system, you must specify it by
setting the LIBS environment variable, e.g., "LIBS='-lregex'".
If you do not have such a library on your system, then you should
download and install, for example, the one from:
    ftp://ftp.gnu.org/gnu/rx/
_EOF_
AC_MSG_ERROR([Cannot find working POSIX regex library])
  fi
  
]) # end of AC_DEFUN of AG_WITHLIB_REGEX


AC_DEFUN([AG_RUN_ALLOCATED_CTIME],[
  AC_MSG_CHECKING([whether ctime() allocates memory for its result])
  AC_CACHE_VAL([ag_cv_run_allocated_ctime],[
  AC_TRY_RUN([@%:@include <time.h>
int main (int argc, char** argv) {
   time_t  timeVal = time( (time_t*)NULL );
   char*   pzTime  = ctime( &timeVal );
   free( (void*)pzTime );
   return 0; }],
    [ag_cv_run_allocated_ctime=yes],[ag_cv_run_allocated_ctime=no],[ag_cv_run_allocated_ctime=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_allocated_ctime
  AC_MSG_RESULT([${ag_cv_run_allocated_ctime}])

  if test "X${ag_cv_run_allocated_ctime}" != Xno
  then
    AC_DEFINE([HAVE_ALLOCATED_CTIME],[1],
        [Define this if ctime() allocates memory for its result])
  fi
  
]) # end of AC_DEFUN of AG_RUN_ALLOCATED_CTIME


AC_DEFUN([AG_RUN_PATHFIND],[
  AC_MSG_CHECKING([whether pathfind(3) works])
  AC_CACHE_VAL([ag_cv_run_pathfind],[
  AC_TRY_RUN([@%:@include <string.h>
@%:@include <stdlib.h>
int main (int argc, char** argv) {
   char* pz = pathfind( getenv( "PATH" ), "sh", "x" );
   return (pz == 0) ? 1 : 0;
}],
    [ag_cv_run_pathfind=yes],[ag_cv_run_pathfind=no],[ag_cv_run_pathfind=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_pathfind
  AC_MSG_RESULT([${ag_cv_run_pathfind}])

  if test "X${ag_cv_run_pathfind}" != Xno
  then
    AC_DEFINE([HAVE_PATHFIND],[1],
        [Define this if pathfind(3) works])
  fi
  
]) # end of AC_DEFUN of AG_RUN_PATHFIND


AC_DEFUN([AG_RUN_STRFTIME],[
  AC_MSG_CHECKING([whether strftime() works])
  AC_CACHE_VAL([ag_cv_run_strftime],[
  AC_TRY_RUN([@%:@include <time.h>
@%:@include <string.h>
char t_buf@<:@ 64 @:>@;
int main() {
  static const char z@<:@@:>@ = "Thursday Aug 28 240";
  struct tm tm;
  tm.tm_sec   = 36;  /* seconds after the minute @<:@0, 61@:>@  */
  tm.tm_min   = 44;  /* minutes after the hour @<:@0, 59@:>@ */
  tm.tm_hour  = 12;  /* hour since midnight @<:@0, 23@:>@ */
  tm.tm_mday  = 28;  /* day of the month @<:@1, 31@:>@ */
  tm.tm_mon   =  7;  /* months since January @<:@0, 11@:>@ */
  tm.tm_year  = 86;  /* years since 1900 */
  tm.tm_wday  =  4;  /* days since Sunday @<:@0, 6@:>@ */
  tm.tm_yday  = 239; /* days since January 1 @<:@0, 365@:>@ */
  tm.tm_isdst =  1;  /* flag for daylight savings time */
  strftime( t_buf, sizeof( t_buf ), "%A %b %d %j", &tm );
  return (strcmp( t_buf, z ) != 0); }],
    [ag_cv_run_strftime=yes],[ag_cv_run_strftime=no],[ag_cv_run_strftime=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_strftime
  AC_MSG_RESULT([${ag_cv_run_strftime}])

  if test "X${ag_cv_run_strftime}" != Xno
  then
    AC_DEFINE([HAVE_STRFTIME],[1],
        [Define this if strftime() works])
  fi
  
]) # end of AC_DEFUN of AG_RUN_STRFTIME


AC_DEFUN([AG_RUN_FOPEN_BINARY],[
  AC_MSG_CHECKING([whether fopen accepts "b" mode])
  AC_CACHE_VAL([ag_cv_run_fopen_binary],[
  AC_TRY_RUN([@%:@include <stdio.h>
int main (int argc, char** argv) {
FILE* fp = fopen("conftest.@S|@ac_ext", "rb");
return (fp == NULL) ? 1 : fclose(fp); }],
    [ag_cv_run_fopen_binary=yes],[ag_cv_run_fopen_binary=no],[ag_cv_run_fopen_binary=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_fopen_binary
  AC_MSG_RESULT([${ag_cv_run_fopen_binary}])

  if test "X${ag_cv_run_fopen_binary}" != Xno
  then
    AC_DEFINE([FOPEN_BINARY_FLAG],"b",
	[fopen(3) accepts a 'b' in the mode flag])
  else
    AC_DEFINE([FOPEN_BINARY_FLAG],"",
	[fopen(3) accepts a 'b' in the mode flag])
  fi
  
]) # end of AC_DEFUN of AG_RUN_FOPEN_BINARY


AC_DEFUN([AG_RUN_FOPEN_TEXT],[
  AC_MSG_CHECKING([whether fopen accepts "t" mode])
  AC_CACHE_VAL([ag_cv_run_fopen_text],[
  AC_TRY_RUN([@%:@include <stdio.h>
int main (int argc, char** argv) {
FILE* fp = fopen("conftest.@S|@ac_ext", "rt");
return (fp == NULL) ? 1 : fclose(fp); }],
    [ag_cv_run_fopen_text=yes],[ag_cv_run_fopen_text=no],[ag_cv_run_fopen_text=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_fopen_text
  AC_MSG_RESULT([${ag_cv_run_fopen_text}])

  if test "X${ag_cv_run_fopen_text}" != Xno
  then
    AC_DEFINE([FOPEN_TEXT_FLAG],"t",
	[fopen(3) accepts a 't' in the mode flag])
  else
    AC_DEFINE([FOPEN_TEXT_FLAG],"",
	[fopen(3) accepts a 't' in the mode flag])
  fi
  
]) # end of AC_DEFUN of AG_RUN_FOPEN_TEXT


AC_DEFUN([AG_WITHLIB_GUILE],[
  AC_ARG_WITH([libguile],
    AC_HELP_STRING([--with-libguile], [libguile installation prefix]),
    [ag_cv_with_libguile_root=${with_libguile}],
    AC_CACHE_CHECK([whether with-libguile was specified], ag_cv_with_libguile_root,
      ag_cv_with_libguile_root=no)
  ) # end of AC_ARG_WITH libguile

  if test "${with_libguile+set}" = set && \
     test "${withval}" = no
  then ## disabled by request
    ag_cv_with_libguile_root=no
    ag_cv_with_libguile_cflags=no
    ag_cv_with_libguile_libs=no
  else

  AC_ARG_WITH([libguile-cflags],
    AC_HELP_STRING([--with-libguile-cflags], [libguile compile flags]),
    [ag_cv_with_libguile_cflags=${with_guile_cflags}],
    AC_CACHE_CHECK([whether with-libguile-cflags was specified], ag_cv_with_libguile_cflags,
      ag_cv_with_libguile_cflags=no)
  ) # end of AC_ARG_WITH libguile-cflags

  AC_ARG_WITH([libguile-libs],
    AC_HELP_STRING([--with-libguile-libs], [libguile link command arguments]),
    [ag_cv_with_libguile_libs=${with_guile_libs}],
    AC_CACHE_CHECK([whether with-libguile-libs was specified], ag_cv_with_libguile_libs,
      ag_cv_with_libguile_libs=no)
  ) # end of AC_ARG_WITH libguile-libs

  case "X${ag_cv_with_libguile_cflags}" in
  Xyes|Xno|X )
    case "X${ag_cv_with_libguile_root}" in
    Xyes|Xno|X ) ag_cv_with_libguile_cflags=no ;;
    * )        ag_cv_with_libguile_cflags=-I${ag_cv_with_libguile_root}/include ;;
    esac
  esac
  case "X${ag_cv_with_libguile_libs}" in
  Xyes|Xno|X )
    case "X${ag_cv_with_libguile_root}" in
    Xyes|Xno|X ) ag_cv_with_libguile_libs=no ;;
    * )        ag_cv_with_libguile_libs="-L${ag_cv_with_libguile_root}/lib -lguile";;
    esac
  esac
  ag_save_CPPFLAGS="${CPPFLAGS}"
  ag_save_LIBS="${LIBS}"
  case "X${ag_cv_with_libguile_cflags}" in
  Xyes|Xno|X )
    f=`guile-config compile 2>/dev/null` || f=''
    test -n "${f}" && ag_cv_with_libguile_cflags="${f}" && \
      AC_MSG_NOTICE([guile-config used for CFLAGS: $f]) ;;
  esac
  case "X${ag_cv_with_libguile_libs}" in
  Xyes|Xno|X )
    f=`guile-config link 2>/dev/null` || f=''
    test -n "${f}" && ag_cv_with_libguile_libs="${f}" && \
      AC_MSG_NOTICE([guile-config used for LIBS: $f]) ;;
  esac
  fi ## disabled by request

  case "X${ag_cv_with_libguile_cflags}" in
  Xyes|Xno|X )
    ag_cv_with_libguile_cflags="" ;;
  * ) CPPFLAGS="${CPPFLAGS} ${ag_cv_with_libguile_cflags}" ;;
  esac
  case "X${ag_cv_with_libguile_libs}" in
  Xyes|Xno|X )
    LIBS="${LIBS} -lguile"
    ag_cv_with_libguile_libs="-lguile" ;;
  * )
    LIBS="${LIBS} ${ag_cv_with_libguile_libs}" ;;
  esac
  LIBGUILE_CFLAGS=""
  LIBGUILE_LIBS=""
  AC_MSG_CHECKING([whether libguile can be linked with])
  AC_CACHE_VAL([ag_cv_with_libguile],[
  AC_LINK_IFELSE([[@%:@include <guile/gh.h>
@%:@include <libguile.h>
int main () {
  SCM fumble, bumble, stumble;
  stumble = scm_cons( fumble, bumble );
  stumble = scm_display( fumble, bumble );
  stumble = scm_ilength( fumble );
  stumble = scm_makstr( 1, 2 );
  stumble = gh_eval_str( "stumble" );
  scm_misc_error( "oops", "bad", bumble );
  stumble = scm_num_eq_p( fumble, bumble );
  scm_wrong_type_arg( "oops", 1, bumble );
  return 0; }]],
    [ag_cv_with_libguile=yes],
    [ag_cv_with_libguile=no]) # end of AC_LINK_IFELSE 
  ]) # end of AC_CACHE_VAL for ag_cv_with_libguile
  AC_MSG_RESULT([${ag_cv_with_libguile}])
    AC_SUBST([LIBGUILE_CFLAGS])
    AC_SUBST([LIBGUILE_LIBS])
    AC_SUBST([LIBGUILE_PATH])

  if test "X${ag_cv_with_libguile}" != Xno
  then[
      LIBGUILE_CFLAGS="${ag_cv_with_libguile_cflags}"
      LIBGUILE_LIBS="${ag_cv_with_libguile_libs}"
      case "${LIBGUILE_LIBS}" in *-L* )
        LIBGUILE_PATH=`echo ${LIBGUILE_LIBS} | sed 's/.*-L[ 	]*//;s/[ 	].*//'`
      ;; * ) LIBGUILE_PATH='' ;; esac]
      CPPFLAGS="@S|@{ag_save_CPPFLAGS}"
  LIBS="@S|@{ag_save_LIBS}"
  else
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LIBS="${ag_save_LIBS}"
      LIBGUILE_CFLAGS=''
      LIBGUILE_LIBS=''
      LIBGUILE_PATH=''
      AC_MSG_ERROR([Cannot find working libguile])
  fi
  AC_SUBST([AG_GUILE])
  
]) # end of AC_DEFUN of AG_WITHLIB_GUILE


AC_DEFUN([AG_LINK_EVAL_STRING],[
  AC_MSG_CHECKING([whether scm_primitive_eval_x links])
  AC_CACHE_VAL([ag_cv_link_eval_string],[
    ag_save_CPPFLAGS="${CPPFLAGS}"
    CPPFLAGS="${ag_cv_with_libguile_cflags} ${CPPFLAGS}"
    ag_save_LIBS="${LIBS}"
    LIBS="${ag_cv_with_libguile_libs} ${LIBS}"
  AC_TRY_LINK([@%:@include <guile/gh.h>
@%:@include <libguile.h>],
    [SCM res = scm_primitive_eval_x( SCM_UNDEFINED );],
    [ag_cv_link_eval_string=yes],[ag_cv_link_eval_string=no]
  ) # end of TRY_LINK
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LIBS="${ag_save_LIBS}"
  ]) # end of AC_CACHE_VAL for ag_cv_link_eval_string
  AC_MSG_RESULT([${ag_cv_link_eval_string}])

  if test "X${ag_cv_link_eval_string}" = Xno
  then
    AC_DEFINE([scm_primitive_eval_x], [scm_eval_x],
        [Define this if no scm_primitive_eval_x])
AC_DEFINE([scm_t_port], [scm_port], [Define this if no scm_t_port])
  fi
  
]) # end of AC_DEFUN of AG_LINK_EVAL_STRING


AC_DEFUN([AG_WITHLIB_XML2],[
  AC_ARG_WITH([libxml2],
    AC_HELP_STRING([--with-libxml2], [libxml2 installation prefix]),
    [ag_cv_with_libxml2_root=${with_libxml2}],
    AC_CACHE_CHECK([whether with-libxml2 was specified], ag_cv_with_libxml2_root,
      ag_cv_with_libxml2_root=no)
  ) # end of AC_ARG_WITH libxml2

  if test "${with_libguile+set}" = set && \
     test "${withval}" = no
  then ## disabled by request
    ag_cv_with_libxml2_root=no
    ag_cv_with_libxml2_cflags=no
    ag_cv_with_libxml2_libs=no
  else

  AC_ARG_WITH([libxml2-cflags],
    AC_HELP_STRING([--with-libxml2-cflags], [libxml2 compile flags]),
    [ag_cv_with_libxml2_cflags=${with_xml2_cflags}],
    AC_CACHE_CHECK([whether with-libxml2-cflags was specified], ag_cv_with_libxml2_cflags,
      ag_cv_with_libxml2_cflags=no)
  ) # end of AC_ARG_WITH libxml2-cflags

  AC_ARG_WITH([libxml2-libs],
    AC_HELP_STRING([--with-libxml2-libs], [libxml2 link command arguments]),
    [ag_cv_with_libxml2_libs=${with_xml2_libs}],
    AC_CACHE_CHECK([whether with-libxml2-libs was specified], ag_cv_with_libxml2_libs,
      ag_cv_with_libxml2_libs=no)
  ) # end of AC_ARG_WITH libxml2-libs

  case "X${ag_cv_with_libxml2_cflags}" in
  Xyes|Xno|X )
    case "X${ag_cv_with_libxml2_root}" in
    Xyes|Xno|X ) ag_cv_with_libxml2_cflags=no ;;
    * )        ag_cv_with_libxml2_cflags=-I${ag_cv_with_libxml2_root}/include ;;
    esac
  esac
  case "X${ag_cv_with_libxml2_libs}" in
  Xyes|Xno|X )
    case "X${ag_cv_with_libxml2_root}" in
    Xyes|Xno|X ) ag_cv_with_libxml2_libs=no ;;
    * )        ag_cv_with_libxml2_libs="-L${ag_cv_with_libxml2_root}/lib -lxml2";;
    esac
  esac
  ag_save_CPPFLAGS="${CPPFLAGS}"
  ag_save_LIBS="${LIBS}"
  case "X${ag_cv_with_libxml2_cflags}" in
  Xyes|Xno|X )
    f=`xml2-config --cflags 2>/dev/null` || f=''
    test -n "${f}" && ag_cv_with_libxml2_cflags="${f}" && \
      AC_MSG_NOTICE([xml2-config used for CFLAGS: $f]) ;;
  esac
  case "X${ag_cv_with_libxml2_libs}" in
  Xyes|Xno|X )
    f=`xml2-config --libs 2>/dev/null` || f=''
    test -n "${f}" && ag_cv_with_libxml2_libs="${f}" && \
      AC_MSG_NOTICE([xml2-config used for LIBS: $f]) ;;
  esac
  fi ## disabled by request

  case "X${ag_cv_with_libxml2_cflags}" in
  Xyes|Xno|X )
    ag_cv_with_libxml2_cflags="" ;;
  * ) CPPFLAGS="${CPPFLAGS} ${ag_cv_with_libxml2_cflags}" ;;
  esac
  case "X${ag_cv_with_libxml2_libs}" in
  Xyes|Xno|X )
    LIBS="${LIBS} -lxml2"
    ag_cv_with_libxml2_libs="-lxml2" ;;
  * )
    LIBS="${LIBS} ${ag_cv_with_libxml2_libs}" ;;
  esac
  LIBXML2_CFLAGS=""
  LIBXML2_LIBS=""
  AC_MSG_CHECKING([whether libxml2 can be linked with])
  AC_CACHE_VAL([ag_cv_with_libxml2],[
  AC_LINK_IFELSE([[@%:@include <libxml/parser.h>
@%:@include <libxml/tree.h>

int main () {
xmlDocPtr p = xmlParseFile( "mumble.xml" ); }]],
    [ag_cv_with_libxml2=yes],
    [ag_cv_with_libxml2=no]) # end of AC_LINK_IFELSE 
  ]) # end of AC_CACHE_VAL for ag_cv_with_libxml2
  AC_MSG_RESULT([${ag_cv_with_libxml2}])
    AC_SUBST([LIBXML2_CFLAGS])
    AC_SUBST([LIBXML2_LIBS])
    AC_SUBST([LIBXML2_PATH])

  if test "X${ag_cv_with_libxml2}" != Xno
  then[
      LIBXML2_CFLAGS="${ag_cv_with_libxml2_cflags}"
      LIBXML2_LIBS="${ag_cv_with_libxml2_libs}"
      case "${LIBXML2_LIBS}" in *-L* )
        LIBXML2_PATH=`echo ${LIBXML2_LIBS} | sed 's/.*-L[ 	]*//;s/[ 	].*//'`
      ;; * ) LIBXML2_PATH='' ;; esac]
        CPPFLAGS="@S|@{ag_save_CPPFLAGS}"
    LIBS="@S|@{ag_save_LIBS}"
    XML2AG_DIR=xml2ag
    AC_SUBST([XML2AG_DIR])
  else
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LIBS="${ag_save_LIBS}"
      LIBXML2_CFLAGS=''
      LIBXML2_LIBS=''
      LIBXML2_PATH=''
  fi
  AC_SUBST([AG_XML2])
  
]) # end of AC_DEFUN of AG_WITHLIB_XML2


AC_DEFUN([AG_RUN_POSIX_SYSINFO],[
  AC_MSG_CHECKING([whether sysinfo(2) is POSIX])
  AC_CACHE_VAL([ag_cv_run_posix_sysinfo],[
  AC_TRY_RUN([@%:@include <sys/systeminfo.h>
int main() { char z@<:@ 256 @:>@;
long sz = sysinfo( SI_SYSNAME, z, sizeof( z ));
return (sz > 0) ? 0 : 1; }],
    [ag_cv_run_posix_sysinfo=yes],[ag_cv_run_posix_sysinfo=no],[ag_cv_run_posix_sysinfo=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_posix_sysinfo
  AC_MSG_RESULT([${ag_cv_run_posix_sysinfo}])

  if test "X${ag_cv_run_posix_sysinfo}" != Xno
  then
    AC_DEFINE([HAVE_POSIX_SYSINFO],[1],
        [Define this if sysinfo(2) is POSIX])
  fi
  
]) # end of AC_DEFUN of AG_RUN_POSIX_SYSINFO


AC_DEFUN([AG_RUN_STRCSPN],[
  AC_MSG_CHECKING([whether strcspn matches prototype and works])
  AC_CACHE_VAL([ag_cv_run_strcspn],[
  AC_TRY_RUN([@%:@include <string.h>
int main (int argc, char** argv) {
   char zRej@<:@@:>@ = "reject";
   char zAcc@<:@@:>@ = "a-ok-eject";
   return strcspn( zAcc, zRej ) - 5;
}],
    [ag_cv_run_strcspn=yes],[ag_cv_run_strcspn=no],[ag_cv_run_strcspn=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_strcspn
  AC_MSG_RESULT([${ag_cv_run_strcspn}])

  if test "X${ag_cv_run_strcspn}" != Xno
  then
    AC_DEFINE([HAVE_STRCSPN],[1],
        [Define this if strcspn matches prototype and works])
  else
    COMPATOBJ="@S|@COMPATOBJ strcspn.lo"
  fi
  
]) # end of AC_DEFUN of AG_RUN_STRCSPN


AC_DEFUN([AG_RUN_SYS_SIGLIST],[
  AC_MSG_CHECKING([whether there is a global text array sys_siglist])
  AC_CACHE_VAL([ag_cv_run_sys_siglist],[
  AC_TRY_RUN([@%:@include <signal.h>
int main() {
  const char* pz = sys_siglist@<:@1@:>@;
  return (pz != 0) ? 0 : 1; }],
    [ag_cv_run_sys_siglist=yes],[ag_cv_run_sys_siglist=no],[ag_cv_run_sys_siglist=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_sys_siglist
  AC_MSG_RESULT([${ag_cv_run_sys_siglist}])

  if test "X${ag_cv_run_sys_siglist}" != Xno
  then
    AC_DEFINE([HAVE_SYS_SIGLIST],[1],
        [Define this if there is a global text array sys_siglist])
  fi
  
]) # end of AC_DEFUN of AG_RUN_SYS_SIGLIST


AC_DEFUN([AG_RUN_UNAME_SYSCALL],[
  AC_MSG_CHECKING([whether uname(2) is POSIX])
  AC_CACHE_VAL([ag_cv_run_uname_syscall],[
  AC_TRY_RUN([@%:@include <sys/utsname.h>
int main() { struct utsname unm;
return uname( &unm ); }],
    [ag_cv_run_uname_syscall=yes],[ag_cv_run_uname_syscall=no],[ag_cv_run_uname_syscall=no]
  ) # end of TRY_RUN
  ]) # end of AC_CACHE_VAL for ag_cv_run_uname_syscall
  AC_MSG_RESULT([${ag_cv_run_uname_syscall}])

  if test "X${ag_cv_run_uname_syscall}" != Xno
  then
    AC_DEFINE([HAVE_UNAME_SYSCALL],[1],
        [Define this if uname(2) is POSIX])
  fi
  
]) # end of AC_DEFUN of AG_RUN_UNAME_SYSCALL


AC_DEFUN([AG_COMPILE_LONG_LONG],[
  AC_MSG_CHECKING([whether long long ints])
  AC_CACHE_VAL([ag_cv_compile_long_long],[
  AC_TRY_COMPILE(,[long long i;],
    [ag_cv_compile_long_long=yes],[ag_cv_compile_long_long=no]
  ) # end of TRY_COMPILE
  ]) # end of AC_CACHE_VAL for ag_cv_compile_long_long
  AC_MSG_RESULT([${ag_cv_compile_long_long}])

  if test "X${ag_cv_compile_long_long}" != Xno
  then
    AC_DEFINE([HAVE_LONG_LONG],[1],
        [Define this if long long ints])
  fi
  
]) # end of AC_DEFUN of AG_COMPILE_LONG_LONG


AC_DEFUN([AG_ENABLE_DEBUG],[
  AC_ARG_ENABLE([debug],
    AC_HELP_STRING([--enable-debug], [wanting autogen debugging]),
    [ag_cv_enable_debug=${enable_debug}],
    AC_CACHE_CHECK([whether wanting autogen debugging], ag_cv_enable_debug,
      ag_cv_enable_debug=no)
  ) # end of AC_ARG_ENABLE

  if test "X${ag_cv_enable_debug}" != Xno
  then
    AC_DEFINE([DEBUG_ENABLED],[1],
        [Define this if wanting autogen debugging])
    AC_DEFINE([DEBUG_ENABLED], [1],
        [Define this if debugging is enabled])
    CFLAGS="-g `echo $CFLAGS|sed 's%-g *%%g;s%-O[0-9]* *%%g'`"
    f=`which dmalloc 2>/dev/null`
    [ -n "$f" ] && LIBS="${LIBS} -ldmalloc"
  fi
  
]) # end of AC_DEFUN of AG_ENABLE_DEBUG


AC_DEFUN([INVOKE_AG_MACROS],[
  # Check to see if using shell scripts.
  AG_DISABLE_SHELL

  # Check to see if a reg expr header is specified.
  AG_WITH_REGEX_HEADER

  # Check to see if a working libregex can be found.
  AG_WITHLIB_REGEX

  # Check to see if ctime() allocates memory for its result.
  AG_RUN_ALLOCATED_CTIME

  # Check to see if pathfind(3) works.
  AG_RUN_PATHFIND

  # Check to see if strftime() works.
  AG_RUN_STRFTIME

  # Check to see if fopen accepts "b" mode.
  AG_RUN_FOPEN_BINARY

  # Check to see if fopen accepts "t" mode.
  AG_RUN_FOPEN_TEXT

  # Check to see if a working libguile can be found.
  AG_WITHLIB_GUILE

  # Check to see if scm_primitive_eval_x links.
  AG_LINK_EVAL_STRING

  # Check to see if a working libxml2 can be found.
  AG_WITHLIB_XML2

  # Check to see if sysinfo(2) is POSIX.
  AG_RUN_POSIX_SYSINFO

  # Check to see if strcspn matches prototype and works.
  AG_RUN_STRCSPN

  # Check to see if there is a global text array sys_siglist.
  AG_RUN_SYS_SIGLIST

  # Check to see if uname(2) is POSIX.
  AG_RUN_UNAME_SYSCALL

  # Check to see if long long ints.
  AG_COMPILE_LONG_LONG

  # Check to see if wanting autogen debugging.
  AG_ENABLE_DEBUG
  
  AC_CHECK_FUNCS(fopencookie funopen, break)
  AC_C_INLINE
  AC_CACHE_CHECK([for static inline], [snv_cv_static_inline], [
  AC_TRY_COMPILE([static inline foo(bar) int bar; { return bar; }],
    [return foo(0);],
    [snv_cv_static_inline='static inline'],
    [snv_cv_static_inline='static'])
  ])
  AC_DEFINE_UNQUOTED(SNV_INLINE, ${snv_cv_static_inline},
           [define to static or static inline])
]) # end AC_DEFUN of INVOKE_AG_MACROS
