/*
 *  DO NOT EDIT THIS FILE   (opts.h)
 *  
 *  It has been autogen-ed  Tuesday May 16, 2000 at 11:11:32 PM BST
 *  From the definitions    ./opts.def
 *  and the template file   ../autoopts/options.tpl
 */

/*
 *  This file contains the programmatic interface to the
 *  Automated Options generated for the AutoGen program.
 *  These macros are documented in the AutoGen info file
 *  in the "Autoopts" chapter.  Please refer to that doc
 *  for usage help.
 */

#ifndef AUTOGEN_OPTS_H
#define AUTOGEN_OPTS_H

/*
 * Autogen copyright 1992-1999 Bruce Korb
 *
 * Autogen is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * Autogen is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Autogen.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */
#include <options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_TEMPL_DIRS       =  0,
        INDEX_OPT_OVERRIDE_TPL     =  1,
        INDEX_OPT_BASE_NAME        =  2,
        INDEX_OPT_SKIP_SUFFIX      =  3,
        INDEX_OPT_EQUATE           =  4,
        INDEX_OPT_LOOP_LIMIT       =  6,
        INDEX_OPT_TIMEOUT          =  7,
        INDEX_OPT_DEFINE           =  9,
        INDEX_OPT_UNDEFINE         = 10,
        INDEX_OPT_VERSION          = 11,
        INDEX_OPT_HELP             = 12,
        INDEX_OPT_MORE_HELP        = 13,
        INDEX_OPT_SAVE_OPTS        = 14,
        INDEX_OPT_LOAD_OPTS        = 15
} teOptIndex;

#define OPTION_CT    16
#define AUTOGEN_VERSION       "4.5.14"
#define AUTOGEN_FULL_VERSION  "AutoGen - The Automated Program Generator - Ver. 4.5.14"

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( TEMPL_DIRS )
 */
#define     DESC(n)     AutoGenOptions.pOptDesc[INDEX_OPT_ ## n]
#define     HAVE_OPT(n) (! UNUSED_OPT(&DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = (void*)NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_TEMPL_DIRS     'L'
#define SET_OPT_TEMPL_DIRS(a)   STMTS( \
        DESC(TEMPL_DIRS).optActualIndex = 0; \
        DESC(TEMPL_DIRS).optActualValue = VALUE_OPT_TEMPL_DIRS; \
        DESC(TEMPL_DIRS).fOptState &= OPTST_PERSISTENT; \
        DESC(TEMPL_DIRS).fOptState |= OPTST_SET; \
        DESC(TEMPL_DIRS).pzLastArg  = (a); \
        (*(DESC(TEMPL_DIRS).pOptProc))( &AutoGenOptions, \
                AutoGenOptions.pOptDesc + 0 ) )
#define VALUE_OPT_OVERRIDE_TPL   'T'
#define VALUE_OPT_BASE_NAME      'b'
#define VALUE_OPT_SKIP_SUFFIX    's'
#define VALUE_OPT_EQUATE         4
#define VALUE_OPT_LOOP_LIMIT     6
#define OPT_VALUE_LOOP_LIMIT     ((int)(OPT_ARG(LOOP_LIMIT)))
#define VALUE_OPT_TIMEOUT        't'
#define OPT_VALUE_TIMEOUT        ((int)(OPT_ARG(TIMEOUT)))
#define VALUE_OPT_DEFINE         'D'
#define WHICH_OPT_DEFINE         (DESC(DEFINE).optActualValue)
#define WHICH_IDX_DEFINE         (DESC(DEFINE).optActualIndex)
#define SET_OPT_DEFINE(a)   STMTS( \
        DESC(DEFINE).optActualIndex = 9; \
        DESC(DEFINE).optActualValue = VALUE_OPT_DEFINE; \
        DESC(DEFINE).fOptState &= OPTST_PERSISTENT; \
        DESC(DEFINE).fOptState |= OPTST_SET; \
        DESC(DEFINE).pzLastArg  = (a); \
        (*(DESC(DEFINE).pOptProc))( &AutoGenOptions, \
                AutoGenOptions.pOptDesc + 9 ) )
#define VALUE_OPT_UNDEFINE       'U'
#define SET_OPT_UNDEFINE(a)   STMTS( \
        DESC(DEFINE).optActualIndex = 10; \
        DESC(DEFINE).optActualValue = VALUE_OPT_UNDEFINE; \
        DESC(DEFINE).fOptState &= OPTST_PERSISTENT; \
        DESC(DEFINE).fOptState |= OPTST_SET | OPTST_EQUIVALENCE; \
        DESC(DEFINE).pzLastArg  = (a); \
        (*(DESC(UNDEFINE).pOptProc))( &AutoGenOptions, \
                AutoGenOptions.pOptDesc + INDEX_OPT_DEFINE ) )

#define VALUE_OPT_VERSION        'v'
#define VALUE_OPT_SAVE_OPTS      '>'
#define VALUE_OPT_LOAD_OPTS      '<'
#define VALUE_OPT_HELP           '?'
#define VALUE_OPT_MORE_HELP      '!'

/*
 *  Interface defines not associated with particular options
 */
#define  ERRSKIP_OPTERR STMTS( AutoGenOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define  ERRSTOP_OPTERR STMTS( AutoGenOptions.fOptSet |= OPTPROC_ERRSTOP )
#define  RESTART_OPT(n) STMTS( \
                AutoGenOptions.curOptIdx = (n); \
                AutoGenOptions.pzCurOpt  = (char*)NULL )
#define    START_OPT    RESTART_OPT(1)
#define     USAGE(c)    (*AutoGenOptions.pUsageProc)( &AutoGenOptions, c )

/* * * * * *
 *
 *  Declare the AutoGen option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   AutoGenOptions;

/* * * * * *
 *
 *  Globals exported from the The Automated Program Generator option definitions
 */
#ifdef DEBUG
#  include "DEBUG specified for compile, but not in options"
#endif

#ifdef  __cplusplus
}
#endif
#endif /* AUTOGEN_OPTS_H */

