/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.Selectable;
import ca.odell.glazedlists.swt.SelectionManager;
import ca.odell.glazedlists.swt.TableCheckFilterList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EventTableViewer
implements ListEventListener {
    private Table table;
    private TableHandler tableHandler = null;
    private TransformedList disposeSource = null;
    private TransformedList swtSource = null;
    private TableCheckFilterList checkFilter = null;
    private TableFormat tableFormat;
    private SelectionManager selection = null;

    public EventTableViewer(EventList source, Table table, String[] propertyNames, String[] columnLabels) {
        this(source, table, GlazedLists.tableFormat(propertyNames, columnLabels));
    }

    public EventTableViewer(EventList source, Table table, TableFormat tableFormat) {
        this.disposeSource = this.swtSource = GlazedListsSWT.swtThreadProxyList(source, table.getDisplay());
        if ((table.getStyle() & 0x20) == 32) {
            this.checkFilter = new TableCheckFilterList(this.swtSource, table, tableFormat);
            this.swtSource = this.checkFilter;
        }
        this.table = table;
        this.tableFormat = tableFormat;
        this.selection = new SelectionManager(this.swtSource, new SelectableTable());
        this.tableHandler = (table.getStyle() & 0x10000000) == 0x10000000 ? new VirtualTableHandler() : new DefaultTableHandler();
        this.initTable();
        this.tableHandler.populateTable();
        this.swtSource.addListEventListener(this);
    }

    private void initTable() {
        this.table.setHeaderVisible(true);
        for (int c = 0; c < this.tableFormat.getColumnCount(); ++c) {
            TableColumn column = new TableColumn(this.table, 16384, c);
            column.setText(this.tableFormat.getColumnName(c));
            column.setWidth(80);
        }
    }

    private void setItemText(TableItem item, Object value) {
        for (int i = 0; i < this.tableFormat.getColumnCount(); ++i) {
            Object cellValue = this.tableFormat.getColumnValue(value, i);
            if (cellValue != null) {
                item.setText(i, cellValue.toString());
                continue;
            }
            item.setText(i, "");
        }
    }

    public TableFormat getTableFormat() {
        return this.tableFormat;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTableFormat(TableFormat tableFormat) {
        throw new UnsupportedOperationException();
    }

    public void setCheckedOnly(boolean checkedOnly) {
        this.checkFilter.setCheckedOnly(checkedOnly);
    }

    public boolean getCheckedOnly() {
        return this.checkFilter.getCheckedOnly();
    }

    public List getAllChecked() {
        return this.checkFilter.getAllChecked();
    }

    public EventList getSourceList() {
        return this.swtSource;
    }

    public EventList getDeselected() {
        return this.selection.getSelectionList().getDeselected();
    }

    public EventList getSelected() {
        return this.selection.getSelectionList().getSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(ListEvent listChanges) {
        this.swtSource.getReadWriteLock().readLock().lock();
        Barcode deletes = new Barcode();
        deletes.addWhite(0, this.swtSource.size());
        int firstChange = this.swtSource.size();
        try {
            this.table.setRedraw(false);
            while (listChanges.next()) {
                int changeIndex = listChanges.getIndex();
                int adjustedIndex = deletes.getIndex(changeIndex, Barcode.WHITE);
                int changeType = listChanges.getType();
                if (changeType == 2) {
                    deletes.addWhite(adjustedIndex, 1);
                    this.tableHandler.addRow(adjustedIndex, this.swtSource.get(changeIndex));
                    firstChange = Math.min(changeIndex, firstChange);
                    continue;
                }
                if (changeType == 1) {
                    this.tableHandler.updateRow(adjustedIndex, this.swtSource.get(changeIndex));
                    continue;
                }
                if (changeType != 0) continue;
                deletes.setBlack(adjustedIndex, 1);
                firstChange = Math.min(changeIndex, firstChange);
            }
            if (deletes.blackSize() > 0) {
                int[] deletedIndices = new int[deletes.blackSize()];
                BarcodeIterator i = deletes.iterator();
                while (i.hasNextBlack()) {
                    i.nextBlack();
                    deletedIndices[i.getBlackIndex()] = i.getIndex();
                }
                this.tableHandler.removeAll(deletedIndices);
            }
            this.table.setRedraw(true);
        }
        finally {
            this.swtSource.getReadWriteLock().readLock().unlock();
        }
    }

    public void invertSelection() {
        this.selection.getSelectionList().invertSelection();
    }

    public void dispose() {
        this.tableHandler.dispose();
        this.selection.dispose();
        this.disposeSource.dispose();
    }

    private final class VirtualTableHandler
    implements TableHandler,
    Listener {
        private Barcode requested = new Barcode();

        public VirtualTableHandler() {
            this.requested.addWhite(0, EventTableViewer.this.swtSource.size());
            EventTableViewer.this.table.addListener(36, (Listener)this);
        }

        public void populateTable() {
            EventTableViewer.this.table.setItemCount(EventTableViewer.this.swtSource.size());
        }

        public void addRow(int row, Object value) {
            if (row <= this.getLastIndex()) {
                this.requested.addBlack(row, 1);
                TableItem item = new TableItem(EventTableViewer.this.table, 0, row);
                EventTableViewer.this.setItemText(item, value);
            } else {
                this.requested.addWhite(this.requested.size(), 1);
                EventTableViewer.this.table.setItemCount(EventTableViewer.this.table.getItemCount() + 1);
            }
        }

        public void updateRow(int row, Object value) {
            if (!this.isVirtual(row)) {
                this.requested.setBlack(row, 1);
                TableItem item = EventTableViewer.this.table.getItem(row);
                EventTableViewer.this.setItemText(item, value);
            }
        }

        public void removeAll(int[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                this.requested.remove(rows[i] - i, 1);
            }
            EventTableViewer.this.table.remove(rows);
        }

        private int getLastIndex() {
            if (this.requested.blackSize() == 0) {
                return -1;
            }
            return this.requested.getIndex(this.requested.blackSize() - 1, Barcode.BLACK);
        }

        private boolean isVirtual(int rowIndex) {
            return this.requested.getBlackIndex(rowIndex) == -1;
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            int whiteIndex = this.requested.getWhiteIndex(EventTableViewer.this.table.getTopIndex(), false);
            int index = this.requested.getIndex(whiteIndex, Barcode.WHITE);
            this.requested.setBlack(index, 1);
            EventTableViewer.this.setItemText(item, EventTableViewer.this.swtSource.get(index));
        }

        public void dispose() {
            EventTableViewer.this.table.removeListener(36, (Listener)this);
        }
    }

    private final class DefaultTableHandler
    implements TableHandler {
        private DefaultTableHandler() {
        }

        public void populateTable() {
            for (int r = 0; r < EventTableViewer.this.swtSource.size(); ++r) {
                this.addRow(r, EventTableViewer.this.swtSource.get(r));
            }
        }

        public void addRow(int row, Object value) {
            TableItem item = new TableItem(EventTableViewer.this.table, 0, row);
            EventTableViewer.this.setItemText(item, value);
        }

        public void updateRow(int row, Object value) {
            TableItem item = EventTableViewer.this.table.getItem(row);
            EventTableViewer.this.setItemText(item, value);
        }

        public void removeAll(int[] rows) {
            EventTableViewer.this.table.remove(rows);
        }

        public void dispose() {
        }
    }

    private static interface TableHandler {
        public void populateTable();

        public void addRow(int var1, Object var2);

        public void updateRow(int var1, Object var2);

        public void removeAll(int[] var1);

        public void dispose();
    }

    private final class SelectableTable
    implements Selectable {
        private SelectableTable() {
        }

        public void addSelectionListener(SelectionListener listener) {
            EventTableViewer.this.table.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            EventTableViewer.this.table.removeSelectionListener(listener);
        }

        public int getSelectionIndex() {
            return EventTableViewer.this.table.getSelectionIndex();
        }

        public int[] getSelectionIndices() {
            return EventTableViewer.this.table.getSelectionIndices();
        }

        public int getStyle() {
            return EventTableViewer.this.table.getStyle();
        }

        public void select(int index) {
            EventTableViewer.this.table.select(index);
        }

        public void deselect(int index) {
            EventTableViewer.this.table.deselect(index);
        }
    }
}

