"""Generated client library for serviceusage version v2beta."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.serviceusage.v2beta import serviceusage_v2beta_messages as messages


class ServiceusageV2beta(base_api.BaseApiClient):
  """Generated client library for service serviceusage version v2beta."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://serviceusage.googleapis.com/'
  MTLS_BASE_URL = 'https://serviceusage.mtls.googleapis.com/'

  _PACKAGE = 'serviceusage'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only', 'https://www.googleapis.com/auth/service.management']
  _VERSION = 'v2beta'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ServiceusageV2beta'
  _URL_VERSION = 'v2beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new serviceusage handle."""
    url = url or self.BASE_URL
    super(ServiceusageV2beta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.categories_categoryServices = self.CategoriesCategoryServicesService(self)
    self.categories = self.CategoriesService(self)
    self.consumerPolicies = self.ConsumerPoliciesService(self)
    self.contentSecurityPolicies = self.ContentSecurityPoliciesService(self)
    self.mcpPolicies = self.McpPoliciesService(self)
    self.operations = self.OperationsService(self)
    self.services_apis_apiVersions_apiOperations = self.ServicesApisApiVersionsApiOperationsService(self)
    self.services_apis_apiVersions = self.ServicesApisApiVersionsService(self)
    self.services_apis = self.ServicesApisService(self)
    self.services_groups_expandedMembers = self.ServicesGroupsExpandedMembersService(self)
    self.services_groups_members = self.ServicesGroupsMembersService(self)
    self.services_groups = self.ServicesGroupsService(self)
    self.services = self.ServicesService(self)
    self.sharedServices = self.SharedServicesService(self)
    self.v2beta = self.V2betaService(self)

  class CategoriesCategoryServicesService(base_api.BaseApiService):
    """Service class for the categories_categoryServices resource."""

    _NAME = 'categories_categoryServices'

    def __init__(self, client):
      super(ServiceusageV2beta.CategoriesCategoryServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List the services that belong to a given category. The supported categories are: `categories/google` and `categories/partner`.

      Args:
        request: (ServiceusageCategoriesCategoryServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCategoryServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/categories/{categoriesId}/categoryServices',
        http_method='GET',
        method_id='serviceusage.categories.categoryServices.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2beta/{+parent}/categoryServices',
        request_field='',
        request_type_name='ServiceusageCategoriesCategoryServicesListRequest',
        response_type_name='ListCategoryServicesResponse',
        supports_download=False,
    )

  class CategoriesService(base_api.BaseApiService):
    """Service class for the categories resource."""

    _NAME = 'categories'

    def __init__(self, client):
      super(ServiceusageV2beta.CategoriesService, self).__init__(client)
      self._upload_configs = {
          }

  class ConsumerPoliciesService(base_api.BaseApiService):
    """Service class for the consumerPolicies resource."""

    _NAME = 'consumerPolicies'

    def __init__(self, client):
      super(ServiceusageV2beta.ConsumerPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Analyze(self, request, global_params=None):
      r"""Analyze a consumer policy change without kicking off the actual update. The consumer policy is subject to change before the actual update takes place.

      Args:
        request: (ServiceusageConsumerPoliciesAnalyzeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Analyze')
      return self._RunMethod(
          config, request, global_params=global_params)

    Analyze.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/consumerPolicies/{consumerPoliciesId}:analyze',
        http_method='POST',
        method_id='serviceusage.consumerPolicies.analyze',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}:analyze',
        request_field='analyzeConsumerPolicyRequest',
        request_type_name='ServiceusageConsumerPoliciesAnalyzeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get the consumer policy of a resource.

      Args:
        request: (ServiceusageConsumerPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiServiceusageV2betaConsumerPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/consumerPolicies/{consumerPoliciesId}',
        http_method='GET',
        method_id='serviceusage.consumerPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageConsumerPoliciesGetRequest',
        response_type_name='GoogleApiServiceusageV2betaConsumerPolicy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update the consumer policy of a resource.

      Args:
        request: (ServiceusageConsumerPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/consumerPolicies/{consumerPoliciesId}',
        http_method='PATCH',
        method_id='serviceusage.consumerPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'validateOnly'],
        relative_path='v2beta/{+name}',
        request_field='googleApiServiceusageV2betaConsumerPolicy',
        request_type_name='ServiceusageConsumerPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ContentSecurityPoliciesService(base_api.BaseApiService):
    """Service class for the contentSecurityPolicies resource."""

    _NAME = 'contentSecurityPolicies'

    def __init__(self, client):
      super(ServiceusageV2beta.ContentSecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get the content security policy of a resource.

      Args:
        request: (ServiceusageContentSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ContentSecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/contentSecurityPolicies/{contentSecurityPoliciesId}',
        http_method='GET',
        method_id='serviceusage.contentSecurityPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageContentSecurityPoliciesGetRequest',
        response_type_name='ContentSecurityPolicy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update the content security policy of a resource.

      Args:
        request: (ServiceusageContentSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/contentSecurityPolicies/{contentSecurityPoliciesId}',
        http_method='PATCH',
        method_id='serviceusage.contentSecurityPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'validateOnly'],
        relative_path='v2beta/{+name}',
        request_field='contentSecurityPolicy',
        request_type_name='ServiceusageContentSecurityPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class McpPoliciesService(base_api.BaseApiService):
    """Service class for the mcpPolicies resource."""

    _NAME = 'mcpPolicies'

    def __init__(self, client):
      super(ServiceusageV2beta.McpPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get the MCP consumer policy of a resource.

      Args:
        request: (ServiceusageMcpPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (McpPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/mcpPolicies/{mcpPoliciesId}',
        http_method='GET',
        method_id='serviceusage.mcpPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageMcpPoliciesGetRequest',
        response_type_name='McpPolicy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update the MCP consumer policy of a resource.

      Args:
        request: (ServiceusageMcpPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/mcpPolicies/{mcpPoliciesId}',
        http_method='PATCH',
        method_id='serviceusage.mcpPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'validateOnly'],
        relative_path='v2beta/{+name}',
        request_field='mcpPolicy',
        request_type_name='ServiceusageMcpPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = 'operations'

    def __init__(self, client):
      super(ServiceusageV2beta.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ServiceusageOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/operations/{operationsId}',
        http_method='GET',
        method_id='serviceusage.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ServiceusageOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='serviceusage.operations.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'name', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v2beta/operations',
        request_field='',
        request_type_name='ServiceusageOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ServicesApisApiVersionsApiOperationsService(base_api.BaseApiService):
    """Service class for the services_apis_apiVersions_apiOperations resource."""

    _NAME = 'services_apis_apiVersions_apiOperations'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesApisApiVersionsApiOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List the API operations of a given API version.

      Args:
        request: (ServiceusageServicesApisApiVersionsApiOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListApiOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services/{servicesId}/apis/{apisId}/apiVersions/{apiVersionsId}/apiOperations',
        http_method='GET',
        method_id='serviceusage.services.apis.apiVersions.apiOperations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2beta/{+parent}/apiOperations',
        request_field='',
        request_type_name='ServiceusageServicesApisApiVersionsApiOperationsListRequest',
        response_type_name='ListApiOperationsResponse',
        supports_download=False,
    )

  class ServicesApisApiVersionsService(base_api.BaseApiService):
    """Service class for the services_apis_apiVersions resource."""

    _NAME = 'services_apis_apiVersions'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesApisApiVersionsService, self).__init__(client)
      self._upload_configs = {
          }

  class ServicesApisService(base_api.BaseApiService):
    """Service class for the services_apis resource."""

    _NAME = 'services_apis'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesApisService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List APIs exposed by the given service.

      Args:
        request: (ServiceusageServicesApisListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceApisResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services/{servicesId}/apis',
        http_method='GET',
        method_id='serviceusage.services.apis.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2beta/{+parent}/apis',
        request_field='',
        request_type_name='ServiceusageServicesApisListRequest',
        response_type_name='ListServiceApisResponse',
        supports_download=False,
    )

  class ServicesGroupsExpandedMembersService(base_api.BaseApiService):
    """Service class for the services_groups_expandedMembers resource."""

    _NAME = 'services_groups_expandedMembers'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesGroupsExpandedMembersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List the expanded members that belong to a given service group or transitively to any of the groups that are members of the service group. The expanded members are always services. The service group is defined by service producers. It throws NOT_FOUND if the given service group is not defined.

      Args:
        request: (ServiceusageServicesGroupsExpandedMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExpandedMembersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services/{servicesId}/groups/{groupsId}/expandedMembers',
        http_method='GET',
        method_id='serviceusage.services.groups.expandedMembers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2beta/{+parent}/expandedMembers',
        request_field='',
        request_type_name='ServiceusageServicesGroupsExpandedMembersListRequest',
        response_type_name='ListExpandedMembersResponse',
        supports_download=False,
    )

  class ServicesGroupsMembersService(base_api.BaseApiService):
    """Service class for the services_groups_members resource."""

    _NAME = 'services_groups_members'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesGroupsMembersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List members for the given service group. The service group is a producer defined service group.

      Args:
        request: (ServiceusageServicesGroupsMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGroupMembersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services/{servicesId}/groups/{groupsId}/members',
        http_method='GET',
        method_id='serviceusage.services.groups.members.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'view'],
        relative_path='v2beta/{+parent}/members',
        request_field='',
        request_type_name='ServiceusageServicesGroupsMembersListRequest',
        response_type_name='ListGroupMembersResponse',
        supports_download=False,
    )

  class ServicesGroupsService(base_api.BaseApiService):
    """Service class for the services_groups resource."""

    _NAME = 'services_groups'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List service groups owned by the given service.

      Args:
        request: (ServiceusageServicesGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services/{servicesId}/groups',
        http_method='GET',
        method_id='serviceusage.services.groups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'view'],
        relative_path='v2beta/{+parent}/groups',
        request_field='',
        request_type_name='ServiceusageServicesGroupsListRequest',
        response_type_name='ListServiceGroupsResponse',
        supports_download=False,
    )

  class ServicesService(base_api.BaseApiService):
    """Service class for the services resource."""

    _NAME = 'services'

    def __init__(self, client):
      super(ServiceusageV2beta.ServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchGet(self, request, global_params=None):
      r"""Get the details of a collection of services.

      Args:
        request: (ServiceusageServicesBatchGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BatchGetServicesResponse) The response message.
      """
      config = self.GetMethodConfig('BatchGet')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchGet.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services:batchGet',
        http_method='GET',
        method_id='serviceusage.services.batchGet',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['services', 'view'],
        relative_path='v2beta/{+parent}/services:batchGet',
        request_field='',
        request_type_name='ServiceusageServicesBatchGetRequest',
        response_type_name='BatchGetServicesResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get the details of a service.

      Args:
        request: (ServiceusageServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceState) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/services/{servicesId}',
        http_method='GET',
        method_id='serviceusage.services.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['view'],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageServicesGetRequest',
        response_type_name='ServiceState',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List public services.

      Args:
        request: (ServiceusageServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPublicServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='serviceusage.services.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2beta/services',
        request_field='',
        request_type_name='ServiceusageServicesListRequest',
        response_type_name='ListPublicServicesResponse',
        supports_download=False,
    )

  class SharedServicesService(base_api.BaseApiService):
    """Service class for the sharedServices resource."""

    _NAME = 'sharedServices'

    def __init__(self, client):
      super(ServiceusageV2beta.SharedServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List shared services to the given resource.

      Args:
        request: (ServiceusageSharedServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSharedServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/sharedServices',
        http_method='GET',
        method_id='serviceusage.sharedServices.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2beta/{+parent}/sharedServices',
        request_field='',
        request_type_name='ServiceusageSharedServicesListRequest',
        response_type_name='ListSharedServicesResponse',
        supports_download=False,
    )

  class V2betaService(base_api.BaseApiService):
    """Service class for the v2beta resource."""

    _NAME = 'v2beta'

    def __init__(self, client):
      super(ServiceusageV2beta.V2betaService, self).__init__(client)
      self._upload_configs = {
          }

    def GetEffectiveMcpPolicy(self, request, global_params=None):
      r"""Get effective MCP consumer policy for a resource, which contains enable rule information of MCP consumer policies from the resource hierarchy.

      Args:
        request: (ServiceusageGetEffectiveMcpPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EffectiveMcpPolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveMcpPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveMcpPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/effectiveMcpPolicy',
        http_method='GET',
        method_id='serviceusage.getEffectiveMcpPolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['view'],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageGetEffectiveMcpPolicyRequest',
        response_type_name='EffectiveMcpPolicy',
        supports_download=False,
    )

    def GetEffectivePolicy(self, request, global_params=None):
      r"""Get effective consumer policy for a resource, which contains enable rule information of consumer policies from the resource hierarchy.

      Args:
        request: (ServiceusageGetEffectivePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EffectivePolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectivePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectivePolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}/effectivePolicy',
        http_method='GET',
        method_id='serviceusage.getEffectivePolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['view'],
        relative_path='v2beta/{+name}',
        request_field='',
        request_type_name='ServiceusageGetEffectivePolicyRequest',
        response_type_name='EffectivePolicy',
        supports_download=False,
    )

    def TestEnabled(self, request, global_params=None):
      r"""Tests a value against the result of merging consumer policies in the resource hierarchy. This operation is designed to be used for building policy-aware UIs and command-line tools, not for access checking.

      Args:
        request: (ServiceusageTestEnabledRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (State) The response message.
      """
      config = self.GetMethodConfig('TestEnabled')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestEnabled.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}:testEnabled',
        http_method='POST',
        method_id='serviceusage.testEnabled',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}:testEnabled',
        request_field='testEnabledRequest',
        request_type_name='ServiceusageTestEnabledRequest',
        response_type_name='State',
        supports_download=False,
    )

    def TestMcpEnabled(self, request, global_params=None):
      r"""Tests a value against the result of merging MCP consumer policies in the resource hierarchy. This operation is designed to be used for building policy-aware UIs and command-line tools, not for access checking.

      Args:
        request: (ServiceusageTestMcpEnabledRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (McpState) The response message.
      """
      config = self.GetMethodConfig('TestMcpEnabled')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestMcpEnabled.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2beta/{v2betaId}/{v2betaId1}:testMcpEnabled',
        http_method='POST',
        method_id='serviceusage.testMcpEnabled',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2beta/{+name}:testMcpEnabled',
        request_field='testMcpEnabledRequest',
        request_type_name='ServiceusageTestMcpEnabledRequest',
        response_type_name='McpState',
        supports_download=False,
    )
