"""Generated client library for observability version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.observability.v1 import observability_v1_messages as messages


class ObservabilityV1(base_api.BaseApiClient):
  """Generated client library for service observability version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://observability.googleapis.com/'
  MTLS_BASE_URL = 'https://observability.mtls.googleapis.com/'

  _PACKAGE = 'observability'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ObservabilityV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new observability handle."""
    url = url or self.BASE_URL
    super(ObservabilityV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders_locations = self.FoldersLocationsService(self)
    self.folders = self.FoldersService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_scopes = self.ProjectsLocationsScopesService(self)
    self.projects_locations_traceScopes = self.ProjectsLocationsTraceScopesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class FoldersLocationsService(base_api.BaseApiService):
    """Service class for the folders_locations resource."""

    _NAME = 'folders_locations'

    def __init__(self, client):
      super(ObservabilityV1.FoldersLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetSettings(self, request, global_params=None):
      r"""Get Settings.

      Args:
        request: (ObservabilityFoldersLocationsGetSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Settings) The response message.
      """
      config = self.GetMethodConfig('GetSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/settings',
        http_method='GET',
        method_id='observability.folders.locations.getSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityFoldersLocationsGetSettingsRequest',
        response_type_name='Settings',
        supports_download=False,
    )

    def UpdateSettings(self, request, global_params=None):
      r"""Update Settings.

      Args:
        request: (ObservabilityFoldersLocationsUpdateSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/settings',
        http_method='PATCH',
        method_id='observability.folders.locations.updateSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='settings',
        request_type_name='ObservabilityFoldersLocationsUpdateSettingsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(ObservabilityV1.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = 'organizations_locations'

    def __init__(self, client):
      super(ObservabilityV1.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetSettings(self, request, global_params=None):
      r"""Get Settings.

      Args:
        request: (ObservabilityOrganizationsLocationsGetSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Settings) The response message.
      """
      config = self.GetMethodConfig('GetSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/settings',
        http_method='GET',
        method_id='observability.organizations.locations.getSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityOrganizationsLocationsGetSettingsRequest',
        response_type_name='Settings',
        supports_download=False,
    )

    def UpdateSettings(self, request, global_params=None):
      r"""Update Settings.

      Args:
        request: (ObservabilityOrganizationsLocationsUpdateSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/settings',
        http_method='PATCH',
        method_id='observability.organizations.locations.updateSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='settings',
        request_type_name='ObservabilityOrganizationsLocationsUpdateSettingsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(ObservabilityV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(ObservabilityV1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (ObservabilityProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='observability.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='ObservabilityProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (ObservabilityProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='observability.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ObservabilityProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='observability.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ObservabilityProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='observability.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1/{+name}/operations',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsScopesService(base_api.BaseApiService):
    """Service class for the projects_locations_scopes resource."""

    _NAME = 'projects_locations_scopes'

    def __init__(self, client):
      super(ObservabilityV1.ProjectsLocationsScopesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a single Scope.

      Args:
        request: (ObservabilityProjectsLocationsScopesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Scope) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/scopes/{scopesId}',
        http_method='GET',
        method_id='observability.projects.locations.scopes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsScopesGetRequest',
        response_type_name='Scope',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Scope.

      Args:
        request: (ObservabilityProjectsLocationsScopesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Scope) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/scopes/{scopesId}',
        http_method='PATCH',
        method_id='observability.projects.locations.scopes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='scope',
        request_type_name='ObservabilityProjectsLocationsScopesPatchRequest',
        response_type_name='Scope',
        supports_download=False,
    )

  class ProjectsLocationsTraceScopesService(base_api.BaseApiService):
    """Service class for the projects_locations_traceScopes resource."""

    _NAME = 'projects_locations_traceScopes'

    def __init__(self, client):
      super(ObservabilityV1.ProjectsLocationsTraceScopesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a new TraceScope.

      Args:
        request: (ObservabilityProjectsLocationsTraceScopesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TraceScope) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/traceScopes',
        http_method='POST',
        method_id='observability.projects.locations.traceScopes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['traceScopeId'],
        relative_path='v1/{+parent}/traceScopes',
        request_field='traceScope',
        request_type_name='ObservabilityProjectsLocationsTraceScopesCreateRequest',
        response_type_name='TraceScope',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a TraceScope.

      Args:
        request: (ObservabilityProjectsLocationsTraceScopesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/traceScopes/{traceScopesId}',
        http_method='DELETE',
        method_id='observability.projects.locations.traceScopes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsTraceScopesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get TraceScope resource.

      Args:
        request: (ObservabilityProjectsLocationsTraceScopesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TraceScope) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/traceScopes/{traceScopesId}',
        http_method='GET',
        method_id='observability.projects.locations.traceScopes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsTraceScopesGetRequest',
        response_type_name='TraceScope',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List TraceScopes of a project in a particular location.

      Args:
        request: (ObservabilityProjectsLocationsTraceScopesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTraceScopesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/traceScopes',
        http_method='GET',
        method_id='observability.projects.locations.traceScopes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/traceScopes',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsTraceScopesListRequest',
        response_type_name='ListTraceScopesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update a TraceScope.

      Args:
        request: (ObservabilityProjectsLocationsTraceScopesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TraceScope) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/traceScopes/{traceScopesId}',
        http_method='PATCH',
        method_id='observability.projects.locations.traceScopes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='traceScope',
        request_type_name='ObservabilityProjectsLocationsTraceScopesPatchRequest',
        response_type_name='TraceScope',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ObservabilityV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (ObservabilityProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='observability.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def GetSettings(self, request, global_params=None):
      r"""Get Settings.

      Args:
        request: (ObservabilityProjectsLocationsGetSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Settings) The response message.
      """
      config = self.GetMethodConfig('GetSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/settings',
        http_method='GET',
        method_id='observability.projects.locations.getSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsGetSettingsRequest',
        response_type_name='Settings',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (ObservabilityProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='observability.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/locations',
        request_field='',
        request_type_name='ObservabilityProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

    def UpdateSettings(self, request, global_params=None):
      r"""Update Settings.

      Args:
        request: (ObservabilityProjectsLocationsUpdateSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/settings',
        http_method='PATCH',
        method_id='observability.projects.locations.updateSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='settings',
        request_type_name='ObservabilityProjectsLocationsUpdateSettingsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ObservabilityV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
