/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadData;

public class ThreadStateIcon
implements Icon {
    public static final int ICON_NONE = -100;
    protected Color threadStateColor;
    protected int height;
    protected int width;

    public ThreadStateIcon(int threadState, int width, int height) {
        this.threadStateColor = this.getThreadStateColor(threadState);
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.threadStateColor != null) {
            g.setColor(this.threadStateColor);
            g.fillRect(x + 1, y + 1, this.width - 1, this.height - 1);
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y, this.width - 1, this.height - 1);
    }

    protected Color getThreadStateColor(int threadState) {
        if (threadState == -100) {
            return null;
        }
        return ThreadData.getThreadStateColor((int)threadState);
    }
}

