/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.ExternalPredecessorRelation;
import net.sf.mpxj.primavera.PercentCompleteType;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;

final class PrimaveraReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private Integer m_defaultCalendarID;
    private Map<Integer, String> m_udfMap = new HashMap<Integer, String>();
    private final UserFieldCounters m_taskUdfCounters;
    private final UserFieldCounters m_resourceUdfCounters;
    private final UserFieldCounters m_assignmentUdfCounters;
    private Map<FieldType, String> m_resourceFields;
    private Map<FieldType, String> m_wbsFields;
    private Map<FieldType, String> m_taskFields;
    private Map<FieldType, String> m_assignmentFields;
    private List<ExternalPredecessorRelation> m_externalPredecessors = new ArrayList<ExternalPredecessorRelation>();
    private final boolean m_matchPrimaveraWBS;
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, TimeUnit> TIME_UNIT_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;
    private static final Map<String, Boolean> STATICTYPE_UDF_MAP;
    private static final Map<String, FieldTypeClass> FIELD_TYPE_MAP;
    private static final long EXCEPTION_EPOCH = -2209161599935L;

    public PrimaveraReader(UserFieldCounters userFieldCounters, UserFieldCounters userFieldCounters2, UserFieldCounters userFieldCounters3, Map<FieldType, String> map, Map<FieldType, String> map2, Map<FieldType, String> map3, Map<FieldType, String> map4, Map<FieldType, String> map5, boolean bl) {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig projectConfig = this.m_project.getProjectConfig();
        projectConfig.setAutoTaskUniqueID(false);
        projectConfig.setAutoResourceUniqueID(false);
        projectConfig.setAutoCalendarUniqueID(true);
        projectConfig.setAutoAssignmentUniqueID(false);
        projectConfig.setAutoWBS(false);
        this.m_resourceFields = map;
        this.m_wbsFields = map2;
        this.m_taskFields = map3;
        this.m_assignmentFields = map4;
        this.applyAliases(map5);
        this.m_taskUdfCounters = userFieldCounters;
        this.m_taskUdfCounters.reset();
        this.m_resourceUdfCounters = userFieldCounters2;
        this.m_resourceUdfCounters.reset();
        this.m_assignmentUdfCounters = userFieldCounters3;
        this.m_assignmentUdfCounters.reset();
        this.m_matchPrimaveraWBS = bl;
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public List<ExternalPredecessorRelation> getExternalPredecessors() {
        return this.m_externalPredecessors;
    }

    public void processProjectProperties(List<Row> list) {
        if (!list.isEmpty()) {
            Row row = list.get(0);
            ProjectProperties projectProperties = this.m_project.getProjectProperties();
            projectProperties.setCreationDate(row.getDate("create_date"));
            projectProperties.setFinishDate(row.getDate("plan_end_date"));
            projectProperties.setName(row.getString("proj_short_name"));
            projectProperties.setStartDate(row.getDate("plan_start_date"));
            projectProperties.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
            projectProperties.setStatusDate(row.getDate("last_recalc_date"));
            projectProperties.setFiscalYearStartMonth(row.getInteger("fy_start_month_num"));
            this.m_defaultCalendarID = row.getInteger("clndr_id");
        }
    }

    public void processUserDefinedFields(List<Row> list) {
        for (Row row : list) {
            this.parseUDF(row);
        }
    }

    public void processCalendars(List<Row> list) {
        Object object = list.iterator();
        while (object.hasNext()) {
            Row row = object.next();
            this.processCalendar(row);
        }
        if (this.m_defaultCalendarID != null && (object = this.m_calMap.get(this.m_defaultCalendarID)) != null) {
            this.m_project.setDefaultCalendar((ProjectCalendar)object);
        }
    }

    public void processCalendar(Row row) {
        ProjectCalendar projectCalendar = this.m_project.addCalendar();
        Integer n = row.getInteger("clndr_id");
        this.m_calMap.put(n, projectCalendar);
        projectCalendar.setName(row.getString("clndr_name"));
        try {
            projectCalendar.setMinutesPerDay((int)NumberHelper.getDouble(row.getDouble("day_hr_cnt")) * 60);
            projectCalendar.setMinutesPerWeek((int)(NumberHelper.getDouble(row.getDouble("week_hr_cnt")) * 60.0));
            projectCalendar.setMinutesPerMonth((int)(NumberHelper.getDouble(row.getDouble("month_hr_cnt")) * 60.0));
            projectCalendar.setMinutesPerYear((int)(NumberHelper.getDouble(row.getDouble("year_hr_cnt")) * 60.0));
        }
        catch (ClassCastException classCastException) {
            return;
        }
        String string = row.getString("clndr_data");
        if (string != null && !string.isEmpty()) {
            Record record = Record.getRecord(string);
            if (record != null) {
                this.processCalendarDays(projectCalendar, record);
                this.processCalendarExceptions(projectCalendar, record);
            }
        } else {
            DateRange dateRange = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(16, 0));
            for (Day day : Day.values()) {
                if (day != Day.SATURDAY && day != Day.SUNDAY) {
                    projectCalendar.setWorkingDay(day, true);
                    ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
                    projectCalendarHours.addRange(dateRange);
                    continue;
                }
                projectCalendar.setWorkingDay(day, false);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(projectCalendar);
    }

    private void processCalendarDays(ProjectCalendar projectCalendar, Record record) {
        Record record2 = record.getChild("DaysOfWeek");
        if (record2 != null) {
            for (Record record3 : record2.getChildren()) {
                this.processCalendarHours(projectCalendar, record3);
            }
        }
    }

    private void processCalendarHours(ProjectCalendar projectCalendar, Record record) {
        Day day = Day.getInstance(Integer.parseInt(record.getField()));
        List<Record> list = record.getChildren();
        if (list.size() == 0) {
            projectCalendar.setWorkingDay(day, false);
        } else {
            projectCalendar.setWorkingDay(day, true);
            ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
            for (Record record2 : list) {
                this.addHours(projectCalendarHours, record2);
            }
        }
    }

    private void addHours(ProjectCalendarDateRanges projectCalendarDateRanges, Record record) {
        if (record.getValue() != null) {
            String[] stringArray = record.getValue().split("\\|");
            try {
                String string;
                String string2;
                if (stringArray[0].equals("s")) {
                    string2 = stringArray[1];
                    string = stringArray[3];
                } else {
                    string2 = stringArray[3];
                    string = stringArray[1];
                }
                if (string.equals("00:00")) {
                    string = "24:00";
                }
                Date date = this.m_calendarTimeFormat.parse(string2);
                Date date2 = this.m_calendarTimeFormat.parse(string);
                projectCalendarDateRanges.addRange(new DateRange(date, date2));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void processCalendarExceptions(ProjectCalendar projectCalendar, Record record) {
        Record record2 = record.getChild("Exceptions");
        if (record2 != null) {
            for (Record record3 : record2.getChildren()) {
                long l = Integer.parseInt(record3.getValue().split("\\|")[1]);
                Date date = DateHelper.getDateFromLong(-2209161599935L + l * 86400000L);
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date);
                for (Record record4 : record3.getChildren()) {
                    this.addHours(projectCalendarException, record4);
                }
            }
        }
    }

    public void processResources(List<Row> list) {
        this.processResources(list, null);
    }

    public void processResources(List<Row> list, List<Row> list2) {
        for (Row row : list) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_resourceFields, row, resource);
            resource.setResourceCalendar(this.getResourceCalendar(row.getInteger("clndr_id")));
            TimeUnit timeUnit = TIME_UNIT_MAP.get(row.getString("cost_qty_type"));
            resource.setStandardRateUnits(timeUnit);
            resource.setOvertimeRateUnits(timeUnit);
            Integer n = resource.getUniqueID();
            List<Row> list3 = this.getContainerUDF(n, list2);
            for (Row row2 : list3) {
                this.addUDFValue(FieldTypeClass.RESOURCE, resource, row2);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private ProjectCalendar getResourceCalendar(Integer n) {
        ProjectCalendar projectCalendar;
        ProjectCalendar projectCalendar2 = null;
        if (n != null && (projectCalendar = this.m_calMap.get(n)) != null) {
            if (!projectCalendar.isDerived()) {
                ProjectCalendar projectCalendar3 = this.m_project.addCalendar();
                projectCalendar3.setParent(projectCalendar);
                projectCalendar3.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                projectCalendar3.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                projectCalendar2 = projectCalendar3;
            } else if (projectCalendar.getResource() == null) {
                projectCalendar2 = projectCalendar;
            } else {
                ProjectCalendar projectCalendar4 = this.m_project.addCalendar();
                projectCalendar4.copy(projectCalendar);
                projectCalendar2 = projectCalendar4;
            }
        }
        return projectCalendar2;
    }

    public void processResourceRates(List<Row> list) {
        Collections.sort(list, new Comparator<Row>(this){

            @Override
            public int compare(Row row, Row row2) {
                Integer n;
                Integer n2 = row.getInteger("rsrc_id");
                int n3 = NumberHelper.compare(n2, n = row2.getInteger("rsrc_id"));
                if (n3 != 0) {
                    return n3;
                }
                Date date = row.getDate("start_date");
                Date date2 = row2.getDate("start_date");
                return DateHelper.compare(date, date2);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Row row = list.get(i);
            Integer n = row.getInteger("rsrc_id");
            Rate rate = new Rate(row.getDouble("cost_per_qty"), TimeUnit.HOURS);
            TimeUnit timeUnit = TimeUnit.HOURS;
            Rate rate2 = new Rate(0.0, TimeUnit.HOURS);
            TimeUnit timeUnit2 = TimeUnit.HOURS;
            Double d = NumberHelper.getDouble(0.0);
            Double d2 = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            Date date = row.getDate("start_date");
            Date date2 = DateHelper.LAST_DATE;
            if (i + 1 < list.size()) {
                object = list.get(i + 1);
                int n2 = object.getInt("rsrc_id");
                if (n == n2) {
                    date2 = object.getDate("start_date");
                }
            }
            if ((object = this.m_project.getResourceByUniqueID(n)) == null) continue;
            CostRateTable costRateTable = ((Resource)object).getCostRateTable(0);
            if (costRateTable == null) {
                costRateTable = new CostRateTable();
                ((Resource)object).setCostRateTable(0, costRateTable);
            }
            CostRateTableEntry costRateTableEntry = new CostRateTableEntry(rate, timeUnit, rate2, timeUnit2, d, date2);
            costRateTable.add(costRateTableEntry);
            AvailabilityTable availabilityTable = ((Resource)object).getAvailability();
            Availability availability = new Availability(date, date2, d2);
            availabilityTable.add(availability);
        }
    }

    public void processTasks(List<Row> list, List<Row> list2) {
        this.processTasks(list, list2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void processTasks(List<Row> list, List<Row> list2, List<Row> list3) {
        Task task;
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        String string = projectProperties.getName();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (!list.isEmpty()) {
            projectProperties.setProjectTitle(list.get(0).getString("wbs_name"));
        }
        for (Row object : list) {
            Task task2 = this.m_project.addTask();
            task2.setProject(string);
            this.processFields(this.m_wbsFields, object, task2);
            hashSet.add(task2.getUniqueID());
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        FieldType fieldType = this.getActivityIDField(this.m_wbsFields);
        this.m_project.getChildTasks().clear();
        for (Row row : list) {
            Task task3 = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            task = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (task == null) {
                this.m_project.getChildTasks().add(task3);
                continue;
            }
            this.m_project.getChildTasks().remove(task3);
            task.getChildTasks().add(task3);
            task3.setWBS(task.getWBS() + "." + task3.getWBS());
            if (fieldType == null) continue;
            task3.set(fieldType, task3.getWBS());
        }
        boolean bl = true;
        this.m_clashMap.clear();
        for (Row row : list2) {
            Integer n;
            Integer n2;
            Integer n3 = row.getInteger("wbs_id");
            Task task4 = this.m_project.getTaskByUniqueID(n3);
            task = task4 == null ? this.m_project.addTask() : task4.addTask();
            task.setProject(string);
            this.processFields(this.m_taskFields, row, task);
            task.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task.setIgnoreResourceCalendar(!"TT_Rsrc".equals(row.getString("task_type")));
            task.setPercentageComplete(this.calculatePercentComplete(row));
            if (this.m_matchPrimaveraWBS && task4 != null) {
                task.setWBS(task4.getWBS());
            }
            if (hashSet.contains(n2 = task.getUniqueID())) {
                void var8_11;
                while (hashSet.contains((int)var8_11)) {
                    ++var8_11;
                }
                n = (int)var8_11;
                this.m_clashMap.put(n2, n);
                n2 = n;
                task.setUniqueID(n2);
            }
            hashSet.add(n2);
            n = row.getInteger("clndr_id");
            ProjectCalendar projectCalendar = this.m_calMap.get(n);
            task.setCalendar(projectCalendar);
            Date date = row.getDate("act_start_date") == null ? row.getDate("restart_date") : row.getDate("act_start_date");
            task.setStart(date);
            Date date2 = row.getDate("act_end_date") == null ? row.getDate("reend_date") : row.getDate("act_end_date");
            task.setFinish(date2);
            Duration duration = Duration.add(task.getActualWork(), task.getRemainingWork(), projectProperties);
            task.setWork(duration);
            List<Row> list4 = this.getContainerUDF(n2, list3);
            for (Row row2 : list4) {
                this.addUDFValue(FieldTypeClass.TASK, task, row2);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.sortActivities(fieldType, this.m_project);
        this.updateStructure();
        this.updateDates();
        this.updateWork();
    }

    private FieldType getActivityIDField(Map<FieldType, String> map) {
        FieldType fieldType = null;
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            if (!entry.getValue().equals("task_code")) continue;
            fieldType = entry.getKey();
            break;
        }
        return fieldType;
    }

    private void addUserDefinedField(FieldTypeClass fieldTypeClass, UserFieldDataType userFieldDataType, String string) {
        try {
            switch (fieldTypeClass) {
                case TASK: {
                    TaskField taskField;
                    while (this.m_taskFields.containsKey(taskField = this.m_taskUdfCounters.nextField(TaskField.class, userFieldDataType)) || this.m_wbsFields.containsKey(taskField)) {
                    }
                    this.m_project.getCustomFields().getCustomField(taskField).setAlias(string);
                    break;
                }
                case RESOURCE: {
                    ResourceField resourceField;
                    while (this.m_resourceFields.containsKey(resourceField = this.m_resourceUdfCounters.nextField(ResourceField.class, userFieldDataType))) {
                    }
                    this.m_project.getCustomFields().getCustomField(resourceField).setAlias(string);
                    break;
                }
                case ASSIGNMENT: {
                    AssignmentField assignmentField;
                    while (this.m_assignmentFields.containsKey(assignmentField = this.m_assignmentUdfCounters.nextField(AssignmentField.class, userFieldDataType))) {
                    }
                    this.m_project.getCustomFields().getCustomField(assignmentField).setAlias(string);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseUDF(Row row) {
        FieldTypeClass fieldTypeClass = FIELD_TYPE_MAP.get(row.getString("table_name"));
        if (fieldTypeClass != null) {
            Integer n = Integer.valueOf(row.getString("udf_type_id"));
            String string = row.getString("logical_data_type");
            String string2 = row.getString("udf_type_label");
            this.m_udfMap.put(n, string2);
            this.addUserDefinedField(fieldTypeClass, UserFieldDataType.valueOf(string), string2);
        }
    }

    private void addUDFValue(FieldTypeClass fieldTypeClass, FieldContainer fieldContainer, Row row) {
        Integer n = Integer.valueOf(row.getString("udf_type_id"));
        String string = this.m_udfMap.get(n);
        Object object = null;
        FieldType fieldType = this.m_project.getCustomFields().getFieldByAlias(fieldTypeClass, string);
        if (fieldType != null) {
            DataType dataType = fieldType.getDataType();
            switch (dataType) {
                case DATE: {
                    object = row.getDate("udf_date");
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    object = row.getDouble("udf_number");
                    break;
                }
                case GUID: 
                case INTEGER: {
                    object = row.getInteger("udf_code_id");
                    break;
                }
                case BOOLEAN: {
                    String string2 = row.getString("udf_text");
                    if (string2 != null) {
                        object = STATICTYPE_UDF_MAP.get(string2);
                        if (object != null) break;
                        object = row.getBoolean("udf_text");
                        break;
                    }
                    object = row.getBoolean("udf_number");
                    break;
                }
                default: {
                    object = row.getString("udf_text");
                }
            }
            fieldContainer.set(fieldType, object);
        }
    }

    private List<Row> getContainerUDF(Integer n, List<Row> list) {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        if (list != null) {
            for (Row row : list) {
                if (!n.equals(row.getInteger("fk_id"))) continue;
                linkedList.add(row);
            }
        }
        return linkedList;
    }

    private void populateField(FieldContainer fieldContainer, FieldType fieldType, FieldType fieldType2, FieldType fieldType3) {
        Object object = fieldContainer.getCachedValue(fieldType3);
        if (object == null) {
            object = fieldContainer.getCachedValue(fieldType2);
        }
        fieldContainer.set(fieldType, object);
    }

    private void sortActivities(final FieldType fieldType, ChildTaskContainer childTaskContainer) {
        List<Task> list = childTaskContainer.getChildTasks();
        if (!list.isEmpty()) {
            for (Task task : list) {
                this.sortActivities(fieldType, task);
                Collections.sort(list, new Comparator<Task>(){

                    @Override
                    public int compare(Task task, Task task2) {
                        boolean bl;
                        boolean bl2 = !task.getChildTasks().isEmpty();
                        boolean bl3 = bl = !task2.getChildTasks().isEmpty();
                        if (bl2 && bl) {
                            return task.getID().compareTo(task2.getID());
                        }
                        if (!bl2 && !bl) {
                            String string = (String)task.getCurrentValue(fieldType);
                            String string2 = (String)task2.getCurrentValue(fieldType);
                            if (string == null || string2 == null) {
                                return string == null && string2 == null ? 0 : (string == null ? 1 : -1);
                            }
                            return string.compareTo(string2);
                        }
                        return bl2 ? 1 : -1;
                    }
                });
            }
        }
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_project.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        task.setSummary(task.getChildTasks().size() != 0);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    private void updateDates() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateDates(task);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateDates(Task task) {
        if (task.getSummary()) {
            void var14_19;
            int n = 0;
            Date date = task.getStart();
            Date date2 = task.getFinish();
            Date date3 = task.getActualStart();
            Date date4 = task.getActualFinish();
            Date date5 = task.getEarlyStart();
            Date date6 = task.getEarlyFinish();
            Date date7 = task.getLateStart();
            Date date8 = task.getLateFinish();
            Date date9 = task.getBaselineStart();
            Date date10 = task.getBaselineFinish();
            for (Task comparable2 : task.getChildTasks()) {
                this.updateDates(comparable2);
                date = DateHelper.min(date, comparable2.getStart());
                date2 = DateHelper.max(date2, comparable2.getFinish());
                date3 = DateHelper.min(date3, comparable2.getActualStart());
                date4 = DateHelper.max(date4, comparable2.getActualFinish());
                date5 = DateHelper.min(date5, comparable2.getEarlyStart());
                date6 = DateHelper.max(date6, comparable2.getEarlyFinish());
                date7 = DateHelper.min(date7, comparable2.getLateStart());
                date8 = DateHelper.max(date8, comparable2.getLateFinish());
                date9 = DateHelper.min(date9, comparable2.getBaselineStart());
                date10 = DateHelper.max(date10, comparable2.getBaselineFinish());
                if (comparable2.getActualFinish() == null) continue;
                ++n;
            }
            task.setStart(date);
            task.setFinish(date2);
            task.setActualStart(date3);
            task.setEarlyStart(date5);
            task.setEarlyFinish(date6);
            task.setLateStart(date7);
            task.setLateFinish(date8);
            task.setBaselineStart(date9);
            task.setBaselineFinish(date10);
            if (n == task.getChildTasks().size()) {
                task.setActualFinish(date4);
            }
            Object object = null;
            if (date9 != null && date10 != null) {
                object = this.m_project.getDefaultCalendar().getWork(date9, date10, TimeUnit.HOURS);
                task.setBaselineDuration((Duration)object);
            }
            Object var14_15 = null;
            if (task.getActualFinish() == null) {
                Date date11;
                Date date12 = task.getEarlyStart();
                if (date12 == null) {
                    date12 = date9;
                }
                if ((date11 = task.getEarlyFinish()) == null) {
                    date11 = date10;
                }
                if (date12 != null && date11 != null) {
                    Duration duration = this.m_project.getDefaultCalendar().getWork(date12, date11, TimeUnit.HOURS);
                }
            } else {
                Duration duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            task.setRemainingDuration((Duration)var14_19);
            if (object != null && ((Duration)object).getDuration() != 0.0 && var14_19 != null) {
                double d = (((Duration)object).getDuration() - var14_19.getDuration()) / ((Duration)object).getDuration() * 100.0;
                task.setPercentageComplete(d);
            }
        }
    }

    private void updateWork() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateWork(task);
        }
    }

    private void updateWork(Task task) {
        if (task.getSummary()) {
            ProjectProperties projectProperties = this.m_project.getProjectProperties();
            Duration duration = null;
            Duration duration2 = null;
            Duration duration3 = null;
            Duration duration4 = null;
            for (Task task2 : task.getChildTasks()) {
                this.updateWork(task2);
                duration = Duration.add(duration, task2.getActualWork(), projectProperties);
                duration2 = Duration.add(duration2, task2.getBaselineWork(), projectProperties);
                duration3 = Duration.add(duration3, task2.getRemainingWork(), projectProperties);
                duration4 = Duration.add(duration4, task2.getWork(), projectProperties);
            }
            task.setActualWork(duration);
            task.setBaselineWork(duration2);
            task.setRemainingWork(duration3);
            task.setWork(duration4);
        }
    }

    public void processPredecessors(List<Row> list) {
        for (Row row : list) {
            Integer n = this.mapTaskID(row.getInteger("task_id"));
            Integer n2 = this.mapTaskID(row.getInteger("pred_task_id"));
            Task task = this.m_project.getTaskByUniqueID(n);
            Task task2 = this.m_project.getTaskByUniqueID(n2);
            RelationType relationType = RELATION_TYPE_MAP.get(row.getString("pred_type"));
            Duration duration = row.getDuration("lag_hr_cnt");
            if (task == null) continue;
            if (task2 != null) {
                Relation relation = task.addPredecessor(task2, relationType, duration);
                this.m_eventManager.fireRelationReadEvent(relation);
                continue;
            }
            this.m_externalPredecessors.add(new ExternalPredecessorRelation(n2, task, relationType, duration));
        }
    }

    public void processAssignments(List<Row> list) {
        this.processAssignments(list, null);
    }

    public void processAssignments(List<Row> list, List<Row> list2) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("rsrc_id"));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            this.processFields(this.m_assignmentFields, row, resourceAssignment);
            this.populateField(resourceAssignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(resourceAssignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            Duration duration = row.getDuration("remain_qty");
            Duration duration2 = row.getDuration("act_ot_qty");
            Duration duration3 = row.getDuration("act_reg_qty");
            Duration duration4 = Duration.add(duration2, duration3, this.m_project.getProjectProperties());
            Duration duration5 = Duration.add(duration4, duration, this.m_project.getProjectProperties());
            resourceAssignment.setActualWork(duration4);
            resourceAssignment.setWork(duration5);
            Double d = row.getDouble("remain_cost");
            Double d2 = row.getDouble("act_ot_cost");
            Double d3 = row.getDouble("act_reg_cost");
            double d4 = NumberHelper.getDouble(d2) + NumberHelper.getDouble(d3);
            double d5 = d4 + NumberHelper.getDouble(d);
            resourceAssignment.setActualCost(NumberHelper.getDouble(d4));
            resourceAssignment.setCost(NumberHelper.getDouble(d5));
            double d6 = resource.getType() == ResourceType.MATERIAL ? (duration5 == null ? 0.0 : duration5.getDuration() * 100.0) : NumberHelper.getDouble(row.getDouble("target_qty_per_hr")) * 100.0;
            resourceAssignment.setUnits(NumberHelper.getDouble(d6));
            Integer n = resourceAssignment.getUniqueID();
            List<Row> list3 = this.getContainerUDF(n, list2);
            for (Row row2 : list3) {
                this.addUDFValue(FieldTypeClass.ASSIGNMENT, resourceAssignment, row2);
            }
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
        this.updateTaskCosts();
    }

    private void updateTaskCosts() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateTaskCosts(task);
        }
    }

    private void updateTaskCosts(Task task) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (Task object2 : task.getChildTasks()) {
            this.updateTaskCosts(object2);
            d += NumberHelper.getDouble(object2.getBaselineCost());
            d2 += NumberHelper.getDouble(object2.getActualCost());
            d3 += NumberHelper.getDouble(object2.getRemainingCost());
            d4 += NumberHelper.getDouble(object2.getCost());
        }
        List<ResourceAssignment> list = task.getResourceAssignments();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ResourceAssignment resourceAssignment = (ResourceAssignment)iterator.next();
            d += NumberHelper.getDouble(resourceAssignment.getBaselineCost());
            d2 += NumberHelper.getDouble(resourceAssignment.getActualCost());
            d3 += NumberHelper.getDouble(resourceAssignment.getRemainingCost());
            d4 += NumberHelper.getDouble(resourceAssignment.getCost());
        }
        task.setBaselineCost(NumberHelper.getDouble(d));
        task.setActualCost(NumberHelper.getDouble(d2));
        task.setRemainingCost(NumberHelper.getDouble(d3));
        task.setCost(NumberHelper.getDouble(d4));
    }

    public void processDefaultCurrency(Row row) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        projectProperties.setCurrencySymbol(row.getString("curr_symbol"));
        projectProperties.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        projectProperties.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        projectProperties.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        projectProperties.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    private void processFields(Map<FieldType, String> map, Row row, FieldContainer fieldContainer) {
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            FieldType fieldType = entry.getKey();
            String string = entry.getValue();
            fieldContainer.set(fieldType, switch (fieldType.getDataType()) {
                case DataType.INTEGER -> row.getInteger(string);
                case DataType.BOOLEAN -> row.getBoolean(string);
                case DataType.DATE -> row.getDate(string);
                case DataType.CURRENCY, DataType.NUMERIC, DataType.PERCENTAGE -> row.getDouble(string);
                case DataType.DELAY, DataType.WORK, DataType.DURATION -> row.getDuration(string);
                case DataType.RESOURCE_TYPE -> RESOURCE_TYPE_MAP.get(row.getString(string));
                case DataType.TASK_TYPE -> TASK_TYPE_MAP.get(row.getString(string));
                case DataType.CONSTRAINT -> CONSTRAINT_TYPE_MAP.get(row.getString(string));
                case DataType.PRIORITY -> PRIORITY_MAP.get(row.getString(string));
                case DataType.GUID -> row.getUUID(string);
                default -> row.getString(string);
            });
        }
    }

    private Integer mapTaskID(Integer n) {
        Integer n2 = this.m_clashMap.get(n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    private void applyAliases(Map<FieldType, String> map) {
        CustomFieldContainer customFieldContainer = this.m_project.getCustomFields();
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            customFieldContainer.getCustomField(entry.getKey()).setAlias(entry.getValue());
        }
    }

    private Number calculatePercentComplete(Row row) {
        return switch (PercentCompleteType.getInstance(row.getString("complete_pct_type"))) {
            case PercentCompleteType.UNITS -> this.calculateUnitsPercentComplete(row);
            case PercentCompleteType.DURATION -> this.calculateDurationPercentComplete(row);
            default -> this.calculatePhysicalPercentComplete(row);
        };
    }

    private Number calculatePhysicalPercentComplete(Row row) {
        return row.getDouble("phys_complete_pct");
    }

    private Number calculateUnitsPercentComplete(Row row) {
        double d;
        double d2 = 0.0;
        double d3 = NumberHelper.getDouble(row.getDouble("act_work_qty"));
        double d4 = d3 + (d = NumberHelper.getDouble(row.getDouble("act_equip_qty")));
        if (d4 != 0.0) {
            double d5;
            double d6 = NumberHelper.getDouble(row.getDouble("remain_work_qty"));
            double d7 = d6 + d3 + (d5 = NumberHelper.getDouble(row.getDouble("remain_equip_qty"))) + d;
            d2 = d7 == 0.0 ? 0.0 : d4 * 100.0 / d7;
        }
        return NumberHelper.getDouble(d2);
    }

    private Number calculateDurationPercentComplete(Row row) {
        double d = 0.0;
        double d2 = row.getDuration("target_drtn_hr_cnt").getDuration();
        double d3 = row.getDuration("remain_drtn_hr_cnt").getDuration();
        if (d2 == 0.0) {
            if (d3 == 0.0 && "TK_Complete".equals(row.getString("status_code"))) {
                d = 100.0;
            }
        } else if (d3 < d2) {
            d = (d2 - d3) * 100.0 / d2;
        }
        return NumberHelper.getDouble(d);
    }

    public static Map<FieldType, String> getDefaultResourceFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(ResourceField.UNIQUE_ID, "rsrc_id");
        linkedHashMap.put(ResourceField.GUID, "guid");
        linkedHashMap.put(ResourceField.NAME, "rsrc_name");
        linkedHashMap.put(ResourceField.CODE, "employee_code");
        linkedHashMap.put(ResourceField.EMAIL_ADDRESS, "email_addr");
        linkedHashMap.put(ResourceField.NOTES, "rsrc_notes");
        linkedHashMap.put(ResourceField.CREATED, "create_date");
        linkedHashMap.put(ResourceField.TYPE, "rsrc_type");
        linkedHashMap.put(ResourceField.INITIALS, "rsrc_short_name");
        linkedHashMap.put(ResourceField.PARENT_ID, "parent_rsrc_id");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultWbsFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(TaskField.UNIQUE_ID, "wbs_id");
        linkedHashMap.put(TaskField.GUID, "guid");
        linkedHashMap.put(TaskField.NAME, "wbs_name");
        linkedHashMap.put(TaskField.BASELINE_COST, "orig_cost");
        linkedHashMap.put(TaskField.REMAINING_COST, "indep_remain_total_cost");
        linkedHashMap.put(TaskField.REMAINING_WORK, "indep_remain_work_qty");
        linkedHashMap.put(TaskField.DEADLINE, "anticip_end_date");
        linkedHashMap.put(TaskField.DATE1, "suspend_date");
        linkedHashMap.put(TaskField.DATE2, "resume_date");
        linkedHashMap.put(TaskField.TEXT1, "task_code");
        linkedHashMap.put(TaskField.WBS, "wbs_short_name");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultTaskFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(TaskField.UNIQUE_ID, "task_id");
        linkedHashMap.put(TaskField.GUID, "guid");
        linkedHashMap.put(TaskField.NAME, "task_name");
        linkedHashMap.put(TaskField.ACTUAL_DURATION, "act_drtn_hr_cnt");
        linkedHashMap.put(TaskField.REMAINING_DURATION, "remain_drtn_hr_cnt");
        linkedHashMap.put(TaskField.ACTUAL_WORK, "act_work_qty");
        linkedHashMap.put(TaskField.REMAINING_WORK, "remain_work_qty");
        linkedHashMap.put(TaskField.BASELINE_WORK, "target_work_qty");
        linkedHashMap.put(TaskField.BASELINE_DURATION, "target_drtn_hr_cnt");
        linkedHashMap.put(TaskField.DURATION, "target_drtn_hr_cnt");
        linkedHashMap.put(TaskField.CONSTRAINT_DATE, "cstr_date");
        linkedHashMap.put(TaskField.ACTUAL_START, "act_start_date");
        linkedHashMap.put(TaskField.ACTUAL_FINISH, "act_end_date");
        linkedHashMap.put(TaskField.LATE_START, "late_start_date");
        linkedHashMap.put(TaskField.LATE_FINISH, "late_end_date");
        linkedHashMap.put(TaskField.EARLY_START, "early_start_date");
        linkedHashMap.put(TaskField.EARLY_FINISH, "early_end_date");
        linkedHashMap.put(TaskField.BASELINE_START, "target_start_date");
        linkedHashMap.put(TaskField.BASELINE_FINISH, "target_end_date");
        linkedHashMap.put(TaskField.CONSTRAINT_TYPE, "cstr_type");
        linkedHashMap.put(TaskField.PRIORITY, "priority_type");
        linkedHashMap.put(TaskField.CREATED, "create_date");
        linkedHashMap.put(TaskField.TYPE, "duration_type");
        linkedHashMap.put(TaskField.FREE_SLACK, "free_float_hr_cnt");
        linkedHashMap.put(TaskField.TOTAL_SLACK, "total_float_hr_cnt");
        linkedHashMap.put(TaskField.TEXT1, "task_code");
        linkedHashMap.put(TaskField.TEXT2, "task_type");
        linkedHashMap.put(TaskField.TEXT3, "status_code");
        linkedHashMap.put(TaskField.NUMBER1, "rsrc_id");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultAssignmentFieldMap() {
        LinkedHashMap<FieldType, String> linkedHashMap = new LinkedHashMap<FieldType, String>();
        linkedHashMap.put(AssignmentField.UNIQUE_ID, "taskrsrc_id");
        linkedHashMap.put(AssignmentField.GUID, "guid");
        linkedHashMap.put(AssignmentField.REMAINING_WORK, "remain_qty");
        linkedHashMap.put(AssignmentField.BASELINE_WORK, "target_qty");
        linkedHashMap.put(AssignmentField.ACTUAL_OVERTIME_WORK, "act_ot_qty");
        linkedHashMap.put(AssignmentField.BASELINE_COST, "target_cost");
        linkedHashMap.put(AssignmentField.ACTUAL_OVERTIME_COST, "act_ot_cost");
        linkedHashMap.put(AssignmentField.REMAINING_COST, "remain_cost");
        linkedHashMap.put(AssignmentField.ACTUAL_START, "act_start_date");
        linkedHashMap.put(AssignmentField.ACTUAL_FINISH, "act_end_date");
        linkedHashMap.put(AssignmentField.BASELINE_START, "target_start_date");
        linkedHashMap.put(AssignmentField.BASELINE_FINISH, "target_end_date");
        linkedHashMap.put(AssignmentField.ASSIGNMENT_DELAY, "target_lag_drtn_hr_cnt");
        return linkedHashMap;
    }

    public static Map<FieldType, String> getDefaultAliases() {
        HashMap<FieldType, String> hashMap = new HashMap<FieldType, String>();
        hashMap.put(TaskField.DATE1, "Suspend Date");
        hashMap.put(TaskField.DATE2, "Resume Date");
        hashMap.put(TaskField.TEXT1, "Code");
        hashMap.put(TaskField.TEXT2, "Activity Type");
        hashMap.put(TaskField.TEXT3, "Status");
        hashMap.put(TaskField.NUMBER1, "Primary Resource Unique ID");
        return hashMap;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.WORK);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        TIME_UNIT_MAP = new HashMap<String, TimeUnit>();
        TIME_UNIT_MAP.put("QT_Minute", TimeUnit.MINUTES);
        TIME_UNIT_MAP.put("QT_Hour", TimeUnit.HOURS);
        TIME_UNIT_MAP.put("QT_Day", TimeUnit.DAYS);
        TIME_UNIT_MAP.put("QT_Week", TimeUnit.WEEKS);
        TIME_UNIT_MAP.put("QT_Month", TimeUnit.MONTHS);
        TIME_UNIT_MAP.put("QT_Year", TimeUnit.YEARS);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
        STATICTYPE_UDF_MAP = new HashMap<String, Boolean>();
        STATICTYPE_UDF_MAP.put("UDF_G0", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G1", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G2", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G3", Boolean.TRUE);
        STATICTYPE_UDF_MAP.put("UDF_G4", Boolean.TRUE);
        FIELD_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        FIELD_TYPE_MAP.put("TASK", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("RSRC", FieldTypeClass.RESOURCE);
        FIELD_TYPE_MAP.put("TASKRSRC", FieldTypeClass.ASSIGNMENT);
    }
}

