/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.RunnerListener;
import processing.app.exec.LineProcessor;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.ProcessResult;
import processing.app.exec.StreamPump;
import processing.core.PApplet;
import processing.mode.android.AndroidSDK;
import processing.mode.android.DeviceListener;
import processing.mode.android.DeviceProperties;
import processing.mode.android.Devices;
import processing.mode.android.LogEntry;

class Device
implements DeviceProperties {
    private final Devices env;
    private final String id;
    private final Set<Integer> activeProcesses = new HashSet<Integer>();
    private final Set<DeviceListener> listeners = Collections.synchronizedSet(new HashSet());
    private Process logcat;
    private static final Pattern SIG = Pattern.compile("PID:\\s+(\\d+)\\s+SIG:\\s+(\\d+)");
    private final List<String> stackTrace = new ArrayList<String>();

    public Device(Devices env, String id) {
        this.env = env;
        this.id = id;
    }

    public void bringLauncherToFront() {
        try {
            this.adb("shell", "am", "start", "-a", "android.intent.action.MAIN", "-c", "android.intent.category.HOME");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean installApp(String apkPath, RunnerListener status) {
        if (!this.isAlive()) {
            return false;
        }
        this.bringLauncherToFront();
        try {
            ProcessResult installResult = this.adb("install", "-r", apkPath);
            if (!installResult.succeeded()) {
                status.statusError("Could not install the sketch.");
                System.err.println(installResult);
                return false;
            }
            String errorMsg = null;
            for (String line : installResult) {
                if (!line.startsWith("Failure")) continue;
                errorMsg = line.substring(8);
                System.err.println(line);
            }
            if (errorMsg == null) {
                status.statusNotice("Done installing.");
                return true;
            }
            status.statusError("Error while installing " + errorMsg);
        }
        catch (IOException e) {
            status.statusError(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public boolean launchApp(String packageName, String className) throws IOException, InterruptedException {
        if (!this.isAlive()) {
            return false;
        }
        return this.adb("shell", "am", "start", "-e", "debug", "true", "-a", "android.intent.action.MAIN", "-c", "android.intent.category.LAUNCHER", "-n", packageName + "/." + className).succeeded();
    }

    public boolean isEmulator() {
        return this.id.startsWith("emulator");
    }

    private void reportStackTrace(LogEntry entry) {
        if (this.stackTrace.isEmpty()) {
            System.err.println("That's weird. Proc " + entry.pid + " got signal 3, but there's no stack trace.");
        }
        List<String> stackCopy = Collections.unmodifiableList(new ArrayList<String>(this.stackTrace));
        for (DeviceListener listener : this.listeners) {
            listener.stackTrace(stackCopy);
        }
        this.stackTrace.clear();
    }

    void initialize() throws IOException, InterruptedException {
        this.adb("logcat", "-c");
        String[] cmd = this.generateAdbCommand("logcat");
        String title = PApplet.join((String[])cmd, (char)' ');
        this.logcat = Runtime.getRuntime().exec(cmd);
        ProcessRegistry.watch(this.logcat);
        new StreamPump(this.logcat.getInputStream(), "log: " + title).addTarget(new LogLineProcessor()).start();
        new StreamPump(this.logcat.getErrorStream(), "err: " + title).addTarget(System.err).start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Device.this.logcat.waitFor();
                }
                catch (InterruptedException e) {
                    System.err.println("AndroidDevice: logcat process monitor interrupted");
                }
                finally {
                    Device.this.shutdown();
                }
            }
        }, "AndroidDevice: logcat process monitor").start();
    }

    synchronized void shutdown() {
        if (!this.isAlive()) {
            return;
        }
        if (this.logcat != null) {
            this.logcat.destroy();
            this.logcat = null;
            ProcessRegistry.unwatch(this.logcat);
        }
        this.env.deviceRemoved(this);
        if (this.activeProcesses.size() > 0) {
            for (DeviceListener listener : this.listeners) {
                listener.sketchStopped();
            }
        }
        this.listeners.clear();
    }

    synchronized boolean isAlive() {
        return this.logcat != null;
    }

    public String getId() {
        return this.id;
    }

    public Devices getEnv() {
        return this.env;
    }

    private void startProc(String name, int pid) {
        this.activeProcesses.add(pid);
    }

    private void endProc(int pid) {
        this.activeProcesses.remove(pid);
        for (DeviceListener listener : this.listeners) {
            listener.sketchStopped();
        }
    }

    public void addListener(DeviceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DeviceListener listener) {
        this.listeners.remove(listener);
    }

    private ProcessResult adb(String ... cmd) throws InterruptedException, IOException {
        String[] adbCmd = this.generateAdbCommand(cmd);
        return AndroidSDK.runADB(adbCmd);
    }

    private String[] generateAdbCommand(String ... cmd) {
        return PApplet.concat((String[])new String[]{"adb", "-s", this.getId()}, (String[])cmd);
    }

    public String toString() {
        return "[AndroidDevice " + this.getId() + "]";
    }

    private class LogLineProcessor
    implements LineProcessor {
        private LogLineProcessor() {
        }

        public void processLine(String line) {
            LogEntry entry = new LogEntry(line);
            if (entry.message.startsWith("PROCESSING")) {
                if (entry.message.contains("onStart")) {
                    Device.this.startProc(entry.source, entry.pid);
                } else if (entry.message.contains("onStop")) {
                    Device.this.endProc(entry.pid);
                }
            } else if (entry.source.equals("Process")) {
                this.handleCrash(entry);
            } else if (Device.this.activeProcesses.contains(entry.pid)) {
                this.handleConsole(entry);
            }
        }

        private void handleCrash(LogEntry entry) {
            Matcher m = SIG.matcher(entry.message);
            if (m.find()) {
                int pid = Integer.parseInt(m.group(1));
                int signal = Integer.parseInt(m.group(2));
                if (Device.this.activeProcesses.contains(pid) && signal == 3) {
                    Device.this.endProc(pid);
                    Device.this.reportStackTrace(entry);
                }
            }
        }

        private void handleConsole(LogEntry entry) {
            boolean isStackTrace;
            boolean bl = isStackTrace = entry.source.equals("AndroidRuntime") && entry.severity == LogEntry.Severity.Error;
            if (isStackTrace) {
                if (!entry.message.startsWith("Uncaught handler")) {
                    Device.this.stackTrace.add(entry.message);
                    System.err.println(entry.message);
                }
            } else if (entry.source.equals("System.out") || entry.source.equals("System.err")) {
                if (entry.severity.useErrorStream) {
                    System.err.println(entry.message);
                } else {
                    System.out.println(entry.message);
                }
            }
        }
    }
}

