/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ClassInstanceCreation
extends Expression
implements Attributed {
    private final List<Expression> ctorParams = new ArrayList<Expression>();
    private ClassName className;
    @NullAllowed
    private final String fileName;
    private final int classCounter;
    private final int classStartOffset;
    private Expression superClass;
    private final List<Expression> interfaces = new ArrayList<Expression>();
    private Block body;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public ClassInstanceCreation(int start, int end, @NonNull ClassName className, @NullAllowed List<Expression> ctorParams) {
        super(start, end);
        assert (className != null);
        this.className = className;
        if (ctorParams != null) {
            this.ctorParams.addAll(ctorParams);
        }
        this.fileName = null;
        this.classCounter = -1;
        this.classStartOffset = -1;
    }

    private ClassInstanceCreation(String fileName, int classCounter, int start, int end, int classStartOffset, @NullAllowed List<Expression> ctorParams, @NullAllowed Expression superClass, @NullAllowed List<Expression> interfaces, @NonNull Block body, List<Attribute> attributes) {
        super(start, end);
        assert (classCounter > 0) : classCounter;
        assert (classStartOffset > -1) : classStartOffset;
        assert (body != null);
        this.fileName = fileName == null ? null : fileName.replace(' ', '_').replace('.', '_');
        this.classCounter = classCounter;
        this.classStartOffset = classStartOffset;
        if (ctorParams != null) {
            this.ctorParams.addAll(ctorParams);
        }
        this.superClass = superClass;
        if (interfaces != null) {
            this.interfaces.addAll(interfaces);
        }
        this.body = body;
        this.attributes.addAll(attributes);
    }

    public static ClassInstanceCreation anonymous(String fileName, int classCounter, int start, int end, int classStartOffset, List<Expression> ctorParams, Expression superClass, List<Expression> interfaces, Block body, List<Attribute> attributes) {
        return new ClassInstanceCreation(fileName, classCounter, start, end, classStartOffset, ctorParams, superClass, interfaces, body, attributes);
    }

    public static ClassInstanceCreation anonymous(String fileName, int classCounter, int start, int end, int classStartOffset, List<Expression> ctorParams, Expression superClass, List<Expression> interfaces, Block body) {
        return new ClassInstanceCreation(fileName, classCounter, start, end, classStartOffset, ctorParams, superClass, interfaces, body, Collections.emptyList());
    }

    public boolean isAnonymous() {
        return this.classStartOffset != -1;
    }

    public ClassName getClassName() {
        if (this.isAnonymous()) {
            return new ClassName(this.classStartOffset, this.classStartOffset, new Identifier(this.classStartOffset, this.classStartOffset, "#anon#" + this.fileName + "#" + this.classCounter));
        }
        return this.className;
    }

    public List<Expression> ctorParams() {
        return Collections.unmodifiableList(this.ctorParams);
    }

    @CheckForNull
    public Expression getSuperClass() {
        return this.superClass;
    }

    public List<Expression> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    @CheckForNull
    public Block getBody() {
        return this.body;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        boolean anonymous = this.isAnonymous();
        if (anonymous) {
            this.getAttributes().forEach(attribute -> sb.append(attribute).append(" "));
            sb.append("class");
        } else {
            sb.append(this.className);
        }
        if (!this.ctorParams.isEmpty()) {
            sb.append('(');
            this.joinExpressions(sb, this.ctorParams);
            sb.append(')');
        }
        if (this.superClass != null) {
            assert (this.className == null) : this.className;
            assert (anonymous);
            sb.append(" extends ");
            sb.append(this.superClass);
        }
        if (!this.interfaces.isEmpty()) {
            assert (this.className == null) : this.className;
            assert (anonymous);
            sb.append(" implements ");
            this.joinExpressions(sb, this.interfaces);
        }
        if (this.body != null) {
            assert (this.className == null) : this.className;
            assert (anonymous);
            sb.append(this.body);
        }
        return sb.toString();
    }

    private void joinExpressions(StringBuilder sb, List<Expression> expressions) {
        boolean first = true;
        for (Expression expression : expressions) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(expression);
        }
    }
}

