/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;

public class ClassInstanceCreationInfo
extends ASTNodeInfo<ClassInstanceCreation> {
    public ClassInstanceCreationInfo(ClassInstanceCreation node) {
        super(node);
    }

    public static ClassInstanceCreationInfo create(ClassInstanceCreation classInstanceCreation) {
        assert (classInstanceCreation.isAnonymous()) : classInstanceCreation;
        return new ClassInstanceCreationInfo(classInstanceCreation);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.CLASS;
    }

    @Override
    public OffsetRange getRange() {
        ClassInstanceCreation originalNode = (ClassInstanceCreation)this.getOriginalNode();
        ClassName className = originalNode.getClassName();
        int start = className.getStartOffset();
        int end = start + "class".length();
        return new OffsetRange(start, end);
    }

    public Expression getSuperClass() {
        return ((ClassInstanceCreation)this.getOriginalNode()).getSuperClass();
    }

    public QualifiedName getSuperClassName() {
        Expression superClass = this.getSuperClass();
        return superClass != null ? QualifiedName.create(superClass) : null;
    }

    public List<? extends Expression> getInterfaces() {
        return ((ClassInstanceCreation)this.getOriginalNode()).getInterfaces();
    }

    public Set<QualifiedName> getInterfaceNames() {
        HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
        List<Expression> interfaes = ((ClassInstanceCreation)this.getOriginalNode()).getInterfaces();
        for (Expression iface : interfaes) {
            QualifiedName ifaceName = QualifiedName.create(iface);
            if (ifaceName == null) continue;
            retval.add(ifaceName);
        }
        return retval;
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(0);
    }

    public Collection<QualifiedName> getUsedTraits() {
        ASTNodeInfo.UsedTraitsVisitor visitor = new ASTNodeInfo.UsedTraitsVisitor();
        Block body = ((ClassInstanceCreation)this.getOriginalNode()).getBody();
        assert (body != null) : (ClassInstanceCreation)this.getOriginalNode();
        body.accept(visitor);
        return visitor.getUsedTraits();
    }

    public List<Attribute> getAttributes() {
        return ((ClassInstanceCreation)this.getOriginalNode()).getAttributes();
    }
}

