/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.FlagsEnum;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Assert;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class Flags {
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int PUBLIC = 1;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int PRIVATE = 2;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int PROTECTED = 4;
    @Use(value={FlagTarget.BLOCK, FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int STATIC = 8;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int FINAL = 16;
    @Use(value={FlagTarget.METHOD})
    public static final int SYNCHRONIZED = 32;
    @Use(value={FlagTarget.VARIABLE})
    public static final int VOLATILE = 64;
    @Use(value={FlagTarget.VARIABLE})
    public static final int TRANSIENT = 128;
    @Use(value={FlagTarget.METHOD})
    public static final int NATIVE = 256;
    @Use(value={FlagTarget.CLASS})
    public static final int INTERFACE = 512;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD})
    public static final int ABSTRACT = 1024;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD})
    public static final int STRICTFP = 2048;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int SYNTHETIC = 4096;
    @Use(value={FlagTarget.CLASS})
    public static final int ANNOTATION = 8192;
    @Use(value={FlagTarget.CLASS, FlagTarget.VARIABLE})
    public static final int ENUM = 16384;
    @Use(value={FlagTarget.MODULE, FlagTarget.VARIABLE})
    public static final int MANDATED = 32768;
    @NotFlag
    public static final int StandardFlags = 4095;
    @Use(value={FlagTarget.CLASS})
    @NoToStringValue
    public static final int ACC_SUPER = 32;
    @Use(value={FlagTarget.METHOD})
    @NoToStringValue
    public static final int ACC_BRIDGE = 64;
    @Use(value={FlagTarget.METHOD})
    @NoToStringValue
    public static final int ACC_VARARGS = 128;
    @Use(value={FlagTarget.CLASS})
    @NoToStringValue
    public static final int ACC_MODULE = 32768;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.MODULE, FlagTarget.PACKAGE, FlagTarget.TYPE_VAR, FlagTarget.VARIABLE})
    public static final int DEPRECATED = 131072;
    @Use(value={FlagTarget.VARIABLE})
    public static final int HASINIT = 262144;
    @Use(value={FlagTarget.CLASS})
    public static final int IMPLICIT_CLASS = 524288;
    @Use(value={FlagTarget.METHOD})
    public static final int BLOCK = 0x100000;
    @Use(value={FlagTarget.CLASS})
    public static final int FROM_SOURCE = 0x200000;
    @Use(value={FlagTarget.CLASS, FlagTarget.VARIABLE})
    public static final int NOOUTERTHIS = 0x400000;
    @Use(value={FlagTarget.CLASS, FlagTarget.PACKAGE})
    public static final int EXISTS = 0x800000;
    @Use(value={FlagTarget.CLASS})
    public static final int COMPOUND = 0x1000000;
    @Use(value={FlagTarget.CLASS})
    public static final int CLASS_SEEN = 0x2000000;
    @Use(value={FlagTarget.CLASS})
    public static final int SOURCE_SEEN = 0x4000000;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD})
    public static final int LOCKED = 0x8000000;
    @Use(value={FlagTarget.CLASS})
    public static final int UNATTRIBUTED = 0x10000000;
    @Use(value={FlagTarget.METHOD})
    public static final int ANONCONSTR = 0x20000000;
    @Use(value={FlagTarget.CLASS})
    public static final int SUPER_OWNER_ATTRIBUTED = 0x20000000;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.TYPE_VAR})
    public static final int ACYCLIC = 0x40000000;
    @Use(value={FlagTarget.METHOD})
    public static final long BRIDGE = 0x80000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long PARAMETER = 0x200000000L;
    @Use(value={FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final long VARARGS = 0x400000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long ACYCLIC_ANN = 0x800000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long GENERATEDCONSTR = 0x1000000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long HYPOTHETICAL = 0x2000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long PROPRIETARY = 0x4000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long UNION = 0x8000000000L;
    @Use(value={FlagTarget.CLASS, FlagTarget.TYPE_VAR})
    public static final long RECOVERABLE = 0x10000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long EFFECTIVELY_FINAL = 0x20000000000L;
    @Use(value={FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final long CLASH = 0x40000000000L;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD})
    public static final long DEFAULT = 0x80000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long AUXILIARY = 0x100000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long NOT_IN_PROFILE = 0x200000000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long BAD_OVERRIDE = 0x200000000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long SIGNATURE_POLYMORPHIC = 0x400000000000L;
    @Use(value={FlagTarget.TYPE_VAR})
    public static final long THROWS = 0x800000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long SEALED = 0x1000000000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long LAMBDA_METHOD = 0x2000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long LOCAL_CAPTURE_FIELD = 0x2000000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long TYPE_TRANSLATED = 0x4000000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long MODULE = 0x8000000000000L;
    @Use(value={FlagTarget.MODULE})
    public static final long AUTOMATIC_MODULE = 0x10000000000000L;
    @Use(value={FlagTarget.PACKAGE})
    public static final long HAS_RESOURCE = 0x10000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long NAME_FILLED = 0x10000000000000L;
    @Use(value={FlagTarget.MODULE})
    public static final long SYSTEM_MODULE = 0x20000000000000L;
    @Use(value={FlagTarget.CLASS})
    public static final long VALUE_BASED = 0x20000000000000L;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.MODULE, FlagTarget.PACKAGE, FlagTarget.TYPE_VAR, FlagTarget.VARIABLE})
    public static final long DEPRECATED_ANNOTATION = 0x40000000000000L;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.MODULE, FlagTarget.PACKAGE, FlagTarget.TYPE_VAR, FlagTarget.VARIABLE})
    public static final long DEPRECATED_REMOVAL = 0x80000000000000L;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.MODULE, FlagTarget.PACKAGE, FlagTarget.TYPE_VAR, FlagTarget.VARIABLE})
    public static final long PREVIEW_API = 0x100000000000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long ANONCONSTR_BASED = 0x200000000000000L;
    @Use(value={FlagTarget.BLOCK})
    public static final long BODY_ONLY_FINALIZE = 131072L;
    @Use(value={FlagTarget.CLASS, FlagTarget.METHOD, FlagTarget.MODULE, FlagTarget.PACKAGE, FlagTarget.TYPE_VAR, FlagTarget.VARIABLE})
    public static final long PREVIEW_REFLECTIVE = 0x400000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long MATCH_BINDING = 0x800000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long MATCH_BINDING_TO_OUTER = 0x1000000000000000L;
    @Use(value={FlagTarget.CLASS, FlagTarget.VARIABLE, FlagTarget.METHOD})
    public static final long RECORD = 0x2000000000000000L;
    @Use(value={FlagTarget.METHOD})
    public static final long COMPACT_RECORD_CONSTRUCTOR = 0x8000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long UNINITIALIZED_FIELD = 0x8000000000000L;
    @Use(value={FlagTarget.METHOD, FlagTarget.VARIABLE})
    public static final int GENERATED_MEMBER = 0x1000000;
    @Use(value={FlagTarget.METHOD})
    public static final long RESTRICTED = 0x4000000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long REQUIRES_IDENTITY = 0x4000000000000000L;
    @Use(value={FlagTarget.VARIABLE})
    public static final long FIELD_INIT_TYPE_ANNOTATIONS_QUEUED = 0x20000000000000L;
    @Use(value={FlagTarget.CLASS})
    @CustomToStringValue(value="non-sealed")
    public static final long NON_SEALED = Long.MIN_VALUE;
    @NotFlag
    public static final int AccessFlags = 7;
    @NotFlag
    public static final int LocalClassFlags = 23568;
    @NotFlag
    public static final int StaticLocalFlags = 24088;
    @NotFlag
    public static final int MemberClassFlags = 24087;
    @NotFlag
    public static final int MemberStaticClassFlags = 24095;
    @NotFlag
    public static final int ClassFlags = 32273;
    @NotFlag
    public static final int InterfaceVarFlags = 25;
    @NotFlag
    public static final int VarFlags = 16607;
    @NotFlag
    public static final int ConstructorFlags = 7;
    @NotFlag
    public static final int InterfaceMethodFlags = 1025;
    @NotFlag
    public static final int MethodFlags = 3391;
    @NotFlag
    public static final int RecordMethodFlags = 3135;
    @NotFlag
    public static final long ExtendedStandardFlags = -9223081765785038849L;
    @NotFlag
    public static final long ExtendedMemberClassFlags = -9223090561878041065L;
    @NotFlag
    public static final long ExtendedMemberStaticClassFlags = -9223090561878041057L;
    @NotFlag
    public static final long ExtendedClassFlags = -9223090561878032879L;
    @NotFlag
    public static final long ModifierFlags = -9223081765785039361L;
    @NotFlag
    public static final long InterfaceMethodMask = 8796093025291L;
    @NotFlag
    public static final long AnnotationTypeElementMask = 1025L;
    @NotFlag
    public static final long LocalVarFlags = 0x200000010L;
    @NotFlag
    public static final long ReceiverParamFlags = 0x200000000L;
    private static final Map<Long, Set<Modifier>> modifierSets = new ConcurrentHashMap<Long, Set<Modifier>>(64);

    private Flags() {
    }

    public static String toString(long flags) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (FlagsEnum flag : Flags.asFlagSet(flags)) {
            buf.append(sep);
            buf.append((Object)flag);
            sep = " ";
        }
        return buf.toString();
    }

    public static EnumSet<FlagsEnum> asFlagSet(long flags) {
        EnumSet<FlagsEnum> flagSet = EnumSet.noneOf(FlagsEnum.class);
        for (FlagsEnum flag : FlagsEnum.values()) {
            if ((flags & flag.value()) == 0L) continue;
            flagSet.add(flag);
            flags &= flag.value() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Assert.check(flags == 0L);
        return flagSet;
    }

    public static String toSource(long flags) {
        return Flags.asModifierSet(flags).stream().map(Modifier::toString).collect(Collectors.joining(" "));
    }

    public static Set<Modifier> asModifierSet(long flags) {
        Set<Modifier> modifiers = modifierSets.get(flags);
        if (modifiers == null) {
            modifiers = EnumSet.noneOf(Modifier.class);
            if (0L != (flags & 1L)) {
                modifiers.add(Modifier.PUBLIC);
            }
            if (0L != (flags & 4L)) {
                modifiers.add(Modifier.PROTECTED);
            }
            if (0L != (flags & 2L)) {
                modifiers.add(Modifier.PRIVATE);
            }
            if (0L != (flags & 0x400L)) {
                modifiers.add(Modifier.ABSTRACT);
            }
            if (0L != (flags & 8L)) {
                modifiers.add(Modifier.STATIC);
            }
            if (0L != (flags & 0x1000000000000L)) {
                modifiers.add(Modifier.SEALED);
            }
            if (0L != (flags & Long.MIN_VALUE)) {
                modifiers.add(Modifier.NON_SEALED);
            }
            if (0L != (flags & 0x10L)) {
                modifiers.add(Modifier.FINAL);
            }
            if (0L != (flags & 0x80L)) {
                modifiers.add(Modifier.TRANSIENT);
            }
            if (0L != (flags & 0x40L)) {
                modifiers.add(Modifier.VOLATILE);
            }
            if (0L != (flags & 0x20L)) {
                modifiers.add(Modifier.SYNCHRONIZED);
            }
            if (0L != (flags & 0x100L)) {
                modifiers.add(Modifier.NATIVE);
            }
            if (0L != (flags & 0x800L)) {
                modifiers.add(Modifier.STRICTFP);
            }
            if (0L != (flags & 0x80000000000L)) {
                modifiers.add(Modifier.DEFAULT);
            }
            modifiers = Collections.unmodifiableSet(modifiers);
            modifierSets.put(flags, modifiers);
        }
        return modifiers;
    }

    public static boolean isStatic(Symbol symbol) {
        return (symbol.flags() & 8L) != 0L;
    }

    public static boolean isEnum(Symbol symbol) {
        return (symbol.flags() & 0x4000L) != 0L;
    }

    public static boolean isConstant(Symbol.VarSymbol symbol) {
        return symbol.getConstValue() != null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NoToStringValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CustomToStringValue {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NotFlag {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Use {
        public FlagTarget[] value();
    }

    public static enum FlagTarget {
        BLOCK,
        CLASS,
        MODULE,
        PACKAGE,
        TYPE_VAR,
        METHOD,
        VARIABLE;

    }
}

