/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.policy;

import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.CreatePolicyDetails;
import com.oracle.bmc.identity.model.Policy;
import com.oracle.bmc.identity.model.UpdatePolicyDetails;
import com.oracle.bmc.identity.requests.CreatePolicyRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.UpdatePolicyRequest;
import com.oracle.bmc.identity.responses.CreatePolicyResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.UpdatePolicyResponse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.policy.Bundle;
import org.netbeans.modules.cloud.oracle.policy.PolicyParser;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class PolicyUploader {
    private static final String DEFAULT_POLICY_NAME = "cloud-assets-auto-generated-policy";
    private static final String DEFAULT_POLICY_DESCRIPTION = "OCI Policy that allows access to added Cloud Assets";
    private final IdentityClient client = OCIManager.getDefault().getActiveSession().newClient(IdentityClient.class);

    public void uploadPolicies(List<String> statements) {
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(TenancyStep.class, s -> new CompartmentStep()).build();
        Lookup lookup = Lookups.fixed((Object[])new Object[]{nsProvider});
        Steps.getDefault().executeMultistep(new TenancyStep(true), lookup).thenAccept(values -> {
            CompartmentItem compartment = (CompartmentItem)values.getValueForStep(CompartmentStep.class);
            String compartmentId = compartment.getKey().getValue();
            try {
                List<String> statementsToAdd = this.filterExistingStatements(statements, compartmentId);
                if (statementsToAdd.isEmpty()) {
                    NotificationUtils.showMessage(Bundle.MSG_StatementsExist());
                    return;
                }
                Optional<Policy> policy = this.findPolicyByNameIfExist(DEFAULT_POLICY_NAME, compartmentId);
                if (policy.isPresent()) {
                    this.updateExistingPolicy(policy.get(), statementsToAdd);
                } else {
                    this.createNewPolicy(statementsToAdd, compartmentId);
                }
            }
            catch (Exception ex) {
                NotificationUtils.showErrorMessage(Bundle.MSG_PolicyUploadError(ex.getMessage()));
            }
        });
    }

    private List<String> filterExistingStatements(List<String> statements, String compartmentId) {
        ListPoliciesRequest request = ListPoliciesRequest.builder().compartmentId(compartmentId).build();
        ListPoliciesResponse response = this.client.listPolicies(request);
        List<String> extractedStatements = PolicyParser.getAllStatementsFrom(response.getItems());
        List<String> noWhitespaceStatements = PolicyParser.removeWhitespacesFromStatements(extractedStatements);
        this.detectOverpermissivePolicies(extractedStatements, compartmentId);
        return statements.stream().filter(i -> !noWhitespaceStatements.contains(PolicyParser.prepareForComparing(i))).collect(Collectors.toList());
    }

    private void detectOverpermissivePolicies(List<String> extractedStatements, String compartmentId) {
        List<String> overpermissive = PolicyParser.filterOverpermissiveStatements(extractedStatements);
        if (!overpermissive.isEmpty()) {
            NotificationUtils.showWarningMessage(Bundle.MSG_PotentialOverpermissivePolicies(compartmentId));
        }
    }

    private Optional<Policy> findPolicyByNameIfExist(String policyName, String compartmentId) {
        ListPoliciesRequest request = ListPoliciesRequest.builder().name(policyName).compartmentId(compartmentId).limit(1).build();
        ListPoliciesResponse response = this.client.listPolicies(request);
        return !response.getItems().isEmpty() ? Optional.of(response.getItems().get(0)) : Optional.empty();
    }

    private void createNewPolicy(List<String> statementsToAdd, String compartmentId) {
        CreatePolicyDetails createPolicyDetails = CreatePolicyDetails.builder().name(DEFAULT_POLICY_NAME).description(DEFAULT_POLICY_DESCRIPTION).compartmentId(compartmentId).statements(statementsToAdd).build();
        CreatePolicyRequest request = CreatePolicyRequest.builder().createPolicyDetails(createPolicyDetails).build();
        CreatePolicyResponse response = this.client.createPolicy(request);
        if (response.get__httpStatusCode__() != 200) {
            NotificationUtils.showErrorMessage(Bundle.MSG_PolicyUploadError(DEFAULT_POLICY_NAME));
        }
        NotificationUtils.showMessage(Bundle.MSG_PolicyUploaded(DEFAULT_POLICY_NAME));
    }

    private void updateExistingPolicy(Policy policy, List<String> statementsToAdd) {
        List<String> resultStatements = Stream.concat(policy.getStatements().stream(), statementsToAdd.stream()).collect(Collectors.toList());
        UpdatePolicyDetails updatePolicyDetails = UpdatePolicyDetails.builder().statements(resultStatements).build();
        UpdatePolicyRequest request = UpdatePolicyRequest.builder().policyId(policy.getId()).updatePolicyDetails(updatePolicyDetails).build();
        UpdatePolicyResponse response = this.client.updatePolicy(request);
        if (response.get__httpStatusCode__() != 200) {
            NotificationUtils.showErrorMessage(Bundle.MSG_PolicyUpdateError(DEFAULT_POLICY_NAME));
        }
        NotificationUtils.showMessage(Bundle.MSG_PolicyUpdated(DEFAULT_POLICY_NAME));
    }
}

