/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.cloud.oracle.assets.Bundle;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public final class SuggestedItem
extends OCIItem {
    private final String path;
    private final Set<String> exclusivePaths;

    public SuggestedItem(String path, String name, Set<String> exclusivePaths) {
        super(OCID.of("", "Suggested"), null, name, null, null);
        this.path = path;
        this.exclusivePaths = exclusivePaths;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getExclusivePaths() {
        return Collections.unmodifiableSet(this.exclusivePaths);
    }

    public static SuggestedItem forPath(String path) {
        switch (path) {
            case "Database": {
                return new SuggestedItem("Database", Bundle.SelectDatabases(), Collections.emptySet());
            }
            case "Vault": {
                return new SuggestedItem("Vault", Bundle.SelectVault(), Collections.emptySet());
            }
            case "Bucket": {
                return new SuggestedItem("Bucket", Bundle.SelectBucket(), Collections.emptySet());
            }
            case "Cluster": {
                return new SuggestedItem("Cluster", Bundle.SelectCluster(), Collections.singleton("ComputeInstance"));
            }
            case "ComputeInstance": {
                return new SuggestedItem("ComputeInstance", Bundle.SelectCompute(), Collections.singleton("Cluster"));
            }
            case "ContainerRepository": {
                return new SuggestedItem("ContainerRepository", Bundle.SelectContainerRepository(), Collections.singleton("ContainerRepository"));
            }
            case "MetricsNamespace": {
                return new SuggestedItem("MetricsNamespace", Bundle.SelectMetricsNamespace(), Collections.singleton("MetricsNamespace"));
            }
        }
        throw new IllegalArgumentException("");
    }
}

