/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.ui.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderRenameHandler;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(FilterNode.class.getName());
    private static final AtomicReference<Action[]> actions = new AtomicReference();
    private final SourceGroup g;

    TreeRootNode(SourceGroup g, boolean reduced) {
        this(DataFolder.findFolder((FileObject)g.getRootFolder()), g, reduced);
    }

    private TreeRootNode(DataFolder folder, SourceGroup g, boolean reduced) {
        this((Node)new FilterNode(folder.getNodeDelegate(), reduced ? FilterNode.Children.LEAF : folder.createNodeChildren((DataFilter)new GroupDataFilter(g))), folder, g, reduced);
    }

    private TreeRootNode(Node originalNode, DataFolder folder, SourceGroup g, boolean reduced) {
        super(originalNode, (Children)(reduced ? FilterNode.Children.create((ChildFactory)new ReducedChildren(folder, new GroupDataFilter(g), g), (boolean)true) : new PackageFilterChildren(originalNode)), (Lookup)new ProxyLookup(new Lookup[]{originalNode.getLookup(), Lookups.singleton((Object)new PathFinder(g, reduced))}));
        this.g = g;
        g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = this.g.getIcon(opened);
        if (icon == null) {
            Image image = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            return ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif"), (int)7, (int)7);
        }
        return ImageUtilities.icon2Image((Icon)icon);
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public String getName() {
        return this.g.getName();
    }

    public String getDisplayName() {
        return this.g.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    @NonNull
    public Action[] getActions(boolean context) {
        Action[] res = actions.get();
        if (res == null && !actions.compareAndSet(null, res = PackageView.createRootNodeActions())) {
            res = actions.get();
        }
        assert (res != null);
        return res;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeRootNode.this.fireNameChange(null, null);
                TreeRootNode.this.fireDisplayNameChange(null, null);
                TreeRootNode.this.fireIconChange();
                TreeRootNode.this.fireOpenedIconChange();
            }
        });
    }

    private static final class GroupDataFilter
    implements ChangeListener,
    PropertyChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private static final long serialVersionUID = 1L;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final SourceGroup g;

        public GroupDataFilter(SourceGroup g) {
            this.g = g;
            VisibilityQuery.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault()));
            g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("containership".equals(e.getPropertyName())) {
                this.cs.fireChange();
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        public boolean acceptFileObject(FileObject fo) {
            return fo.isValid() && this.g.contains(fo) && VisibilityQuery.getDefault().isVisible(fo);
        }
    }

    private static class ReducedChildren
    extends ChildFactory<DataObject>
    implements ChangeListener,
    PropertyChangeListener {
        private final DataFolder folder;
        private final ChangeableDataFilter filter;
        private final SourceGroup g;

        ReducedChildren(DataFolder folder, ChangeableDataFilter filter, SourceGroup g) {
            this.folder = folder;
            this.filter = filter;
            this.g = g;
            filter.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)filter));
            folder.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)folder));
        }

        protected boolean createKeys(List<DataObject> keys) {
            ArrayList<DataObject> files = new ArrayList<DataObject>();
            for (DataObject f : this.folder.getChildren()) {
                if (!this.filter.acceptDataObject(f)) continue;
                if (f instanceof DataFolder) {
                    while (true) {
                        DataObject candidate = null;
                        f.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)f));
                        for (DataObject kid : ((DataFolder)f).getChildren()) {
                            if (!this.filter.acceptDataObject(kid)) continue;
                            if (kid instanceof DataFolder) {
                                if (candidate == null) {
                                    candidate = kid;
                                    continue;
                                }
                                candidate = null;
                                break;
                            }
                            candidate = null;
                            break;
                        }
                        if (candidate == null) break;
                        f = candidate;
                    }
                    keys.add(f);
                    continue;
                }
                files.add(f);
            }
            keys.addAll(files);
            return true;
        }

        protected Node createNodeForKey(DataObject key) {
            if (!key.isValid()) {
                return null;
            }
            return key instanceof DataFolder ? new PackageFilterNode((DataFolder)key, this.folder, this.filter, this.g) : key.getNodeDelegate().cloneNode();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh(false);
        }
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node originalNode) {
            super(originalNode);
        }

        protected Node copyNode(Node originalNode) {
            FileObject fobj = (FileObject)originalNode.getLookup().lookup(FileObject.class);
            if (fobj == null) {
                LOG.log(Level.WARNING, "The node {0} has no FileObject in its Lookup.", originalNode);
                return super.copyNode(originalNode);
            }
            return fobj.isFolder() ? new PackageFilterNode(originalNode) : super.copyNode(originalNode);
        }
    }

    public static final class PathFinder
    implements org.netbeans.spi.project.ui.PathFinder {
        private final SourceGroup g;
        private final boolean reduced;

        PathFinder(SourceGroup g, boolean reduced) {
            this.g = g;
            this.reduced = reduced;
        }

        public Node findPath(Node rootNode, Object o) {
            FileObject fo;
            if (o instanceof FileObject) {
                fo = (FileObject)o;
            } else if (o instanceof DataObject) {
                fo = ((DataObject)o).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                return this.reduced ? this.findPathReduced(fo, rootNode) : this.findPathPlain(fo, groupRoot, rootNode);
            }
            if (groupRoot.equals(fo)) {
                return rootNode;
            }
            return null;
        }

        private Node findPathPlain(FileObject fo, FileObject groupRoot, Node rootNode) {
            FileObject folder = fo.isFolder() ? fo : fo.getParent();
            String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)folder);
            ArrayList<String> path = new ArrayList<String>();
            StringTokenizer strtok = new StringTokenizer(relPath, "/");
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                path.add(token);
            }
            try {
                Node folderNode;
                Node node = folderNode = folder.equals(groupRoot) ? rootNode : NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                if (fo.isFolder()) {
                    return folderNode;
                }
                Node[] childs = folderNode.getChildren().getNodes(true);
                for (int i = 0; i < childs.length; ++i) {
                    DataObject dobj = (DataObject)childs[i].getLookup().lookup(DataObject.class);
                    if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                    return childs[i];
                }
            }
            catch (NodeNotFoundException e) {
                e.printStackTrace();
            }
            return null;
        }

        private Node findPathReduced(FileObject fo, Node n) {
            FileObject f = (FileObject)n.getLookup().lookup(FileObject.class);
            if (f == fo) {
                return n;
            }
            if (f != null && FileUtil.isParentOf((FileObject)f, (FileObject)fo)) {
                for (Node child : n.getChildren().getNodes(true)) {
                    Node found = this.findPathReduced(fo, child);
                    if (found == null) continue;
                    return found;
                }
            }
            return null;
        }
    }

    private static final class PackageFilterNode
    extends FilterNode {
        private static final String PUBLIC_PACKAGE_BADGE = "org/netbeans/spi/java/project/support/ui/publicBadge.gif";
        private static final String PRIVATE_PACKAGE_BADGE = "org/netbeans/spi/java/project/support/ui/privateBadge.gif";
        private static Image unlockBadge;
        private static Image lockBadge;
        private final DataFolder parent;
        private final SourceGroup g;
        private Action[] actions;
        private final Action testPackageAction = FileSensitiveActions.fileCommandAction((String)"test.single", (String)NbBundle.getMessage(TreeRootNode.class, (String)"LBL_TestPackageAction_Name"), null);

        public PackageFilterNode(Node origNode) {
            super(origNode, (Children)new PackageFilterChildren(origNode));
            this.parent = null;
            this.g = null;
        }

        PackageFilterNode(DataFolder folder, DataFolder parent, ChangeableDataFilter filter, SourceGroup g) {
            super(folder.getNodeDelegate(), FilterNode.Children.create((ChildFactory)new ReducedChildren(folder, filter, g), (boolean)true));
            this.parent = parent;
            this.g = g;
        }

        public String getName() {
            String relName;
            DataObject d;
            if (this.parent != null && (d = (DataObject)this.getLookup().lookup(DataObject.class)) != null && (relName = FileUtil.getRelativePath((FileObject)this.parent.getPrimaryFile(), (FileObject)d.getPrimaryFile())) != null) {
                return relName.replace('/', '.');
            }
            return super.getName();
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    ArrayList<Action> actionList = new ArrayList<Action>(superActions.length);
                    for (int i = 0; i < superActions.length; ++i) {
                        if (superActions[i] instanceof FileSystemAction) {
                            actionList.add(null);
                            actionList.add(this.testPackageAction);
                            actionList.addAll(Utilities.actionsForPath((String)"Projects/package/Actions"));
                        }
                        actionList.add(superActions[i]);
                    }
                    this.actions = new Action[actionList.size()];
                    actionList.toArray(this.actions);
                }
                return this.actions;
            }
            return super.getActions(context);
        }

        public String getDisplayName() {
            if (this.parent != null) {
                return this.getName();
            }
            return super.getDisplayName();
        }

        public void destroy() throws IOException {
            if (this.parent != null) {
                for (DataObject d = (DataObject)this.getLookup().lookup(DataObject.class); d != null && FileUtil.isParentOf((FileObject)this.parent.getPrimaryFile(), (FileObject)d.getPrimaryFile()); d = d.getFolder()) {
                    d.delete();
                }
            } else {
                super.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setName(String name) {
            if (this.parent != null) {
                if (PackageViewChildren.isValidPackageName(name)) {
                    PackageRenameHandler prh = (PackageRenameHandler)Lookup.getDefault().lookup(PackageRenameHandler.class);
                    FolderRenameHandler frh = (FolderRenameHandler)Lookup.getDefault().lookup(FolderRenameHandler.class);
                    if (prh != null && frh != null) {
                        DataFolder folder = (DataFolder)this.getLookup().lookup(DataFolder.class);
                        String old = this.getName();
                        int dot = old.lastIndexOf(46);
                        if (name.lastIndexOf(46) == dot) {
                            if (dot == -1) {
                                frh.handleRename(folder, name);
                                return;
                            }
                            if (dot != -1 && name.substring(0, dot).equals(old.substring(0, dot))) {
                                frh.handleRename(folder, name.substring(dot + 1));
                                return;
                            }
                        }
                        for (DataObject d : folder.getChildren()) {
                            if (!(d instanceof DataFolder)) continue;
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_unsupported_rename(), 1));
                            return;
                        }
                        String parentPackageSlashes = FileUtil.getRelativePath((FileObject)this.g.getRootFolder(), (FileObject)this.parent.getPrimaryFile());
                        if (parentPackageSlashes != null) {
                            prh.handleRename((Node)new PackageViewChildren(this.g).new PackageViewChildren.PackageNode(this.g.getRootFolder(), folder), (String)(parentPackageSlashes.isEmpty() ? "" : parentPackageSlashes.replace('/', '.') + ".") + name);
                            return;
                        }
                    }
                    FileObject d = ((DataObject)this.getLookup().lookup(DataObject.class)).getPrimaryFile();
                    FileObject origParent = d.getParent();
                    try {
                        FileLock lock = d.lock();
                        try {
                            String child;
                            FileObject p;
                            int dot = name.lastIndexOf(46);
                            if (dot == -1) {
                                p = this.parent.getPrimaryFile();
                                child = name;
                            } else {
                                p = FileUtil.createFolder((FileObject)this.parent.getPrimaryFile(), (String)name.substring(0, dot).replace('.', '/'));
                                child = name.substring(dot + 1);
                            }
                            d.move(lock, p, child, null);
                        }
                        finally {
                            lock.releaseLock();
                        }
                        while (origParent != null && origParent.isValid() && origParent.getChildren().length == 0) {
                            FileObject higher = origParent.getParent();
                            origParent.delete();
                            origParent = higher;
                        }
                    }
                    catch (IOException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_InvalidPackageName(), 1));
                }
                return;
            }
            if (Utilities.isJavaIdentifier((String)name)) {
                super.setName(name);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_InvalidPackageName(), 1));
            }
        }

        @CheckForNull
        private DataFolder topPackage() {
            DataFolder there;
            if (this.parent == null) {
                return null;
            }
            DataFolder here = (DataFolder)this.getLookup().lookup(DataFolder.class);
            while (here != null && (there = here.getFolder()) != null && there != this.parent) {
                here = there;
            }
            return here;
        }

        public Transferable clipboardCut() throws IOException {
            DataFolder top = this.topPackage();
            if (top != null) {
                return top.getNodeDelegate().clipboardCut();
            }
            return super.clipboardCut();
        }

        public Transferable clipboardCopy() throws IOException {
            DataFolder top = this.topPackage();
            if (top != null) {
                return top.getNodeDelegate().clipboardCopy();
            }
            return super.clipboardCopy();
        }

        public Image getIcon(int type) {
            return this.getIcon(type, false);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image getIcon(int type, boolean opened) {
            Image icon;
            DataObject dobj;
            if (this.parent != null && (dobj = (DataObject)this.getLookup().lookup(DataObject.class)) != null) {
                FileObject f = dobj.getPrimaryFile();
                Image icon2 = PackageDisplayUtils.getIcon(f, false);
                try {
                    icon2 = FileUIUtils.getImageDecorator((FileSystem)f.getFileSystem()).annotateIcon(icon2, type, Collections.singleton(f));
                }
                catch (FileStateInvalidException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
                return icon2;
            }
            Image image = icon = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            if (icon == null) {
                return icon;
            }
            DataObject dobj2 = (DataObject)this.getLookup().lookup(DataObject.class);
            if (dobj2 == null) {
                return icon;
            }
            FileObject fo = dobj2.getPrimaryFile();
            if (fo == null) {
                return icon;
            }
            Boolean pub = AccessibilityQuery.isPubliclyAccessible((FileObject)fo);
            if (pub == Boolean.TRUE) {
                Class<PackageFilterNode> clazz = PackageFilterNode.class;
                synchronized (PackageFilterNode.class) {
                    if (unlockBadge == null) {
                        unlockBadge = ImageUtilities.loadImage((String)PUBLIC_PACKAGE_BADGE);
                    }
                    // ** MonitorExit[var7_10] (shouldn't be in output)
                    return ImageUtilities.mergeImages((Image)icon, (Image)unlockBadge, (int)0, (int)0);
                }
            }
            if (pub == Boolean.FALSE) {
                Class<PackageFilterNode> clazz = PackageFilterNode.class;
                synchronized (PackageFilterNode.class) {
                    if (lockBadge == null) {
                        lockBadge = ImageUtilities.loadImage((String)PRIVATE_PACKAGE_BADGE);
                    }
                    // ** MonitorExit[var7_11] (shouldn't be in output)
                    return ImageUtilities.mergeImages((Image)icon, (Image)lockBadge, (int)0, (int)0);
                }
            }
            return icon;
        }

        public String getShortDescription() {
            DataObject doj;
            if (this.g != null && (doj = (DataObject)this.getLookup().lookup(DataObject.class)) != null) {
                FileObject f = doj.getPrimaryFile();
                String rel = FileUtil.getRelativePath((FileObject)this.g.getRootFolder(), (FileObject)f);
                if (rel != null) {
                    return PackageDisplayUtils.getToolTip(f, rel.replace('/', '.'));
                }
            }
            return super.getShortDescription();
        }
    }
}

