/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.db.dataview.table.celleditor.AlwaysEnable;
import org.netbeans.modules.db.dataview.table.celleditor.MonitorableCharacterStreamTransfer;
import org.netbeans.modules.db.dataview.table.celleditor.StringTableCellEditor;
import org.netbeans.modules.db.dataview.util.FileBackedClob;
import org.netbeans.modules.db.dataview.util.LobHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ClobFieldTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
AlwaysEnable {
    private static final Logger LOG = Logger.getLogger(ClobFieldTableCellEditor.class.getName());
    private static final String EDIT = "edit";
    private static File lastFile;
    private Clob currentValue;
    private JButton button = new JButton();
    private JPopupMenu popup;
    private JTable table;
    private int currentRow;
    private int currentColumn;
    private int currentModelRow;
    private int currentModelColumn;
    private JMenuItem saveContentMenuItem;
    private JMenuItem editContentMenuItem;
    private JMenuItem loadContentMenuItem;
    private JMenuItem nullContentMenuItem;

    public ClobFieldTableCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setContentAreaFilled(false);
        this.button.setOpaque(false);
        this.button.setBorderPainted(false);
        this.button.setRolloverEnabled(false);
        this.button.setAlignmentX(0.0f);
        this.button.setHorizontalAlignment(2);
        this.button.setFont(new Font(this.button.getFont().getFamily(), 2, 9));
        this.popup = new JPopupMenu();
        this.saveContentMenuItem = new JMenuItem(NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"saveLob.title"));
        this.saveContentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClobFieldTableCellEditor.this.saveLobToFile(ClobFieldTableCellEditor.this.currentValue);
                ClobFieldTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.popup.add(this.saveContentMenuItem);
        this.editContentMenuItem = new JMenuItem(NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"editClob.title"));
        this.editContentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClobFieldTableCellEditor.this.fireEditingStopped();
                ClobFieldTableCellEditor.this.editCell();
            }
        });
        this.popup.add(this.editContentMenuItem);
        this.loadContentMenuItem = new JMenuItem(NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"loadLob.title"));
        this.loadContentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clob newValue = ClobFieldTableCellEditor.this.loadLobFromFile();
                if (newValue != null) {
                    ClobFieldTableCellEditor.this.currentValue = newValue;
                }
                ClobFieldTableCellEditor.this.fireEditingStopped();
            }
        });
        this.popup.add(this.loadContentMenuItem);
        this.nullContentMenuItem = new JMenuItem(NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"nullLob.title"));
        this.nullContentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClobFieldTableCellEditor.this.currentValue = null;
                ClobFieldTableCellEditor.this.fireEditingStopped();
            }
        });
        this.popup.add(this.nullContentMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.popup.show(this.button, 0, this.button.getHeight());
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentValue = (Clob)value;
        this.currentColumn = column;
        this.currentRow = row;
        this.table = table;
        this.currentModelColumn = table.convertColumnIndexToModel(column);
        this.currentModelRow = table.convertRowIndexToModel(row);
        boolean editable = table.getModel().isCellEditable(this.currentModelRow, this.currentModelColumn);
        if (this.currentValue != null) {
            this.saveContentMenuItem.setEnabled(true);
            this.button.setText(LobHelper.clobToDescription(this.currentValue));
        } else {
            this.saveContentMenuItem.setEnabled(false);
            this.button.setText("<NULL>");
        }
        this.loadContentMenuItem.setEnabled(editable);
        this.nullContentMenuItem.setEnabled(editable);
        if (editable) {
            this.editContentMenuItem.setEnabled(true);
            this.editContentMenuItem.setText(NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"editClob.title"));
        } else {
            this.editContentMenuItem.setEnabled(this.currentValue != null);
            this.editContentMenuItem.setText(NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"editClobReadOnly.title"));
        }
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return super.isCellEditable(anEvent);
    }

    private void saveLobToFile(Clob b) {
        if (b == null) {
            return;
        }
        CharsetSelector charset = new CharsetSelector();
        JFileChooser c = new JFileChooser();
        c.setCurrentDirectory(lastFile);
        c.setAccessory(charset);
        int fileDialogState = c.showSaveDialog(this.table);
        if (fileDialogState == 0) {
            File f;
            lastFile = f = c.getSelectedFile();
            try {
                Reader r = b.getCharacterStream();
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), charset.getSelectedCharset());
                if (!this.doTransfer(r, w, (int)b.length(), "Save to file: " + f.toString(), false)) {
                    f.delete();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IOException while saving CLOB to file", ex);
                this.displayError(f, ex, false);
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "SQLException while saving CLOB to file", ex);
                this.displayError(f, ex, false);
            }
        }
    }

    private Clob loadLobFromFile() {
        CharsetSelector charset = new CharsetSelector();
        JFileChooser c = new JFileChooser();
        c.setCurrentDirectory(lastFile);
        c.setAccessory(charset);
        FileBackedClob result = null;
        int fileDialogState = c.showOpenDialog(this.table);
        if (fileDialogState == 0) {
            File f;
            lastFile = f = c.getSelectedFile();
            try {
                result = new FileBackedClob();
                InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), charset.getSelectedCharset());
                if (!this.doTransfer(r, result.setCharacterStream(1L), (int)f.length() / 2, "Load from file: " + f.toString(), true)) {
                    result = null;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IOException while loading CLOB from file", ex);
                this.displayError(f, ex, true);
                result = null;
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "SQLException while loading CLOB from file", ex);
                this.displayError(f, ex, true);
                result = null;
            }
        }
        return result;
    }

    private boolean doTransfer(Reader in, Writer out, Integer size, String title, boolean sizeEstimated) throws IOException {
        MonitorableCharacterStreamTransfer ft = new MonitorableCharacterStreamTransfer(in, out, sizeEstimated ? null : size);
        Throwable t = size == null || size > 0x100000 ? (Throwable)BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)ft, (String)title, (boolean)false) : ft.run(null);
        in.close();
        out.close();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t != null) {
            throw new RuntimeException(t);
        }
        return !ft.isCancel();
    }

    private void displayError(File f, Exception ex, boolean read) {
        String messageMsg;
        String titleMsg;
        DialogDisplayer dd = DialogDisplayer.getDefault();
        String errorObjectMsg = ex instanceof SQLException ? NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"lobErrorObject.database") : NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"lobErrorObject.file");
        if (!read) {
            titleMsg = NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"clobSaveToFileError.title");
            messageMsg = NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"clobSaveToFileError.message", (Object)errorObjectMsg, (Object)f.getAbsolutePath(), (Object)ex.getLocalizedMessage());
        } else {
            titleMsg = NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"clobReadFromFileError.title");
            messageMsg = NbBundle.getMessage(ClobFieldTableCellEditor.class, (String)"clobReadFromFileError.message", (Object)errorObjectMsg, (Object)f.getAbsolutePath(), (Object)ex.getLocalizedMessage());
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)messageMsg, titleMsg, 2, 2, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION);
        dd.notifyLater(nd);
    }

    protected void editCell() {
        String stringVal = "";
        if (this.currentValue != null) {
            try {
                stringVal = this.currentValue.getSubString(1L, (int)this.currentValue.length());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        JTextArea textArea = new JTextArea(20, 80);
        textArea.setDropTarget(null);
        textArea.setText(stringVal);
        textArea.setCaretPosition(0);
        textArea.setEditable(this.table.getModel().isCellEditable(this.currentModelRow, this.currentModelColumn));
        JScrollPane pane = new JScrollPane(textArea);
        pane.addHierarchyListener(new StringTableCellEditor.MakeResizableListener(pane));
        Frame parent = WindowManager.getDefault().getMainWindow();
        if (this.table.isCellEditable(this.currentRow, this.currentColumn)) {
            int result = JOptionPane.showOptionDialog(parent, pane, this.table.getColumnName(this.currentColumn), 2, -1, null, null, null);
            if (result == 0) {
                try {
                    this.table.setValueAt(new FileBackedClob(textArea.getText()), this.currentRow, this.currentColumn);
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            JOptionPane.showMessageDialog(parent, pane, this.table.getColumnName(this.currentColumn), -1, null);
        }
    }

    private class CharsetSelector
    extends JPanel {
        private JComboBox charsetSelect;

        CharsetSelector() {
            ArrayList<Charset> charset = new ArrayList<Charset>(Charset.availableCharsets().values());
            charset.sort(new Comparator<Charset>(){

                @Override
                public int compare(Charset o1, Charset o2) {
                    return o1.displayName().compareTo(o2.displayName());
                }
            });
            this.charsetSelect = new JComboBox();
            this.charsetSelect.setModel(new DefaultComboBoxModel<Charset>(charset.toArray(new Charset[0])));
            this.charsetSelect.setSelectedItem(Charset.defaultCharset());
            this.add(this.charsetSelect);
        }

        public Charset getSelectedCharset() {
            return (Charset)this.charsetSelect.getSelectedItem();
        }

        public void setSelectedCharset(Charset selectedCharset) {
            this.charsetSelect.setSelectedItem(selectedCharset);
        }
    }
}

