/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.jumpto.SearchHistory;
import org.netbeans.modules.jumpto.common.ItemRenderer;
import org.netbeans.modules.jumpto.common.UiUtils;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.netbeans.modules.jumpto.type.GoToTypeAction;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class GoToPanel
extends JPanel {
    private static final Icon WAIT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/wait.gif", (boolean)false);
    private static final Icon WARN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/warning.png", (boolean)false);
    private static final int BRIGHTER_COLOR_COMPONENT = 10;
    private final ContentProvider contentProvider;
    private boolean containsScrollPane;
    JLabel messageLabel;
    private Iterable<? extends TypeDescriptor> selectedTypes = List.of();
    private String oldMessage;
    long time = -1L;
    private final SearchHistory searchHistory;
    private boolean pastedFromClipboard = false;
    private JCheckBox caseSensitive;
    private JLabel jLabelList;
    private JLabel jLabelLocation;
    private JLabel jLabelText;
    private JLabel jLabelWarning;
    private JTextField jTextFieldLocation;
    private JPanel listPanel;
    private JList<TypeDescriptor> matchesList;
    private JScrollPane matchesScrollPane1;
    JTextField nameField;
    private JCheckBox prefereOpen;

    public GoToPanel(ContentProvider contentProvider, boolean multiSelection) throws IOException {
        this.contentProvider = contentProvider;
        this.initComponents();
        ((AbstractDocument)this.nameField.getDocument()).setDocumentFilter(UiUtils.newUserInputFilter());
        this.containsScrollPane = true;
        this.matchesList.setSelectionMode(multiSelection ? 2 : 0);
        this.matchesList.addListSelectionListener(null);
        Color bgColorBrighter = new Color(Math.min(this.getBackground().getRed() + 10, 255), Math.min(this.getBackground().getGreen() + 10, 255), Math.min(this.getBackground().getBlue() + 10, 255));
        this.messageLabel = new JLabel();
        this.messageLabel.setBackground(bgColorBrighter);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setEnabled(true);
        this.messageLabel.setText(NbBundle.getMessage(GoToPanel.class, (String)"TXT_NoTypesFound"));
        this.messageLabel.setFont(this.matchesList.getFont());
        this.matchesList.setCellRenderer(contentProvider.getListCellRenderer(this.matchesList, this.caseSensitive.getModel()));
        contentProvider.setListModel(this, null);
        PatternListener pl = new PatternListener(this);
        this.nameField.getDocument().addDocumentListener(pl);
        this.caseSensitive.setSelected(UiOptions.GoToTypeDialog.getCaseSensitive());
        this.caseSensitive.addItemListener(pl);
        this.prefereOpen.setSelected(GoToSettings.getDefault().isSortingPreferOpenProjects());
        this.prefereOpen.addItemListener(pl);
        this.matchesList.addListSelectionListener(pl);
        this.searchHistory = new SearchHistory(GoToPanel.class, this.nameField);
    }

    @Override
    public void removeNotify() {
        this.searchHistory.saveHistory();
        super.removeNotify();
    }

    boolean setModel(ListModel<TypeDescriptor> model) {
        assert (SwingUtilities.isEventDispatchThread());
        this.matchesList.setModel(model);
        if (model.getSize() > 0 || this.getText() == null || this.getText().isBlank()) {
            this.matchesList.setSelectedIndex(0);
            this.setListPanelContent(null, false);
            if (this.time != -1L) {
                GoToTypeAction.LOGGER.fine("Real search time " + (System.currentTimeMillis() - this.time) + " ms.");
                this.time = -1L;
            }
            return true;
        }
        this.setListPanelContent(NbBundle.getMessage(GoToPanel.class, (String)"TXT_NoTypesFound"), false);
        return false;
    }

    boolean revalidateModel() {
        return this.setModel(this.matchesList.getModel());
    }

    public void setInitialText(String text) {
        SwingUtilities.invokeLater(() -> {
            String textInField = this.nameField.getText();
            if (textInField == null || textInField.isBlank()) {
                this.nameField.setText(text);
                this.nameField.setCaretPosition(text.length());
                this.nameField.setSelectionStart(0);
                this.nameField.setSelectionEnd(text.length());
            }
        });
    }

    public void setSelectedTypes() {
        this.selectedTypes = List.copyOf(this.matchesList.getSelectedValuesList());
    }

    public Iterable<? extends TypeDescriptor> getSelectedTypes() {
        return this.selectedTypes;
    }

    void setWarning(String warningMessage) {
        if (warningMessage != null) {
            this.jLabelWarning.setIcon(WARN_ICON);
            this.jLabelWarning.setBorder(BorderFactory.createEmptyBorder(3, 1, 1, 1));
        } else {
            this.jLabelWarning.setIcon(null);
            this.jLabelWarning.setBorder(null);
        }
        this.jLabelWarning.setText(warningMessage);
    }

    public void setMouseListener(MouseListener warningMouseListener) {
        if (this.messageLabel.getMouseListeners().length == 0) {
            this.messageLabel.addMouseListener(warningMouseListener);
        }
    }

    private void initComponents() {
        this.jLabelText = new JLabel();
        this.nameField = new JTextField();
        this.jLabelList = new JLabel();
        this.listPanel = new JPanel();
        this.matchesScrollPane1 = new JScrollPane();
        this.matchesList = new JList();
        this.jLabelWarning = new JLabel();
        this.caseSensitive = new JCheckBox();
        this.prefereOpen = new JCheckBox();
        this.jLabelLocation = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setFocusable(false);
        this.setNextFocusableComponent(this.nameField);
        this.setLayout(new GridBagLayout());
        this.jLabelText.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabelText, (String)NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_TypeName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelText, gridBagConstraints);
        this.jLabelText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToPanel.class, (String)"GoToPanel.jLabelText.AccessibleContext.accessibleDescription"));
        this.nameField.setFont(new Font("Monospaced", 0, this.getFontSize()));
        this.nameField.setBorder(BorderFactory.createEtchedBorder());
        this.nameField.addActionListener(this::nameFieldActionPerformed);
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GoToPanel.this.nameFieldKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                GoToPanel.this.nameFieldKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                GoToPanel.this.nameFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.jLabelList.setLabelFor(this.matchesList);
        Mnemonics.setLocalizedText((JLabel)this.jLabelList, (String)NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_MatchesList_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelList, gridBagConstraints);
        this.listPanel.setBorder(BorderFactory.createEtchedBorder());
        this.listPanel.setName("dataPanel");
        this.listPanel.setLayout(new BorderLayout());
        this.matchesScrollPane1.setBorder(null);
        this.matchesScrollPane1.setFocusable(false);
        this.matchesList.setFont(new Font("Monospaced", 0, this.getFontSize()));
        this.matchesList.setVisibleRowCount(15);
        this.matchesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                GoToPanel.this.matchesListMouseReleased(evt);
            }
        });
        this.matchesScrollPane1.setViewportView(this.matchesList);
        this.matchesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToPanel.class, (String)"ACSD_GoToListName"));
        this.matchesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToPanel.class, (String)"GoToPanel.matchesList.AccessibleContext.accessibleDescription"));
        this.listPanel.add((Component)this.matchesScrollPane1, "Center");
        this.jLabelWarning.setFocusable(false);
        this.listPanel.add((Component)this.jLabelWarning, "Last");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.listPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitive, (String)NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_CaseSensitive"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.caseSensitive, gridBagConstraints);
        this.caseSensitive.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToPanel.class, (String)"GoToPanel.caseSensitive.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.prefereOpen, (String)NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_PreferOpenProjects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.prefereOpen, gridBagConstraints);
        this.prefereOpen.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToPanel.class, (String)"GoToPanel.prefereOpen.AccessibleContext.accessibleDescription"));
        this.jLabelLocation.setText(NbBundle.getMessage(GoToPanel.class, (String)"LBL_GoToType_LocationJLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelLocation, gridBagConstraints);
        this.jTextFieldLocation.setEditable(false);
        this.jTextFieldLocation.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jTextFieldLocation, gridBagConstraints);
    }

    private void matchesListMouseReleased(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.nameFieldActionPerformed(null);
        }
    }

    private void nameFieldKeyTyped(KeyEvent evt) {
        if (this.boundScrollingKey(evt)) {
            this.delegateScrollingKey(evt);
        }
    }

    private void nameFieldKeyReleased(KeyEvent evt) {
        if (this.boundScrollingKey(evt)) {
            this.delegateScrollingKey(evt);
        }
    }

    private void nameFieldKeyPressed(KeyEvent evt) {
        if (this.boundScrollingKey(evt)) {
            this.delegateScrollingKey(evt);
        } else {
            String action;
            Object o = this.nameField.getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt));
            if (o instanceof String && "paste-from-clipboard".equals(action = (String)o)) {
                String selectedTxt = this.nameField.getSelectedText();
                String txt = this.nameField.getText();
                if (selectedTxt != null && txt != null && selectedTxt.length() == txt.length()) {
                    this.pastedFromClipboard = true;
                }
            }
        }
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        if (this.contentProvider.hasValidContent()) {
            this.contentProvider.closeDialog();
            this.setSelectedTypes();
        }
    }

    private String getText() {
        try {
            String text = this.nameField.getDocument().getText(0, this.nameField.getDocument().getLength());
            return text;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    private int getFontSize() {
        return this.jLabelList.getFont().getSize();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    public boolean isPreferOpenProjects() {
        return this.prefereOpen.isSelected();
    }

    void updateMessage(@NullAllowed String message) {
        if (message == null ? this.oldMessage != null : !message.equals(this.oldMessage)) {
            this.setListPanelContent(message, true);
        }
    }

    void setListPanelContent(String message, boolean waitIcon) {
        assert (SwingUtilities.isEventDispatchThread());
        this.oldMessage = message;
        if (message == null) {
            if (!this.containsScrollPane) {
                this.listPanel.remove(this.messageLabel);
                this.listPanel.add(this.matchesScrollPane1);
                this.containsScrollPane = true;
                this.revalidate();
                this.repaint();
            }
        } else {
            this.jTextFieldLocation.setText("");
            this.messageLabel.setText((String)(waitIcon ? "<html>" + message + "&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"http://www.netbeans.org\">" + NbBundle.getMessage(GoToPanel.class, (String)"TXT_CancelSearch") + "</a></html>" : message));
            this.messageLabel.setIcon(waitIcon ? WAIT_ICON : null);
            if (this.containsScrollPane) {
                this.listPanel.remove(this.matchesScrollPane1);
                this.listPanel.add(this.messageLabel);
                this.containsScrollPane = false;
            }
            this.revalidate();
            this.repaint();
        }
    }

    @CheckForNull
    private Pair<String, JComponent> listActionFor(KeyEvent ev) {
        InputMap map = this.matchesList.getInputMap();
        Object object = map.get(KeyStroke.getKeyStrokeForEvent(ev));
        if (object instanceof String) {
            String str = (String)object;
            return Pair.of((Object)str, this.matchesList);
        }
        map = this.matchesScrollPane1.getInputMap(1);
        object = map.get(KeyStroke.getKeyStrokeForEvent(ev));
        if (object instanceof String) {
            String str = (String)object;
            return Pair.of((Object)str, (Object)this.matchesScrollPane1);
        }
        return null;
    }

    private boolean boundScrollingKey(KeyEvent ev) {
        Pair<String, JComponent> p = this.listActionFor(ev);
        if (p == null) {
            return false;
        }
        String action = (String)p.first();
        return "selectPreviousRow".equals(action) || "selectNextRow".equals(action) || "selectPreviousRowExtendSelection".equals(action) || "selectNextRowExtendSelection".equals(action) || "scrollUp".equals(action) || "scrollDown".equals(action);
    }

    private void delegateScrollingKey(KeyEvent ev) {
        Pair<String, JComponent> p = this.listActionFor(ev);
        if (p == null) {
            return;
        }
        String action = (String)p.first();
        JComponent target = (JComponent)p.second();
        if ("selectNextRow".equals(action) && this.matchesList.getSelectedIndex() == this.matchesList.getModel().getSize() - 1) {
            this.matchesList.setSelectedIndex(0);
            this.matchesList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(action) && this.matchesList.getSelectedIndex() == 0) {
            int last = this.matchesList.getModel().getSize() - 1;
            this.matchesList.setSelectedIndex(last);
            this.matchesList.ensureIndexIsVisible(last);
            return;
        }
        Action a = target.getActionMap().get(action);
        if (a != null) {
            a.actionPerformed(new ActionEvent(target, 0, action));
        }
    }

    public static interface ContentProvider {
        @NonNull
        public ItemRenderer<TypeDescriptor> getListCellRenderer(@NonNull JList<TypeDescriptor> var1, @NonNull ButtonModel var2);

        public boolean setListModel(GoToPanel var1, String var2);

        public void closeDialog();

        public boolean hasValidContent();
    }

    private static class PatternListener
    implements DocumentListener,
    ItemListener,
    ListSelectionListener {
        private final GoToPanel dialog;

        PatternListener(GoToPanel dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.dialog.pastedFromClipboard) {
                this.dialog.pastedFromClipboard = false;
            } else {
                this.update();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            UiOptions.GoToTypeDialog.setCaseSensitive(this.dialog.isCaseSensitive());
            boolean restart = false;
            if (GoToSettings.getDefault().isSortingPreferOpenProjects() != this.dialog.isPreferOpenProjects()) {
                GoToSettings.getDefault().setSortingPreferOpenProjects(this.dialog.isPreferOpenProjects());
                restart = true;
            }
            this.update(restart);
        }

        @Override
        public void valueChanged(@NonNull ListSelectionEvent ev) {
            TypeDescriptor selected = this.dialog.matchesList.getSelectedValue();
            if (selected != null) {
                this.dialog.jTextFieldLocation.setText(selected.getFileDisplayPath());
            } else {
                this.dialog.jTextFieldLocation.setText("");
            }
        }

        private void update() {
            this.update(false);
        }

        private void update(boolean restart) {
            this.dialog.time = System.currentTimeMillis();
            String text = this.dialog.getText();
            if (restart) {
                this.dialog.contentProvider.setListModel(this.dialog, null);
            }
            if (this.dialog.contentProvider.setListModel(this.dialog, text)) {
                this.dialog.updateMessage(NbBundle.getMessage(GoToPanel.class, (String)"TXT_Searching"));
            }
        }
    }
}

