/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Color;
import java.awt.Component;
import java.io.CharConversionException;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

public final class UIUtilities {
    private static final String TEST_JAVA_MIME_TYPE = "test_text/x-java";
    public static final EnumSet allowedElementKinds = EnumSet.of(ElementKind.PACKAGE, new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.RECORD, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.INSTANCE_INIT, ElementKind.STATIC_INIT, ElementKind.FIELD, ElementKind.ENUM_CONSTANT, ElementKind.TYPE_PARAMETER});
    private static final String TYPE_COLOR = "#707070";
    private static final String INHERITED_COLOR = "#7D694A";

    private UIUtilities() {
    }

    public static String getColumnName(String name) {
        return name == null || name.length() == 0 ? " " : name;
    }

    public static void initColumnWidth(JTable table, int index, Object longValue, int padding) {
        TableColumn column = table.getColumnModel().getColumn(index);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        comp = table.getDefaultRenderer(table.getModel().getColumnClass(index)).getTableCellRendererComponent(table, longValue, false, false, 0, index);
        width = Math.max(width, comp.getPreferredSize().width) + 2 * padding;
        column.setPreferredWidth(width);
        if (longValue instanceof Boolean) {
            column.setMaxWidth(width);
        }
    }

    public static String getHtml(String text) {
        StringBuilder buf = new StringBuilder();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)JavaTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)TEST_JAVA_MIME_TYPE));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = ((JavaTokenId)token.id()).primaryCategory();
            if (category == null) {
                category = "whitespace";
            }
            AttributeSet set = settings.getTokenFontColors(category);
            buf.append(UIUtilities.color(UIUtilities.htmlize(token.text().toString()), set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuffer buf = new StringBuffer(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + UIUtilities.getHTMLColor(LFCustoms.getForeground((AttributeSet)set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        Object colorR = "0" + Integer.toHexString(c.getRed());
        colorR = ((String)colorR).substring(((String)colorR).length() - 2);
        Object colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = ((String)colorG).substring(((String)colorG).length() - 2);
        Object colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = ((String)colorB).substring(((String)colorB).length() - 2);
        String html_color = "#" + (String)colorR + (String)colorG + (String)colorB;
        return html_color;
    }

    public static String htmlize(String input) {
        String temp = input.replace("<", "&lt;");
        temp = temp.replace(">", "&gt;");
        return temp;
    }

    static String format(Element element) {
        return UIUtilities.format(element, false, false);
    }

    static String format(Element element, boolean forSignature, boolean FQNs) {
        StringBuilder stringBuilder = new StringBuilder();
        UIUtilities.format(element, stringBuilder, forSignature, FQNs);
        return stringBuilder.toString();
    }

    static void format(Element element, StringBuilder stringBuilder, boolean forSignature, boolean FQNs) {
        if (element == null) {
            return;
        }
        boolean first = true;
        Set<javax.lang.model.element.Modifier> modifiers = element.getModifiers();
        switch (element.getKind()) {
            case PACKAGE: {
                PackageElement packageElement = (PackageElement)element;
                if (forSignature) {
                    stringBuilder.append("package ");
                }
                stringBuilder.append(packageElement.getQualifiedName());
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case RECORD: {
                if (forSignature) {
                    stringBuilder.append(UIUtilities.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                }
                if (forSignature) {
                    switch (element.getKind()) {
                        case CLASS: {
                            stringBuilder.append("class ");
                            break;
                        }
                        case INTERFACE: {
                            stringBuilder.append("interface ");
                            break;
                        }
                        case ENUM: {
                            stringBuilder.append("enum ");
                            break;
                        }
                        case ANNOTATION_TYPE: {
                            stringBuilder.append("@interface ");
                        }
                    }
                }
                TypeElement typeElement = (TypeElement)element;
                stringBuilder.append(FQNs ? typeElement.getQualifiedName().toString() : typeElement.getSimpleName().toString());
                UIUtilities.formatTypeParameters(typeElement.getTypeParameters(), stringBuilder, FQNs);
                break;
            }
            case CONSTRUCTOR: {
                if (forSignature) {
                    stringBuilder.append(UIUtilities.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                }
                ExecutableElement constructorElement = (ExecutableElement)element;
                stringBuilder.append(constructorElement.getEnclosingElement().getSimpleName().toString());
                stringBuilder.append("(");
                UIUtilities.formatVariableElements(constructorElement.getParameters(), constructorElement.isVarArgs(), stringBuilder, FQNs);
                stringBuilder.append(")");
                List<? extends TypeMirror> thrownTypesMirrors = constructorElement.getThrownTypes();
                if (thrownTypesMirrors.isEmpty()) break;
                stringBuilder.append(" throws ");
                UIUtilities.formatTypeMirrors(thrownTypesMirrors, stringBuilder, FQNs);
                break;
            }
            case METHOD: {
                ExecutableElement methodElement = (ExecutableElement)element;
                TypeMirror returnTypeMirror = methodElement.getReturnType();
                List<? extends TypeParameterElement> typeParameters = methodElement.getTypeParameters();
                if (forSignature) {
                    stringBuilder.append(UIUtilities.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    if (typeParameters != null && typeParameters.size() > 0) {
                        UIUtilities.formatTypeParameters(typeParameters, stringBuilder, FQNs);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" ");
                        }
                    }
                    UIUtilities.formatTypeMirror(returnTypeMirror, stringBuilder, FQNs);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(methodElement.getSimpleName().toString());
                stringBuilder.append("(");
                UIUtilities.formatVariableElements(methodElement.getParameters(), methodElement.isVarArgs(), stringBuilder, FQNs);
                stringBuilder.append(")");
                List<? extends TypeMirror> thrownTypesMirrorsByMethod = methodElement.getThrownTypes();
                if (!thrownTypesMirrorsByMethod.isEmpty()) {
                    stringBuilder.append(" throws ");
                    UIUtilities.formatTypeMirrors(thrownTypesMirrorsByMethod, stringBuilder, FQNs);
                }
                if (forSignature) {
                    Object annotationValueValue;
                    AnnotationValue annotationValue = methodElement.getDefaultValue();
                    if (annotationValue == null || (annotationValueValue = annotationValue.getValue()) == null) break;
                    stringBuilder.append(" default ");
                    if (annotationValueValue instanceof String) {
                        stringBuilder.append("\"");
                    } else if (annotationValueValue instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(annotationValueValue));
                    if (annotationValueValue instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(annotationValueValue instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                UIUtilities.formatTypeMirror(returnTypeMirror, stringBuilder, FQNs);
                if (typeParameters == null || typeParameters.size() <= 0) break;
                stringBuilder.append(":");
                UIUtilities.formatTypeParameters(typeParameters, stringBuilder, FQNs);
                break;
            }
            case TYPE_PARAMETER: {
                TypeParameterElement typeParameterElement = (TypeParameterElement)element;
                stringBuilder.append(typeParameterElement.getSimpleName());
                List<? extends TypeMirror> bounds = null;
                try {
                    bounds = typeParameterElement.getBounds();
                    if (bounds == null || bounds.size() <= 0 || bounds.size() == 1 && "java.lang.Object".equals(bounds.get(0).toString())) break;
                    stringBuilder.append(" extends ");
                    first = true;
                    for (TypeMirror typeMirror : bounds) {
                        if (first) {
                            first = false;
                        } else {
                            stringBuilder.append(" & ");
                        }
                        UIUtilities.formatTypeMirror(typeMirror, stringBuilder, FQNs);
                    }
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    break;
                }
            }
            case FIELD: {
                VariableElement fieldElement = (VariableElement)element;
                if (forSignature) {
                    stringBuilder.append(UIUtilities.toString(modifiers));
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    UIUtilities.formatTypeMirror(fieldElement.asType(), stringBuilder, FQNs);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(fieldElement.getSimpleName().toString());
                if (forSignature) {
                    Object object = fieldElement.getConstantValue();
                    if (object == null) break;
                    stringBuilder.append(" = ");
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                    } else if (object instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(object));
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(object instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                UIUtilities.formatTypeMirror(fieldElement.asType(), stringBuilder, FQNs);
                break;
            }
            case ENUM_CONSTANT: {
                stringBuilder.append(element.toString());
                break;
            }
            case PARAMETER: 
            case LOCAL_VARIABLE: {
                VariableElement variableElement = (VariableElement)element;
                UIUtilities.formatTypeMirror(variableElement.asType(), stringBuilder, FQNs);
                stringBuilder.append(" ");
                stringBuilder.append(element.getSimpleName().toString());
            }
        }
    }

    static void formatTypeMirror(TypeMirror typeMirror, StringBuilder stringBuilder, boolean FQNs) {
        if (typeMirror == null) {
            return;
        }
        boolean first = true;
        switch (typeMirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                stringBuilder.append(typeMirror);
                break;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                stringBuilder.append(typeVariable.asElement().getSimpleName().toString());
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                stringBuilder.append("?");
                if (wildcardType.getExtendsBound() != null) {
                    stringBuilder.append(" extends ");
                    UIUtilities.formatTypeMirror(wildcardType.getExtendsBound(), stringBuilder, FQNs);
                }
                if (wildcardType.getSuperBound() == null) break;
                stringBuilder.append(" super ");
                UIUtilities.formatTypeMirror(wildcardType.getSuperBound(), stringBuilder, FQNs);
                break;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                Element element = declaredType.asElement();
                if (element instanceof TypeElement) {
                    stringBuilder.append(FQNs ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
                } else {
                    stringBuilder.append(element.getSimpleName().toString());
                }
                List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
                if (typeArgs.isEmpty()) break;
                stringBuilder.append("<");
                UIUtilities.formatTypeMirrors(typeArgs, stringBuilder, FQNs);
                stringBuilder.append(">");
                break;
            }
            case ARRAY: {
                int dims = 0;
                while (typeMirror.getKind() == TypeKind.ARRAY) {
                    ++dims;
                    typeMirror = ((ArrayType)typeMirror).getComponentType();
                }
                UIUtilities.formatTypeMirror(typeMirror, stringBuilder, FQNs);
                for (int i = 0; i < dims; ++i) {
                    stringBuilder.append("[]");
                }
                break;
            }
        }
    }

    static void formatTypeParameters(List<? extends TypeParameterElement> typeParameters, StringBuilder stringBuilder, boolean FQNs) {
        if (typeParameters == null || typeParameters.size() == 0) {
            return;
        }
        boolean first = true;
        if (typeParameters.size() > 0) {
            stringBuilder.append("<");
            first = true;
            for (TypeParameterElement typeParameterElement : typeParameters) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                UIUtilities.format(typeParameterElement, stringBuilder, false, FQNs);
            }
            stringBuilder.append(">");
        }
    }

    static void formatVariableElements(List<? extends VariableElement> variableElements, boolean varArgs, StringBuilder stringBuilder, boolean FQNs) {
        if (variableElements == null || variableElements.size() == 0) {
            return;
        }
        boolean first = true;
        for (VariableElement variableElement : variableElements) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            UIUtilities.format(variableElement, stringBuilder, false, FQNs);
        }
        if (varArgs) {
            stringBuilder.append("...");
        }
    }

    static void formatTypeMirrors(List<? extends TypeMirror> thrownTypeMirros, StringBuilder stringBuilder, boolean FQNs) {
        if (thrownTypeMirros == null || thrownTypeMirros.size() == 0) {
            return;
        }
        boolean first = true;
        for (TypeMirror typeMirror : thrownTypeMirros) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            UIUtilities.formatTypeMirror(typeMirror, stringBuilder, FQNs);
        }
    }

    static int getIntModifiers(Set<javax.lang.model.element.Modifier> modifiers) {
        int intModifiers = 0;
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            intModifiers |= 0x400;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.FINAL)) {
            intModifiers |= 0x10;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.NATIVE)) {
            intModifiers |= 0x100;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PRIVATE)) {
            intModifiers |= 2;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PROTECTED)) {
            intModifiers |= 4;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            intModifiers |= 1;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            intModifiers |= 8;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.STRICTFP)) {
            intModifiers |= 0x800;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.SYNCHRONIZED)) {
            intModifiers |= 0x20;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.TRANSIENT)) {
            intModifiers |= 0x80;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.VOLATILE)) {
            intModifiers |= 0x40;
        }
        return intModifiers;
    }

    static String toString(Set<javax.lang.model.element.Modifier> modifiers) {
        return Modifier.toString(UIUtilities.getIntModifiers(modifiers));
    }

    static Set<javax.lang.model.element.Modifier> getModifiers(int intModifiers) {
        EnumSet<javax.lang.model.element.Modifier> modifiers = EnumSet.noneOf(javax.lang.model.element.Modifier.class);
        if ((intModifiers & 0x400) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.ABSTRACT);
        }
        if ((intModifiers & 0x10) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.FINAL);
        }
        if ((intModifiers & 0x100) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.NATIVE);
        }
        if ((intModifiers & 2) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.PRIVATE);
        }
        if ((intModifiers & 4) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.PROTECTED);
        }
        if ((intModifiers & 1) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        if ((intModifiers & 8) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.STATIC);
        }
        if ((intModifiers & 0x800) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.STRICTFP);
        }
        if ((intModifiers & 0x20) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.SYNCHRONIZED);
        }
        if ((intModifiers & 0x80) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.TRANSIENT);
        }
        if ((intModifiers & 0x40) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.VOLATILE);
        }
        return modifiers;
    }

    static String getClassName(String className) {
        return UIUtilities.getClassName(className, false);
    }

    static String getClassName(String className, boolean FQNs) {
        int lastDot;
        int firstLessThan = className.indexOf(60);
        if (firstLessThan != -1) {
            className = className.substring(0, firstLessThan);
        }
        if (!FQNs && (lastDot = className.lastIndexOf(46)) != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    static String getClassNameSansPackage(String className) {
        int lastDot;
        int firstLessThan = className.indexOf(60);
        if (firstLessThan != -1) {
            className = className.substring(0, firstLessThan);
        }
        if ((lastDot = className.lastIndexOf(46)) != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    static void firstRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            tree.setSelectionRow(0);
            UIUtilities.scrollTreeToSelectedRow(tree);
        }
    }

    static void previousRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            int selectedRow = tree.getSelectionModel().getMinSelectionRow();
            if (selectedRow == -1) {
                selectedRow = rowCount - 1;
            } else if (--selectedRow < 0) {
                selectedRow = rowCount - 1;
            }
            tree.setSelectionRow(selectedRow);
            UIUtilities.scrollTreeToSelectedRow(tree);
        }
    }

    static void nextRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            int selectedRow = tree.getSelectionModel().getMinSelectionRow();
            if (selectedRow == -1) {
                selectedRow = 0;
                tree.setSelectionRow(selectedRow);
            } else {
                ++selectedRow;
            }
            tree.setSelectionRow(selectedRow % rowCount);
            UIUtilities.scrollTreeToSelectedRow(tree);
        }
    }

    static void lastRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            tree.setSelectionRow(rowCount - 1);
            UIUtilities.scrollTreeToSelectedRow(tree);
        }
    }

    static void scrollTreeToSelectedRow(final JTree tree) {
        final int selectedRow = tree.getLeadSelectionRow();
        if (selectedRow >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tree.scrollRectToVisible(tree.getRowBounds(selectedRow));
                }
            });
        }
    }

    static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String createHeader(ExecutableElement e, boolean isDeprecated, boolean isInherited, boolean html, boolean isBold) {
        TypeMirror rt;
        StringBuilder sb = new StringBuilder();
        if (html) {
            if (isDeprecated) {
                sb.append("<s>");
            } else if (isBold) {
                sb.append("<b>");
            }
            if (isInherited) {
                sb.append("<font color=#7D694A>");
            }
        }
        Name name = e.getKind() == ElementKind.CONSTRUCTOR ? e.getEnclosingElement().getSimpleName() : e.getSimpleName();
        sb.append(UIUtilities.escape(name.toString()));
        if (html && isDeprecated) {
            sb.append("</s>");
        }
        sb.append("(");
        List<? extends VariableElement> params = e.getParameters();
        Iterator<? extends VariableElement> it = params.iterator();
        while (it.hasNext()) {
            VariableElement param = it.next();
            if (html) {
                sb.append("<font color=#707070>");
            }
            boolean vararg = !it.hasNext() && e.isVarArgs();
            sb.append(UIUtilities.printArg(param.asType(), vararg, html));
            if (html) {
                sb.append("</font>");
            }
            sb.append(" ");
            sb.append(UIUtilities.escape(param.getSimpleName().toString()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (html && !isDeprecated && isBold) {
            sb.append("</b>");
        }
        if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
            sb.append(" : ");
            if (html) {
                sb.append("<font color=#707070>");
            }
            sb.append(UIUtilities.print(e.getReturnType(), html));
            if (html) {
                sb.append("</font>");
            }
        }
        return sb.toString();
    }

    public static String createHeader(VariableElement e, boolean isDeprecated, boolean isInherited, boolean html, boolean isBold) {
        StringBuilder sb = new StringBuilder();
        if (html) {
            if (isDeprecated) {
                sb.append("<s>");
            } else if (isBold) {
                sb.append("<b>");
            }
            if (isInherited) {
                sb.append("<font color=#7D694A>");
            }
        }
        sb.append(UIUtilities.escape(e.getSimpleName().toString()));
        if (html) {
            if (isDeprecated) {
                sb.append("</s>");
            } else if (isBold) {
                sb.append("</b>");
            }
        }
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            if (html) {
                sb.append("<font color=#707070>");
            }
            sb.append(UIUtilities.print(e.asType(), html));
            if (html) {
                sb.append("</font>");
            }
        }
        return sb.toString();
    }

    public static String createHeader(TypeParameterElement e, boolean isDeprecated, boolean isInherited, boolean html, boolean isBold) {
        StringBuilder sb = new StringBuilder();
        if (html) {
            if (isDeprecated) {
                sb.append("<s>");
            } else if (isBold) {
                sb.append("<b>");
            }
            if (isInherited) {
                sb.append("<font color=#7D694A>");
            }
        }
        sb.append(UIUtilities.escape(e.getSimpleName().toString()));
        if (html) {
            if (isDeprecated) {
                sb.append("</s>");
            } else if (isBold) {
                sb.append("</b>");
            }
        }
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            if (html) {
                sb.append("<font color=#707070>");
            }
            sb.append(UIUtilities.print(e.asType(), html));
            if (html) {
                sb.append("</font>");
            }
        }
        return sb.toString();
    }

    public static String createHeader(PackageElement e, boolean isDeprecated, boolean isInherited, boolean html, boolean isBold) {
        StringBuilder sb = new StringBuilder();
        if (html) {
            if (isDeprecated) {
                sb.append("<s>");
            } else if (isBold) {
                sb.append("<b>");
            }
            if (isInherited) {
                sb.append("<font color=#7D694A>");
            }
        }
        sb.append(UIUtilities.escape(e.getSimpleName().toString()));
        if (html) {
            if (isDeprecated) {
                sb.append("</s>");
            } else if (isBold) {
                sb.append("</b>");
            }
        }
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            if (html) {
                sb.append("<font color=#707070>");
            }
            sb.append(UIUtilities.print(e.asType(), html));
            if (html) {
                sb.append("</font>");
            }
        }
        return sb.toString();
    }

    public static String createHeader(TypeElement e, boolean isDeprecated, boolean isInherited, boolean html, boolean isBold) {
        List<? extends TypeParameterElement> typeParams;
        StringBuilder sb = new StringBuilder();
        if (html) {
            if (isDeprecated) {
                sb.append("<s>");
            } else if (isBold) {
                sb.append("<b>");
            }
            if (isInherited) {
                sb.append("<font color=#7D694A>");
            }
        }
        sb.append(UIUtilities.escape(e.getSimpleName().toString()));
        if (html && isDeprecated) {
            sb.append("</s>");
        }
        if ((typeParams = e.getTypeParameters()) != null && !typeParams.isEmpty()) {
            sb.append(html ? "&lt;" : "<");
            Iterator<? extends TypeParameterElement> it = typeParams.iterator();
            while (it.hasNext()) {
                TypeParameterElement tp = it.next();
                sb.append(UIUtilities.escape(tp.getSimpleName().toString()));
                List<? extends TypeMirror> bounds = null;
                try {
                    bounds = tp.getBounds();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (bounds != null && !bounds.isEmpty()) {
                    sb.append(UIUtilities.printBounds(bounds, html));
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(html ? "&gt;" : ">");
        }
        if (html && !isDeprecated && isBold) {
            sb.append("<b>");
        }
        TypeMirror sc = e.getSuperclass();
        String scName = UIUtilities.print(sc, html);
        if (sc == null || e.getKind() == ElementKind.ENUM || e.getKind() == ElementKind.ANNOTATION_TYPE || "java.lang.Object".equals(sc.toString()) || "<none>".equals(sc.toString())) {
            scName = null;
        }
        List<? extends TypeMirror> ifaces = e.getInterfaces();
        if (!(scName == null && ifaces.isEmpty() || e.getKind() == ElementKind.ANNOTATION_TYPE)) {
            sb.append(" :: ");
            if (scName != null) {
                if (html) {
                    sb.append("<font color=#707070>");
                }
                sb.append(scName);
                if (html) {
                    sb.append("</font>");
                }
            }
            if (!ifaces.isEmpty()) {
                if (scName != null) {
                    sb.append(" : ");
                }
                Iterator<? extends TypeMirror> it = ifaces.iterator();
                while (it.hasNext()) {
                    TypeMirror typeMirror = it.next();
                    if (html) {
                        sb.append("<font color=#707070>");
                    }
                    sb.append(UIUtilities.print(typeMirror, html));
                    if (html) {
                        sb.append("</font>");
                    }
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        return sb.toString();
    }

    public static boolean runWhenScanFinished(Runnable runnable, String actionName) {
        return ScanDialog.runWhenScanFinished(() -> {
            if (ParserManager.isParsing()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }, (String)actionName);
    }

    private static String printBounds(List<? extends TypeMirror> bounds, boolean html) {
        if (bounds.size() == 1 && "java.lang.Object".equals(bounds.get(0).toString())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" extends ");
        Iterator<? extends TypeMirror> it = bounds.iterator();
        while (it.hasNext()) {
            TypeMirror bound = it.next();
            sb.append(UIUtilities.print(bound, html));
            if (!it.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    private static String printArg(TypeMirror tm, boolean varArg, boolean html) {
        if (varArg) {
            if (tm.getKind() == TypeKind.ARRAY) {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(UIUtilities.print(at.getComponentType(), html));
                sb.append("...");
                return sb.toString();
            }
            assert (false) : "Expected array: " + tm.toString() + " ( " + tm.getKind() + " )";
        }
        return UIUtilities.print(tm, html);
    }

    private static String print(TypeMirror tm, boolean html) {
        switch (tm.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)tm;
                StringBuilder sb = new StringBuilder(dt.asElement().getSimpleName().toString());
                List<? extends TypeMirror> typeArgs = dt.getTypeArguments();
                if (!typeArgs.isEmpty()) {
                    sb.append(html ? "&lt;" : "<");
                    Iterator<? extends TypeMirror> it = typeArgs.iterator();
                    while (it.hasNext()) {
                        TypeMirror ta = it.next();
                        sb.append(UIUtilities.print(ta, html));
                        if (!it.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(html ? "&gt;" : ">");
                }
                return sb.toString();
            }
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)tm;
                StringBuilder sb = new StringBuilder(tv.asElement().getSimpleName().toString());
                return sb.toString();
            }
            case ARRAY: {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(UIUtilities.print(at.getComponentType(), html));
                sb.append("[]");
                return sb.toString();
            }
            case WILDCARD: {
                WildcardType wt = (WildcardType)tm;
                StringBuilder sb = new StringBuilder("?");
                if (wt.getExtendsBound() != null) {
                    sb.append(" extends ");
                    sb.append(UIUtilities.print(wt.getExtendsBound(), html));
                }
                if (wt.getSuperBound() != null) {
                    sb.append(" super ");
                    sb.append(UIUtilities.print(wt.getSuperBound(), html));
                }
                return sb.toString();
            }
        }
        return UIUtilities.escape(tm.toString());
    }

    public static class BooleanTableCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer checkbox;
        private final TableCellRenderer label;

        public BooleanTableCellRenderer(JTable jt) {
            this(jt.getDefaultRenderer(String.class), jt.getDefaultRenderer(Boolean.class));
        }

        private BooleanTableCellRenderer(TableCellRenderer label, TableCellRenderer checkbox) {
            this.checkbox = checkbox;
            this.label = label;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer rend = value == null || !table.getModel().isCellEditable(row, column) ? this.label : this.checkbox;
            value = value != null && rend == this.label ? null : value;
            Component comp = rend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return comp;
        }
    }

    public static class JavaElementListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, this.extractText(value), index, isSelected, cellHasFocus);
            if (value instanceof MemberInfo) {
                Icon i = ((MemberInfo)value).getIcon();
                this.setIcon(i);
            }
            return this;
        }

        protected String extractText(Object value) {
            if (value instanceof MemberInfo) {
                return ((MemberInfo)value).getHtmlText();
            }
            return value.toString();
        }
    }

    public static class JavaElementTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, this.extractText(value), isSelected, hasFocus, row, column);
            if (value instanceof MemberInfo) {
                Icon i = ((MemberInfo)value).getIcon();
                this.setIcon(i);
            } else {
                this.setIcon(null);
            }
            return this;
        }

        protected String extractText(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof MemberInfo) {
                return ((MemberInfo)value).getHtmlText();
            }
            return value.toString();
        }
    }
}

