/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.crypto.dsig.keyinfo;

import com.sun.xml.security.core.dsig.KeyValueType;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.DSAKeyValue;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.RSAKeyValue;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="KeyValue", namespace="http://www.w3.org/2000/09/xmldsig#")
public class KeyValue
extends KeyValueType
implements javax.xml.crypto.dsig.keyinfo.KeyValue {
    @Override
    public PublicKey getPublicKey() throws KeyException {
        Object publicKey = null;
        for (Object o : this.content) {
            if (o instanceof DSAKeyValue) {
                DSAKeyValue dsaKeyValue = (DSAKeyValue)o;
                DSAPublicKeySpec spec = new DSAPublicKeySpec(new BigInteger(dsaKeyValue.getY()), new BigInteger(dsaKeyValue.getP()), new BigInteger(dsaKeyValue.getQ()), new BigInteger(dsaKeyValue.getG()));
                try {
                    KeyFactory fac = KeyFactory.getInstance("DSA");
                    return fac.generatePublic(spec);
                }
                catch (Exception ex) {
                    throw new KeyException(ex);
                }
            }
            if (!(o instanceof RSAKeyValue)) continue;
            RSAKeyValue rsaKayValue = (RSAKeyValue)o;
            RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(rsaKayValue.getModulus()), new BigInteger(rsaKayValue.getExponent()));
            try {
                KeyFactory fac = KeyFactory.getInstance("RSA");
                return fac.generatePublic(spec);
            }
            catch (Exception ex) {
                throw new KeyException(ex);
            }
        }
        return null;
    }

    @Override
    public boolean isFeatureSupported(String string2) {
        return false;
    }

    public void setContent(List<Object> content) {
        this.content = content;
    }
}

