/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryEntryImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;

public class ClassificationSchemeImpl
extends RegistryEntryImpl
implements ClassificationScheme,
Serializable {
    transient boolean childrenLoaded = false;
    transient boolean isPredefined = false;
    ArrayList children = new ArrayList();

    public ClassificationSchemeImpl() {
    }

    public ClassificationSchemeImpl(Key key) {
        this();
        this.key = key;
    }

    public ClassificationSchemeImpl(Concept concept) throws JAXRException {
        this(concept.getKey());
        this.name = concept.getName();
        this.description = concept.getDescription();
    }

    public ClassificationSchemeImpl(Key key, String description, String name) {
        this(key);
        this.description = new InternationalStringImpl(description);
        this.name = new InternationalStringImpl(name);
    }

    public ClassificationSchemeImpl(String key, String description, String name) {
        this(new KeyImpl(key), description, name);
    }

    public ClassificationSchemeImpl(String name, String description) {
        this();
        this.name = new InternationalStringImpl(name);
        this.description = new InternationalStringImpl(description);
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        if (concept != null && !this.children.contains(concept)) {
            ((ConceptImpl)concept).setClassificationScheme(this);
            this.children.add(concept);
            this.childrenLoaded = true;
            this.setIsModified(true);
        }
    }

    public void addChildConcepts(Collection concepts) throws JAXRException {
        if (concepts == null) {
            return;
        }
        Iterator iter = concepts.iterator();
        try {
            while (iter.hasNext()) {
                ConceptImpl concept = (ConceptImpl)iter.next();
                this.addChildConcept(concept);
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Objects_in_collection_must_be_Concepts"), (Throwable)e);
        }
    }

    public void removeChildConcept(Concept concept) throws JAXRException {
        if (concept != null) {
            this.children.remove(concept);
            this.setIsModified(true);
        }
    }

    public void removeChildConcepts(Collection concepts) throws JAXRException {
        if (concepts != null) {
            this.children.removeAll(concepts);
            this.setIsModified(true);
        }
    }

    public int getChildConceptCount() throws JAXRException {
        return this.children.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return (Collection)this.children.clone();
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList descendants = new ArrayList(this.children);
        for (Concept child : this.children) {
            if (child.getChildConceptCount() <= 0) continue;
            descendants.addAll(child.getDescendantConcepts());
        }
        return descendants;
    }

    public boolean isExternal() {
        return this.children.size() == 0;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public void setPredefined(boolean predefined) {
        this.isPredefined = predefined;
    }

    public boolean childrenLoaded() {
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(boolean loaded) {
        this.childrenLoaded = loaded;
    }

    @Override
    public void addExternalLink(ExternalLink link) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (link != null) {
            ExternalLinkImpl externalLink = (ExternalLinkImpl)link;
            externalLink.addLinkedObject(this);
            this.externalLinks.add(externalLink);
            this.setIsModified(true);
        }
    }

    @Override
    public void addExternalLinks(Collection links) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (links != null) {
            if (links.size() > 1) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Cannot_add_more_than_one_ExternalLink"));
            }
            Iterator iter = links.iterator();
            try {
                while (iter.hasNext()) {
                    ExternalLinkImpl externalLink = (ExternalLinkImpl)iter.next();
                    externalLink.addLinkedObject(this);
                    this.externalLinks.add(externalLink);
                    this.setIsModified(true);
                }
            }
            catch (ClassCastException e) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Objects_in_collection_must_be_ExternalLinks"), (Throwable)e);
            }
        }
    }

    @Override
    public void setExternalLinks(Collection links) throws JAXRException {
        if (links == null) {
            this.externalLinks.clear();
            return;
        }
        if (links.size() > 1) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ClassificationSchemeImpl:Cannot_set_more_than_one_ExternalLink."));
        }
        this.externalLinks.clear();
        this.addExternalLinks(links);
    }

    public int getValueType() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setValueType(int valueType) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

