/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.editors.FormatSelector;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AbstractFormatterFactoryEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
PropertyChangeListener,
FormAwareEditor {
    private FormatSelector selector;
    private FormProperty property;
    private static final String PRE_MASK_CODE = "try {";
    private static final String POST_MASK_CODE = "} catch (java.text.ParseException ex) {\nex.printStackTrace();\n}";
    private static final String XML_FORMAT = "Format";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SUBTYPE = "subtype";
    private static final String ATTR_FORMAT = "format";

    @Override
    public Component getCustomEditor() {
        Object value;
        if (this.selector == null) {
            this.selector = new FormatSelector();
            this.selector.addPropertyChangeListener(this);
        }
        if ((value = this.getValue()) instanceof FormFormatter) {
            FormFormatter formatter = (FormFormatter)value;
            this.selector.setFormat(formatter.getFormat());
        } else {
            this.selector.setFormat(new FormatSelector.FormatInfo(0, 0, null));
            this.propertyChange(null);
        }
        return this.selector.getSelectorPanel();
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (!(value instanceof FormFormatter)) {
            return super.getJavaInitializationString();
        }
        FormFormatter formatter = (FormFormatter)value;
        FormatSelector.FormatInfo formatInfo = formatter.getFormat();
        int type = formatInfo.getType();
        int subtype = formatInfo.getSubtype();
        Object format = formatInfo.getFormat();
        if (format != null) {
            format = "\"" + ((String)format).replace("\"", "\\\"") + "\"";
        }
        Object code = null;
        if (type == 5) {
            code = "new javax.swing.text.MaskFormatter(" + (String)format + ")";
        } else if (type == 1) {
            switch (subtype) {
                case -1: {
                    code = "new java.text.SimpleDateFormat(" + (String)format + ")";
                    break;
                }
                case 0: {
                    code = "";
                    break;
                }
                case 1: {
                    code = "java.text.DateFormat.getDateInstance(java.text.DateFormat.SHORT)";
                    break;
                }
                case 2: {
                    code = "java.text.DateFormat.getDateInstance(java.text.DateFormat.MEDIUM)";
                    break;
                }
                case 3: {
                    code = "java.text.DateFormat.getDateInstance(java.text.DateFormat.LONG)";
                    break;
                }
                case 4: {
                    code = "java.text.DateFormat.getDateInstance(java.text.DateFormat.FULL)";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            code = "new javax.swing.text.DateFormatter(" + (String)code + ")";
        } else if (type == 2) {
            switch (subtype) {
                case -1: {
                    code = "new java.text.SimpleDateFormat(" + (String)format + ")";
                    break;
                }
                case 0: {
                    code = "java.text.DateFormat.getTimeInstance()";
                    break;
                }
                case 1: {
                    code = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.SHORT)";
                    break;
                }
                case 2: {
                    code = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.MEDIUM)";
                    break;
                }
                case 3: {
                    code = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.LONG)";
                    break;
                }
                case 4: {
                    code = "java.text.DateFormat.getTimeInstance(java.text.DateFormat.FULL)";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            code = "new javax.swing.text.DateFormatter(" + (String)code + ")";
        } else if (type == 0) {
            switch (subtype) {
                case -1: {
                    code = "new java.text.DecimalFormat(" + (String)format + ")";
                    break;
                }
                case 0: {
                    code = "";
                    break;
                }
                case 1: {
                    code = "java.text.NumberFormat.getIntegerInstance()";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            code = "new javax.swing.text.NumberFormatter(" + (String)code + ")";
        } else if (type == 3) {
            code = subtype == 0 ? "java.text.NumberFormat.getPercentInstance()" : "new java.text.DecimalFormat(" + (String)format + ")";
            code = "new javax.swing.text.NumberFormatter(" + (String)code + ")";
        } else if (type == 4) {
            code = subtype == 0 ? "java.text.NumberFormat.getCurrencyInstance()" : "new java.text.DecimalFormat(" + (String)format + ")";
            code = "new javax.swing.text.NumberFormatter(" + (String)code + ")";
        }
        return "new javax.swing.text.DefaultFormatterFactory(" + (String)code + ")";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        String msg = NbBundle.getMessage(AbstractFormatterFactoryEditor.class, (String)"MSG_AbstractFormatterFactory");
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setValue(new FormFormatter(this.selector.getFormat()));
    }

    @Override
    public void setValue(Object value) {
        this.updatePrePostCode(value, this.getValue());
        super.setValue(value);
    }

    private void updatePrePostCode(Object newValue, Object oldValue) {
        if (newValue instanceof FormFormatter && ((FormFormatter)newValue).getFormat().getType() == 5) {
            this.property.setPreCode(PRE_MASK_CODE);
            this.property.setPostCode(POST_MASK_CODE);
        } else if (oldValue instanceof FormFormatter && ((FormFormatter)oldValue).getFormat().getType() == 5 || this.property.getPostCode() != null && this.property.getPreCode().trim().equals(PRE_MASK_CODE)) {
            this.property.setPreCode(null);
            this.property.setPostCode(null);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    public void readFromXML(Node element) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        String typeTxt = attributes.getNamedItem(ATTR_TYPE).getNodeValue();
        String subtypeTxt = attributes.getNamedItem(ATTR_SUBTYPE).getNodeValue();
        String format = null;
        Node node = attributes.getNamedItem(ATTR_FORMAT);
        if (node != null) {
            format = node.getNodeValue();
        }
        int type = Integer.parseInt(typeTxt);
        int subtype = Integer.parseInt(subtypeTxt);
        this.setValue(new FormFormatter(new FormatSelector.FormatInfo(type, subtype, format)));
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_FORMAT);
        Object value = this.getValue();
        FormFormatter formatter = (FormFormatter)value;
        FormatSelector.FormatInfo format = formatter.getFormat();
        el.setAttribute(ATTR_TYPE, "" + format.getType());
        el.setAttribute(ATTR_SUBTYPE, "" + format.getSubtype());
        if (format.isCustomizable()) {
            el.setAttribute(ATTR_FORMAT, format.getFormat());
        }
        return el;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_AbstractFormatterFactoryEditor_DisplayName");
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.property = property;
    }

    @Override
    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    static class FormFormatter
    extends FormDesignValueAdapter {
        private FormatSelector.FormatInfo format;

        FormFormatter(FormatSelector.FormatInfo format) {
            this.format = format;
        }

        public FormatSelector.FormatInfo getFormat() {
            return this.format;
        }

        @Override
        public Object getDesignValue() {
            DefaultFormatter value = null;
            int type = this.format.getType();
            if (type == 5) {
                try {
                    value = new MaskFormatter(this.format.getFormat());
                }
                catch (ParseException pex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, pex.getMessage(), pex);
                    value = new MaskFormatter();
                }
            } else if (type == 1) {
                DateFormat dateFormat = null;
                switch (this.format.getSubtype()) {
                    case -1: {
                        dateFormat = new SimpleDateFormat(this.format.getFormat());
                        break;
                    }
                    case 0: {
                        dateFormat = DateFormat.getDateInstance();
                        break;
                    }
                    case 1: {
                        dateFormat = DateFormat.getDateInstance(3);
                        break;
                    }
                    case 2: {
                        dateFormat = DateFormat.getDateInstance(2);
                        break;
                    }
                    case 3: {
                        dateFormat = DateFormat.getDateInstance(1);
                        break;
                    }
                    case 4: {
                        dateFormat = DateFormat.getDateInstance(0);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                value = new DateFormatter(dateFormat);
            } else if (type == 2) {
                DateFormat timeFormat = null;
                switch (this.format.getSubtype()) {
                    case -1: {
                        timeFormat = new SimpleDateFormat(this.format.getFormat());
                        break;
                    }
                    case 0: {
                        timeFormat = DateFormat.getTimeInstance();
                        break;
                    }
                    case 1: {
                        timeFormat = DateFormat.getTimeInstance(3);
                        break;
                    }
                    case 2: {
                        timeFormat = DateFormat.getTimeInstance(2);
                        break;
                    }
                    case 3: {
                        timeFormat = DateFormat.getTimeInstance(1);
                        break;
                    }
                    case 4: {
                        timeFormat = DateFormat.getTimeInstance(0);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                value = new DateFormatter(timeFormat);
            } else if (type == 0) {
                NumberFormat numberFormat = null;
                switch (this.format.getSubtype()) {
                    case -1: {
                        numberFormat = new DecimalFormat(this.format.getFormat());
                        break;
                    }
                    case 0: {
                        numberFormat = NumberFormat.getInstance();
                        break;
                    }
                    case 1: {
                        numberFormat = NumberFormat.getIntegerInstance();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                value = new NumberFormatter(numberFormat);
            } else if (type == 3) {
                NumberFormat percentFormat = this.format.getSubtype() == 0 ? NumberFormat.getPercentInstance() : new DecimalFormat(this.format.getFormat());
                value = new NumberFormatter(percentFormat);
            } else if (type == 4) {
                NumberFormat currencyFormat = this.format.getSubtype() == 0 ? NumberFormat.getCurrencyInstance() : new DecimalFormat(this.format.getFormat());
                value = new NumberFormatter(currencyFormat);
            } else assert (false);
            return new DefaultFormatterFactory(value);
        }

        @Override
        public Object copy(FormProperty targetFormProperty) {
            return new FormFormatter(this.format);
        }
    }
}

