/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.net.URLClassLoader;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.AbstractParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.openide.ErrorManager;

public class HolderTypeTreeNode
extends AbstractParameterTreeNode {
    private URLClassLoader urlClassLoader;

    public HolderTypeTreeNode(TypeNodeData userObject, URLClassLoader inClassLoader) {
        super(userObject);
        this.urlClassLoader = inClassLoader;
    }

    @Override
    public void updateValueFromChildren(TypeNodeData inData) {
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getChildAt(0);
        TypeNodeData childData = (TypeNodeData)childNode.getUserObject();
        Object holderValue = childData.getTypeValue();
        if (holderValue != null) {
            Object holder = ((TypeNodeData)this.getUserObject()).getTypeValue();
            try {
                ReflectionHelper.setHolderValue(holder, holderValue);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    @Override
    public void updateChildren() {
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getChildAt(0);
        TypeNodeData childData = (TypeNodeData)childNode.getUserObject();
        Object heldValue = null;
        Object userObject = this.getUserObject();
        if (null != userObject) {
            Object holder = ((TypeNodeData)userObject).getTypeValue();
            try {
                heldValue = ReflectionHelper.getHolderValue(holder);
            }
            catch (Exception wsfe) {
                Throwable cause = wsfe.getCause();
                ErrorManager.getDefault().notify(cause);
                ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to get the held value on Holder: " + ((TypeNodeData)userObject).getRealTypeName() + "WebServiceReflectionException=" + cause);
            }
            childData.setTypeValue(heldValue);
            childNode.setUserObject(childData);
            if (childNode instanceof ParameterTreeNode) {
                ((ParameterTreeNode)((Object)childNode)).updateChildren();
            }
        }
    }
}

