/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.CompilerTask;
import org.netbeans.modules.websvc.core.jaxws.actions.DispatchClientMethodGenerator;
import org.netbeans.modules.websvc.core.jaxws.actions.DispatchCompilerTask;
import org.netbeans.modules.websvc.core.jaxws.actions.InsertTask;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsClientMethodGenerator;
import org.netbeans.modules.websvc.core.jaxws.actions.PolicyManager;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.OperationNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JaxWsCodeGenerator {
    private static final String POLICY_MANAGER = "policyManager";
    private static final JaxWsCodeGenerator INSTANCE = new JaxWsCodeGenerator();
    private static final List IMPLICIT_JSP_OBJECTS = Arrays.asList("request", "response", "session", "out", "page", "config", "application", "pageContext");
    private static final String HINT_INIT_ARGUMENTS = " // TODO initialize WS operation arguments here\n";
    static final String JAVA_TRY = "\ntry '{' // Call Web Service Operation\n";
    static final String JAVA_SERVICE_DEF = "   {0} {7} = new {0}();\n";
    static final String JAVA_PORT_DEF = "   {1} port = {7}.{2}({9});\n";
    static final String JAVA_RESULT = "   {3}   // TODO process result here\n   {4} result = port.{5}({6});\n";
    static final String JAVA_VOID = "   {3}   port.{5}({6});\n";
    static final String JAVA_RESULT_1 = "   {3}   return port.{5}({6});\n";
    static final String JAVA_OUT = "   {8}.println(\"Result = \"+result);\n";
    static final String JAVA_CATCH = "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    static final String JAVA_STATIC_STUB_ASYNC_POLLING = "\ntry '{' // Call Web Service Operation(async. polling)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}   // TODO process asynchronous response here\n   {4} resp = port.{5}({6});\n   while(!resp.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+resp.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    static final String JAVA_STATIC_STUB_ASYNC_CALLBACK = "\ntry '{' // Call Web Service Operation(async. callback)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> response) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ response.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} result = port.{5}({6});\n   while(!result.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JSP_STATIC_STUB = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process result here\n\t{4} result = port.{5}({6});\n\tout.println(\"Result = \"+result);\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_VOID = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\tport.{5}({6});\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_POLLING = "    <%-- start web service invocation(async. polling) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} resp = port.{5}({6});\n\twhile(!resp.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+resp.get());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. polling) --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_CALLBACK = "    <%-- start web service invocation(async. callback) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} result = port.{5}({6});\n\twhile(!result.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+asyncHandler.getResponse());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. callback) --%><hr/>\n";
    private static final String JSP_CALLBACK_HANDLER = "<%!\nclass {0} implements javax.xml.ws.AsyncHandler<{1}> '{'\n    private {1} output;\n\n    public void handleResponse(javax.xml.ws.Response<{1}> response) '{'\n        try '{'\n            output = response.get();\n        '}' catch(Exception ex) '{'\n            // TODO handle exception\n        '}'\n    '}'\n\n    {1} getResponse() '{'\n         return output;\n    '}'\n'}'\n%>\n";
    private static final String QNAME = "\nQName portQName = new QName(\"{0}\" , \"{1}\"); ";
    private static final String JSP_DISPATCH = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\tjavax.xml.namespace.QName portQName = new javax.xml.namespace.QName(\"{1}\", \"{2}\");\n\tString req = \"{3}\";\n\tjavax.xml.ws.Dispatch<javax.xml.transform.Source> sourceDispatch = null;\n\tsourceDispatch = service.createDispatch(portQName, javax.xml.transform.Source.class, javax.xml.ws.Service.Mode.PAYLOAD);\n\tjavax.xml.transform.Source result = sourceDispatch.invoke(new javax.xml.transform.stream.StreamSource(new java.io.StringReader(req)));\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";

    public static void insertMethodCall(InvokeOperationCookie.TargetSourceType targetSourceType, DataObject dataObj, Lookup sourceNodeLookup) {
        Document document;
        int position;
        OperationNode opNode;
        block7: {
            EditorCookie cookie = (EditorCookie)dataObj.getCookie(EditorCookie.class);
            opNode = (OperationNode)((Object)sourceNodeLookup.lookup(OperationNode.class));
            boolean inJsp = InvokeOperationCookie.TargetSourceType.JSP == targetSourceType;
            Node portNode = opNode.getParentNode();
            Node serviceNode = portNode.getParentNode();
            JaxWsCodeGenerator.addProjectReference(serviceNode, dataObj);
            position = -1;
            if (inJsp) {
                document = cookie.getDocument();
                try {
                    String content = document.getText(0, document.getLength());
                    position = content.lastIndexOf("</body>");
                    if (position < 0) {
                        position = content.lastIndexOf("</html>");
                    }
                    if (position >= 0) {
                        while (position > 0 && content.charAt(position - 1) != '\n' && content.charAt(position - 1) != '\r') {
                            --position;
                        }
                        break block7;
                    }
                    position = document.getLength();
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            } else {
                EditorCookie ec = (EditorCookie)dataObj.getCookie(EditorCookie.class);
                JEditorPane pane = ec.getOpenedPanes()[0];
                document = pane.getDocument();
                position = pane.getCaretPosition();
            }
        }
        int pos = position;
        JaxWsCodeGenerator.insertMethod(document, pos, opNode);
    }

    private static void addProjectReference(Node serviceNode, DataObject dObj) {
        Node clientNode = serviceNode.getParentNode();
        FileObject srcRoot = (FileObject)clientNode.getLookup().lookup(FileObject.class);
        Project clientProject = FileOwnerQuery.getOwner((FileObject)srcRoot);
        if (dObj != null) {
            FileObject targetFo = dObj.getPrimaryFile();
            JaxWsUtils.addProjectReference(clientProject, targetFo);
        }
    }

    private static String resolveInitValue(String type, FileObject targetFile) {
        if ("int".equals(type)) {
            return "0;";
        }
        if ("long".equals(type)) {
            return "0L;";
        }
        if ("float".equals(type)) {
            return "0.0f;";
        }
        if ("double".equals(type)) {
            return "0.0d;";
        }
        if ("short".equals(type)) {
            return "(short)0;";
        }
        if ("byte".equals(type)) {
            return "(byte)0;";
        }
        if ("boolean".equals(type)) {
            return "false;";
        }
        if ("java.lang.String".equals(type)) {
            return "\"\";";
        }
        if ("java.lang.Integer".equals(type)) {
            return "Integer.valueOf(0);";
        }
        if ("java.lang.Long".equals(type)) {
            return "Long.valueOf(0L);";
        }
        if ("java.lang.Float".equals(type)) {
            return "Float.valueOf(0.0f);";
        }
        if ("java.lang.Double".equals(type)) {
            return "Double.valueOf(0.0d);";
        }
        if ("java.lang.Short".equals(type)) {
            return "Short.valueOf((short)0);";
        }
        if ("java.lang.Byte".equals(type)) {
            return "Byte.valueOf((byte)0);";
        }
        if ("java.lang.Boolean".equals(type)) {
            return "Boolean.FALSE;";
        }
        if (type.endsWith("CallbackHandler")) {
            return "new " + type + "();";
        }
        if (type.startsWith("javax.xml.ws.AsyncHandler")) {
            return "new " + type + "() {";
        }
        ResultHolder<String> result = new ResultHolder<String>("");
        JaxWsCodeGenerator.getInitValue(type, targetFile, result);
        String returnText = result.getResult();
        if (!returnText.equals("")) {
            return returnText;
        }
        return "null;";
    }

    private static void getInitValue(final String type, FileObject targetFile, final ResultHolder<String> result) {
        if (targetFile == null) {
            return;
        }
        JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFile);
        if (targetSource == null) {
            result.setResult("null;");
            return;
        }
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                if (!JaxWsCodeGenerator.isEnum(controller, type) && JaxWsCodeGenerator.hasNoArgConstructor(controller, type)) {
                    result.setResult("new " + type + "();");
                }
            }

            public void cancel() {
            }
        };
        try {
            targetSource.runUserActionTask((Task)task, true);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static boolean isEnum(CompilationController controller, String type) {
        TypeElement classEl = controller.getElements().getTypeElement(JaxWsCodeGenerator.getCanonicalClassName(type));
        if (classEl != null) {
            return classEl.getKind() == ElementKind.ENUM;
        }
        return false;
    }

    private static boolean hasNoArgConstructor(CompilationController controller, String type) {
        TypeElement classEl = controller.getElements().getTypeElement(JaxWsCodeGenerator.getCanonicalClassName(type));
        if (classEl != null) {
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(classEl.getEnclosedElements());
            for (ExecutableElement c : constructors) {
                if (c.getParameters().size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getCanonicalClassName(String genericClassName) {
        int index = genericClassName.indexOf("<");
        if (index != -1) {
            return genericClassName.substring(0, index);
        }
        return genericClassName;
    }

    private static String resolveResponseType(String argumentType) {
        int start = argumentType.indexOf("<");
        int end = argumentType.indexOf(">");
        if (start > 0 && end > 0 && start < end) {
            return argumentType.substring(start + 1, end);
        }
        return "javax.xml.ws.Response";
    }

    private static String pureJavaName(String javaNameWithPackage) {
        int index = javaNameWithPackage.lastIndexOf(".");
        return index >= 0 ? javaNameWithPackage.substring(index + 1) : javaNameWithPackage;
    }

    public static void insertMethod(final Document document, final int pos, final OperationNode operationNode) {
        WsdlOperation operation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JaxWsCodeGenerator.doInsertMethod(document, pos, operationNode);
            }
        };
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runnable, (String)NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"MSG_GenerateMethod", (Object)operation.getName()));
    }

    public static void doInsertMethod(Document document, int pos, OperationNode operationNode) {
        String relativePath;
        Node portNode = operationNode.getParentNode();
        Node serviceNode = portNode.getParentNode();
        Node wsdlNode = serviceNode.getParentNode();
        WsdlOperation operation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
        WsdlPort port = (WsdlPort)portNode.getLookup().lookup(WsdlPort.class);
        WsdlService service = (WsdlService)serviceNode.getLookup().lookup(WsdlService.class);
        Client client = (Client)wsdlNode.getLookup().lookup(Client.class);
        JaxWsClientNode wsClientNode = (JaxWsClientNode)((Object)wsdlNode.getLookup().lookup(JaxWsClientNode.class));
        FileObject srcRoot = (FileObject)wsdlNode.getLookup().lookup(FileObject.class);
        JAXWSClientSupport clientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)srcRoot);
        FileObject wsdlFileObject = null;
        FileObject localWsdlocalFolder = clientSupport.getLocalWsdlFolderForClient(client.getName(), false);
        if (localWsdlocalFolder != null && (relativePath = client.getLocalWsdlFile()) != null) {
            wsdlFileObject = localWsdlocalFolder.getFileObject(relativePath);
        }
        FileObject documentFileObject = NbEditorUtilities.getFileObject((Document)document);
        String wsdlUrl = JaxWsCodeGenerator.findWsdlLocation(client, documentFileObject);
        Project targetProject = FileOwnerQuery.getOwner((FileObject)documentFileObject);
        HashMap<String, Object> context = (HashMap<String, Object>)wsClientNode.getValue("context");
        if (context == null) {
            context = new HashMap<String, Object>();
            wsClientNode.setValue("context", context);
        }
        JaxWsCodeGenerator.insertMethod(client, document, pos, service, port, operation, wsdlFileObject, wsdlUrl, context, targetProject);
    }

    private static void insertMethod(Document document, int pos, WsdlService service, WsdlPort port, WsdlOperation operation, FileObject wsdlFileObject, String wsdlUrl, PolicyManager manager) {
        String argumentDeclarationPart;
        String argumentInitializationPart;
        String[] exceptionTypes;
        String[] paramNames;
        String[] paramTypes;
        String returnTypeName;
        String serviceJavaName;
        String portGetterMethod;
        String portJavaName;
        String operationJavaName;
        String serviceFieldName;
        boolean inJsp = "text/x-jsp".equals(document.getProperty("mimeType"));
        String responseType = "Object";
        String callbackHandlerName = "javax.xml.ws.AsyncHandler";
        try {
            serviceFieldName = "service";
            operationJavaName = operation.getJavaName();
            portJavaName = port.getJavaName();
            portGetterMethod = port.getPortGetter();
            serviceJavaName = service.getJavaName();
            List arguments = operation.getParameters();
            returnTypeName = operation.getReturnTypeName();
            Iterator it = operation.getExceptions();
            ArrayList<String> exceptionList = new ArrayList<String>();
            while (it.hasNext()) {
                exceptionList.add((String)it.next());
            }
            StringBuffer argumentBuffer1 = new StringBuffer();
            StringBuffer argumentBuffer2 = new StringBuffer();
            ArrayList<String> paramTypesList = new ArrayList<String>();
            ArrayList<String> paramNamesList = new ArrayList<String>();
            int argSize = arguments.size();
            for (int i = 0; i < argSize; ++i) {
                String argumentTypeName = ((WsdlParameter)arguments.get(i)).getTypeName();
                if (argumentTypeName.startsWith("javax.xml.ws.AsyncHandler")) {
                    responseType = JaxWsCodeGenerator.resolveResponseType(argumentTypeName);
                    if (inJsp) {
                        argumentTypeName = JaxWsCodeGenerator.pureJavaName(portJavaName) + "CallbackHandler";
                    }
                    callbackHandlerName = argumentTypeName;
                }
                String argumentName = ((WsdlParameter)arguments.get(i)).getName();
                if (inJsp && IMPLICIT_JSP_OBJECTS.contains(argumentName)) {
                    argumentName = argumentName + "_1";
                }
                argumentBuffer1.append("\t" + argumentTypeName + " " + argumentName + " = " + JaxWsCodeGenerator.resolveInitValue(argumentTypeName, NbEditorUtilities.getFileObject((Document)document)) + "\n");
                argumentBuffer2.append(i > 0 ? ", " + argumentName : argumentName);
                paramTypesList.add(argumentTypeName);
                paramNamesList.add(argumentName);
            }
            paramTypes = new String[argSize];
            paramTypesList.toArray(paramTypes);
            paramNames = new String[argSize];
            paramNamesList.toArray(paramNames);
            exceptionTypes = new String[exceptionList.size()];
            exceptionList.toArray(exceptionTypes);
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            argumentDeclarationPart = argumentBuffer2.toString();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            String message = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return;
        }
        manager.chosePolicy();
        if (inJsp) {
            JaxWsCodeGenerator.insertJspMethod(document, pos, operation, serviceJavaName, portJavaName, portGetterMethod, operationJavaName, returnTypeName, responseType, callbackHandlerName, argumentInitializationPart, argumentDeclarationPart);
        } else {
            JaxWsCodeGenerator.insertJavaMethod(document, pos, operation, wsdlUrl, manager, serviceJavaName, serviceFieldName, portJavaName, portGetterMethod, operationJavaName, returnTypeName, responseType, argumentInitializationPart, argumentDeclarationPart, paramNames, paramTypes, exceptionTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static void insertJavaMethod(final Document document, final int pos, WsdlOperation operation, String wsdlUrl, PolicyManager manager, String serviceJavaName, String serviceFieldName, String portJavaName, String portGetterMethod, String operationJavaName, String returnTypeName, String responseType, String argumentInitializationPart, String argumentDeclarationPart, String[] paramNames, String[] paramTypes, String[] exceptionTypes) {
        FileObject targetFo = NbEditorUtilities.getFileObject((Document)document);
        JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFo);
        String respType = responseType;
        String[] argumentInitPart = new String[]{argumentInitializationPart};
        String[] argumentDeclPart = new String[]{argumentDeclarationPart};
        String[] serviceFName = new String[]{serviceFieldName};
        try {
            CompilerTask task = JaxWsCodeGenerator.getCompilerTask(serviceJavaName, serviceFName, argumentDeclPart, paramNames, argumentInitPart, manager);
            targetSource.runUserActionTask((Task)task, true);
            if (0 == operation.getOperationType()) {
                String body = task.getMethodBody(portJavaName, portGetterMethod, returnTypeName, operationJavaName);
                boolean isStatic = !task.isWsRefInjection() || Car.getCar((FileObject)targetFo) != null;
                String webServiceRefWarning = task.isWsRefInjection() ? NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"WRN_WebServiceRef") : "";
                JaxWsClientMethodGenerator clientMethodGenerator = new JaxWsClientMethodGenerator(isStatic, operationJavaName, returnTypeName, paramTypes, paramNames, exceptionTypes, "{ " + webServiceRefWarning + body + "}");
                targetSource.runModificationTask((Task)clientMethodGenerator).commit();
            } else {
                final String invocationBody = task.getJavaInvocationBody(operation, portJavaName, portGetterMethod, returnTypeName, operationJavaName, respType);
                final Indent indent = Indent.get((Document)document);
                indent.lock();
                try {
                    ((BaseDocument)document).runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                System.out.println("............. 11111111111 ............. ");
                                document.insertString(pos, invocationBody, null);
                                indent.reindent(pos, pos + invocationBody.length());
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
                finally {
                    indent.unlock();
                }
            }
            InsertTask modificationTask = JaxWsCodeGenerator.getClassModificationTask(serviceJavaName, serviceFName, wsdlUrl, manager, task.containsWsRefInjection());
            targetSource.runModificationTask((Task)modificationTask).commit();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
    }

    private static void insertJspMethod(final Document document, final int pos, WsdlOperation operation, String serviceJavaName, String portJavaName, String portGetterMethod, String operationJavaName, String returnTypeName, String responseType, String callbackHandlerName, String argumentInitializationPart, String argumentDeclarationPart) {
        Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart};
        final String invocationBody = JaxWsCodeGenerator.getJSPInvocationBody(operation, args);
        try {
            if (2 == operation.getOperationType()) {
                Object[] args1 = new Object[]{callbackHandlerName, responseType};
                final String methodBody = MessageFormat.format(JSP_CALLBACK_HANDLER, args1);
                NbDocument.runAtomic((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.insertString(document.getLength(), methodBody, null);
                            document.insertString(pos, invocationBody, null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            } else {
                document.insertString(pos, invocationBody, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static InsertTask getClassModificationTask(String serviceJavaName, String[] serviceFName, String wsdlUrl, PolicyManager manager, boolean containsWsRefInjection) {
        return new InsertTask(serviceJavaName, serviceFName[0], wsdlUrl, manager, containsWsRefInjection);
    }

    private static CompilerTask getCompilerTask(String serviceJavaName, String[] serviceFName, String[] argumentDeclPart, String[] paramNames, String[] argumentInitPart, PolicyManager manager) {
        return new CompilerTask(serviceJavaName, serviceFName, argumentDeclPart, paramNames, argumentInitPart, manager);
    }

    private static String findWsdlLocation(Client client, FileObject targetFo) {
        Project targetProject = FileOwnerQuery.getOwner((FileObject)targetFo);
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)targetProject.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null && J2eeModule.Type.WAR.equals(moduleProvider.getJ2eeModule().getType())) {
            return "WEB-INF/wsdl/" + client.getLocalWsdlFile();
        }
        return "META-INF/wsdl/" + client.getLocalWsdlFile();
    }

    private static void insertMethod(Client client, Document document, int pos, WsdlService service, WsdlPort port, WsdlOperation operation, FileObject wsdlFileObject, String wsdlUrl, Map<String, Object> context, Project project) {
        PolicyManager manager = (PolicyManager)context.get(POLICY_MANAGER);
        if (manager == null || !client.getWsdlUrl().equals(manager.getWsdlUrl())) {
            manager = new PolicyManager(client.getWsdlUrl(), wsdlFileObject, project);
            context.put(POLICY_MANAGER, manager);
        }
        manager.init(client);
        if (client.getUseDispatch().booleanValue()) {
            JaxWsCodeGenerator.insertDispatchMethod(document, pos, service, port, operation, wsdlFileObject, wsdlUrl, manager);
        } else {
            JaxWsCodeGenerator.insertMethod(document, pos, service, port, operation, wsdlFileObject, wsdlUrl, manager);
        }
    }

    private static String getJSPInvocationBody(WsdlOperation operation, Object[] args) {
        String invocationBody = "";
        switch (operation.getOperationType()) {
            case 0: {
                if ("void".equals(args[4])) {
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB_VOID, args);
                    break;
                }
                invocationBody = MessageFormat.format(JSP_STATIC_STUB, args);
                break;
            }
            case 1: {
                invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_POLLING, args);
                break;
            }
            case 2: {
                invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_CALLBACK, args);
                break;
            }
        }
        return invocationBody;
    }

    static boolean foundImport(String importStatement, CompilationUnitTree tree) {
        List<? extends ImportTree> imports = tree.getImports();
        for (ImportTree importTree : imports) {
            if (!importStatement.equals(importTree.getQualifiedIdentifier().toString())) continue;
            return true;
        }
        return false;
    }

    public static String generateXMLMessage(WsdlPort port, WsdlOperation operation) {
        StringBuffer message = new StringBuffer("");
        String operationName = operation.getOperationName();
        String namespace = port.getNamespaceURI();
        message.append("<");
        message.append(operationName);
        message.append("  xmlns=\\\"");
        message.append(namespace);
        message.append("\\\">");
        List parameters = operation.getParameters();
        for (WsdlParameter parameter : parameters) {
            String name = parameter.getName();
            message.append("<");
            message.append(name);
            message.append(">");
            message.append("ENTER VALUE");
            message.append("</");
            message.append(name);
            message.append(">");
        }
        message.append("</");
        message.append(operationName);
        message.append(">");
        return message.toString();
    }

    private static String getDispatchInvocationMethod(WsdlPort port, WsdlOperation operation) {
        StringBuffer invoke = new StringBuffer("");
        invoke.append(MessageFormat.format(QNAME, port.getNamespaceURI(), port.getName()));
        invoke.append("\n");
        invoke.append("String req = ");
        invoke.append("\"");
        invoke.append(JaxWsCodeGenerator.generateXMLMessage(port, operation));
        invoke.append("\";\n");
        invoke.append(MessageFormat.format(JAVA_TRY, new Object[0]));
        invoke.append("\n");
        invoke.append("Dispatch<Source> sourceDispatch = null;\n");
        invoke.append("sourceDispatch = service.createDispatch(portQName, Source.class, Service.Mode.PAYLOAD);\n");
        invoke.append("Source result = sourceDispatch.invoke(new StreamSource(new StringReader(req)));\n");
        invoke.append(MessageFormat.format(JAVA_CATCH, new Object[0]));
        invoke.append("\n");
        return invoke.toString();
    }

    private static String getJSPDispatchBody(Object[] args) {
        return MessageFormat.format(JSP_DISPATCH, args);
    }

    private static void insertDispatchMethod(Document document, int pos, WsdlService service, WsdlPort port, WsdlOperation operation, FileObject wsdlFileObject, String wsdlUrl, PolicyManager manager) {
        boolean inJsp = "text/x-jsp".equals(document.getProperty("mimeType"));
        if (inJsp) {
            Object[] args = new Object[]{service.getJavaName(), port.getNamespaceURI(), port.getJavaName(), JaxWsCodeGenerator.generateXMLMessage(port, operation)};
            String invocationBody = JaxWsCodeGenerator.getJSPDispatchBody(args);
            try {
                document.insertString(pos, invocationBody, null);
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return;
        }
        try {
            JaxWsCodeGenerator.insertDispatchJavaMethod(document, pos, service, port, operation, wsdlUrl, manager);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static void insertDispatchJavaMethod(final Document document, final int pos, WsdlService service, WsdlPort port, WsdlOperation operation, String wsdlUrl, PolicyManager manager) throws IOException {
        FileObject targetFo = NbEditorUtilities.getFileObject((Document)document);
        JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFo);
        String serviceJavaName = service.getJavaName();
        String[] serviceFName = new String[]{"service"};
        String[] argumentDeclPart = new String[]{""};
        String[] argumentInitPart = new String[]{""};
        CompilerTask compilerTask = JaxWsCodeGenerator.getCompilerTask(serviceJavaName, serviceFName, argumentDeclPart, new String[0], argumentInitPart, manager);
        targetSource.runUserActionTask((Task)compilerTask, true);
        StringBuilder methodBody = new StringBuilder();
        String serviceDeclForJava = "";
        if (compilerTask.containsWsRefInjection()) {
            Object[] args = new Object[]{service.getJavaName(), null, null, null, null, null, null, "service"};
            serviceDeclForJava = MessageFormat.format(JAVA_SERVICE_DEF, args);
            methodBody.append(serviceDeclForJava);
        }
        String invocationBody = JaxWsCodeGenerator.getDispatchInvocationMethod(port, operation);
        DispatchClientMethodGenerator generator = new DispatchClientMethodGenerator(operation.getJavaName(), methodBody.append(invocationBody).toString(), pos);
        ModificationResult result = targetSource.runModificationTask((Task)generator);
        if (generator.isMethodBody()) {
            final String insideMethodBody = serviceDeclForJava + invocationBody;
            final Indent indent = Indent.get((Document)document);
            indent.lock();
            try {
                ((BaseDocument)document).runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.insertString(pos, insideMethodBody, null);
                            indent.reindent(pos, pos + insideMethodBody.length());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            finally {
                indent.unlock();
            }
        } else {
            result.commit();
        }
        InsertTask modificationTask = JaxWsCodeGenerator.getClassModificationTask(serviceJavaName, serviceFName, wsdlUrl, manager, compilerTask.containsWsRefInjection());
        targetSource.runModificationTask((Task)modificationTask).commit();
        DispatchCompilerTask task = new DispatchCompilerTask();
        targetSource.runModificationTask((Task)task).commit();
    }

    private static class ResultHolder<E> {
        private E result;

        public ResultHolder(E result) {
            this.result = result;
        }

        public E getResult() {
            return this.result;
        }

        public void setResult(E result) {
            this.result = result;
        }
    }
}

