/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.JavaSourceTaskFactory;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.formatters.Formatters;
import org.netbeans.modules.debugger.jpda.expr.formatters.FormattersLoopControl;
import org.netbeans.modules.debugger.jpda.expr.formatters.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesFormatterFilter;
import org.netbeans.modules.debugger.jpda.ui.values.ComputeInlineValues;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class InlineValueComputerImpl
implements PreferenceChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(InlineValueComputerImpl.class.getName());
    private static final RequestProcessor EVALUATOR = new RequestProcessor(InlineValueComputerImpl.class.getName(), 1, false, false);
    private static final String JAVA_STRATUM = "Java";
    private final JPDADebuggerImpl debugger;
    private final Preferences prefs;
    private TaskDescription currentTask;

    private InlineValueComputerImpl(Session session) {
        JPDADebugger jpdaDebugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
        if (jpdaDebugger instanceof JPDADebuggerImpl) {
            this.debugger = (JPDADebuggerImpl)jpdaDebugger;
            this.debugger.addPropertyChangeListener((PropertyChangeListener)this);
            this.prefs = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
        } else {
            this.debugger = null;
            this.prefs = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && this.debugger.getState() == 4) {
            this.setNewTask(null);
        }
        if ("currentCallStackFrame".equals(evt.getPropertyName())) {
            this.refreshVariables();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.refreshVariables();
    }

    private void refreshVariables() {
        TaskDescription newTask;
        CallStackFrame frame = this.debugger.getCurrentCallStackFrame();
        FileObject frameFile = null;
        int frameLineNumber = -1;
        StyledDocument frameDocument = null;
        if (this.prefs.getBoolean("enable.inline.values", true) && frame != null && !frame.isObsolete() && frame.getThread().isSuspended() && JAVA_STRATUM.equals(frame.getDefaultStratum())) {
            try {
                String url = this.debugger.getEngineContext().getURL(frame, JAVA_STRATUM);
                FileObject fileObject = frameFile = url != null ? URLMapper.findFileObject((URL)URI.create(url).toURL()) : null;
                if (frameFile != null) {
                    frameLineNumber = frame.getLineNumber(JAVA_STRATUM);
                    EditorCookie ec = (EditorCookie)frameFile.getLookup().lookup(EditorCookie.class);
                    frameDocument = ec != null ? ec.getDocument() : null;
                }
            }
            catch (MalformedURLException | InternalExceptionWrapper | InvalidStackFrameExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.setNewTask(newTask = frameFile != null && frameDocument != null ? new TaskDescription(frameFile, frameLineNumber, frameDocument) : null)) {
            return;
        }
        if (newTask != null) {
            CountDownLatch computationDone = new CountDownLatch(1);
            newTask.addCancelCallback(computationDone::countDown);
            AtomicReference values = new AtomicReference();
            EVALUATOR.post(() -> {
                OffsetsBag runningBag = new OffsetsBag(newTask.frameDocument);
                ((ComputeInlineVariablesFactory)((Object)((Object)Lookup.getDefault().lookup(ComputeInlineVariablesFactory.class)))).set(newTask.frameFile, newTask.frameLineNumber, variables -> {
                    values.set(variables);
                    computationDone.countDown();
                });
                try {
                    computationDone.await();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (newTask.isCancelled()) {
                    return;
                }
                Collection variables2 = (Collection)values.get();
                if (variables2 == null) {
                    return;
                }
                HashMap<String, Variable> expression2Value = new HashMap<String, Variable>();
                HashMap<Integer, Map> line2Values = new HashMap<Integer, Map>();
                for (ComputeInlineValues.InlineVariable v : variables2) {
                    String valueText;
                    if (newTask.isCancelled()) {
                        return;
                    }
                    Variable value = expression2Value.computeIfAbsent(v.expression(), expr -> {
                        try {
                            return this.debugger.evaluate(expr);
                        }
                        catch (InvalidExpressionException ex) {
                            LOG.log(Level.FINE, null, ex);
                            return null;
                        }
                    });
                    if (value == null) continue;
                    if (value instanceof ObjectVariable) {
                        ObjectVariable ov = (ObjectVariable)value;
                        valueText = this.toValue(ov).replace("\n", "\\n");
                    } else {
                        valueText = value.getValue();
                    }
                    line2Values.computeIfAbsent(v.lineEnd(), __ -> new LinkedHashMap()).putIfAbsent(v.expression(), v.expression() + " = " + valueText);
                    String mergedValues = ((Map)line2Values.get(v.lineEnd())).values().stream().collect(Collectors.joining(", ", "  ", ""));
                    AttributeSet attrs = AttributesUtilities.createImmutable((Object[])new Object[]{"virtual-text-prepend", mergedValues});
                    runningBag.addHighlight(v.lineEnd(), v.lineEnd() + 1, attrs);
                    this.setHighlights(newTask, runningBag);
                }
            });
        }
    }

    private String toValue(ObjectVariable variable) {
        FormattersLoopControl formattersLoop = new FormattersLoopControl();
        String type = variable.getType();
        ObjectVariable ov = variable;
        JPDAClassType ct = ov.getClassType();
        if (ct == null) {
            return ov.getValue();
        }
        VariablesFormatter f = Formatters.getFormatterForType((JPDAClassType)ct, (VariablesFormatter[])formattersLoop.getFormatters());
        String[] formattersInLoopRef = new String[]{null};
        if (f != null && formattersLoop.canUse(f, ct.getName(), formattersInLoopRef)) {
            String code = f.getValueFormatCode();
            if (code != null && code.length() > 0) {
                try {
                    Method evaluateMethod = ov.getClass().getMethod("evaluate", String.class);
                    evaluateMethod.setAccessible(true);
                    Variable ret = (Variable)evaluateMethod.invoke((Object)ov, code);
                    if (ret == null) {
                        return null;
                    }
                    return ret.getValue();
                }
                catch (InvocationTargetException itex) {
                    Throwable t = itex.getTargetException();
                    if (t instanceof InvalidExpressionException) {
                        return ov.getValue();
                    }
                    Exceptions.printStackTrace((Throwable)t);
                }
                catch (ReflectiveOperationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (formattersInLoopRef[0] != null) {
            // empty if block
        }
        if (VariablesFormatterFilter.isToStringValueType(type)) {
            try {
                return "\"" + ov.getToStringValue() + "\"";
            }
            catch (InvalidExpressionException ex) {
                Logger.getLogger(VariablesFormatterFilter.class.getName()).fine("getToStringValue() " + ex.getLocalizedMessage());
                if (ex.getTargetException() instanceof UnsupportedOperationException) {
                    return ov.getValue();
                }
                return ex.getLocalizedMessage();
            }
        }
        return ov.getValue();
    }

    private synchronized boolean setNewTask(TaskDescription newTask) {
        if (Objects.equals(this.currentTask, newTask)) {
            return true;
        }
        if (this.currentTask != null) {
            this.currentTask.cancel();
            InlineValueComputerImpl.getHighlightsBag(this.currentTask.frameDocument).clear();
        }
        this.currentTask = newTask;
        return false;
    }

    private synchronized void setHighlights(TaskDescription task, OffsetsBag highlights) {
        if (!task.isCancelled()) {
            InlineValueComputerImpl.getHighlightsBag(this.currentTask.frameDocument).setHighlights(highlights);
        }
    }

    public static HighlightsLayerFactory createHighlightsLayerFactory() {
        return new HighlightsLayerFactory(){

            public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
                return new HighlightsLayer[]{HighlightsLayer.create((String)InlineValueComputerImpl.class.getName(), (ZOrder)ZOrder.SYNTAX_RACK.forPosition(1400), (boolean)false, (HighlightsContainer)InlineValueComputerImpl.getHighlightsBag(context.getDocument()))};
            }
        };
    }

    private static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(InlineValueComputerImpl.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, true);
            doc.putProperty(InlineValueComputerImpl.class, bag);
        }
        return bag;
    }

    private static final class TaskDescription {
        public final FileObject frameFile;
        public final int frameLineNumber;
        public final Document frameDocument;
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final List<Runnable> cancelCallbacks = Collections.synchronizedList(new ArrayList());

        public TaskDescription(FileObject frameFile, int frameLineNumber, Document frameDocument) {
            this.frameFile = frameFile;
            this.frameLineNumber = frameLineNumber;
            this.frameDocument = frameDocument;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            ArrayList<Runnable> callbacks;
            this.cancelled.set(true);
            List<Runnable> list = this.cancelCallbacks;
            synchronized (list) {
                callbacks = new ArrayList<Runnable>(this.cancelCallbacks);
            }
            for (Runnable r : callbacks) {
                r.run();
            }
        }

        public void addCancelCallback(Runnable r) {
            this.cancelCallbacks.add(r);
            if (this.cancelled.get()) {
                r.run();
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.frameFile);
            hash = 53 * hash + this.frameLineNumber;
            hash = 53 * hash + System.identityHashCode(this.frameDocument);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TaskDescription other = (TaskDescription)obj;
            if (this.frameLineNumber != other.frameLineNumber) {
                return false;
            }
            if (!Objects.equals(this.frameFile, other.frameFile)) {
                return false;
            }
            return this.frameDocument == other.frameDocument;
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }

    public static final class ComputeInlineVariablesFactory
    extends JavaSourceTaskFactory {
        private FileObject currentFile;
        private int currentLineNumber;
        private Consumer<Collection<ComputeInlineValues.InlineVariable>> currentTarget;

        public ComputeInlineVariablesFactory() {
            super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.NORMAL, TaskIndexingMode.ALLOWED_DURING_SCAN);
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            return new CancellableTask<CompilationInfo>(){
                private final AtomicBoolean cancel = new AtomicBoolean();

                public void cancel() {
                    this.cancel.set(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(CompilationInfo info) throws Exception {
                    Consumer<Collection<ComputeInlineValues.InlineVariable>> target;
                    int line;
                    this.cancel.set(false);
                    ComputeInlineVariablesFactory computeInlineVariablesFactory = this;
                    synchronized (computeInlineVariablesFactory) {
                        if (!info.getFileObject().equals(currentFile)) {
                            return;
                        }
                        line = currentLineNumber;
                        target = currentTarget;
                    }
                    Collection<ComputeInlineValues.InlineVariable> variables = ComputeInlineValues.computeVariables(info, line, 1, this.cancel);
                    target.accept(variables);
                }
            };
        }

        protected synchronized Collection<FileObject> getFileObjects() {
            return this.currentFile != null ? List.of(this.currentFile) : List.of();
        }

        public synchronized void set(FileObject currentFile, int lineNumber, Consumer<Collection<ComputeInlineValues.InlineVariable>> target) {
            this.currentFile = currentFile;
            this.currentLineNumber = lineNumber;
            this.currentTarget = target;
            this.fileObjectsChanged();
            if (currentFile != null) {
                this.reschedule(currentFile);
            }
        }
    }

    public static final class Init
    extends DebuggerManagerAdapter {
        public void sessionAdded(Session session) {
            new InlineValueComputerImpl(session);
        }
    }
}

