/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.spi.impl.CheckNode;
import org.netbeans.modules.refactoring.spi.impl.CheckRenderer;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class CheckNodeListener
implements MouseListener,
KeyListener {
    private final boolean isQuery;

    public CheckNodeListener(boolean isQuery) {
        this.isQuery = isQuery;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        JTree tree = (JTree)e.getSource();
        Point p = e.getPoint();
        int x = e.getX();
        int row = tree.getRowForLocation(x, y = e.getY());
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            CheckNode node = (CheckNode)path.getLastPathComponent();
            if (this.isQuery) {
                TreeElement treeElement;
                Object o;
                if (e.getClickCount() == 2) {
                    Object o2 = node.getUserObject();
                    if (o2 instanceof Openable) {
                        Openable openable = (Openable)o2;
                        openable.open();
                    } else if (o2 instanceof TreeElement) {
                        TreeElement treeElement2 = (TreeElement)o2;
                        if ((o2 = treeElement2.getUserObject()) instanceof RefactoringElement || o2 instanceof FileObject || o2 instanceof Openable) {
                            if (!CheckNodeListener.findInSource(node)) {
                                if (tree.isCollapsed(row)) {
                                    tree.expandRow(row);
                                } else {
                                    tree.collapseRow(row);
                                }
                            }
                        } else if (tree.isCollapsed(row)) {
                            tree.expandRow(row);
                        } else {
                            tree.collapseRow(row);
                        }
                    } else if (tree.isCollapsed(row)) {
                        tree.expandRow(row);
                    } else {
                        tree.collapseRow(row);
                    }
                } else if (e.getClickCount() == 1 && (o = node.getUserObject()) instanceof TreeElement && (o = (treeElement = (TreeElement)o).getUserObject()) instanceof RefactoringElement) {
                    CheckNodeListener.openDiff(node);
                }
            } else {
                TreeElement treeElement;
                Object o;
                Rectangle chRect = CheckRenderer.getCheckBoxRectangle();
                Rectangle rowRect = tree.getPathBounds(path);
                chRect.setLocation(chRect.x + rowRect.x, chRect.y + rowRect.y);
                if (e.getClickCount() == 1 && chRect.contains(p) && !node.isDisabled()) {
                    TreeElement treeElement3;
                    boolean isSelected = !node.isSelected();
                    node.setSelected(isSelected);
                    Object o3 = node.getUserObject();
                    if (o3 instanceof TreeElement && (o3 = (treeElement3 = (TreeElement)o3).getUserObject()) instanceof RefactoringElement) {
                        CheckNodeListener.openDiff(node);
                    }
                    ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
                    if (row == 0) {
                        tree.revalidate();
                    }
                    tree.repaint();
                } else if (e.getClickCount() == 2 && !chRect.contains(p)) {
                    Object o4 = node.getUserObject();
                    if (o4 instanceof TreeElement) {
                        TreeElement treeElement4 = (TreeElement)o4;
                        if ((o4 = treeElement4.getUserObject()) instanceof RefactoringElement || o4 instanceof FileObject) {
                            CheckNodeListener.findInSource(node);
                        }
                    } else if (o4 instanceof Openable) {
                        Openable openable = (Openable)o4;
                        openable.open();
                    } else if (tree.isCollapsed(row)) {
                        tree.expandRow(row);
                    } else {
                        tree.collapseRow(row);
                    }
                } else if (e.getClickCount() == 1 && !chRect.contains(p) && (o = node.getUserObject()) instanceof TreeElement && (o = (treeElement = (TreeElement)o).getUserObject()) instanceof RefactoringElement) {
                    CheckNodeListener.openDiff(node);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        TreeElement treeElement;
        CheckNode node;
        Object o;
        JTree tree;
        TreePath path;
        int keyCode = e.getKeyCode();
        if ((keyCode == 38 || keyCode == 40) && (path = (tree = (JTree)e.getSource()).getSelectionPath()) != null && (o = (node = (CheckNode)path.getLastPathComponent()).getUserObject()) instanceof TreeElement && (o = (treeElement = (TreeElement)o).getUserObject()) instanceof RefactoringElement) {
            CheckNodeListener.openDiff(node);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        int y;
        int x;
        int row;
        JTree tree = (JTree)event.getSource();
        TreePath path = tree.getPathForRow(row = tree.getRowForLocation(x = event.getX(), y = event.getY()));
        if (path == null) {
            return;
        }
        CheckNode node = (CheckNode)path.getLastPathComponent();
        if (!SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        Object o = node.getUserObject();
        if (!(o instanceof TreeElement)) {
            return;
        }
        if ((o = ((TreeElement)o).getUserObject()) instanceof RefactoringElement) {
            RefactoringElement refactoringElement = (RefactoringElement)o;
            this.showPopup(refactoringElement.getLookup().lookupAll(Action.class), tree, x, y);
        }
    }

    private void showPopup(Collection<? extends Action> actions, Component c, int x, int y) {
        if (actions.isEmpty()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        for (Action action : actions) {
            menu.add(action);
        }
        menu.show(c, x, y);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        int keyCode = e.getKeyCode();
        if (keyCode == 32) {
            JTree tree2 = (JTree)e.getSource();
            TreePath path2 = tree2.getSelectionPath();
            if (path2 != null) {
                CheckNode node;
                node.setSelected(!(node = (CheckNode)path2.getLastPathComponent()).isSelected());
                tree2.repaint();
                e.consume();
            }
        } else if (keyCode == 10 && (path = (tree = (JTree)e.getSource()).getSelectionPath()) != null) {
            CheckNode node = (CheckNode)path.getLastPathComponent();
            CheckNodeListener.findInSource(node);
        }
    }

    static boolean findInSource(CheckNode node) {
        Object o = node.getUserObject();
        if (o instanceof TreeElement) {
            TreeElement treeElement = (TreeElement)o;
            if (o instanceof Openable) {
                Openable openable = (Openable)o;
                openable.open();
                return true;
            }
            o = treeElement.getUserObject();
            if (o instanceof RefactoringElement) {
                RefactoringElement refactoringElement = (RefactoringElement)o;
                APIAccessor.DEFAULT.getRefactoringElementImplementation(refactoringElement).openInEditor();
                return true;
            }
            if (o instanceof Openable) {
                Openable openable = (Openable)o;
                openable.open();
                return true;
            }
            if (o instanceof FileObject) {
                FileObject fileObject = (FileObject)o;
                try {
                    OpenCookie oc = (OpenCookie)DataObject.find((FileObject)fileObject).getCookie(OpenCookie.class);
                    if (oc != null) {
                        oc.open();
                        return true;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    static void openDiff(CheckNode node) {
        TreeElement treeElement;
        Object o = node.getUserObject();
        if (o instanceof TreeElement && (o = (treeElement = (TreeElement)o).getUserObject()) instanceof RefactoringElement) {
            RefactoringElement refactoringElement = (RefactoringElement)o;
            APIAccessor.DEFAULT.getRefactoringElementImplementation(refactoringElement).showPreview();
        }
    }

    static void selectNextPrev(boolean next, boolean jumpSource, JTree tree) {
        CheckNode node;
        int[] rows = tree.getSelectionRows();
        int newRow = rows == null || rows.length == 0 ? 0 : rows[0];
        int maxcount = tree.getRowCount();
        do {
            TreePath path;
            if (next) {
                if (++newRow >= maxcount) {
                    newRow = 0;
                }
            } else if (--newRow < 0) {
                newRow = maxcount - 1;
            }
            if ((node = (CheckNode)(path = tree.getPathForRow(newRow)).getLastPathComponent()).isLeaf()) continue;
            tree.expandRow(newRow);
            maxcount = tree.getRowCount();
        } while (!node.isLeaf());
        tree.setSelectionRow(newRow);
        CheckNodeListener.verticalScrollRowToVisible(tree, newRow);
        CheckNodeListener.openDiff(node);
        if (jumpSource) {
            CheckNodeListener.findInSource(node);
        }
    }

    private static void verticalScrollRowToVisible(JTree tree, int row) {
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            tree.makeVisible(path);
            Rectangle bounds = tree.getPathBounds(path);
            bounds.setLocation(0, (int)bounds.getY());
            tree.scrollRectToVisible(bounds);
        }
    }
}

