/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DiffChunk;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FileDiffResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="oldPath")
    private final String oldPath;
    @JsonProperty(value="newPath")
    private final String newPath;
    @JsonProperty(value="oldId")
    private final String oldId;
    @JsonProperty(value="newId")
    private final String newId;
    @JsonProperty(value="areConflictsInFile")
    private final Boolean areConflictsInFile;
    @JsonProperty(value="isLarge")
    private final Boolean isLarge;
    @JsonProperty(value="isBinary")
    private final Boolean isBinary;
    @JsonProperty(value="changes")
    private final List<DiffChunk> changes;

    @Deprecated
    @ConstructorProperties(value={"oldPath", "newPath", "oldId", "newId", "areConflictsInFile", "isLarge", "isBinary", "changes"})
    public FileDiffResponse(String oldPath, String newPath, String oldId, String newId, Boolean areConflictsInFile, Boolean isLarge, Boolean isBinary, List<DiffChunk> changes) {
        this.oldPath = oldPath;
        this.newPath = newPath;
        this.oldId = oldId;
        this.newId = newId;
        this.areConflictsInFile = areConflictsInFile;
        this.isLarge = isLarge;
        this.isBinary = isBinary;
        this.changes = changes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String getOldId() {
        return this.oldId;
    }

    public String getNewId() {
        return this.newId;
    }

    public Boolean getAreConflictsInFile() {
        return this.areConflictsInFile;
    }

    public Boolean getIsLarge() {
        return this.isLarge;
    }

    public Boolean getIsBinary() {
        return this.isBinary;
    }

    public List<DiffChunk> getChanges() {
        return this.changes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FileDiffResponse(");
        sb.append("super=").append(super.toString());
        sb.append("oldPath=").append(String.valueOf(this.oldPath));
        sb.append(", newPath=").append(String.valueOf(this.newPath));
        sb.append(", oldId=").append(String.valueOf(this.oldId));
        sb.append(", newId=").append(String.valueOf(this.newId));
        sb.append(", areConflictsInFile=").append(String.valueOf(this.areConflictsInFile));
        sb.append(", isLarge=").append(String.valueOf(this.isLarge));
        sb.append(", isBinary=").append(String.valueOf(this.isBinary));
        sb.append(", changes=").append(String.valueOf(this.changes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileDiffResponse)) {
            return false;
        }
        FileDiffResponse other = (FileDiffResponse)((Object)o);
        return Objects.equals(this.oldPath, other.oldPath) && Objects.equals(this.newPath, other.newPath) && Objects.equals(this.oldId, other.oldId) && Objects.equals(this.newId, other.newId) && Objects.equals(this.areConflictsInFile, other.areConflictsInFile) && Objects.equals(this.isLarge, other.isLarge) && Objects.equals(this.isBinary, other.isBinary) && Objects.equals(this.changes, other.changes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.oldPath == null ? 43 : this.oldPath.hashCode());
        result = result * 59 + (this.newPath == null ? 43 : this.newPath.hashCode());
        result = result * 59 + (this.oldId == null ? 43 : this.oldId.hashCode());
        result = result * 59 + (this.newId == null ? 43 : this.newId.hashCode());
        result = result * 59 + (this.areConflictsInFile == null ? 43 : this.areConflictsInFile.hashCode());
        result = result * 59 + (this.isLarge == null ? 43 : this.isLarge.hashCode());
        result = result * 59 + (this.isBinary == null ? 43 : this.isBinary.hashCode());
        result = result * 59 + (this.changes == null ? 43 : this.changes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="oldPath")
        private String oldPath;
        @JsonProperty(value="newPath")
        private String newPath;
        @JsonProperty(value="oldId")
        private String oldId;
        @JsonProperty(value="newId")
        private String newId;
        @JsonProperty(value="areConflictsInFile")
        private Boolean areConflictsInFile;
        @JsonProperty(value="isLarge")
        private Boolean isLarge;
        @JsonProperty(value="isBinary")
        private Boolean isBinary;
        @JsonProperty(value="changes")
        private List<DiffChunk> changes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder oldPath(String oldPath) {
            this.oldPath = oldPath;
            this.__explicitlySet__.add("oldPath");
            return this;
        }

        public Builder newPath(String newPath) {
            this.newPath = newPath;
            this.__explicitlySet__.add("newPath");
            return this;
        }

        public Builder oldId(String oldId) {
            this.oldId = oldId;
            this.__explicitlySet__.add("oldId");
            return this;
        }

        public Builder newId(String newId) {
            this.newId = newId;
            this.__explicitlySet__.add("newId");
            return this;
        }

        public Builder areConflictsInFile(Boolean areConflictsInFile) {
            this.areConflictsInFile = areConflictsInFile;
            this.__explicitlySet__.add("areConflictsInFile");
            return this;
        }

        public Builder isLarge(Boolean isLarge) {
            this.isLarge = isLarge;
            this.__explicitlySet__.add("isLarge");
            return this;
        }

        public Builder isBinary(Boolean isBinary) {
            this.isBinary = isBinary;
            this.__explicitlySet__.add("isBinary");
            return this;
        }

        public Builder changes(List<DiffChunk> changes) {
            this.changes = changes;
            this.__explicitlySet__.add("changes");
            return this;
        }

        public FileDiffResponse build() {
            FileDiffResponse model = new FileDiffResponse(this.oldPath, this.newPath, this.oldId, this.newId, this.areConflictsInFile, this.isLarge, this.isBinary, this.changes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FileDiffResponse model) {
            if (model.wasPropertyExplicitlySet("oldPath")) {
                this.oldPath(model.getOldPath());
            }
            if (model.wasPropertyExplicitlySet("newPath")) {
                this.newPath(model.getNewPath());
            }
            if (model.wasPropertyExplicitlySet("oldId")) {
                this.oldId(model.getOldId());
            }
            if (model.wasPropertyExplicitlySet("newId")) {
                this.newId(model.getNewId());
            }
            if (model.wasPropertyExplicitlySet("areConflictsInFile")) {
                this.areConflictsInFile(model.getAreConflictsInFile());
            }
            if (model.wasPropertyExplicitlySet("isLarge")) {
                this.isLarge(model.getIsLarge());
            }
            if (model.wasPropertyExplicitlySet("isBinary")) {
                this.isBinary(model.getIsBinary());
            }
            if (model.wasPropertyExplicitlySet("changes")) {
                this.changes(model.getChanges());
            }
            return this;
        }
    }
}

