/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi.newproject;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gradle.spi.newproject.BaseGradleWizardIterator;
import org.netbeans.modules.gradle.spi.newproject.TemplateOperation;
import org.openide.WizardDescriptor;

public class SimpleGradleWizardIterator
extends BaseGradleWizardIterator {
    final String title;
    final String buildTemplate;
    final Map<String, Object> templateParams;
    private static final String TEMPLATE_SETTINGS = "org/netbeans/modules/gradle/newproject/single-settings.gradle.template";
    private static final String TEMPLATE_BUILD = "org/netbeans/modules/gradle/newproject/single-build.gradle.template";
    private static final String TEMPLATE_PROPS = "org/netbeans/modules/gradle/newproject/single-gradle.properties.template";
    public static final String PROP_PROJECT_ROOT = "projectDir";
    public static final String PROP_MAIN_JAVA_DIR = "projectMainJavaDir";
    public static final String PROP_PLUGINS = "plugins";
    public static final String PROP_DEPENDENCIES = "dependencies";
    public static final String PROP_JAVA_VERSION = "javaVersion";

    public SimpleGradleWizardIterator(String title, String buildTemplate, Map<String, Object> params) {
        this.title = title;
        this.buildTemplate = buildTemplate;
        this.templateParams = params;
    }

    public SimpleGradleWizardIterator(String title, Map<String, Object> params) {
        this(title, TEMPLATE_BUILD, params);
    }

    @Override
    protected List<? extends WizardDescriptor.Panel<WizardDescriptor>> createPanels() {
        return Collections.singletonList(SimpleGradleWizardIterator.createProjectAttributesPanel(null));
    }

    @Override
    protected final String getTitle() {
        return this.title;
    }

    @Override
    protected void collectOperations(TemplateOperation ops, Map<String, Object> params) {
        params.putAll(this.templateParams);
        String name = (String)params.get("name");
        String packageBase = (String)params.get("packageBase");
        File loc = (File)params.get("projdir");
        File root = new File(loc, name);
        File mainJava = new File(root, "src/main/java");
        params.put(PROP_PROJECT_ROOT, root);
        params.put(PROP_MAIN_JAVA_DIR, mainJava);
        ops.createFolder(root);
        ops.copyFromFile(this.buildTemplate, new File(root, "build.gradle"), params);
        if (this.assumedRoot() == null) {
            ops.copyFromFile(TEMPLATE_SETTINGS, new File(root, "settings.gradle"), params);
            ops.copyFromFile(TEMPLATE_PROPS, new File(root, "gradle.properties"), params);
        }
        ops.createFolder(mainJava);
        ops.createPackage(mainJava, packageBase);
        ops.addProjectPreload(root);
        Boolean initWrapper = (Boolean)params.get("initWrapper");
        if (initWrapper == null || initWrapper.booleanValue()) {
            ops.addWrapperInit(root);
        }
    }
}

