/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.openide.util.NbBundle;

public class RecentCategory
extends Category {
    private final BugtrackingManager bugtrackingManager = BugtrackingManager.getInstance();
    private List<String> recentIdx;

    public RecentCategory() {
        super(NbBundle.getMessage(RecentCategory.class, (String)"LBL_Recent"), new ArrayList<IssueImpl>(), true);
    }

    @Override
    public boolean persist() {
        return false;
    }

    @Override
    public void reload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IssueImpl> getTasks() {
        RecentCategory recentCategory = this;
        synchronized (recentCategory) {
            List<IssueImpl> recent = this.bugtrackingManager.getAllRecentIssues();
            this.recentIdx = new ArrayList<String>(recent.size());
            for (IssueImpl recentIssue : recent) {
                this.recentIdx.add(recentIssue.getID());
            }
            return new ArrayList<IssueImpl>(recent);
        }
    }

    public Comparator<TaskNode> getTaskNodeComparator() {
        return new Comparator<TaskNode>(){

            @Override
            public int compare(TaskNode o1, TaskNode o2) {
                IssueImpl issue1 = o1.getTask();
                IssueImpl issue2 = o2.getTask();
                Integer i1 = issue1 != null ? RecentCategory.this.recentIdx.indexOf(issue1.getID()) : -1;
                Integer i2 = issue2 != null ? RecentCategory.this.recentIdx.indexOf(issue2.getID()) : -1;
                return i1.compareTo(i2);
            }
        };
    }

    @Override
    public int sortIndex() {
        return 800;
    }
}

