/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.fixes;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RemoveAnnotation
implements Fix {
    private FileObject fileObject;
    private Element element;
    private String annotation;
    private String simpleName;

    public RemoveAnnotation(FileObject fileObject, Element element, AnnotationMirror annMirror) {
        this.element = element;
        this.fileObject = fileObject;
        Element annotationElement = annMirror.getAnnotationType().asElement();
        assert (annotationElement instanceof TypeElement);
        this.annotation = ((TypeElement)annotationElement).getQualifiedName().toString();
        this.simpleName = annotationElement.getSimpleName().toString();
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(WorkingCopy workingCopy) throws Exception {
                if (RemoveAnnotation.this.element.getKind() == ElementKind.PARAMETER) {
                    Element method = RemoveAnnotation.this.element.getEnclosingElement();
                    if (!(method instanceof ExecutableElement)) return;
                    ExecutableElement methodElement = (ExecutableElement)method;
                    List<? extends VariableElement> parameters = methodElement.getParameters();
                    int index = parameters.indexOf(RemoveAnnotation.this.element);
                    if (index == -1) {
                        return;
                    }
                    Utilities.removeAnnotation(workingCopy, (ElementHandle<ExecutableElement>)ElementHandle.create((Element)methodElement), index, RemoveAnnotation.this.annotation);
                    return;
                } else {
                    Utilities.removeAnnotation(workingCopy, (ElementHandle<Element>)ElementHandle.create((Element)RemoveAnnotation.this.element), RemoveAnnotation.this.annotation);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            if (javaSource != null) {
                javaSource.runModificationTask((Task)task).commit();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        String annotationLabel = this.simpleName;
        return NbBundle.getMessage(RemoveAnnotation.class, (String)"LBL_RemoveAnnotation", (Object)annotationLabel);
    }
}

