/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.util.Vector;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.JMSWizardVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class JMSWizardPanel
extends ResourceWizardPanel {
    private JMSWizardVisualPanel component;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private String[] groupNames;
    private boolean setupValid = true;

    public JMSWizardPanel(ResourceConfigHelper helper, Wizard wizardInfo) {
        this.helper = helper;
        this.wizardInfo = wizardInfo;
        this.groupNames = new String[]{"general"};
    }

    public Component getComponent() {
        if (this.component == null) {
            FieldGroup[] groups = new FieldGroup[this.groupNames.length];
            for (int i = 0; i < this.groupNames.length; ++i) {
                groups[i] = FieldGroupHelper.getFieldGroup(this.wizardInfo, this.groupNames[i]);
            }
            Object panelType = null;
            this.component = new JMSWizardVisualPanel(this, groups);
        }
        return this.component;
    }

    public boolean createNew() {
        return this.component != null;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx("AS_Wiz_JMS_general");
    }

    public ResourceConfigHelper getHelper() {
        return this.helper;
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(this.bundle.getString("Empty_String"));
        String jndiName = this.helper.getData().getString("jndi-name");
        if (jndiName.trim().length() == 0 || jndiName.trim().equals("")) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
            return false;
        }
        if (!ResourceUtils.isLegalResourceName(jndiName)) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
            return false;
        }
        if (!ResourceUtils.isUniqueFileName(jndiName, this.helper.getData().getTargetFileObject(), "jms/myQueue")) {
            this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
            return false;
        }
        return true;
    }

    public FieldGroup getFieldGroup(String groupName) {
        return FieldGroupHelper.getFieldGroup(this.wizardInfo, groupName);
    }

    @Override
    public void readSettings(Object settings) {
        this.wizDescriptor = (WizardDescriptor)settings;
        TemplateWizard wizard = (TemplateWizard)settings;
        String targetName = wizard.getTargetName();
        FileObject resFolder = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(resFolder);
        if (resFolder != null) {
            String resourceName = this.helper.getData().getString("jndi-name");
            if (resourceName != null && !resourceName.equals("")) {
                targetName = resourceName;
            }
            targetName = ResourceUtils.createUniqueFileName(targetName, resFolder, "jms/myQueue");
            this.helper.getData().setTargetFile(targetName);
            if (this.component == null) {
                this.getComponent();
            }
            this.component.setHelper(this.helper);
        } else {
            this.setupValid = false;
        }
    }

    @Override
    public boolean isFinishPanel() {
        this.isValid();
        ResourceConfigData data = this.helper.getData();
        Vector vec = data.getProperties();
        for (int i = 0; i < vec.size(); ++i) {
            NameValuePair pair = (NameValuePair)vec.elementAt(i);
            if (pair.getParamName() != null && pair.getParamValue() != null && pair.getParamName().length() != 0 && pair.getParamValue().length() != 0) continue;
            return false;
        }
        return true;
    }

    private boolean setupValid() {
        return this.setupValid;
    }
}

