/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.parser.DG;
import org.netbeans.modules.languages.parser.DGUtils;
import org.netbeans.modules.languages.parser.NodeFactory;
import org.netbeans.modules.languages.parser.StringInput;

public class Pattern {
    private static final Character STAR = Character.valueOf('\u0000');
    private static NodeFactory<Integer> nodeFactory = new NodeFactory<Integer>(){
        private int counter = 1;

        @Override
        public Integer createNode() {
            return this.counter++;
        }
    };
    private static Set<Character> whitespace = new HashSet<Character>();
    private DG<Integer, Character, Integer, TokenType> dg;

    public static Pattern create() {
        return new Pattern();
    }

    public static Pattern create(String input) throws ParseException {
        if (input.length() == 0) {
            throw new ParseException("Empty pattern.");
        }
        return Pattern.create(new StringInput(input));
    }

    public static Pattern create(CharInput input) throws ParseException {
        Pattern p = Pattern.createIn(input);
        DG<Integer, Character, Integer, TokenType> ndg = DGUtils.reduce(p.dg, nodeFactory);
        return new Pattern(ndg);
    }

    private static Pattern createCaseInsensitive(StringBuffer input) throws ParseException {
        int length = input.length();
        Pattern pattern = new Pattern();
        for (int x = 0; x < length; ++x) {
            char down;
            char c = input.charAt(x);
            char up = Character.toUpperCase(c);
            pattern = up != (down = Character.toLowerCase(c)) ? pattern.append(new Pattern(Character.valueOf(up)).merge(new Pattern(Character.valueOf(down)))) : pattern.append(new Pattern(Character.valueOf(c)));
        }
        return pattern;
    }

    /*
     * Unable to fully structure code
     */
    private static Pattern createIn(CharInput input) throws ParseException {
        pattern = new Pattern();
        last = null;
        ch = input.next();
        while (ch != '\u0000') {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    input.read();
                    break;
                }
                case '*': {
                    input.read();
                    if (last == null) {
                        throw new ParseException("Unexpected character '" + ch + "'.");
                    }
                    last = last.star();
                    break;
                }
                case '?': {
                    input.read();
                    if (last == null) {
                        throw new ParseException("Unexpected character '" + ch + "'.");
                    }
                    last = last.question();
                    break;
                }
                case '+': {
                    input.read();
                    if (last == null) {
                        throw new ParseException("Unexpected character '" + ch + "'.");
                    }
                    last = last.plus();
                    break;
                }
                case '(': {
                    input.read();
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    last = Pattern.createIn(input);
                    if (input.next() != ')') {
                        throw new ParseException("Unexpected character '" + input.next() + "'.");
                    }
                    input.read();
                    break;
                }
                case '\"': 
                case '\'': {
                    input.read();
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    last = Pattern.create();
                    buf = new StringBuffer();
                    ch = input.next();
                    while (ch != '\"' && ch != '\'') {
                        if (ch == '\u0000') {
                            throw new ParseException("Unexpected character '" + ch + "'.");
                        }
                        if (ch != '\\') ** GOTO lbl119
                        input.read();
                        switch (input.next()) {
                            case '\\': {
                                input.read();
                                buf.append('\\');
                                ** GOTO lbl121
                            }
                            case 'n': {
                                input.read();
                                buf.append('\n');
                                ** GOTO lbl121
                            }
                            case 'r': {
                                input.read();
                                buf.append('\r');
                                ** GOTO lbl121
                            }
                            case 't': {
                                input.read();
                                buf.append('\t');
                                ** GOTO lbl121
                            }
                            case '\"': {
                                input.read();
                                buf.append('\"');
                                ** GOTO lbl121
                            }
                            case '\'': {
                                input.read();
                                buf.append('\'');
                                ** GOTO lbl121
                            }
                            case 'u': {
                                input.read();
                                ch1 = 0;
                                for (i = 4096; i >= 1; i /= 16) {
                                    c = input.next();
                                    ii = 0;
                                    if ('0' <= c && c <= '9') {
                                        ii = c - 48;
                                    } else if ('a' <= c && c <= 'f') {
                                        ii = c - 97 + 10;
                                    } else if ('A' <= c && c <= 'F') {
                                        ii = c - 65 + 10;
                                    } else {
                                        throw new ParseException("Unexpected character after \\u:" + c);
                                    }
                                    ch1 += ii * i;
                                    input.read();
                                }
                                buf.append((char)ch1);
                                ** GOTO lbl121
                            }
                            default: {
                                throw new ParseException("Unexpected character after \\:" + input.next());
                            }
                        }
lbl119:
                        // 1 sources

                        buf.append(input.read());
lbl121:
                        // 8 sources

                        ch = input.next();
                    }
                    input.read();
                    ch = input.next();
                    if (ch == 'i') {
                        input.read();
                        last = last.append(Pattern.createCaseInsensitive(buf));
                        break;
                    }
                    length = buf.length();
                    pat = new Pattern();
                    for (x = 0; x < length; ++x) {
                        pat = pat.append(new Pattern(Character.valueOf(buf.charAt(x))));
                    }
                    last = last.append(pat);
                    break;
                }
                case '|': {
                    input.read();
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    last = null;
                    pattern = pattern.merge(Pattern.createIn(input));
                    return pattern;
                }
                case '-': {
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    input.read();
                    Pattern.skipWhitespaces(input);
                    ch = input.next();
                    if (ch != '\'' && ch != '\"') {
                        throw new ParseException("Unexpected character '" + ch + "'.");
                    }
                    input.read();
                    ch = input.next();
                    if (ch == '\'' || ch == '\"') {
                        throw new ParseException("Unexpected character '" + ch + "'.");
                    }
                    edge = Character.valueOf(input.next());
                    last = new Pattern(true, Collections.singleton(edge));
                    last = last.star().append(new Pattern(edge));
                    input.read();
                    ch = input.next();
                    while (ch != '\'' && ch != '\"') {
                        if (ch == '\u0000') {
                            throw new ParseException("Unexpected character '" + ch + "'.");
                        }
                        last = last.plus();
                        endN = last.dg.getEnds().iterator().next();
                        newE = Pattern.nodeFactory.createNode();
                        last.dg.addNode(newE);
                        last.dg.addEdge(endN, newE, Character.valueOf(input.next()));
                        last.dg.setEnds(Collections.singleton(newE));
                        input.read();
                        ch = input.next();
                    }
                    input.read();
                    break;
                }
                case ')': {
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    return pattern;
                }
                case '.': {
                    input.read();
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    last = new Pattern(Pattern.STAR);
                    break;
                }
                case '[': {
                    input.read();
                    if (last != null) {
                        pattern = pattern.append(last);
                    }
                    not = false;
                    ch = input.next();
                    if (ch == '^') {
                        input.read();
                        ch = input.next();
                        not = true;
                    }
                    set = new HashSet<Character>();
                    l = '\u0000';
                    minus = false;
                    ch = input.next();
                    while (ch != ']' && ch != '\u0000') {
                        switch (ch) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                input.read();
                                break;
                            }
                            case '\"': 
                            case '\'': {
                                ol = l;
                                if (l != '\u0000' && !minus) {
                                    set.add(Character.valueOf(l));
                                }
                                input.read();
                                ch = input.next();
                                if (ch == '\\') {
                                    input.read();
                                    ch = input.next();
                                    switch (ch) {
                                        case 'n': {
                                            l = '\n';
                                            break;
                                        }
                                        case 't': {
                                            l = '\t';
                                            break;
                                        }
                                        case 'r': {
                                            l = '\r';
                                            break;
                                        }
                                        case '\'': {
                                            l = '\'';
                                            break;
                                        }
                                        case '\\': {
                                            l = '\\';
                                            break;
                                        }
                                        case '\"': {
                                            l = '\"';
                                            break;
                                        }
                                        case 'u': {
                                            l = '\u0000';
                                            for (i = 4096; i >= 1; i /= 16) {
                                                input.read();
                                                c = input.next();
                                                ii = 0;
                                                if ('0' <= c && c <= '9') {
                                                    ii = c - 48;
                                                } else if ('a' <= c && c <= 'f') {
                                                    ii = c - 97 + 10;
                                                } else if ('A' <= c && c <= 'F') {
                                                    ii = c - 65 + 10;
                                                } else {
                                                    throw new ParseException("Unexpected character after \\u:" + c);
                                                }
                                                l = (char)(l + ii * i);
                                            }
                                            break;
                                        }
                                        default: {
                                            throw new ParseException("Unexpected character '" + ch + "'.");
                                        }
                                    }
                                    input.read();
                                } else {
                                    l = input.read();
                                }
                                ch = input.next();
                                if (ch != '\"' && ch != '\'') {
                                    throw new ParseException("Unexpected character '" + ch + "'.");
                                }
                                input.read();
                                if (minus) {
                                    Pattern.addInterval(set, ol, l);
                                    l = '\u0000';
                                }
                                minus = false;
                                break;
                            }
                            case '-': {
                                input.read();
                                if (l == '\u0000') {
                                    throw new ParseException("Unexpected character '-'.");
                                }
                                minus = true;
                                break;
                            }
                            default: {
                                throw new ParseException("Unexpected character '" + ch + "'.");
                            }
                        }
                        ch = input.next();
                    }
                    if (minus) {
                        throw new ParseException("Unexpected character '" + ch + "'.");
                    }
                    if (l != '\u0000') {
                        set.add(Character.valueOf(l));
                    }
                    input.read();
                    last = new Pattern(not, set);
                    break;
                }
                default: {
                    throw new ParseException("Unexpected character '" + ch + "'.");
                }
            }
            ch = input.next();
        }
        if (last != null) {
            pattern = pattern.append(last);
        }
        return pattern;
    }

    private static void skipWhitespaces(CharInput input) {
        while (whitespace.contains(Character.valueOf(input.next()))) {
            input.read();
        }
    }

    private static void addInterval(Set<Character> set, char from, char to) throws ParseException {
        if (from > to) {
            throw new ParseException("Invalid interval (" + from + ">" + to + ").");
        }
        do {
            set.add(Character.valueOf(from));
        } while ((from = (char)(from + '\u0001')) <= to);
    }

    private Pattern(DG<Integer, Character, Integer, TokenType> dg) {
        this.dg = dg;
    }

    private Pattern() {
        this.dg = DG.createDG(nodeFactory.createNode());
    }

    private Pattern(Pattern p) {
        this.dg = DGUtils.cloneDG(p.dg, false, nodeFactory);
    }

    private Pattern(Character edge) {
        Integer start = nodeFactory.createNode();
        this.dg = DG.createDG(start);
        Integer end = nodeFactory.createNode();
        this.dg.addNode(end);
        this.dg.addEdge(start, end, edge);
        this.dg.setEnds(Collections.singleton(end));
    }

    private Pattern(boolean not, Set<Character> edges) {
        Integer start = nodeFactory.createNode();
        this.dg = DG.createDG(start);
        Integer end = nodeFactory.createNode();
        this.dg.addNode(end);
        this.dg.setStart(start);
        this.dg.setEnds(Collections.emptySet());
        for (Character edge : edges) {
            this.dg.addEdge(start, end, edge);
        }
        if (not) {
            Integer failedState = nodeFactory.createNode();
            this.dg.addNode(failedState);
            this.dg.addEdge(start, failedState, STAR);
            this.dg.addEnd(failedState);
        } else {
            this.dg.addEnd(end);
        }
    }

    public Pattern clonePattern() {
        return new Pattern(this);
    }

    public Pattern star() {
        DG<Integer, Character, Integer, TokenType> ndg = DGUtils.plus(this.dg, STAR, nodeFactory);
        ndg = DGUtils.merge(DG.createDG(nodeFactory.createNode()), ndg, STAR, nodeFactory);
        Pattern p = new Pattern(ndg);
        return p;
    }

    public Pattern plus() {
        DG<Integer, Character, Integer, TokenType> ndg = DGUtils.plus(this.dg, STAR, nodeFactory);
        Pattern p = new Pattern(ndg);
        return p;
    }

    public Pattern question() {
        DG<Integer, Character, Integer, TokenType> ndg = DGUtils.cloneDG(this.dg, true, nodeFactory);
        ndg.addEnd(ndg.getStartNode());
        Pattern p = new Pattern(ndg);
        return p;
    }

    public Pattern merge(Pattern parser) {
        DG<Integer, Character, Integer, TokenType> ndg = DGUtils.merge(this.dg, parser.dg, STAR, nodeFactory);
        Pattern p = new Pattern(ndg);
        return p;
    }

    public Pattern append(Pattern parser) {
        DG<Integer, Character, Integer, TokenType> ndg = DGUtils.append(this.dg, parser.dg, STAR, nodeFactory);
        Pattern p = new Pattern(ndg);
        return p;
    }

    public boolean matches(String text) {
        int i = 0;
        Integer state = this.dg.getStartNode();
        while (i < text.length()) {
            if ((state = this.dg.getNode(state, Character.valueOf(text.charAt(i++)))) != null) continue;
            return false;
        }
        return this.dg.getEnds().contains(state);
    }

    public Integer next(CharInput input) {
        return this.next(this.dg.getStartNode(), input);
    }

    public Integer next(Integer state, CharInput input) {
        int lastIndex = input.getIndex();
        Integer lastState = null;
        while (state != null) {
            if (this.dg.getEnds().contains(state)) {
                lastState = state;
                lastIndex = input.getIndex();
            }
            if (input.eof()) break;
            Integer newState = this.dg.getNode(state, Character.valueOf(input.next()));
            if ((state = newState != null ? newState : this.dg.getNode(state, STAR)) == null) continue;
            input.read();
        }
        input.setIndex(lastIndex);
        return lastState;
    }

    public String toString() {
        return this.dg.toString();
    }

    public Object read(CharInput input) {
        if (input.eof()) {
            return null;
        }
        int originalIndex = input.getIndex();
        int lastIndex = -1;
        TokenType lastTT = null;
        Integer node = this.dg.getStartNode();
        while (!input.eof()) {
            TokenType bestTT;
            Character edge = Character.valueOf(input.next());
            Integer nnode = this.dg.getNode(node, edge);
            if (nnode == null) {
                edge = STAR;
                nnode = this.dg.getNode(node, edge);
            }
            if (input.getIndex() > originalIndex && (bestTT = this.getBestTT(node)) != null) {
                lastTT = bestTT;
                lastIndex = input.getIndex();
            }
            if (nnode == null || this.dg.getEdges(nnode).isEmpty() && this.dg.getProperties(nnode).isEmpty()) {
                if (lastTT == null) {
                    return null;
                }
                input.setIndex(lastIndex);
                return lastTT;
            }
            input.read();
            node = nnode;
        }
        TokenType bestTT = this.getBestTT(node);
        if (bestTT != null) {
            lastTT = bestTT;
            lastIndex = input.getIndex();
        }
        if (lastTT == null) {
            return null;
        }
        return lastTT;
    }

    private TokenType getBestTT(Integer node) {
        Map<Integer, TokenType> tts = this.dg.getProperties(node);
        TokenType best = null;
        for (Integer i : tts.keySet()) {
            TokenType tt = tts.get(i);
            if (best != null && best.getPriority() <= tt.getPriority()) continue;
            best = tt;
        }
        return best;
    }

    void mark(int priority, TokenType r) {
        for (Integer s : this.dg.getEnds()) {
            this.dg.setProperty(s, priority, r);
        }
    }

    static {
        whitespace.add(Character.valueOf(' '));
        whitespace.add(Character.valueOf('\n'));
        whitespace.add(Character.valueOf('\r'));
        whitespace.add(Character.valueOf('\t'));
    }
}

