/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomHandleStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private OperationPanel panel;
    private PanelBodyContainer component;
    private OperationWizardModel model = null;
    private WizardDescriptor wd = null;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_CUSTOM_INSTALL = "CustomHandleStep_Header_Install_Head";
    private static final String CONTENT_CUSTOM_INSTALL = "CustomHandleStep_Header_Install_Content";
    private static final String HEAD_CUSTOM_UNINSTALL = "CustomHandleStep_Header_Uninstall_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL = "CustomHandleStep_Header_Uninstall_Content";
    private static final String HEAD_CUSTOM_INSTALL_DONE = "CustomHandleStep_Header_InstallDone_Head";
    private static final String CONTENT_CUSTOM_INSTALL_DONE = "CustomHandleStep_Header_InstallDone_Content";
    private static final String HEAD_CUSTOM_UNINSTALL_DONE = "CustomHandleStep_Header_UninstallDone_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL_DONE = "CustomHandleStep_Header_UninstallDone_Content";
    private static final String HEAD_CUSTOM_INSTALL_FAIL = "CustomHandleStep_Header_InstallFail_Head";
    private static final String CONTENT_CUSTOM_INSTALL_FAIL = "CustomHandleStep_Header_InstallFail_Content";
    private static final String HEAD_CUSTOM_UNINSTALL_FAIL = "CustomHandleStep_Header_UninstallFail_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL_FAIL = "CustomHandleStep_Header_UninstallFail_Content";
    private static final String HEAD_CUSTOM_INSTALL_RESTART = "CustomHandleStep_Header_Install_Restart_Head";
    private static final String CONTENT_CUSTOM_INSTALL_RESTART = "CustomHandleStep_Header_Install_Restart_Content";
    private static final String HEAD_CUSTOM_UNINSTALL_RESTART = "CustomHandleStep_Header_Uninstall_Restart_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL_RESTART = "CustomHandleStep_Header_Uninstall_Restart_Content";
    private OperationSupport.Restarter restarter = null;
    private boolean isInstall = false;
    private boolean passed = false;
    private String errorMessage = null;
    private boolean done = false;
    private boolean wasStored = false;

    public CustomHandleStep(OperationWizardModel model) {
        this.model = model;
        this.isInstall = model instanceof InstallUnitWizardModel;
    }

    public boolean isFinishPanel() {
        return !this.model.hasStandardComponents();
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(false);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("run-action".equals(evt.getPropertyName())) {
                        CustomHandleStep.this.doHandleOperation();
                    }
                }
            });
            this.component = this.isInstall ? new PanelBodyContainer(this.getBundle(HEAD_CUSTOM_INSTALL, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL, new String[0]), this.panel) : new PanelBodyContainer(this.getBundle(HEAD_CUSTOM_UNINSTALL, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL, new String[0]), this.panel);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private void doHandleOperation() {
        this.restarter = null;
        if (this.handleOperation()) {
            if (this.isInstall) {
                if (this.restarter != null) {
                    this.presentInstallNeedsRestart();
                } else {
                    this.presentInstallDone();
                }
            } else if (this.restarter != null) {
                this.presentUninstallNeedsRestart();
            } else {
                this.presentUninstallDone();
            }
        } else if (this.isInstall) {
            this.presentInstallFail(this.errorMessage);
        } else {
            this.presentUninstallFail(this.errorMessage);
        }
        this.done = true;
        this.fireChange();
    }

    private boolean handleOperation() {
        final OperationSupport support = (OperationSupport)this.model.getCustomHandledContainer().getSupport();
        assert (support != null);
        this.passed = false;
        Runnable performOperation = new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressHandle handle = ProgressHandle.createHandle((String)(CustomHandleStep.this.isInstall ? CustomHandleStep.this.getBundle("CustomHandleStep_Install_InstallingPlugins", new String[0]) : CustomHandleStep.this.getBundle("CustomHandleStep_Uninstall_UninstallingPlugins", new String[0])));
                    JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
                    JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
                    JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
                    handle.setInitialDelay(0);
                    CustomHandleStep.this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
                    CustomHandleStep.this.restarter = support.doOperation(handle);
                    CustomHandleStep.this.passed = true;
                    CustomHandleStep.this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(CustomHandleStep.this.getBundle("CustomHandleStep_Done", new String[0])));
                }
                catch (OperationException ex) {
                    CustomHandleStep.this.log.log(Level.INFO, ex.getMessage(), ex);
                    CustomHandleStep.this.passed = false;
                    CustomHandleStep.this.errorMessage = ex.getLocalizedMessage();
                }
            }
        };
        performOperation.run();
        return this.passed;
    }

    private void presentInstallDone() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_INSTALL_DONE, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL_DONE, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        this.panel.setBody(this.getBundle("CustomHandleStep_InstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    private void presentInstallFail(String msg) {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_INSTALL_FAIL, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL_FAIL, new String[0]));
        this.model.modifyOptionsForDoClose(this.wd);
        this.panel.setBody(this.getBundle("CustomHandleStep_InstallFail_Text", msg), this.model.getCustomHandledComponents());
    }

    private void presentUninstallDone() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_UNINSTALL_DONE, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL_DONE, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        this.panel.setBody(this.getBundle("CustomHandleStep_UninstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    private void presentUninstallFail(String msg) {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_UNINSTALL_FAIL, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL_FAIL, new String[0]));
        this.model.modifyOptionsForDoClose(this.wd);
        this.panel.setBody(this.getBundle("CustomHandleStep_UninstallFail_Text", msg), this.model.getCustomHandledComponents());
    }

    private void presentInstallNeedsRestart() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_INSTALL_RESTART, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL_RESTART, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        if (this.isFinishPanel()) {
            this.panel.setRestartButtonsVisible(true);
        }
        this.panel.setBody(this.getBundle("CustomHandleStep_InstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    private void presentUninstallNeedsRestart() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_UNINSTALL_RESTART, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL_RESTART, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        if (this.isFinishPanel()) {
            this.panel.setRestartButtonsVisible(true);
        }
        this.panel.setBody(this.getBundle("CustomHandleStep_UninstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
        this.done = false;
        this.wasStored = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeSettings(WizardDescriptor wd) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wd.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue()) || WizardDescriptor.NEXT_OPTION.equals(wd.getValue())) {
            this.model.getCustomHandledContainer().removeAll();
            return;
        }
        if (this.restarter == null) {
            if (!WizardDescriptor.FINISH_OPTION.equals(wd.getValue())) return;
            this.model.getCustomHandledContainer().removeAll();
            return;
        }
        final OperationSupport support = (OperationSupport)this.model.getCustomHandledContainer().getSupport();
        assert (support != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getCustomHandledContainer().listAll() + " and invalid elements " + this.model.getCustomHandledContainer().listInvalid();
        if (this.panel.restartNow()) {
            try {
                support.doRestart(this.restarter, null);
                return;
            }
            catch (OperationException x) {
                this.log.log(Level.INFO, x.getMessage(), x);
                return;
            }
        }
        support.doRestartLater(this.restarter);
        this.model.getCustomHandledContainer().removeAll();
        Runnable onMouseClick = new Runnable(){

            @Override
            public void run() {
                try {
                    support.doRestart(CustomHandleStep.this.restarter, null);
                }
                catch (OperationException x) {
                    CustomHandleStep.this.log.log(Level.INFO, x.getMessage(), x);
                }
            }
        };
        InstallStep.notifyRestartNeeded(onMouseClick, this.getBundle(this.isInstall ? "CustomHandleStep_Install_RestartNeeded" : "CustomHandleStep_Uninstall_RestartNeeded", new String[0]));
    }

    public boolean isValid() {
        return this.done;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        CustomHandleStep customHandleStep = this;
        synchronized (customHandleStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key, String ... params) {
        return NbBundle.getMessage(CustomHandleStep.class, (String)key, (Object[])params);
    }
}

