/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.env.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.languages.env.EnvKeyHandle;
import org.netbeans.modules.languages.env.completion.KeyCompletionProposal;
import org.netbeans.modules.languages.env.lexer.EnvTokenId;
import org.netbeans.modules.languages.env.parser.EnvParserResult;
import org.openide.filesystems.FileObject;

public class EnvCompletionHandler
implements CodeCompletionHandler2 {
    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        return null;
    }

    public CodeCompletionResult complete(CodeCompletionContext context) {
        if (CancelSupport.getDefault().isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        if (!(context.getParserResult() instanceof EnvParserResult)) {
            return CodeCompletionResult.NONE;
        }
        EnvParserResult parserResult = (EnvParserResult)context.getParserResult();
        if (parserResult.getInterpolationOccurences().isEmpty()) {
            return CodeCompletionResult.NONE;
        }
        boolean isInInterpolationContext = false;
        block0: for (Map.Entry<String, List<OffsetRange>> entry : parserResult.getInterpolationOccurences().entrySet()) {
            for (OffsetRange range : entry.getValue()) {
                if (!range.containsInclusive(context.getCaretOffset())) continue;
                isInInterpolationContext = true;
                continue block0;
            }
        }
        if (!isInInterpolationContext) {
            return CodeCompletionResult.NONE;
        }
        int offset = context.getCaretOffset();
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        ArrayList<KeyCompletionProposal> completionProposals = new ArrayList<KeyCompletionProposal>();
        String contextPrefix = context.getPrefix();
        for (Map.Entry<String, OffsetRange> entry : parserResult.getDefinedKeys().entrySet()) {
            if (entry.getValue().getEnd() > offset || !entry.getKey().startsWith(contextPrefix)) continue;
            int anchorOffset = this.computeAnchorOffset(contextPrefix, offset);
            EnvKeyHandle handle = new EnvKeyHandle(entry.getKey(), fo);
            completionProposals.add(new KeyCompletionProposal(handle, anchorOffset));
        }
        return new DefaultCompletionResult(completionProposals, false);
    }

    public String document(ParserResult info, ElementHandle element) {
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return PrefixResolver.create(info, caretOffset).resolve();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        CodeCompletionHandler.QueryType result = CodeCompletionHandler.QueryType.ALL_COMPLETION;
        if (typedText.length() == 0 || typedText.isBlank()) {
            result = CodeCompletionHandler.QueryType.NONE;
        }
        return result;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private int computeAnchorOffset(@NonNull String prefix, int offset) {
        return offset - prefix.length();
    }

    private static final class PrefixResolver {
        private final ParserResult info;
        private final int offset;

        static PrefixResolver create(ParserResult info, int offset) {
            return new PrefixResolver(info, offset);
        }

        private PrefixResolver(ParserResult info, int offset) {
            this.info = info;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolve() {
            AbstractDocument doc = (AbstractDocument)this.info.getSnapshot().getSource().getDocument(false);
            doc.readLock();
            try {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(this.offset);
                ts.movePrevious();
                ts.moveNext();
                Token token = ts.token();
                String tokenText = token.text().toString();
                if (token.id().equals((Object)EnvTokenId.INTERPOLATION_OPERATOR)) {
                    if (tokenText.equals("{")) {
                        ts.moveNext();
                        token = ts.token();
                    } else {
                        ts.movePrevious();
                        token = ts.token();
                    }
                    if (token.id().equals((Object)EnvTokenId.INTERPOLATION_OPERATOR)) {
                        String string = token.text().toString();
                        return string;
                    }
                }
                String string = null;
                return string;
            }
            finally {
                doc.readUnlock();
            }
        }
    }
}

