/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Arrays;
import org.netbeans.modules.openide.util.GlobalLookup;
import org.openide.util.Lookup;
import org.openide.util.lookup.ExcludingLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.MetaInfServicesLookup;
import org.openide.util.lookup.SimpleLookup;
import org.openide.util.lookup.SimpleProxyLookup;
import org.openide.util.lookup.SingletonLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public class Lookups {
    private Lookups() {
    }

    public static Lookup singleton(Object objectToLookup) {
        if (objectToLookup == null) {
            throw new NullPointerException();
        }
        return new SingletonLookup(objectToLookup);
    }

    public static Lookup fixed(Object ... objectsToLookup) {
        if (objectsToLookup == null) {
            throw new NullPointerException();
        }
        if (objectsToLookup.length == 0) {
            return Lookup.EMPTY;
        }
        if (objectsToLookup.length == 1) {
            return Lookups.singleton(objectsToLookup[0]);
        }
        return new SimpleLookup(Arrays.asList(objectsToLookup));
    }

    public static <T, R> Lookup fixed(T[] keys, InstanceContent.Convertor<? super T, R> convertor) {
        if (keys == null) {
            throw new NullPointerException();
        }
        if (convertor == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Arrays.asList(keys), convertor);
    }

    public static Lookup proxy(Lookup.Provider provider) {
        return new SimpleProxyLookup(provider);
    }

    public static Lookup metaInfServices(ClassLoader classLoader) {
        return new MetaInfServicesLookup(classLoader, "META-INF/services/");
    }

    public static Lookup metaInfServices(ClassLoader classLoader, String prefix) {
        return new MetaInfServicesLookup(classLoader, prefix);
    }

    public static Lookup forPath(String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return NamedServicesProvider.forPath((String)path);
    }

    public static Lookup exclude(Lookup lookup, Class ... classes) {
        return new ExcludingLookup(lookup, classes);
    }

    public static <T> Lookup.Item<T> lookupItem(T instance, String id) {
        return new LookupItem<T>(instance, id);
    }

    public static void executeWith(Lookup defaultLookup, Runnable code) {
        if (!GlobalLookup.execute(defaultLookup, code)) {
            code.run();
        }
    }

    private static class LookupItem<T>
    extends Lookup.Item<T> {
        private String id;
        private T instance;

        public LookupItem(T instance) {
            this(instance, null);
        }

        public LookupItem(T instance, String id) {
            this.id = id;
            this.instance = instance;
        }

        @Override
        public String getDisplayName() {
            return this.getId();
        }

        @Override
        public String getId() {
            return this.id == null ? this.instance.toString() : this.id;
        }

        @Override
        public T getInstance() {
            return this.instance;
        }

        @Override
        public Class<? extends T> getType() {
            return this.instance.getClass();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupItem) {
                return this.instance == ((LookupItem)object).getInstance();
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

