/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.sync.Bundle;
import org.netbeans.modules.php.project.connections.sync.SummaryPanel;
import org.netbeans.modules.php.project.connections.sync.SyncController;
import org.netbeans.modules.php.project.connections.sync.SyncItem;
import org.netbeans.modules.php.project.connections.sync.diff.DiffPanel;
import org.netbeans.modules.php.project.ui.HintArea;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public final class SyncPanel
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 1674646546545121L;
    static final Logger LOGGER = Logger.getLogger(SyncPanel.class.getName());
    private static final String DIFF_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/diff.png";
    private static final String RESET_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/reset.png";
    private static final String ERROR_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/error.png";
    private static final String WARNING_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/warning.gif";
    private static final String HORIZONTAL_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/horizontal.png";
    private static final String HEADER_INFO_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/header_info.png";
    static final RequestProcessor RP = new RequestProcessor("PHP: Sync items validation & information");
    private static final List<SyncItem.Operation> OPERATIONS = Arrays.asList(SyncItem.Operation.NOOP, SyncItem.Operation.DOWNLOAD, SyncItem.Operation.UPLOAD, SyncItem.Operation.DELETE);
    final RemoteClient remoteClient;
    final List<SyncItem> allItems;
    final List<SyncItem> displayedItems;
    final FileTableModel tableModel;
    final JPopupMenu headerPopupMenu = new JPopupMenu();
    final JPopupMenu popupMenu = new JPopupMenu();
    boolean remotePathFirst = true;
    boolean selectionIsAdjusting = false;
    Point popupMenuPoint = new Point();
    List<? extends RowSorter.SortKey> sortKeys = Collections.singletonList(new RowSorter.SortKey(1, SortOrder.ASCENDING));
    private final PhpProject project;
    private final String remoteConfigurationName;
    private final String defaultInfoMessage;
    private final List<ViewCheckBox> viewCheckBoxes;
    private final ItemListener viewListener = new ViewListener();
    private PopupMenuListener popupMenuListener;
    private DialogDescriptor descriptor = null;
    private Boolean rememberShowSummary = null;
    private JButton okButton = null;
    private JButton checkAllButton;
    private JButton deleteButton;
    private JButton diffButton;
    private JButton downloadButton;
    private JScrollPane itemScrollPane;
    private JTable itemTable;
    private JScrollPane messagesScrollPane;
    private JTextPane messagesTextPane;
    private JButton noopButton;
    private JPanel operationButtonsPanel;
    private JPanel operationsPanel;
    private JPanel problemsPanel;
    private JButton resetButton;
    private JCheckBox showSummaryCheckBox;
    private JPanel spaceHolderPanel;
    private JLabel syncInfoLabel;
    private JPanel syncInfoPanel;
    private JButton uncheckAllButton;
    private JButton uploadButton;
    private JCheckBox viewDeleteCheckBox;
    private JCheckBox viewDownloadCheckBox;
    private JCheckBox viewErrorCheckBox;
    private JCheckBox viewFileConflictCheckBox;
    private JCheckBox viewFileDirCollisionCheckBox;
    private JCheckBox viewNoopCheckBox;
    private JCheckBox viewSymlinkCheckBox;
    private JCheckBox viewUploadCheckBox;
    private JCheckBox viewWarningCheckBox;

    SyncPanel(PhpProject project, String remoteConfigurationName, List<SyncItem> items, RemoteClient remoteClient, SyncController.SourceFiles sourceFiles) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (items != null);
        this.project = project;
        this.remoteConfigurationName = remoteConfigurationName;
        this.allItems = new CopyOnWriteArrayList<SyncItem>(items);
        this.displayedItems = new ArrayList<SyncItem>(items);
        this.remoteClient = remoteClient;
        this.tableModel = new FileTableModel(this.displayedItems);
        this.defaultInfoMessage = this.getDefaultInfoMessage(items, sourceFiles);
        this.initComponents();
        this.viewCheckBoxes = this.getViewCheckBoxes();
        this.initViewCheckBoxes();
        this.initViewButtons();
        this.initTable();
        this.initOperationButtons();
        this.initDiffButton();
        this.initMessages();
        this.initShowSummaryCheckBox(sourceFiles == SyncController.SourceFiles.PROJECT);
    }

    private JCheckBox createViewCheckBox() {
        ViewCheckBox viewCheckBox = new ViewCheckBox();
        viewCheckBox.setSelected(true);
        viewCheckBox.addItemListener(this.viewListener);
        return viewCheckBox;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.connections.sync.SyncPanel");
    }

    public boolean open() {
        boolean okPressed;
        assert (SwingUtilities.isEventDispatchThread());
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)Bundle.SyncPanel_button_titleWithMnemonics());
        this.descriptor = new DialogDescriptor((Object)this, Bundle.SyncPanel_title(this.project.getName(), this.remoteConfigurationName), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.okButton.addActionListener(new OkActionListener(dialog));
        this.descriptor.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        this.descriptor.setAdditionalOptions(new Object[]{this.showSummaryCheckBox});
        this.validateItems();
        this.updateSyncInfo();
        try {
            dialog.setVisible(true);
            okPressed = this.descriptor.getValue() == this.okButton;
        }
        finally {
            dialog.dispose();
        }
        return okPressed;
    }

    public List<SyncItem> getItems() {
        assert (SwingUtilities.isEventDispatchThread());
        return new ArrayList<SyncItem>(this.allItems);
    }

    private List<ViewCheckBox> getViewCheckBoxes() {
        return Arrays.asList((ViewCheckBox)this.viewNoopCheckBox, (ViewCheckBox)this.viewDownloadCheckBox, (ViewCheckBox)this.viewUploadCheckBox, (ViewCheckBox)this.viewDeleteCheckBox, (ViewCheckBox)this.viewSymlinkCheckBox, (ViewCheckBox)this.viewFileDirCollisionCheckBox, (ViewCheckBox)this.viewFileConflictCheckBox, (ViewCheckBox)this.viewWarningCheckBox, (ViewCheckBox)this.viewErrorCheckBox);
    }

    private void initViewCheckBoxes() {
        this.initViewCheckBox(this.viewNoopCheckBox, SyncItem.Operation.NOOP);
        this.initViewCheckBox(this.viewDownloadCheckBox, EnumSet.of(SyncItem.Operation.DOWNLOAD, SyncItem.Operation.DOWNLOAD_REVIEW));
        this.initViewCheckBox(this.viewUploadCheckBox, EnumSet.of(SyncItem.Operation.UPLOAD, SyncItem.Operation.UPLOAD_REVIEW));
        this.initViewCheckBox(this.viewDeleteCheckBox, SyncItem.Operation.DELETE);
        this.initViewCheckBox(this.viewSymlinkCheckBox, SyncItem.Operation.SYMLINK);
        this.initViewCheckBox(this.viewFileDirCollisionCheckBox, SyncItem.Operation.FILE_DIR_COLLISION);
        this.initViewCheckBox(this.viewFileConflictCheckBox, SyncItem.Operation.FILE_CONFLICT);
        this.initViewCheckBox(this.viewWarningCheckBox, Bundle.SyncPanel_view_warning());
        this.initViewCheckBox(this.viewErrorCheckBox, Bundle.SyncPanel_view_error());
        ((ViewCheckBox)this.viewWarningCheckBox).setFilter(new SyncItemFilter(){

            @Override
            public boolean accept(SyncItem syncItem) {
                return syncItem.validate().hasWarning();
            }
        });
        ((ViewCheckBox)this.viewErrorCheckBox).setFilter(new SyncItemFilter(){

            @Override
            public boolean accept(SyncItem syncItem) {
                return syncItem.validate().hasError();
            }
        });
    }

    private void initViewCheckBox(JCheckBox checkBox, SyncItem.Operation operation) {
        this.initViewCheckBox(checkBox, EnumSet.of(operation));
    }

    private void initViewCheckBox(JCheckBox checkBox, final EnumSet<SyncItem.Operation> operations) {
        SyncItem.Operation operation = (SyncItem.Operation)((Object)operations.iterator().next());
        this.initViewCheckBox(checkBox, operation.getTitleWithMnemonic());
        ((ViewCheckBox)checkBox).setFilter(new SyncItemFilter(){

            @Override
            public boolean accept(SyncItem syncItem) {
                return operations.contains((Object)syncItem.getOperation());
            }
        });
    }

    private void initViewCheckBox(JCheckBox checkBox, String titleWithMnemonic) {
        Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)titleWithMnemonic);
    }

    private void initViewButtons() {
        this.checkAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncPanel.this.setViewCheckBoxesSelected(true);
            }
        });
        this.uncheckAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncPanel.this.setViewCheckBoxesSelected(false);
            }
        });
    }

    private void initTable() {
        assert (SwingUtilities.isEventDispatchThread());
        this.initTableModel();
        this.initTableSorter();
        this.initTableRenderers();
        this.initTableHeader();
        this.initTableRows();
        this.initTableColumns();
        this.initTableSelections();
        this.initTableActions();
        this.initTableHeaderPopupMenu();
        this.initTablePopupMenu();
    }

    private void reinitTable() {
        assert (SwingUtilities.isEventDispatchThread());
        this.initTableSorter();
        this.initTableHeader();
        this.initTableRows();
        this.initTableColumns();
        this.initTableHeaderPopupMenu();
        this.initTablePopupMenu();
    }

    private void initTableModel() {
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SyncPanel.this.validateItems();
                SyncPanel.this.updateSyncInfo();
            }
        });
        this.itemTable.setModel(this.tableModel);
    }

    private void initTableSorter() {
        TableRowSorter<FileTableModel> sorter = new TableRowSorter<FileTableModel>(this.tableModel);
        this.itemTable.setRowSorter(sorter);
        sorter.setSortKeys(this.sortKeys);
        sorter.setComparator(0, new SyncItemImageIconComparator());
        sorter.setSortable(2, false);
    }

    private void initTableRenderers() {
        this.itemTable.setDefaultRenderer(Icon.class, new IconRenderer());
        this.itemTable.setDefaultRenderer(String.class, new StringRenderer());
        this.itemTable.setDefaultRenderer(SyncItem.Operation.class, new OperationRenderer());
    }

    private void initTableHeader() {
        JTableHeader header = this.itemTable.getTableHeader();
        header.setPreferredSize(new Dimension(this.itemTable.getColumnModel().getTotalColumnWidth(), Math.max(20, this.itemTable.getFont().getSize() + 5)));
        header.setReorderingAllowed(false);
        TableColumn infoColumn = header.getColumnModel().getColumn(0);
        infoColumn.setHeaderRenderer(new HeaderRenderer(Bundle.SyncPanel_table_header_info_toolTip()));
        infoColumn.setHeaderValue(ImageUtilities.loadImageIcon((String)HEADER_INFO_ICON_PATH, (boolean)false));
        TableColumn operationColumn = header.getColumnModel().getColumn(2);
        operationColumn.setHeaderRenderer(new HeaderRenderer(Bundle.SyncPanel_table_header_operation_toolTip()));
        operationColumn.setHeaderValue(ImageUtilities.loadImageIcon((String)HORIZONTAL_ICON_PATH, (boolean)false));
        TableColumn remotePathColumn = header.getColumnModel().getColumn(this.remotePathFirst ? 1 : 3);
        remotePathColumn.setHeaderRenderer(new HeaderRenderer(Bundle.SyncPanel_table_header_remotePath_toolTip()));
        TableColumn localPathColumn = header.getColumnModel().getColumn(this.remotePathFirst ? 3 : 1);
        localPathColumn.setHeaderRenderer(new HeaderRenderer(Bundle.SyncPanel_table_header_localPath_toolTip()));
        this.itemTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SyncPanel.this.itemTable.columnAtPoint(e.getPoint()) == 2) {
                    SyncPanel.this.swapPaths();
                }
            }
        });
    }

    private void initTableRows() {
        this.itemTable.setRowHeight(Math.max(20, this.itemTable.getFont().getSize() + 5));
    }

    private void initTableColumns() {
        TableColumnModel columnModel = this.itemTable.getColumnModel();
        columnModel.getColumn(0).setMinWidth(20);
        columnModel.getColumn(0).setMaxWidth(20);
        columnModel.getColumn(0).setResizable(false);
        columnModel.getColumn(1).setPreferredWidth(1000);
        columnModel.getColumn(2).setMinWidth(40);
        columnModel.getColumn(2).setPreferredWidth(40);
        columnModel.getColumn(3).setPreferredWidth(1000);
    }

    private void initTableSelections() {
        this.itemTable.setColumnSelectionAllowed(false);
        this.itemTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                if (SyncPanel.this.selectionIsAdjusting) {
                    return;
                }
                SyncPanel.this.updateSyncInfo();
                SyncPanel.this.setEnabledOperationButtons();
                SyncPanel.this.setEnabledDiffButton();
            }
        });
    }

    private void initTableActions() {
        this.itemTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SyncPanel.this.headerPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.itemTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    if (SyncPanel.this.itemTable.getSelectedColumn() == 2) {
                        SyncPanel.this.cycleOperations();
                    }
                } else if (e.getClickCount() == 2 && SyncPanel.this.isDiffActionPossible(false)) {
                    SyncPanel.this.openDiffPanel();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SyncPanel.this.popupMenuPoint.x = e.getX();
                    SyncPanel.this.popupMenuPoint.y = e.getY();
                    SyncPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void initTableHeaderPopupMenu() {
        assert (SwingUtilities.isEventDispatchThread());
        this.headerPopupMenu.removeAll();
        JMenuItem swapMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_swapPaths());
        swapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncPanel.this.swapPaths();
            }
        });
        this.headerPopupMenu.add(swapMenuItem);
        this.headerPopupMenu.addSeparator();
        JMenuItem sortLocalAscMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_sort_local_asc());
        sortLocalAscMenuItem.addActionListener(new SortPopupMenuItemListener(this.remotePathFirst ? 3 : 1, SortOrder.ASCENDING));
        this.headerPopupMenu.add(sortLocalAscMenuItem);
        JMenuItem sortRemoteAscMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_sort_remote_asc());
        sortRemoteAscMenuItem.addActionListener(new SortPopupMenuItemListener(this.remotePathFirst ? 1 : 3, SortOrder.ASCENDING));
        this.headerPopupMenu.add(sortRemoteAscMenuItem);
        JMenuItem sortLocalDescMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_sort_local_desc());
        sortLocalDescMenuItem.addActionListener(new SortPopupMenuItemListener(this.remotePathFirst ? 3 : 1, SortOrder.DESCENDING));
        this.headerPopupMenu.add(sortLocalDescMenuItem);
        JMenuItem sortRemoteDescMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_sort_remote_desc());
        sortRemoteDescMenuItem.addActionListener(new SortPopupMenuItemListener(this.remotePathFirst ? 1 : 3, SortOrder.DESCENDING));
        this.headerPopupMenu.add(sortRemoteDescMenuItem);
        JMenuItem sortInfoMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_sort_info());
        sortInfoMenuItem.addActionListener(new SortPopupMenuItemListener(0, SortOrder.DESCENDING));
        this.headerPopupMenu.add(sortInfoMenuItem);
    }

    private void initTablePopupMenu() {
        assert (SwingUtilities.isEventDispatchThread());
        this.popupMenu.removeAll();
        if (this.popupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.popupMenuListener);
        }
        final JMenuItem resetMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_resetItem(), ImageUtilities.loadImageIcon((String)RESET_ICON_PATH, (boolean)false));
        resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SyncItem> selectedItems = SyncPanel.this.getSelectedItems(true);
                for (SyncItem item : selectedItems) {
                    if (!item.isOperationChangePossible()) continue;
                    item.resetOperation();
                }
                SyncPanel.this.updateDisplayedItems();
                SyncPanel.this.reselectItems(selectedItems);
            }
        });
        this.popupMenu.add(resetMenuItem);
        this.popupMenu.addSeparator();
        final JMenuItem operationNoopMenuItem = new JMenuItem(SyncItem.Operation.NOOP.getToolTip(), SyncItem.Operation.NOOP.getIcon(!this.remotePathFirst));
        operationNoopMenuItem.addActionListener(new PopupMenuItemListener(SyncItem.Operation.NOOP));
        this.popupMenu.add(operationNoopMenuItem);
        final JMenuItem operationDownloadMenuItem = new JMenuItem(SyncItem.Operation.DOWNLOAD.getToolTip(), SyncItem.Operation.DOWNLOAD.getIcon(!this.remotePathFirst));
        operationDownloadMenuItem.addActionListener(new PopupMenuItemListener(SyncItem.Operation.DOWNLOAD));
        this.popupMenu.add(operationDownloadMenuItem);
        final JMenuItem operationUploadMenuItem = new JMenuItem(SyncItem.Operation.UPLOAD.getToolTip(), SyncItem.Operation.UPLOAD.getIcon(!this.remotePathFirst));
        operationUploadMenuItem.addActionListener(new PopupMenuItemListener(SyncItem.Operation.UPLOAD));
        this.popupMenu.add(operationUploadMenuItem);
        final JMenuItem operationDeleteMenuItem = new JMenuItem(SyncItem.Operation.DELETE.getToolTip(), SyncItem.Operation.DELETE.getIcon(!this.remotePathFirst));
        operationDeleteMenuItem.addActionListener(new PopupMenuItemListener(SyncItem.Operation.DELETE));
        this.popupMenu.add(operationDeleteMenuItem);
        this.popupMenu.addSeparator();
        final JMenuItem disableDownloadsMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_disable_download());
        disableDownloadsMenuItem.addActionListener(new PopupMenuItemListener(Arrays.asList(SyncItem.Operation.DOWNLOAD, SyncItem.Operation.DOWNLOAD_REVIEW), SyncItem.Operation.NOOP));
        this.popupMenu.add(disableDownloadsMenuItem);
        final JMenuItem disableUploadsMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_disable_upload());
        disableUploadsMenuItem.addActionListener(new PopupMenuItemListener(Arrays.asList(SyncItem.Operation.UPLOAD, SyncItem.Operation.UPLOAD_REVIEW), SyncItem.Operation.NOOP));
        this.popupMenu.add(disableUploadsMenuItem);
        final JMenuItem disableDeletionsMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_disable_delete());
        disableDeletionsMenuItem.addActionListener(new PopupMenuItemListener(SyncItem.Operation.DELETE, SyncItem.Operation.NOOP));
        this.popupMenu.add(disableDeletionsMenuItem);
        this.popupMenu.addSeparator();
        final JMenuItem diffMenuItem = new JMenuItem(Bundle.SyncPanel_popupMenu_diffItem(), ImageUtilities.loadImageIcon((String)DIFF_ICON_PATH, (boolean)false));
        diffMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncPanel.this.openDiffPanel();
            }
        });
        this.popupMenu.add(diffMenuItem);
        this.popupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean operationChangesPossible = SyncPanel.this.areOperationChangesPossible(SyncPanel.this.getSelectedItems(true));
                resetMenuItem.setEnabled(operationChangesPossible);
                operationNoopMenuItem.setEnabled(operationChangesPossible);
                operationDownloadMenuItem.setEnabled(operationChangesPossible);
                operationUploadMenuItem.setEnabled(operationChangesPossible);
                operationDeleteMenuItem.setEnabled(operationChangesPossible);
                disableDownloadsMenuItem.setEnabled(operationChangesPossible);
                disableUploadsMenuItem.setEnabled(operationChangesPossible);
                disableDeletionsMenuItem.setEnabled(operationChangesPossible);
                diffMenuItem.setEnabled(SyncPanel.this.isDiffActionPossible(true));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    private void initOperationButtons() {
        this.initOperationButton(this.noopButton, SyncItem.Operation.NOOP);
        this.initOperationButton(this.downloadButton, SyncItem.Operation.DOWNLOAD);
        this.initOperationButton(this.uploadButton, SyncItem.Operation.UPLOAD);
        this.initOperationButton(this.deleteButton, SyncItem.Operation.DELETE);
        this.initResetButton();
    }

    private void initOperationButton(JButton button, SyncItem.Operation operation) {
        button.setText(null);
        button.setIcon(operation.getIcon(!this.remotePathFirst));
        button.setToolTipText(operation.getToolTip());
        button.addActionListener(new OperationButtonListener(operation));
    }

    private void reinitOperationButtons() {
        this.reinitOperationButton(this.noopButton, SyncItem.Operation.NOOP);
        this.reinitOperationButton(this.downloadButton, SyncItem.Operation.DOWNLOAD);
        this.reinitOperationButton(this.uploadButton, SyncItem.Operation.UPLOAD);
        this.reinitOperationButton(this.deleteButton, SyncItem.Operation.DELETE);
    }

    private void reinitOperationButton(JButton button, SyncItem.Operation operation) {
        button.setIcon(operation.getIcon(!this.remotePathFirst));
    }

    private void initResetButton() {
        this.resetButton.setText(null);
        this.resetButton.setIcon(ImageUtilities.loadImageIcon((String)RESET_ICON_PATH, (boolean)false));
        this.resetButton.setToolTipText(Bundle.SyncPanel_resetButton_toolTip());
        this.resetButton.addActionListener(new OperationButtonListener(null));
    }

    private void initDiffButton() {
        this.diffButton.setText(null);
        this.diffButton.setIcon(ImageUtilities.loadImageIcon((String)DIFF_ICON_PATH, (boolean)false));
        this.diffButton.setToolTipText(Bundle.SyncPanel_diffButton_toolTip());
        this.diffButton.addActionListener(new DiffActionListener());
    }

    private void initMessages() {
        this.syncInfoPanel.setBackground(Utils.getHintBackground());
        this.syncInfoPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, UIManager.getColor("Table.gridColor")));
        this.messagesTextPane.setText(this.defaultInfoMessage);
    }

    private String getDefaultInfoMessage(List<SyncItem> items, SyncController.SourceFiles sourceFiles) {
        StringBuilder msg = new StringBuilder();
        boolean firstRun = false;
        for (SyncItem item : items) {
            if (item.hasLastTimestamp()) continue;
            firstRun = true;
            break;
        }
        if (firstRun) {
            msg.append(Bundle.SyncPanel_info_firstRun());
        }
        if (sourceFiles == SyncController.SourceFiles.INDIVIDUAL_FILES) {
            msg.append(Bundle.SyncPanel_info_files());
        }
        msg.append(Bundle.SyncPanel_info_warning());
        return msg.toString();
    }

    private void initShowSummaryCheckBox(boolean showSummary) {
        if (!showSummary) {
            this.showSummaryCheckBox.setVisible(false);
            return;
        }
        this.showSummaryCheckBox.setSelected(PhpOptions.getInstance().getRemoteSyncShowSummary());
        this.showSummaryCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SyncPanel.this.rememberShowSummary = e.getStateChange() == 1;
            }
        });
    }

    void setEnabledOperationButtons() {
        boolean enabled = this.areOperationChangesPossible(this.getSelectedItems(false));
        this.noopButton.setEnabled(enabled);
        this.downloadButton.setEnabled(enabled);
        this.uploadButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
    }

    private boolean areOperationChangesPossible(List<SyncItem> selectedItems) {
        assert (SwingUtilities.isEventDispatchThread());
        if (selectedItems.isEmpty()) {
            return false;
        }
        for (SyncItem item : selectedItems) {
            if (!item.isOperationChangePossible()) continue;
            return true;
        }
        return false;
    }

    boolean isDiffActionPossible(boolean includingMousePosition) {
        List<SyncItem> selectedItems = this.getSelectedItems(includingMousePosition);
        if (selectedItems.size() != 1) {
            return false;
        }
        return selectedItems.get(0).isDiffPossible();
    }

    void setEnabledDiffButton() {
        this.diffButton.setEnabled(this.isDiffActionPossible(false));
    }

    SyncItem getSelectedItem(boolean includingMousePosition) {
        assert (SwingUtilities.isEventDispatchThread());
        List<SyncItem> selectedItems = this.getSelectedItems(includingMousePosition);
        if (selectedItems.size() == 1) {
            return selectedItems.get(0);
        }
        return null;
    }

    void reselectItem(SyncItem syncItem) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (this.itemTable.getSelectedRowCount() <= 1) : "Selected rows in table: " + this.itemTable.getSelectedRowCount();
        Integer index = this.itemsToIndex(this.displayedItems).get(syncItem);
        if (index != null) {
            index = this.itemTable.convertRowIndexToView(index);
            this.itemTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    List<SyncItem> getSelectedItems(boolean includingMousePosition) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] selectedRows = this.itemTable.getSelectedRows();
        if (selectedRows.length == 0) {
            if (includingMousePosition) {
                return Collections.singletonList(this.displayedItems.get(this.itemTable.convertRowIndexToModel(this.itemTable.rowAtPoint(this.popupMenuPoint))));
            }
            return Collections.emptyList();
        }
        ArrayList<SyncItem> selectedItems = new ArrayList<SyncItem>(selectedRows.length);
        for (int index : selectedRows) {
            SyncItem syncItem = this.displayedItems.get(this.itemTable.convertRowIndexToModel(index));
            selectedItems.add(syncItem);
        }
        return selectedItems;
    }

    void reselectItems(List<SyncItem> selectedItems) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<Integer> selectedRows = new ArrayList<Integer>(selectedItems.size());
        Map<SyncItem, Integer> itemsToIndex = this.itemsToIndex(this.displayedItems);
        if (!itemsToIndex.isEmpty()) {
            for (SyncItem item : selectedItems) {
                Integer index = itemsToIndex.get(item);
                if (index == null) continue;
                selectedRows.add(this.itemTable.convertRowIndexToView(index));
            }
        }
        this.selectionIsAdjusting = true;
        Iterator<Pair<Integer, Integer>> iterator = PhpProjectUtils.getIntervals(selectedRows).iterator();
        while (iterator.hasNext()) {
            Pair<Integer, Integer> pair = iterator.next();
            if (!iterator.hasNext()) {
                this.selectionIsAdjusting = false;
            }
            this.itemTable.getSelectionModel().addSelectionInterval((Integer)pair.first(), (Integer)pair.second());
        }
        this.selectionIsAdjusting = false;
    }

    void validateItems() {
        assert (SwingUtilities.isEventDispatchThread());
        this.invalidatePanel();
        RP.post(new Runnable(){

            @Override
            public void run() {
                boolean warn = false;
                for (SyncItem syncItem : SyncPanel.this.allItems) {
                    SyncItem.ValidationResult validationResult = syncItem.validate();
                    if (validationResult.hasError()) {
                        SyncPanel.this.setError(Bundle.SyncPanel_error_operations());
                        return;
                    }
                    if (!validationResult.hasWarning()) continue;
                    warn = true;
                }
                if (warn) {
                    SyncPanel.this.setWarning(Bundle.SyncPanel_warn_operations());
                } else {
                    SyncPanel.this.clearError();
                }
            }
        });
    }

    void setError(final String error) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                String msg = SyncPanel.this.getImgTag(SyncPanel.ERROR_ICON_PATH) + SyncPanel.this.getColoredText(error, UIManager.getColor("nb.errorForeground")) + "<br>" + SyncPanel.this.defaultInfoMessage;
                SyncPanel.this.messagesTextPane.setText(msg);
                SyncPanel.this.descriptor.setValid(false);
                SyncPanel.this.okButton.setEnabled(false);
            }
        });
    }

    void setWarning(final String warning) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                String msg = SyncPanel.this.getImgTag(SyncPanel.WARNING_ICON_PATH) + SyncPanel.this.getColoredText(warning, UIManager.getColor("nb.warningForeground")) + "<br>" + SyncPanel.this.defaultInfoMessage;
                SyncPanel.this.messagesTextPane.setText(msg);
                SyncPanel.this.descriptor.setValid(true);
                SyncPanel.this.okButton.setEnabled(true);
            }
        });
    }

    void clearError() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                SyncPanel.this.messagesTextPane.setText(SyncPanel.this.defaultInfoMessage);
                SyncPanel.this.descriptor.setValid(true);
                SyncPanel.this.okButton.setEnabled(true);
            }
        });
    }

    void invalidatePanel() {
        assert (SwingUtilities.isEventDispatchThread());
        this.messagesTextPane.setText(Bundle.SyncPanel_collectingInformation());
        this.descriptor.setValid(false);
        this.okButton.setEnabled(false);
    }

    private String getImgTag(String src) {
        return "<img src=\"" + SyncPanel.class.getClassLoader().getResource(src).toExternalForm() + "\">&nbsp;";
    }

    private String getColoredText(String text, Color color) {
        String colorText = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        return "<span style=\"color: " + colorText + ";\">" + text + "</span>";
    }

    void updateSyncInfo() {
        assert (SwingUtilities.isEventDispatchThread());
        this.syncInfoLabel.setText(Bundle.SyncPanel_collectingInformation());
        final CopyOnWriteArrayList<SyncItem> selectedItems = new CopyOnWriteArrayList<SyncItem>(this.getSelectedItems(false));
        RP.post(new Runnable(){

            @Override
            public void run() {
                List<SyncItem> selectedItemsCopy = selectedItems;
                if (selectedItemsCopy.size() == 1) {
                    final SyncItem syncItem = (SyncItem)selectedItemsCopy.get(0);
                    final SyncItem.ValidationResult result = syncItem.validate();
                    if (result.hasError()) {
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                SyncPanel.this.syncInfoLabel.setForeground(UIManager.getColor("nb.errorForeground"));
                                SyncPanel.this.syncInfoLabel.setText(Bundle.SyncPanel_info_prefix_error(syncItem.getName(), result.getMessage()));
                            }
                        });
                        return;
                    }
                    if (result.hasWarning()) {
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                SyncPanel.this.syncInfoLabel.setForeground(UIManager.getColor("nb.warningForeground"));
                                SyncPanel.this.syncInfoLabel.setText(Bundle.SyncPanel_info_prefix_warning(syncItem.getName(), result.getMessage()));
                            }
                        });
                        return;
                    }
                    selectedItemsCopy.clear();
                }
                boolean all = false;
                if (selectedItemsCopy.isEmpty()) {
                    all = true;
                    selectedItemsCopy = SyncPanel.this.allItems;
                }
                SyncInfo syncInfo = SyncPanel.this.getSyncInfo(selectedItemsCopy);
                String info = Bundle.SyncPanel_info_status(syncInfo.download, syncInfo.upload, syncInfo.delete, syncInfo.noop, syncInfo.errors, syncInfo.warnings);
                final String msg = all ? Bundle.SyncPanel_info_prefix_all(info) : Bundle.SyncPanel_info_prefix_selection(info);
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        SyncPanel.this.syncInfoLabel.setForeground(UIManager.getColor("Label.foreground"));
                        SyncPanel.this.syncInfoLabel.setText(msg);
                    }
                });
            }
        });
    }

    public SyncInfo getSyncInfo(List<SyncItem> items) {
        SyncInfo syncInfo = new SyncInfo();
        block8: for (SyncItem syncItem : items) {
            SyncItem.ValidationResult validationResult = syncItem.validate();
            if (validationResult.hasError()) {
                ++syncInfo.errors;
            } else if (validationResult.hasWarning()) {
                ++syncInfo.warnings;
            }
            switch (syncItem.getOperation()) {
                case SYMLINK: {
                    continue block8;
                }
                case NOOP: {
                    ++syncInfo.noop;
                    continue block8;
                }
                case DOWNLOAD: 
                case DOWNLOAD_REVIEW: {
                    ++syncInfo.download;
                    continue block8;
                }
                case UPLOAD: 
                case UPLOAD_REVIEW: {
                    ++syncInfo.upload;
                    continue block8;
                }
                case DELETE: {
                    ++syncInfo.delete;
                    continue block8;
                }
                case FILE_CONFLICT: 
                case FILE_DIR_COLLISION: {
                    continue block8;
                }
            }
            assert (false) : "Unknown operation: " + syncItem.getOperation();
        }
        return syncInfo;
    }

    void openDiffPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        SyncItem syncItem = this.getSelectedItem(true);
        if (syncItem == null) {
            return;
        }
        DiffPanel diffPanel = new DiffPanel(this.remoteClient, syncItem, ProjectPropertiesSupport.getEncoding(this.project));
        try {
            if (diffPanel.open()) {
                syncItem.setOperation(SyncItem.Operation.UPLOAD);
                this.updateDisplayedItems();
                this.reselectItem(syncItem);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error while saving document", ex);
            this.setError(Bundle.SyncPanel_error_documentSave());
        }
    }

    void cycleOperations() {
        SyncItem syncItem = this.getSelectedItem(false);
        if (syncItem == null) {
            return;
        }
        int index = OPERATIONS.indexOf((Object)syncItem.getOperation());
        if (index != -1) {
            index = index == OPERATIONS.size() - 1 ? 0 : ++index;
            syncItem.setOperation(OPERATIONS.get(index));
            this.updateDisplayedItems();
            this.reselectItem(syncItem);
        }
    }

    void setViewCheckBoxesSelected(boolean selected) {
        for (ViewCheckBox checkBox : this.viewCheckBoxes) {
            checkBox.setSelected(selected);
        }
    }

    void updateDisplayedItems() {
        assert (SwingUtilities.isEventDispatchThread());
        this.displayedItems.clear();
        List<ViewCheckBox> selectedViewCheckBoxes = this.getSelectedViewCheckBoxes();
        if (!selectedViewCheckBoxes.isEmpty()) {
            block0: for (SyncItem syncItem : this.allItems) {
                for (ViewCheckBox checkBox : selectedViewCheckBoxes) {
                    if (!checkBox.getFilter().accept(syncItem)) continue;
                    this.displayedItems.add(syncItem);
                    continue block0;
                }
            }
        }
        this.tableModel.fireSyncItemsChange();
    }

    void swapPaths() {
        assert (SwingUtilities.isEventDispatchThread());
        this.remotePathFirst = !this.remotePathFirst;
        this.sortKeys = this.adjustSortKeys(this.itemTable.getRowSorter().getSortKeys());
        List<SyncItem> selectedItems = this.getSelectedItems(false);
        this.tableModel.fireTableHeaderChanged();
        this.reinitTable();
        this.reinitOperationButtons();
        this.reselectItems(selectedItems);
    }

    private List<? extends RowSorter.SortKey> adjustSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        ArrayList<? extends RowSorter.SortKey> currentKeys = new ArrayList<RowSorter.SortKey>(sortKeys);
        ArrayList<RowSorter.SortKey> newKeys = new ArrayList<RowSorter.SortKey>(currentKeys.size());
        for (RowSorter.SortKey sortKey : currentKeys) {
            int column = sortKey.getColumn();
            RowSorter.SortKey newSortKey = column == 1 ? new RowSorter.SortKey(3, sortKey.getSortOrder()) : (column == 3 ? new RowSorter.SortKey(1, sortKey.getSortOrder()) : sortKey);
            newKeys.add(newSortKey);
        }
        return newKeys;
    }

    private List<ViewCheckBox> getSelectedViewCheckBoxes() {
        ArrayList<ViewCheckBox> selected = new ArrayList<ViewCheckBox>(this.viewCheckBoxes.size());
        for (ViewCheckBox button : this.viewCheckBoxes) {
            if (!button.isSelected()) continue;
            selected.add(button);
        }
        return selected;
    }

    private Map<SyncItem, Integer> itemsToIndex(List<SyncItem> items) {
        int i = 0;
        HashMap<SyncItem, Integer> map = new HashMap<SyncItem, Integer>(items.size() * 2);
        for (SyncItem syncItem : items) {
            map.put(syncItem, i++);
        }
        return map;
    }

    private void initComponents() {
        this.showSummaryCheckBox = new JCheckBox();
        this.operationsPanel = new JPanel();
        this.viewDownloadCheckBox = this.createViewCheckBox();
        this.viewUploadCheckBox = this.createViewCheckBox();
        this.viewNoopCheckBox = this.createViewCheckBox();
        this.viewDeleteCheckBox = this.createViewCheckBox();
        this.problemsPanel = new JPanel();
        this.viewWarningCheckBox = this.createViewCheckBox();
        this.viewErrorCheckBox = this.createViewCheckBox();
        this.viewFileConflictCheckBox = this.createViewCheckBox();
        this.viewFileDirCollisionCheckBox = this.createViewCheckBox();
        this.viewSymlinkCheckBox = this.createViewCheckBox();
        this.spaceHolderPanel = new JPanel();
        this.uncheckAllButton = new JButton();
        this.checkAllButton = new JButton();
        this.itemScrollPane = new JScrollPane();
        this.itemTable = new JTable();
        this.syncInfoPanel = new JPanel();
        this.syncInfoLabel = new JLabel();
        this.operationButtonsPanel = new JPanel();
        this.diffButton = new JButton();
        this.noopButton = new JButton();
        this.downloadButton = new JButton();
        this.uploadButton = new JButton();
        this.deleteButton = new JButton();
        this.resetButton = new JButton();
        this.messagesScrollPane = new JScrollPane();
        this.messagesTextPane = new HintArea();
        Mnemonics.setLocalizedText((AbstractButton)this.showSummaryCheckBox, (String)NbBundle.getMessage(SyncPanel.class, (String)"SyncPanel.showSummaryCheckBox.text"));
        this.operationsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SyncPanel.class, (String)"SyncPanel.operationsPanel.title")));
        GroupLayout operationsPanelLayout = new GroupLayout(this.operationsPanel);
        this.operationsPanel.setLayout(operationsPanelLayout);
        operationsPanelLayout.setHorizontalGroup(operationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(operationsPanelLayout.createSequentialGroup().addContainerGap().addGroup(operationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewDownloadCheckBox).addComponent(this.viewUploadCheckBox)).addGap(18, 18, 18).addGroup(operationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewNoopCheckBox).addComponent(this.viewDeleteCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        operationsPanelLayout.setVerticalGroup(operationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(operationsPanelLayout.createSequentialGroup().addContainerGap().addGroup(operationsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.viewNoopCheckBox).addComponent(this.viewDownloadCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(operationsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.viewUploadCheckBox).addComponent(this.viewDeleteCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        this.problemsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SyncPanel.class, (String)"SyncPanel.problemsPanel.title")));
        GroupLayout problemsPanelLayout = new GroupLayout(this.problemsPanel);
        this.problemsPanel.setLayout(problemsPanelLayout);
        problemsPanelLayout.setHorizontalGroup(problemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(problemsPanelLayout.createSequentialGroup().addContainerGap().addGroup(problemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewWarningCheckBox).addComponent(this.viewErrorCheckBox)).addGap(18, 18, 18).addGroup(problemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewFileConflictCheckBox).addComponent(this.viewFileDirCollisionCheckBox)).addGap(18, 18, 18).addComponent(this.viewSymlinkCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        problemsPanelLayout.setVerticalGroup(problemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(problemsPanelLayout.createSequentialGroup().addContainerGap().addGroup(problemsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.viewSymlinkCheckBox).addComponent(this.viewFileConflictCheckBox).addComponent(this.viewWarningCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(problemsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.viewErrorCheckBox).addComponent(this.viewFileDirCollisionCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.uncheckAllButton, (String)NbBundle.getMessage(SyncPanel.class, (String)"SyncPanel.uncheckAllButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkAllButton, (String)NbBundle.getMessage(SyncPanel.class, (String)"SyncPanel.checkAllButton.text"));
        GroupLayout spaceHolderPanelLayout = new GroupLayout(this.spaceHolderPanel);
        this.spaceHolderPanel.setLayout(spaceHolderPanelLayout);
        spaceHolderPanelLayout.setHorizontalGroup(spaceHolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.uncheckAllButton).addComponent(this.checkAllButton, GroupLayout.Alignment.TRAILING));
        spaceHolderPanelLayout.linkSize(0, this.checkAllButton, this.uncheckAllButton);
        spaceHolderPanelLayout.setVerticalGroup(spaceHolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spaceHolderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.checkAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uncheckAllButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.itemTable.setSelectionMode(2);
        this.itemScrollPane.setViewportView(this.itemTable);
        Mnemonics.setLocalizedText((JLabel)this.syncInfoLabel, (String)"SYNC INFO LABEL");
        GroupLayout syncInfoPanelLayout = new GroupLayout(this.syncInfoPanel);
        this.syncInfoPanel.setLayout(syncInfoPanelLayout);
        syncInfoPanelLayout.setHorizontalGroup(syncInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(syncInfoPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.syncInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        syncInfoPanelLayout.setVerticalGroup(syncInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(syncInfoPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.syncInfoLabel).addGap(5, 5, 5)));
        this.diffButton.setIcon(ImageUtilities.loadIcon((String)DIFF_ICON_PATH));
        this.diffButton.setEnabled(false);
        this.operationButtonsPanel.add(this.diffButton);
        Mnemonics.setLocalizedText((AbstractButton)this.noopButton, (String)" ");
        this.noopButton.setEnabled(false);
        this.operationButtonsPanel.add(this.noopButton);
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)" ");
        this.downloadButton.setEnabled(false);
        this.operationButtonsPanel.add(this.downloadButton);
        Mnemonics.setLocalizedText((AbstractButton)this.uploadButton, (String)" ");
        this.uploadButton.setEnabled(false);
        this.operationButtonsPanel.add(this.uploadButton);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)" ");
        this.deleteButton.setEnabled(false);
        this.operationButtonsPanel.add(this.deleteButton);
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)" ");
        this.resetButton.setEnabled(false);
        this.operationButtonsPanel.add(this.resetButton);
        this.messagesScrollPane.setBorder(null);
        this.messagesScrollPane.setHorizontalScrollBarPolicy(31);
        this.messagesScrollPane.setViewportView(this.messagesTextPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemScrollPane, -1, 728, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.operationsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.problemsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 0, -2).addComponent(this.spaceHolderPanel, -2, -1, -2)).addComponent(this.messagesScrollPane, -2, -1, Short.MAX_VALUE).addComponent(this.operationButtonsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.syncInfoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.operationsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.problemsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.spaceHolderPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.itemScrollPane, -1, 283, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.syncInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.operationButtonsPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.messagesScrollPane, -2, 80, -2)));
    }

    private class ViewListener
    implements ItemListener {
        private ViewListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SyncPanel.this.updateDisplayedItems();
        }
    }

    private final class FileTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 16478634354314324L;
        private final List<SyncItem> items;

        public FileTableModel(List<SyncItem> items) {
            assert (SwingUtilities.isEventDispatchThread());
            this.items = items;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            assert (SwingUtilities.isEventDispatchThread());
            return false;
        }

        @Override
        public int getRowCount() {
            assert (SwingUtilities.isEventDispatchThread());
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (SwingUtilities.isEventDispatchThread());
            SyncItem syncItem = this.items.get(rowIndex);
            if (columnIndex == 0) {
                SyncItem.ValidationResult validationResult = syncItem.validate();
                if (validationResult.hasError()) {
                    return ImageUtilities.loadImageIcon((String)SyncPanel.ERROR_ICON_PATH, (boolean)false);
                }
                if (validationResult.hasWarning()) {
                    return ImageUtilities.loadImageIcon((String)SyncPanel.WARNING_ICON_PATH, (boolean)false);
                }
                return null;
            }
            if (columnIndex == 1 || columnIndex == 3) {
                if (this.isRemotePathColumn(columnIndex)) {
                    return syncItem.getRemotePath();
                }
                return syncItem.getLocalPath();
            }
            if (columnIndex == 2) {
                return syncItem.getOperation();
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            assert (SwingUtilities.isEventDispatchThread());
            if (columnIndex == 0 || columnIndex == 2) {
                return "";
            }
            if (columnIndex == 1 || columnIndex == 3) {
                if (this.isRemotePathColumn(columnIndex)) {
                    return Bundle.SyncPanel_table_column_remote_title();
                }
                return Bundle.SyncPanel_table_column_local_title();
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            assert (SwingUtilities.isEventDispatchThread());
            if (columnIndex == 0) {
                return Icon.class;
            }
            if (columnIndex == 1 || columnIndex == 3) {
                return String.class;
            }
            if (columnIndex == 2) {
                return SyncItem.Operation.class;
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        public void fireSyncItemsChange() {
            assert (SwingUtilities.isEventDispatchThread());
            this.fireTableDataChanged();
        }

        public void fireTableHeaderChanged() {
            assert (SwingUtilities.isEventDispatchThread());
            this.fireTableStructureChanged();
        }

        boolean isRemotePathColumn(int columnIndex) {
            assert (SwingUtilities.isEventDispatchThread());
            if (SyncPanel.this.remotePathFirst && columnIndex == 1) {
                return true;
            }
            return !SyncPanel.this.remotePathFirst && columnIndex == 3;
        }
    }

    private static final class ViewCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 16576854546544L;
        private SyncItemFilter filter;

        private ViewCheckBox() {
        }

        public SyncItemFilter getFilter() {
            return this.filter;
        }

        public void setFilter(SyncItemFilter filter) {
            this.filter = filter;
        }
    }

    private final class OkActionListener
    implements ActionListener {
        private final Dialog dialog;

        public OkActionListener(Dialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SyncPanel.this.rememberShowSummary != null) {
                PhpOptions.getInstance().setRemoteSyncShowSummary(SyncPanel.this.rememberShowSummary);
            }
            if (!SyncPanel.this.showSummaryCheckBox.isVisible() || !SyncPanel.this.showSummaryCheckBox.isSelected()) {
                this.closeDialog();
                return;
            }
            SyncInfo syncInfo = SyncPanel.this.getSyncInfo(SyncPanel.this.allItems);
            SummaryPanel panel = new SummaryPanel(syncInfo.upload, syncInfo.download, syncInfo.delete, syncInfo.noop);
            if (panel.open()) {
                this.closeDialog();
            }
        }

        private void closeDialog() {
            this.dialog.setVisible(false);
        }
    }

    private static interface SyncItemFilter {
        public boolean accept(SyncItem var1);
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class SyncItemImageIconComparator
    implements Comparator<ImageIcon> {
        private SyncItemImageIconComparator() {
        }

        @Override
        public int compare(ImageIcon icon1, ImageIcon icon2) {
            ImageIcon error = ImageUtilities.loadImageIcon((String)SyncPanel.ERROR_ICON_PATH, (boolean)false);
            boolean isError1 = error.equals(icon1);
            boolean isError2 = error.equals(icon2);
            if (isError1 && isError2) {
                return 0;
            }
            if (isError1) {
                return 1;
            }
            if (isError2) {
                return -1;
            }
            ImageIcon warning = ImageUtilities.loadImageIcon((String)SyncPanel.WARNING_ICON_PATH, (boolean)false);
            boolean isWarning1 = warning.equals(icon1);
            boolean isWarning2 = warning.equals(icon2);
            if (isWarning1 && isWarning2) {
                return 0;
            }
            if (isWarning1) {
                return 1;
            }
            if (isWarning2) {
                return -1;
            }
            return 0;
        }
    }

    private final class IconRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -46865321321L;

        private IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (SwingUtilities.isEventDispatchThread());
            Icon icon = (Icon)value;
            JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setHorizontalAlignment(0);
            rendererComponent.setToolTipText(SyncPanel.this.displayedItems.get(row).validate().getMessage());
            rendererComponent.setText(null);
            rendererComponent.setIcon(icon);
            return rendererComponent;
        }
    }

    private final class StringRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 567654543546954L;

        private StringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object text = (String)value;
            JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (text != null) {
                rendererComponent.setHorizontalAlignment(2);
                rendererComponent.setToolTipText((String)text);
                if (!SyncPanel.this.tableModel.isRemotePathColumn(column) && SyncPanel.this.displayedItems.get(row).hasTmpLocalFile()) {
                    text = Bundle.SyncPanel_localFile_modified_mark(text);
                }
                text = " " + (String)text;
            }
            rendererComponent.setText((String)text);
            rendererComponent.setIcon(null);
            return rendererComponent;
        }
    }

    private final class OperationRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6786654671313465458L;

        private OperationRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SyncItem.Operation operation = (SyncItem.Operation)((Object)value);
            if (operation == null) {
                String expected;
                try {
                    expected = SyncPanel.this.displayedItems.get(SyncPanel.this.itemTable.convertRowIndexToModel(row)).getOperation().toString();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    expected = "???";
                }
                LOGGER.log(Level.WARNING, "Unexpected null value for operation (row: {0}, column: {1}, expected: {2})", new Object[]{row, column, expected});
                operation = SyncItem.Operation.NOOP;
            }
            rendererComponent.setIcon(operation.getIcon(!SyncPanel.this.remotePathFirst));
            if (OPERATIONS.contains((Object)operation)) {
                rendererComponent.setToolTipText(Bundle.SyncPanel_operation_tooltip(operation.getTitle()));
            } else {
                rendererComponent.setToolTipText(operation.getTitle());
            }
            rendererComponent.setText(null);
            rendererComponent.setHorizontalAlignment(0);
            return rendererComponent;
        }
    }

    private static final class HeaderRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = -6517698451435465L;
        private final String toolTip;

        public HeaderRenderer(String toolTip) {
            this.toolTip = toolTip;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (SwingUtilities.isEventDispatchThread());
            JLabel rendererComponent = (JLabel)table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Icon) {
                Icon icon = (Icon)value;
                rendererComponent.setHorizontalAlignment(0);
                rendererComponent.setText(null);
                rendererComponent.setIcon(icon);
            }
            rendererComponent.setToolTipText(this.toolTip);
            return rendererComponent;
        }
    }

    private class SortPopupMenuItemListener
    implements ActionListener {
        private final int column;
        private final SortOrder sortOrder;

        public SortPopupMenuItemListener(int column, SortOrder sortOrder) {
            this.column = column;
            this.sortOrder = sortOrder;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowSorter<? extends TableModel> rowSorter = SyncPanel.this.itemTable.getRowSorter();
            rowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(this.column, this.sortOrder)));
        }
    }

    private class PopupMenuItemListener
    implements ActionListener {
        private final Collection<SyncItem.Operation> fromOperations;
        private final SyncItem.Operation toOperation;

        public PopupMenuItemListener(SyncItem.Operation toOperation) {
            this(Collections.emptyList(), toOperation);
        }

        public PopupMenuItemListener(SyncItem.Operation fromOperation, SyncItem.Operation toOperation) {
            this(Collections.singleton(fromOperation), toOperation);
        }

        public PopupMenuItemListener(Collection<SyncItem.Operation> fromOperations, SyncItem.Operation toOperation) {
            this.fromOperations = fromOperations;
            this.toOperation = toOperation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<SyncItem> selectedItems = SyncPanel.this.getSelectedItems(true);
            for (SyncItem item : selectedItems) {
                if (!item.isOperationChangePossible() || !this.fromOperations.isEmpty() && !this.fromOperations.contains((Object)item.getOperation())) continue;
                item.setOperation(this.toOperation);
            }
            SyncPanel.this.updateDisplayedItems();
            SyncPanel.this.reselectItems(selectedItems);
        }
    }

    private final class OperationButtonListener
    implements ActionListener {
        private final SyncItem.Operation operation;

        public OperationButtonListener(SyncItem.Operation operation) {
            this.operation = operation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (SwingUtilities.isEventDispatchThread());
            List<SyncItem> selectedItems = SyncPanel.this.getSelectedItems(false);
            for (SyncItem syncItem : selectedItems) {
                if (!syncItem.isOperationChangePossible()) continue;
                if (this.operation == null) {
                    syncItem.resetOperation();
                    continue;
                }
                syncItem.setOperation(this.operation);
            }
            SyncPanel.this.updateDisplayedItems();
            SyncPanel.this.reselectItems(selectedItems);
        }
    }

    private final class DiffActionListener
    implements ActionListener {
        private DiffActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SyncPanel.this.openDiffPanel();
        }
    }

    public static final class SyncInfo {
        public int download = 0;
        public int upload = 0;
        public int delete = 0;
        public int noop = 0;
        public int errors = 0;
        public int warnings = 0;
    }
}

