/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.annotations.CallStackAnnotation;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.models.CallStackModel;
import org.netbeans.modules.php.dbgp.packets.ContextNamesCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.EvalCommand;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.modules.php.dbgp.packets.StackGetCommand;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.w3c.dom.Node;

public class StackGetResponse
extends DbgpResponse {
    private static final String STACK = "stack";

    StackGetResponse(Node node) {
        super(node);
    }

    public List<Stack> getStackElements() {
        LinkedList<Stack> result = new LinkedList<Stack>();
        List<Node> nodes = StackGetResponse.getChildren(this.getNode(), STACK);
        for (Node node : nodes) {
            result.add(new Stack(node));
        }
        return result;
    }

    @Override
    public void process(DebugSession session, DbgpCommand command) {
        if (!(command instanceof StackGetCommand)) {
            return;
        }
        List<Stack> stacks = this.getStackElements();
        this.annotateStackTrace(session, stacks);
        DebugSession currentSession = SessionManager.getInstance().getSession(session.getSessionId());
        if (currentSession != session) {
            return;
        }
        this.updateUIViews(session, stacks);
    }

    private void updateUIViews(DebugSession session, List<Stack> stacks) {
        CallStackModel callStackModel;
        DebugSession.IDESessionBridge bridge = session.getBridge();
        if (bridge != null && (callStackModel = bridge.getCallStackModel()) != null) {
            callStackModel.setCallStack(stacks);
        }
        this.requestContextNames(session);
        StackGetResponse.updateWatchView(session);
        this.updateBreakpointsView(session, stacks);
    }

    private void updateBreakpointsView(DebugSession session, List<Stack> stacks) {
        BreakpointModel breakpointModel;
        if (stacks.isEmpty()) {
            return;
        }
        DebugSession.IDESessionBridge bridge = session.getBridge();
        if (bridge != null && (breakpointModel = bridge.getBreakpointModel()) != null && !breakpointModel.isSearchCurrentBreakpointById()) {
            breakpointModel.setCurrentStack(stacks.get(0), session);
        }
    }

    public static void updateWatchView(DebugSession session) {
        if (PhpOptions.getInstance().isDebuggerWatchesAndEval()) {
            Watch[] allWatches;
            for (Watch watch : allWatches = DebuggerManager.getDebuggerManager().getWatches()) {
                String expression = watch.getExpression();
                EvalCommand command = new EvalCommand(session.getTransactionId());
                command.setData(expression);
                session.sendCommandLater(command);
            }
        }
    }

    private void requestContextNames(DebugSession session) {
        ContextNamesCommand contextNames = new ContextNamesCommand(session.getTransactionId());
        session.sendCommandLater(contextNames);
    }

    private void annotateStackTrace(DebugSession session, List<Stack> stacks) {
        session.getBridge().hideAnnotations();
        for (Stack stack : stacks) {
            int level = stack.getLevel();
            int lineno = stack.getLine();
            Line line = Utils.getLine(lineno > 0 ? lineno : 1, stack.getFileName(), session.getSessionId());
            if (line == null) continue;
            if (level == 0) {
                session.getBridge().showCurrentDebuggerLine(line);
                continue;
            }
            session.getBridge().annotate(new CallStackAnnotation((Annotatable)line));
        }
    }
}

