/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteInstanceConfigurationRequest
extends BmcRequest<Void> {
    private String instanceConfigurationId;
    private String ifMatch;

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().instanceConfigurationId(this.instanceConfigurationId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteInstanceConfigurationRequest)) {
            return false;
        }
        DeleteInstanceConfigurationRequest other = (DeleteInstanceConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteInstanceConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConfigurationId = null;
        private String ifMatch = null;

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteInstanceConfigurationRequest build() {
            DeleteInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteInstanceConfigurationRequest buildWithoutInvocationCallback() {
            DeleteInstanceConfigurationRequest request = new DeleteInstanceConfigurationRequest();
            request.instanceConfigurationId = this.instanceConfigurationId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

