/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.toml;

import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.toml.TomlTokenId;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class TomlTypedTextInterceptor
implements TypedTextInterceptor {
    private int caretPosition = -1;
    private static final Set<? extends TokenId> STRING_OR_WS = EnumSet.of(TomlTokenId.STRING, TomlTokenId.WHITESPACE);

    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        block23: {
            String txt;
            block22: {
                txt = context.getText();
                if (context.getReplacedText().length() != 0) break block22;
                switch (txt) {
                    case "{": {
                        context.setText("{}", 1);
                        break;
                    }
                    case "}": {
                        if (!"}".equals(TomlTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) break;
                        this.skipNext(context);
                        break;
                    }
                    case "[": {
                        context.setText("[]", 1);
                        break;
                    }
                    case "]": {
                        if (!"]".equals(TomlTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) break;
                        this.skipNext(context);
                        break;
                    }
                    case " ": {
                        String b = TomlTypedTextInterceptor.textBefore((TypedTextInterceptor.Context)context, 1);
                        String a = TomlTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1);
                        if ((!"{".equals(b) || !"}".equals(a)) && (!"[".equals(b) || !"]".equals(a))) break;
                        context.setText("  ", 1);
                        break;
                    }
                    case "\"": {
                        if (TomlTypedTextInterceptor.isInMultilineString((TypedTextInterceptor.Context)context) || "\"\"".equals(TomlTypedTextInterceptor.textBefore((TypedTextInterceptor.Context)context, 2))) break;
                        if ("\"".equals(TomlTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) {
                            this.skipNext(context);
                            break;
                        }
                        int quotes = TomlTypedTextInterceptor.quotesInLine((TypedTextInterceptor.Context)context, '\"');
                        if (quotes % 2 == 0) {
                            context.setText("\"\"", 1);
                            break;
                        }
                        break block23;
                    }
                    case "'": {
                        if (TomlTypedTextInterceptor.isInMultilineString((TypedTextInterceptor.Context)context) || "''".equals(TomlTypedTextInterceptor.textBefore((TypedTextInterceptor.Context)context, 2))) break;
                        if ("'".equals(TomlTypedTextInterceptor.textAfter((TypedTextInterceptor.Context)context, 1))) {
                            this.skipNext(context);
                            break;
                        }
                        int quotes = TomlTypedTextInterceptor.quotesInLine((TypedTextInterceptor.Context)context, '\'');
                        if (quotes % 2 != 0) break;
                        context.setText("''", 1);
                    }
                }
                break block23;
            }
            if (("\"".equals(txt) || "'".equals(txt)) && !TomlTypedTextInterceptor.isInMultilineString((TypedTextInterceptor.Context)context)) {
                context.setText(txt + context.getReplacedText() + txt, context.getReplacedText().length() + 2);
            }
        }
    }

    private void skipNext(TypedTextInterceptor.MutableContext context) {
        context.setText("", 0);
        this.caretPosition = context.getOffset() + 1;
    }

    private static String textAfter(TypedTextInterceptor.Context context, int length) throws BadLocationException {
        int next = Math.min(length, context.getDocument().getLength() - context.getOffset());
        return context.getDocument().getText(context.getOffset(), next);
    }

    private static String textBefore(TypedTextInterceptor.Context context, int lenght) throws BadLocationException {
        int pre = Math.min(lenght, context.getOffset());
        return context.getDocument().getText(context.getOffset() - pre, pre);
    }

    private static boolean isInMultilineString(TypedTextInterceptor.Context context) {
        TokenHierarchy th = TokenHierarchy.get((Document)context.getDocument());
        TokenSequence ts = th.tokenSequence();
        ts.move(context.getOffset());
        ts.movePrevious();
        while (ts.token() != null && STRING_OR_WS.contains(ts.token().id())) {
            ts.movePrevious();
        }
        return ts.token() != null && TomlTokenId.STRING_QUOTE == ts.token().id() && ts.token().text().length() == 3;
    }

    private static int quotesInLine(TypedTextInterceptor.Context context, char quote) throws BadLocationException {
        LineDocument doc = (LineDocument)context.getDocument();
        int lineStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)context.getOffset());
        int lineEnd = LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)context.getOffset());
        char[] line = doc.getText(lineStart, lineEnd - lineStart).toCharArray();
        int quotes = 0;
        for (int i = 0; i < line.length; ++i) {
            char d = line[i];
            if ('\\' == d) {
                ++i;
                continue;
            }
            if (quote != d) continue;
            ++quotes;
        }
        return quotes;
    }

    public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        if (this.caretPosition > -1) {
            context.getComponent().setCaretPosition(this.caretPosition);
            this.caretPosition = -1;
        }
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    public static class TomlTypedTextInterceptorFactory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new TomlTypedTextInterceptor();
        }
    }
}

