/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class J2SELibrarySourceLevelQueryImpl
implements SourceLevelQueryImplementation {
    private static final String JDK_12 = "1.2";
    private static final String JDK_13 = "1.3";
    private static final String JDK_14 = "1.4";
    private static final String JDK_15 = "1.5";
    private static final String JDK_16 = "1.6";
    private static final String JDK_17 = "1.7";
    private static final String JDK_18 = "1.8";
    private static final String JDK_9 = "9";
    private static final String JDK_UNKNOWN = "";
    private static final String CLASS = "class";
    private static final int CF_MAGIC = -889275714;
    private static final int CF_INVALID = -1;
    private static final int CF_11 = 45;
    private static final int CF_12 = 46;
    private static final int CF_13 = 47;
    private static final int CF_14 = 48;
    private static final int CF_15 = 49;
    private static final int CF_16 = 50;
    private static final int CF_17 = 51;
    private static final int CF_18 = 52;
    private static final int CF_19 = 53;
    private Map<Library, String> sourceLevelCache = new WeakHashMap<Library, String>();
    private Reference<FileObject> lastUsedRoot;
    private Reference<Library> lastUsedLibrary;

    public String getSourceLevel(FileObject javaFile) {
        Library ll = this.isLastUsed(javaFile);
        if (ll != null) {
            return this.getSourceLevel(ll);
        }
        for (LibraryManager mgr : LibraryManager.getOpenManagers()) {
            for (Library lib : mgr.getLibraries()) {
                ClassPath cp;
                FileObject root;
                List sourceRoots;
                if (!lib.getType().equals("j2se") || (sourceRoots = lib.getContent("src")).isEmpty() || (root = (cp = ClassPathSupport.createClassPath((URL[])sourceRoots.toArray(new URL[0]))).findOwnerRoot(javaFile)) == null) continue;
                this.setLastUsedRoot(root, lib);
                return this.getSourceLevel(lib);
            }
        }
        return null;
    }

    private String getSourceLevel(Library lib) {
        String slevel = this.sourceLevelCache.get(lib);
        if (slevel == null) {
            slevel = this.getSourceLevel(lib.getContent("classpath"));
            this.sourceLevelCache.put(lib, slevel);
        }
        return slevel == JDK_UNKNOWN ? null : slevel;
    }

    private String getSourceLevel(List cpRoots) {
        FileObject classFile = this.getClassFile(cpRoots);
        if (classFile == null) {
            return JDK_UNKNOWN;
        }
        int version = this.getClassFileMajorVersion(classFile);
        switch (version) {
            case 45: 
            case 46: {
                return JDK_12;
            }
            case 47: {
                return JDK_13;
            }
            case 48: {
                return JDK_14;
            }
            case 49: {
                return JDK_15;
            }
            case 50: {
                return JDK_16;
            }
            case 51: {
                return JDK_17;
            }
            case 52: {
                return JDK_18;
            }
            case 53: {
                return JDK_9;
            }
        }
        return JDK_UNKNOWN;
    }

    private FileObject getClassFile(List<URL> cpRoots) {
        Iterator<URL> it = cpRoots.iterator();
        while (it.hasNext()) {
            FileObject cf;
            FileObject root = URLMapper.findFileObject((URL)it.next());
            if (root == null || (cf = this.findClassFile(root)) == null) continue;
            return cf;
        }
        return null;
    }

    private FileObject findClassFile(FileObject root) {
        if (root.isData()) {
            if (CLASS.equals(root.getExt())) {
                return root;
            }
            return null;
        }
        FileObject[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject result = this.findClassFile(children[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClassFileMajorVersion(FileObject classFile) {
        short s;
        DataInputStream in = null;
        try {
            short major;
            in = new DataInputStream(classFile.getInputStream());
            int magic = in.readInt();
            if (-889275714 != magic) {
                int n = -1;
                return n;
            }
            short minor = in.readShort();
            s = major = in.readShort();
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return s;
    }

    private synchronized void setLastUsedRoot(FileObject root, Library lib) {
        this.lastUsedRoot = new SoftReference<FileObject>(root);
        this.lastUsedLibrary = new WeakReference<Library>(lib);
    }

    private synchronized Library isLastUsed(FileObject javaFile) {
        if (this.lastUsedRoot == null) {
            return null;
        }
        FileObject root = this.lastUsedRoot.get();
        if (root == null) {
            return null;
        }
        if (root.equals(javaFile) || FileUtil.isParentOf((FileObject)root, (FileObject)javaFile)) {
            return this.lastUsedLibrary.get();
        }
        return null;
    }
}

