/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.openide.util.Lookup;
import org.openide.util.io.NullInputStream;

public abstract class IOContext {
    private static Reference<IOContext> lastCtx = new WeakReference<Object>(null);

    static IOContext find() {
        IOContext ctx = (IOContext)Lookup.getDefault().lookup(IOContext.class);
        if (ctx == null && (ctx = lastCtx.get()) != null && !ctx.isValid()) {
            lastCtx.clear();
            ctx = null;
        }
        if (ctx == null) {
            ctx = StdErrContext.DEFAULT;
        } else if (lastCtx.get() != ctx) {
            lastCtx = new WeakReference<IOContext>(ctx);
        }
        return ctx;
    }

    protected void stdIn(String line) throws IOException {
    }

    protected InputStream getStdIn() throws IOException {
        return new NullInputStream();
    }

    protected abstract void stdOut(String var1);

    protected abstract void stdErr(String var1);

    protected abstract boolean isValid();

    private static final class StdErrContext
    extends IOContext {
        static final StdErrContext DEFAULT = new StdErrContext();

        private StdErrContext() {
        }

        @Override
        protected void stdIn(String line) throws IOException {
        }

        @Override
        protected InputStream getStdIn() throws IOException {
            return System.in;
        }

        @Override
        protected void stdOut(String chunk) {
            System.out.print(chunk);
        }

        @Override
        protected void stdErr(String chunk) {
            System.err.print(chunk);
        }

        @Override
        protected boolean isValid() {
            return true;
        }
    }
}

