/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.singlesourcefile;

import com.google.gson.JsonPrimitive;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spi.preview.PreviewEnabler;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.UpdateConfigParams;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class EnablePreviewSingleSourceFile
implements PreviewEnabler {
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private static final String SOURCE_FLAG = "--source";
    private static final Pattern SOURCE_FLAG_PATTERN = Pattern.compile("--source[ \t]+[0-9]+");
    private FileObject file;

    private EnablePreviewSingleSourceFile(@NonNull FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        this.file = file;
    }

    public void enablePreview(String newSourceLevel) throws Exception {
        NbCodeLanguageClient client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class);
        if (client == null) {
            return;
        }
        client.getClientConfigurationManager().getConfigurationUsingAltPrefix("runConfig.vmOptions", Utils.toUri(this.file)).thenApply(c -> {
            Object compilerArgs = ((JsonPrimitive)c).getAsString();
            if (compilerArgs == null) {
                compilerArgs = "";
            }
            Matcher m = SOURCE_FLAG_PATTERN.matcher((CharSequence)compilerArgs);
            String realNewSourceLevel = newSourceLevel;
            if (realNewSourceLevel == null) {
                realNewSourceLevel = EnablePreviewSingleSourceFile.getJdkRunVersion();
            }
            compilerArgs = ((String)compilerArgs).contains(SOURCE_FLAG) ? m.replaceAll("--enable-preview --source " + realNewSourceLevel) : (String)compilerArgs + (((String)compilerArgs).isEmpty() ? "" : " ") + "--enable-preview --source " + realNewSourceLevel;
            client.configurationUpdate(new UpdateConfigParams(client.getNbCodeCapabilities().getAltConfigurationPrefix() + "runConfig", "vmOptions", (String)compilerArgs));
            return null;
        });
    }

    private static String getJdkRunVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        return javaVersion;
    }

    public static final class FactoryImpl
    implements PreviewEnabler.Factory {
        public PreviewEnabler enablerFor(FileObject file) {
            if (file != null) {
                NbCodeLanguageClient client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class);
                if (client == null) {
                    return null;
                }
                Project prj = FileOwnerQuery.getOwner((FileObject)file);
                if (prj == null) {
                    return new EnablePreviewSingleSourceFile(file);
                }
            }
            return null;
        }
    }
}

