/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.input;

import java.util.List;
import java.util.Objects;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;

public final class QuickPickStep
extends ShowQuickPickParams {
    private int totalSteps;
    @NonNull
    private String stepId;

    public QuickPickStep() {
        this.totalSteps = 0;
        this.stepId = "";
    }

    public QuickPickStep(int totalSteps, @NonNull String stepId, @NonNull String placeHolder, @NonNull List<QuickPickItem> items) {
        super(placeHolder, items);
        this.totalSteps = totalSteps;
        this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (String)"stepId");
    }

    public QuickPickStep(int totalSteps, @NonNull String stepId, String title, @NonNull String placeHolder, boolean canPickMany, @NonNull List<QuickPickItem> items) {
        super(title, placeHolder, canPickMany, items);
        this.totalSteps = totalSteps;
        this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (String)"stepId");
    }

    @Pure
    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Pure
    @NonNull
    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(@NonNull String stepId) {
        this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (String)"stepId");
    }

    @Override
    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("totalSteps", (Object)this.totalSteps);
        b.add("stepId", (Object)this.stepId);
        b.add("title", (Object)this.getTitle());
        b.add("placeHolder", (Object)this.getPlaceHolder());
        b.add("canPickMany", (Object)this.getCanPickMany());
        b.add("items", this.getItems());
        return b.toString();
    }

    @Override
    @Pure
    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + this.totalSteps;
        hash = 71 * hash + Objects.hashCode(this.stepId);
        hash = 71 * hash + Objects.hashCode(this.getTitle());
        hash = 71 * hash + Objects.hashCode(this.getPlaceHolder());
        hash = 71 * hash + (this.getCanPickMany() ? 1 : 0);
        hash = 71 * hash + Objects.hashCode(this.getItems());
        return hash;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickPickStep other = (QuickPickStep)obj;
        if (this.totalSteps != other.totalSteps) {
            return false;
        }
        if (this.getCanPickMany() != other.getCanPickMany()) {
            return false;
        }
        if (!Objects.equals(this.stepId, other.stepId)) {
            return false;
        }
        if (!Objects.equals(this.getTitle(), other.getTitle())) {
            return false;
        }
        if (!Objects.equals(this.getPlaceHolder(), other.getPlaceHolder())) {
            return false;
        }
        return Objects.equals(this.getItems(), other.getItems());
    }
}

