/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.StackLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CommonLoggerLog4j
implements StackLogger {
    private Logger logger;

    @Override
    public void logStackTrace() {
        this.logStackTrace(32);
    }

    @Override
    public void logStackTrace(int traceLevel) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StackTraceElement[] ste = new Exception().getStackTrace();
        for (int i = 1; i < ste.length; ++i) {
            String callFrame = "[" + ste[i].getFileName() + ":" + ste[i].getLineNumber() + "]";
            pw.print(callFrame);
        }
        pw.close();
        String stackTrace = sw.getBuffer().toString();
        this.logger.debug((Object)stackTrace);
    }

    @Override
    public int getLineCount() {
        return 0;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addAppender(Appender appender) {
        this.logger.addAppender(appender);
    }

    @Override
    public void logException(Throwable ex) {
        this.logger.error((Object)"Error", ex);
    }

    @Override
    public void logDebug(String message) {
        this.logger.debug((Object)message);
    }

    @Override
    public void logTrace(String message) {
        this.logger.debug((Object)message);
    }

    private void setTraceLevel(int level) {
    }

    public int getTraceLevel() {
        return CommonLoggerLog4j.levelToInt(this.logger.getLevel());
    }

    @Override
    public void logFatalError(String message) {
        this.logger.fatal((Object)message);
    }

    @Override
    public void logError(String message) {
        this.logger.error((Object)message);
    }

    public CommonLoggerLog4j(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setStackProperties(Properties configurationProperties) {
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isLoggingEnabled(int logLevel) {
        return this.logger.isEnabledFor((Priority)CommonLoggerLog4j.intToLevel(logLevel));
    }

    @Override
    public void logError(String message, Exception ex) {
        Logger logger = this.getLogger();
        logger.error((Object)message, (Throwable)ex);
    }

    @Override
    public void logWarning(String string) {
        this.getLogger().warn((Object)string);
    }

    @Override
    public void logInfo(String string) {
        this.getLogger().info((Object)string);
    }

    @Override
    public void disableLogging() {
    }

    @Override
    public void enableLogging() {
    }

    public static Level intToLevel(int intLevel) {
        switch (intLevel) {
            case 16: {
                return Level.INFO;
            }
            case 32: {
                return Level.DEBUG;
            }
            case 4: {
                return Level.ERROR;
            }
            case 8: {
                return Level.WARN;
            }
            case 64: {
                return Level.TRACE;
            }
            case 2: {
                return Level.FATAL;
            }
        }
        return Level.OFF;
    }

    public static int levelToInt(Level level) {
        if (level.equals((Object)Level.INFO)) {
            return 16;
        }
        if (level.equals((Object)Level.ERROR)) {
            return 4;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return 32;
        }
        if (level.equals((Object)Level.WARN)) {
            return 8;
        }
        if (level.equals((Object)Level.TRACE)) {
            return 64;
        }
        if (level.equals((Object)Level.FATAL)) {
            return 2;
        }
        return 0;
    }

    @Override
    public String getLoggerName() {
        if (this.logger != null) {
            return this.logger.getName();
        }
        return null;
    }

    @Override
    public void setBuildTimeStamp(String buildTimeStamp) {
        this.logger.info((Object)("Build timestamp: " + buildTimeStamp));
    }
}

