/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.ContinueMessage;
import net.sf.freecol.common.networking.DisconnectMessage;
import net.sf.freecol.common.networking.EndTurnMessage;
import net.sf.freecol.common.networking.EnterRevengeModeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ReconnectMessage;
import net.sf.freecol.common.networking.RequestLaunchMessage;
import net.sf.freecol.common.networking.RetireMessage;
import net.sf.freecol.common.networking.StartGameMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public abstract class TrivialMessage
extends Message {
    public static final ContinueMessage continueMessage = new ContinueMessage();
    public static final DisconnectMessage disconnectMessage = new DisconnectMessage();
    public static final EndTurnMessage endTurnMessage = new EndTurnMessage();
    public static final EnterRevengeModeMessage enterRevengeModeMessage = new EnterRevengeModeMessage();
    public static final ReconnectMessage reconnectMessage = new ReconnectMessage();
    public static final RequestLaunchMessage requestLaunchMessage = new RequestLaunchMessage();
    public static final RetireMessage retireMessage = new RetireMessage();
    public static final StartGameMessage startGameMessage = new StartGameMessage();
    private String type;

    protected TrivialMessage(String type) {
        this.type = type;
    }

    protected TrivialMessage(String tag, Game game, FreeColXMLReader xr) throws XMLStreamException {
        this(tag);
        xr.closeTag(tag);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    protected void setType(String type) {
        this.type = type;
    }

    @Override
    protected boolean hasAttribute(String key) {
        return false;
    }

    @Override
    protected String getStringAttribute(String key) {
        return null;
    }

    @Override
    protected void setStringAttribute(String key, String value) {
        if (key != null && value != null) {
            throw new RuntimeException(this.getType() + ".setStringAttribute NYI");
        }
    }

    @Override
    protected Map<String, String> getStringAttributeMap() {
        return Collections.emptyMap();
    }

    @Override
    protected int getChildCount() {
        return 0;
    }

    @Override
    protected List<FreeColObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    protected void setChildren(List<? extends FreeColObject> fcos) {
        if (fcos != null && !fcos.isEmpty()) {
            throw new RuntimeException(this.getType() + ".setChildren NYI");
        }
    }

    @Override
    protected <T extends FreeColObject> void appendChild(T fco) {
        if (fco != null) {
            throw new RuntimeException(this.getType() + ".append NYI");
        }
    }

    @Override
    protected <T extends FreeColObject> void appendChildren(Collection<T> fcos) {
        if (fcos != null) {
            throw new RuntimeException(this.getType() + ".append NYI");
        }
    }

    @Override
    public boolean currentPlayerMessage() {
        return false;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) throws FreeColException {
        throw new FreeColException(this.getType() + " aiHandler NYI");
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) throws FreeColException {
        throw new FreeColException(this.getType() + " clientHandler NYI");
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return serverPlayer.clientError("Invalid message type: " + this.getType());
    }
}

