/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;
import org.pentaho.di.core.Const;

public class ValueNumber
implements ValueInterface,
Cloneable {
    private double number;
    private int length;
    private int precision;

    public ValueNumber() {
        this.number = 0.0;
        this.length = -1;
        this.precision = -1;
    }

    public ValueNumber(double number) {
        this.number = number;
        this.length = -1;
        this.precision = -1;
    }

    public int getType() {
        return 1;
    }

    public String getTypeDesc() {
        return "Number";
    }

    public String getString() {
        return Double.toString(this.number);
    }

    public void setSerializable(Serializable ser) {
    }

    public double getNumber() {
        return this.number;
    }

    public Date getDate() {
        return new Date((long)this.number);
    }

    public boolean getBoolean() {
        return this.number != 0.0;
    }

    public long getInteger() {
        return Math.round(this.number);
    }

    public void setString(String string) {
        this.number = Const.toDouble(string, 0.0);
    }

    public void setNumber(double number) {
        this.number = number;
    }

    public void setDate(Date date) {
        this.number = date.getTime();
    }

    public void setBoolean(boolean bool) {
        this.number = bool ? 1.0 : 0.0;
    }

    public void setInteger(long number) {
        this.number = number;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setLength(int length, int precision) {
        this.length = length;
        this.precision = precision;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public Object clone() {
        try {
            ValueNumber retval = (ValueNumber)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BigDecimal getBigNumber() {
        return BigDecimal.valueOf(this.number);
    }

    public void setBigNumber(BigDecimal number) {
        this.number = number.doubleValue();
    }

    public Serializable getSerializable() {
        return new Double(this.number);
    }

    public byte[] getBytes() {
        return null;
    }

    public void setBytes(byte[] b) {
    }
}

