/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class HeaderComponent
extends JComponent {
    private boolean isPressed;
    private boolean isSelected;
    private static CellRendererPane PAINTER;
    private static JTable REF_TABLE;

    HeaderComponent(final ActionListener listener) {
        if (listener != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    HeaderComponent.this.isPressed = true;
                    HeaderComponent.this.isSelected = true;
                    HeaderComponent.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    HeaderComponent.this.isPressed = false;
                    if (HeaderComponent.this.isSelected) {
                        HeaderComponent.this.repaint();
                        this.fireActionEvent(e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (HeaderComponent.this.isPressed || !this.isButtonDown(e)) {
                        HeaderComponent.this.isSelected = true;
                        HeaderComponent.this.repaint();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (HeaderComponent.this.isSelected) {
                        HeaderComponent.this.isSelected = false;
                        HeaderComponent.this.repaint();
                    }
                }

                private void fireActionEvent(MouseEvent e) {
                    ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), e.paramString(), e.getWhen(), e.getModifiers());
                    listener.actionPerformed(ae);
                }

                private boolean isButtonDown(MouseEvent e) {
                    return SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e);
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        JTableHeader header = HeaderComponent.getHeader();
        this.setupHeader(header);
        TableCellRenderer renderer = header.getDefaultRenderer();
        JComponent component = (JComponent)renderer.getTableCellRendererComponent(HeaderComponent.getTable(), "", this.isSelected && this.isPressed, this.isFocusOwner(), -1, 0);
        int height = header.getPreferredSize().height;
        component.setBounds(0, 0, this.getWidth(), height);
        component.setOpaque(false);
        HeaderComponent.getPainter().paintComponent(g, component, null, 0, 0, this.getWidth(), height, false);
    }

    private void setupHeader(JTableHeader h) {
        h.setDraggedColumn(this.isSelected && this.isPressed ? HeaderComponent.getColumn() : null);
        MouseEvent e = this.isSelected && !this.isPressed ? new MouseEvent(h, 504, 1L, 0, 1, 1, 0, false) : new MouseEvent(h, 505, 1L, 0, 0, 0, 0, false);
        h.dispatchEvent(e);
    }

    private static CellRendererPane getPainter() {
        if (PAINTER == null) {
            PAINTER = new CellRendererPane();
        }
        return PAINTER;
    }

    private static JTable getTable() {
        if (REF_TABLE == null) {
            REF_TABLE = new JTable(new Object[][]{new Object[0]}, new Object[]{" "}){

                @Override
                protected JTableHeader createDefaultTableHeader() {
                    return new JTableHeader(this.columnModel){

                        @Override
                        public boolean contains(int x, int y) {
                            return x == 1 && y == 1;
                        }
                    };
                }
            };
        }
        return REF_TABLE;
    }

    private static JTableHeader getHeader() {
        return HeaderComponent.getTable().getTableHeader();
    }

    private static TableColumn getColumn() {
        return HeaderComponent.getHeader().getColumnModel().getColumn(0);
    }
}

