/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.util.NbBundle;
import tr.model.action.PeriodWeek;
import tr.prefs.dates.DatesPrefs;

public class PeriodWeeklyPanel
extends JPanel {
    private final JLabel[] dayLabels = new JLabel[8];
    private PeriodWeek periodWeek = new PeriodWeek();
    private JLabel lblFri;
    private JLabel lblMon;
    private JLabel lblSat;
    private JLabel lblSun;
    private JLabel lblThu;
    private JLabel lblTue;
    private JLabel lblWed;
    private static final Color SELECTED_BG_COLOR = UIManager.getDefaults().getColor("List.selectionBackground");
    private static final Color SELECTED_FG_COLOR = UIManager.getDefaults().getColor("List.selectionForeground");
    private static final Color DESELECTED_BG_COLOR = UIManager.getDefaults().getColor("Label.background");
    private static final Color DESELECTED_FG_COLOR = UIManager.getDefaults().getColor("Label.foreground");

    public PeriodWeeklyPanel() {
        this.initComponents();
        this.initOther();
    }

    private void initOther() {
        this.lblSun.setName(Integer.toString(1));
        this.lblMon.setName(Integer.toString(2));
        this.lblTue.setName(Integer.toString(3));
        this.lblWed.setName(Integer.toString(4));
        this.lblThu.setName(Integer.toString(5));
        this.lblFri.setName(Integer.toString(6));
        this.lblSat.setName(Integer.toString(7));
        this.dayLabels[1] = this.lblSun;
        this.dayLabels[2] = this.lblMon;
        this.dayLabels[3] = this.lblTue;
        this.dayLabels[4] = this.lblWed;
        this.dayLabels[5] = this.lblThu;
        this.dayLabels[6] = this.lblFri;
        this.dayLabels[7] = this.lblSat;
        if (DatesPrefs.getFirstDayOfWeek() == 2) {
            this.remove(this.lblSun);
            this.add(this.lblSun);
        }
    }

    public void setPeriodWeek(PeriodWeek periodWeek) {
        this.periodWeek = periodWeek;
        this.deselectLabel(this.dayLabels[1]);
        this.deselectLabel(this.dayLabels[2]);
        this.deselectLabel(this.dayLabels[3]);
        this.deselectLabel(this.dayLabels[4]);
        this.deselectLabel(this.dayLabels[5]);
        this.deselectLabel(this.dayLabels[6]);
        this.deselectLabel(this.dayLabels[7]);
        Iterator i$ = periodWeek.getSelectedDays().iterator();
        while (i$.hasNext()) {
            int day = (Integer)i$.next();
            this.selectDay(day);
        }
    }

    private void selectLabel(JLabel label) {
        if (label == null) {
            return;
        }
        label.setBackground(SELECTED_BG_COLOR);
        label.setForeground(SELECTED_FG_COLOR);
    }

    private void deselectLabel(JLabel label) {
        if (label == null) {
            return;
        }
        label.setBackground(DESELECTED_BG_COLOR);
        label.setForeground(DESELECTED_FG_COLOR);
    }

    private boolean isSelectedDay(int dayNumber) {
        return this.periodWeek.isSelected(Integer.valueOf(dayNumber));
    }

    private void selectDay(int dayNumber) {
        this.periodWeek.select(Integer.valueOf(dayNumber));
        this.selectLabel(this.dayLabels[dayNumber]);
    }

    private void deselectDay(int dayNumber) {
        this.periodWeek.deselected(Integer.valueOf(dayNumber));
        this.deselectLabel(this.dayLabels[dayNumber]);
    }

    public void notifyStartDate(Date startDate) {
        if (startDate == null) {
            return;
        }
        if (this.periodWeek.getSelectedDays().size() > 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        this.selectDay(calendar.get(7));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lblMon.setEnabled(enabled);
        this.lblTue.setEnabled(enabled);
        this.lblWed.setEnabled(enabled);
        this.lblThu.setEnabled(enabled);
        this.lblFri.setEnabled(enabled);
        this.lblSat.setEnabled(enabled);
        this.lblSun.setEnabled(enabled);
    }

    private void initComponents() {
        this.lblSun = new JLabel();
        this.lblMon = new JLabel();
        this.lblTue = new JLabel();
        this.lblWed = new JLabel();
        this.lblThu = new JLabel();
        this.lblFri = new JLabel();
        this.lblSat = new JLabel();
        this.setLayout(new GridLayout(1, 0));
        this.lblSun.setHorizontalAlignment(0);
        this.lblSun.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"sunday"));
        this.lblSun.setBorder(BorderFactory.createEtchedBorder());
        this.lblSun.setMaximumSize(new Dimension(50, 23));
        this.lblSun.setMinimumSize(new Dimension(50, 23));
        this.lblSun.setOpaque(true);
        this.lblSun.setPreferredSize(new Dimension(50, 23));
        this.lblSun.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblSun);
        this.lblMon.setForeground(DESELECTED_FG_COLOR);
        this.lblMon.setHorizontalAlignment(0);
        this.lblMon.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"monday"));
        this.lblMon.setBorder(BorderFactory.createEtchedBorder());
        this.lblMon.setMaximumSize(new Dimension(50, 23));
        this.lblMon.setMinimumSize(new Dimension(50, 23));
        this.lblMon.setOpaque(true);
        this.lblMon.setPreferredSize(new Dimension(50, 23));
        this.lblMon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblMon);
        this.lblTue.setForeground(DESELECTED_FG_COLOR);
        this.lblTue.setHorizontalAlignment(0);
        this.lblTue.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"tuesday"));
        this.lblTue.setBorder(BorderFactory.createEtchedBorder());
        this.lblTue.setMaximumSize(new Dimension(50, 23));
        this.lblTue.setMinimumSize(new Dimension(50, 23));
        this.lblTue.setOpaque(true);
        this.lblTue.setPreferredSize(new Dimension(50, 23));
        this.lblTue.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblTue);
        this.lblWed.setForeground(DESELECTED_FG_COLOR);
        this.lblWed.setHorizontalAlignment(0);
        this.lblWed.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"wednesday"));
        this.lblWed.setBorder(BorderFactory.createEtchedBorder());
        this.lblWed.setMaximumSize(new Dimension(50, 23));
        this.lblWed.setMinimumSize(new Dimension(50, 23));
        this.lblWed.setOpaque(true);
        this.lblWed.setPreferredSize(new Dimension(50, 23));
        this.lblWed.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblWed);
        this.lblThu.setForeground(DESELECTED_FG_COLOR);
        this.lblThu.setHorizontalAlignment(0);
        this.lblThu.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"thursday"));
        this.lblThu.setBorder(BorderFactory.createEtchedBorder());
        this.lblThu.setMaximumSize(new Dimension(50, 23));
        this.lblThu.setMinimumSize(new Dimension(50, 23));
        this.lblThu.setOpaque(true);
        this.lblThu.setPreferredSize(new Dimension(50, 23));
        this.lblThu.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblThu);
        this.lblFri.setForeground(DESELECTED_FG_COLOR);
        this.lblFri.setHorizontalAlignment(0);
        this.lblFri.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"friday"));
        this.lblFri.setBorder(BorderFactory.createEtchedBorder());
        this.lblFri.setMaximumSize(new Dimension(50, 23));
        this.lblFri.setMinimumSize(new Dimension(50, 23));
        this.lblFri.setOpaque(true);
        this.lblFri.setPreferredSize(new Dimension(50, 23));
        this.lblFri.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblFri);
        this.lblSat.setForeground(DESELECTED_FG_COLOR);
        this.lblSat.setHorizontalAlignment(0);
        this.lblSat.setText(NbBundle.getMessage(PeriodWeeklyPanel.class, (String)"saturday"));
        this.lblSat.setBorder(BorderFactory.createEtchedBorder());
        this.lblSat.setMaximumSize(new Dimension(50, 23));
        this.lblSat.setMinimumSize(new Dimension(50, 23));
        this.lblSat.setOpaque(true);
        this.lblSat.setPreferredSize(new Dimension(50, 23));
        this.lblSat.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeriodWeeklyPanel.this.mouseClicked(evt);
            }
        });
        this.add(this.lblSat);
    }

    private void mouseClicked(MouseEvent evt) {
        try {
            JLabel dayLabel = (JLabel)evt.getSource();
            if (dayLabel.isEnabled()) {
                int dayNumber = Integer.parseInt(dayLabel.getName());
                if (this.isSelectedDay(dayNumber)) {
                    this.deselectDay(dayNumber);
                } else {
                    this.selectDay(dayNumber);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

