/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageCache;
import org.apache.fop.image.ImageLoader;

class ContextImageCache
implements ImageCache {
    private boolean collective;
    private Map contextStore = Collections.synchronizedMap(new HashMap());
    private Set invalid = null;
    private Map refStore = null;
    private ReferenceQueue refQueue = new ReferenceQueue();

    public ContextImageCache(boolean col) {
        this.collective = col;
        if (this.collective) {
            this.refStore = Collections.synchronizedMap(new HashMap());
            this.invalid = Collections.synchronizedSet(new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FopImage getImage(String url, FOUserAgent context) {
        ImageLoader im = null;
        ContextImageCache contextImageCache = this;
        synchronized (contextImageCache) {
            if (this.collective && this.invalid.contains(url)) {
                return null;
            }
            Context con = (Context)this.contextStore.get(context);
            if (con == null) {
                con = new Context(context, this.collective);
                this.contextStore.put(context, con);
            } else {
                if (con.invalid(url)) {
                    return null;
                }
                im = con.getImage(url);
            }
            if (im == null && this.collective) {
                Reference ref;
                Context c;
                Iterator i = this.contextStore.values().iterator();
                while (i.hasNext() && ((c = (Context)i.next()) == con || (im = c.getImage(url)) == null)) {
                }
                if (im == null && (ref = (Reference)this.refStore.get(url)) != null && (im = (ImageLoader)ref.get()) == null) {
                    this.refStore.remove(url);
                }
            }
            if (im != null) {
                con.putImage(url, im);
            } else {
                im = con.getImage(url, this);
            }
        }
        if (im != null) {
            return im.loadImage();
        }
        return null;
    }

    public void releaseImage(String url, FOUserAgent context) {
        Context con = (Context)this.contextStore.get(context);
        if (con != null) {
            if (this.collective) {
                ImageLoader im = con.getImage(url);
                this.refStore.put(url, this.wrapInReference(im, url));
            }
            con.releaseImage(url);
        }
    }

    public void invalidateImage(String url, FOUserAgent context) {
        Context con;
        if (this.collective) {
            if (this.invalid.size() > 100) {
                this.invalid.clear();
            }
            this.invalid.add(url);
        }
        if ((con = (Context)this.contextStore.get(context)) != null) {
            con.invalidateImage(url);
        }
    }

    private Reference wrapInReference(Object obj, Object key) {
        return new SoftReferenceWithKey(obj, key, this.refQueue);
    }

    public void removeContext(FOUserAgent context) {
        Context con = (Context)this.contextStore.get(context);
        if (con != null) {
            if (this.collective) {
                Map images = con.getImages();
                Iterator iter = images.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.refStore.put(entry.getKey(), this.wrapInReference(entry.getValue(), entry.getKey()));
                }
            }
            this.contextStore.remove(context);
        }
        this.checkReferenceQueue();
    }

    private void checkReferenceQueue() {
        SoftReferenceWithKey ref;
        while ((ref = (SoftReferenceWithKey)this.refQueue.poll()) != null) {
            this.refStore.remove(ref.key);
        }
    }

    public void clearAll() {
        this.refStore.clear();
        this.invalid.clear();
    }

    class Context {
        private Map images = Collections.synchronizedMap(new HashMap());
        private Set invalid = null;
        private FOUserAgent userAgent;

        public Context(FOUserAgent ua, boolean inv) {
            this.userAgent = ua;
            if (inv) {
                this.invalid = Collections.synchronizedSet(new HashSet());
            }
        }

        public ImageLoader getImage(String url, ImageCache c) {
            if (this.images.containsKey(url)) {
                return (ImageLoader)this.images.get(url);
            }
            ImageLoader loader = new ImageLoader(url, c, this.userAgent);
            this.images.put(url, loader);
            return loader;
        }

        public void putImage(String url, ImageLoader image) {
            this.images.put(url, image);
        }

        public ImageLoader getImage(String url) {
            return (ImageLoader)this.images.get(url);
        }

        public void releaseImage(String url) {
            this.images.remove(url);
        }

        public Map getImages() {
            return this.images;
        }

        public void invalidateImage(String url) {
            this.invalid.add(url);
        }

        public boolean invalid(String url) {
            return this.invalid.contains(url);
        }
    }

    private static class SoftReferenceWithKey
    extends SoftReference {
        private Object key;

        public SoftReferenceWithKey(Object referent, Object key, ReferenceQueue q) {
            super(referent, q);
            this.key = key;
        }
    }
}

