/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.util.Calendar;
import java.util.Date;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.context.ContextChangeCookie;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.util.Observable;
import tr.view.DeleteAction;
import tr.view.DeleteCookie;
import tr.view.ReprocessAction;
import tr.view.ReprocessCookie;
import tr.view.WindowUtils;
import tr.view.actions.screens.SetDoneAction;
import tr.view.actions.screens.SetDoneCookie;
import tr.view.contexts.ContextChangeAction;
import tr.view.process.ProcessThoughtsAction;
import tr.view.projects.PostponeActionAction;
import tr.view.projects.PostponeActionCookie;
import tr.view.topics.TopicChangeAction;

public class ActionNode
extends AbstractNode
implements TopicChangeCookie,
ContextChangeCookie,
DeleteCookie,
SetDoneCookie,
ReprocessCookie,
PostponeActionCookie {
    public final Action action;

    public ActionNode(Action action) {
        super(Children.LEAF, Lookups.singleton((Object)action));
        this.action = action;
    }

    public String toString() {
        return this.action.getDescription();
    }

    public javax.swing.Action[] getActions(boolean popup) {
        return new javax.swing.Action[]{SystemAction.get(ReprocessAction.class), SystemAction.get(PostponeActionAction.class), SystemAction.get(ContextChangeAction.class), SystemAction.get(TopicChangeAction.class), SystemAction.get(SetDoneAction.class), SystemAction.get(DeleteAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == DeleteCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this;
        }
        if (clazz == ContextChangeCookie.class) {
            return this;
        }
        if (clazz == SetDoneCookie.class) {
            return this;
        }
        if (clazz == ReprocessCookie.class) {
            return this;
        }
        if (clazz == PostponeActionCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    public Action getAction() {
        return this.action;
    }

    public void delete() {
        this.action.getParent().remove((Item)this.action);
    }

    public void setDone(boolean done) {
        this.action.setDone(done);
    }

    public void reprocess(boolean now) {
        if (this.action == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        ProcessThoughtsAction processThoughtsAction = null;
        if (now && (processThoughtsAction = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class)) != null) {
            WindowUtils.closeWindows();
        }
        this.action.removeFromParent();
        Thought thought = new Thought(data.getNextID());
        thought.setDescription(this.action.getDescription());
        thought.setTopic(this.action.getTopic());
        thought.setAction(this.action);
        data.getThoughtManager().insert((Observable)thought, 0);
        if (now && processThoughtsAction != null) {
            processThoughtsAction.performAction();
        }
    }

    public void setTopic(Topic topic) {
        this.action.setTopic(topic);
    }

    public void setContext(Context context) {
        this.action.setContext(context);
    }

    private Date add(Date date, int n, PostponeActionAction.Periods periods) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        switch (periods) {
            case DAYS: {
                calendar.add(6, n);
                break;
            }
            case WEEKS: {
                calendar.add(3, n);
                break;
            }
            case MONTHS: {
                calendar.add(2, n);
                break;
            }
            case YEARS: {
                calendar.add(1, n);
            }
        }
        return calendar.getTime();
    }

    public void postponeAction(int n, PostponeActionAction.Periods periods) {
        switch (this.action.getState().getType()) {
            case DOASAP: {
                this.action.setDueDate(this.add(this.action.getDueDate(), n, periods));
                break;
            }
            case INACTIVE: {
                this.action.setStartDate(this.add(this.action.getStartDate(), n, periods));
                break;
            }
            case SCHEDULED: {
                ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
                state.setDate(this.add(state.getDate(), n, periods));
                break;
            }
            case DELEGATED: {
                ActionStateDelegated state = (ActionStateDelegated)this.action.getState();
                state.setDate(this.add(state.getDate(), n, periods));
                break;
            }
        }
    }
}

